/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.analysis.binding;

import java.util.List;
import org.eclipse.photran.internal.core.analysis.binding.BindingCollector;
import org.eclipse.photran.internal.core.analysis.binding.Definition;
import org.eclipse.photran.internal.core.analysis.binding.VariableAccess;
import org.eclipse.photran.internal.core.analysis.types.FunctionType;
import org.eclipse.photran.internal.core.analysis.types.Type;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.parser.ASTFunctionParNode;
import org.eclipse.photran.internal.core.parser.ASTFunctionStmtNode;
import org.eclipse.photran.internal.core.parser.ASTPrefixSpecNode;
import org.eclipse.photran.internal.core.parser.ASTSubroutineParNode;
import org.eclipse.photran.internal.core.parser.ASTSubroutineStmtNode;
import org.eclipse.photran.internal.core.parser.ASTTypeSpecNode;
import org.eclipse.photran.internal.core.vpg.AnnotationType;
import org.eclipse.photran.internal.core.vpg.PhotranTokenRef;

class SubprogramTypeCollector
extends BindingCollector {
    SubprogramTypeCollector() {
    }

    public void visitASTSubroutineStmtNode(ASTSubroutineStmtNode node) {
        super.traverseChildren(node);
        PhotranTokenRef tokenRef = node.getSubroutineName().getSubroutineName().getTokenRef();
        this.updateDefinitionWithTypeInfo(tokenRef, this.typeOf(node));
    }

    public void visitASTFunctionStmtNode(ASTFunctionStmtNode node) {
        super.traverseChildren(node);
        PhotranTokenRef tokenRef = node.getFunctionName().getFunctionName().getTokenRef();
        this.updateDefinitionWithTypeInfo(tokenRef, this.typeOf(node));
    }

    private void updateDefinitionWithTypeInfo(PhotranTokenRef tokenRef, FunctionType type) {
        Definition def = this.vpg.getDefinitionFor(tokenRef);
        def.setType(type);
        this.vpgProvider.setDefinitionFor(tokenRef, def);
    }

    private FunctionType typeOf(ASTSubroutineStmtNode node) {
        FunctionType type = new FunctionType(node.getSubroutineName().getSubroutineName().getText());
        type.setReturnType(Type.VOID);
        if (node.getSubroutinePars() != null) {
            for (ASTSubroutineParNode param : node.getSubroutinePars()) {
                if (param.isAsterisk()) continue;
                type.addArgument(param.getVariableName().getText(), this.typeOf(param.getVariableName()), this.intentOf(param.getVariableName()));
            }
        }
        return type;
    }

    private FunctionType typeOf(ASTFunctionStmtNode node) {
        FunctionType type = new FunctionType(node.getFunctionName().getFunctionName().getText());
        if (node.getPrefixSpecList() != null) {
            int i = 0;
            while (i < node.getPrefixSpecList().size()) {
                ASTTypeSpecNode typeSpec = ((ASTPrefixSpecNode)node.getPrefixSpecList().get(i)).getTypeSpec();
                if (typeSpec != null) {
                    type.setReturnType(Type.parse(typeSpec));
                }
                ++i;
            }
        }
        if (node.hasResultClause()) {
            type.setReturnType(this.typeOf(node.getName()));
        }
        if (node.getFunctionPars() != null) {
            for (ASTFunctionParNode param : node.getFunctionPars()) {
                type.addArgument(param.getVariableName().getText(), this.typeOf(param.getVariableName()), this.intentOf(param.getVariableName()));
            }
        }
        return type;
    }

    private Type typeOf(Token variableName) {
        Definition def = this.bindUniquely(variableName);
        return def == null ? Type.UNKNOWN : def.getType();
    }

    private VariableAccess intentOf(Token variableName) {
        Definition def = this.bindUniquely(variableName);
        if (def == null) {
            return VariableAccess.RW;
        }
        if (def.isIntentIn() && def.isIntentOut()) {
            return VariableAccess.RW;
        }
        if (def.isIntentIn()) {
            return VariableAccess.READ;
        }
        if (def.isIntentOut()) {
            return VariableAccess.WRITE;
        }
        return VariableAccess.RW;
    }

    private Definition bindUniquely(Token ident) {
        List<PhotranTokenRef> bindings = this.bind(ident);
        if (bindings.size() >= 1) {
            return (Definition)bindings.get(0).getAnnotation(AnnotationType.DEFINITION_ANNOTATION_TYPE);
        }
        return null;
    }
}

