/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.sync.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.PatternSyntaxException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.ptp.rdt.sync.core.BinaryResourceMatcher;
import org.eclipse.ptp.rdt.sync.core.BuildConfigurationManager;
import org.eclipse.ptp.rdt.sync.core.BuildScenario;
import org.eclipse.ptp.rdt.sync.core.PathResourceMatcher;
import org.eclipse.ptp.rdt.sync.core.RegexResourceMatcher;
import org.eclipse.ptp.rdt.sync.core.RemoteContentProvider;
import org.eclipse.ptp.rdt.sync.core.ResourceMatcher;
import org.eclipse.ptp.rdt.sync.core.SyncFileFilter;
import org.eclipse.ptp.rdt.sync.core.SyncManager;
import org.eclipse.ptp.rdt.sync.ui.messages.Messages;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class SyncFileTree
extends ApplicationWindow {
    private static final int ERROR_DISPLAY_SECONDS = 3;
    private static final Display display = Display.getCurrent();
    private static final Color excludeRed = display.getSystemColor(4);
    private static final Color includeGreen = display.getSystemColor(6);
    private final int windowWidth;
    private final int viewHeight;
    private final IProject project;
    private final SyncFileFilter filter;
    private final boolean modify_default_filter;
    private SyncCheckboxTreeViewer treeViewer;
    private Table patternTable;
    private Button showRemoteButton;
    private Label remoteErrorLabel;
    private Button upButton;
    private Button downButton;
    private Button deleteButton;
    private Text newPattern;
    private Button excludeButton;
    private Button includeButton;
    private Combo specialFiltersCombo;
    private Label patternErrorLabel;
    private Button cancelButton;
    private Button okButton;
    private final Map<String, ResourceMatcher> specialFilterNameToPatternMap = new HashMap<String, ResourceMatcher>();

    public SyncFileTree(IProject p) {
        this(p, false);
    }

    public SyncFileTree(IProject p, boolean modify_default) {
        super(null);
        this.project = p;
        this.modify_default_filter = modify_default;
        this.filter = this.modify_default_filter ? SyncManager.getDefaultFileFilter() : SyncManager.getFileFilter((IProject)this.project);
        BinaryResourceMatcher bpm = new BinaryResourceMatcher();
        this.specialFilterNameToPatternMap.put(bpm.toString(), (ResourceMatcher)bpm);
        this.windowWidth = SyncFileTree.display.getBounds().width / 3;
        this.viewHeight = SyncFileTree.display.getBounds().height / 6;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.modify_default_filter) {
            shell.setText(Messages.SyncFileTree_20);
        } else {
            shell.setText(Messages.SyncFileTree_0);
        }
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.verticalSpacing = 20;
        composite.setLayout((Layout)gl);
        Composite treeViewerComposite = new Composite(composite, 2048);
        treeViewerComposite.setLayout((Layout)new GridLayout(2, false));
        treeViewerComposite.setLayoutData((Object)new GridData(this.windowWidth, this.viewHeight));
        Label treeViewerLabel = new Label(treeViewerComposite, 0);
        treeViewerLabel.setText(Messages.SyncFileTree_1);
        treeViewerLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.formatAsHeader(treeViewerLabel);
        this.treeViewer = new SyncCheckboxTreeViewer(treeViewerComposite);
        this.treeViewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.treeViewer.setContentProvider((IContentProvider)new SFTTreeContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new SFTTreeLabelProvider());
        this.treeViewer.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isChecked(Object element) {
                return !SyncFileTree.this.filter.shouldIgnore((IResource)element);
            }

            public boolean isGrayed(Object element) {
                return false;
            }
        });
        this.treeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                IPath path = ((IResource)event.getElement()).getProjectRelativePath();
                if (event.getChecked()) {
                    SyncFileTree.this.filter.addPattern((ResourceMatcher)new PathResourceMatcher(path), SyncFileFilter.PatternType.INCLUDE);
                } else {
                    SyncFileTree.this.filter.addPattern((ResourceMatcher)new PathResourceMatcher(path), SyncFileFilter.PatternType.EXCLUDE);
                }
                SyncFileTree.this.update();
            }
        });
        this.treeViewer.setInput(this.project);
        this.showRemoteButton = new Button(treeViewerComposite, 32);
        this.showRemoteButton.setText(Messages.SyncFileTree_2);
        this.showRemoteButton.setSelection(((SFTTreeContentProvider)this.treeViewer.getContentProvider()).getShowRemoteFiles());
        this.showRemoteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SyncFileTree.this.update();
            }
        });
        this.remoteErrorLabel = new Label(treeViewerComposite, 0x1000000);
        this.remoteErrorLabel.setForeground(excludeRed);
        this.remoteErrorLabel.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite patternTableComposite = new Composite(composite, 2048);
        patternTableComposite.setLayout((Layout)new GridLayout(2, false));
        patternTableComposite.setLayoutData((Object)new GridData(this.windowWidth, this.viewHeight));
        Label patternTableLabel = new Label(patternTableComposite, 0);
        patternTableLabel.setText(Messages.SyncFileTree_3);
        this.formatAsHeader(patternTableLabel);
        patternTableLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 4, 1));
        this.patternTable = new Table(patternTableComposite, 2818);
        this.patternTable.setLayoutData((Object)new GridData(4, 4, true, true, 1, 3));
        this.patternTable.setHeaderVisible(true);
        this.patternTable.setLinesVisible(true);
        TableColumn patternColumn = new TableColumn(this.patternTable, 16384, 0);
        patternColumn.setText(Messages.SyncFileTree_4);
        patternColumn.setWidth(250);
        TableColumn typeColumn = new TableColumn(this.patternTable, 16384, 1);
        typeColumn.setText(Messages.SyncFileTree_5);
        typeColumn.setWidth(50);
        this.upButton = new Button(patternTableComposite, 8);
        this.upButton.setText(Messages.SyncFileTree_6);
        this.upButton.setLayoutData((Object)new GridData(0x1000000, 128, false, false));
        this.upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TableItem[] selectedPatternItems = SyncFileTree.this.patternTable.getSelection();
                if (selectedPatternItems.length != 1) {
                    return;
                }
                int patternIndex = SyncFileTree.this.patternTable.getSelectionIndex();
                if (SyncFileTree.this.filter.promote((ResourceMatcher)selectedPatternItems[0].getData())) {
                    --patternIndex;
                }
                SyncFileTree.this.update();
                SyncFileTree.this.patternTable.select(patternIndex);
            }
        });
        this.downButton = new Button(patternTableComposite, 8);
        this.downButton.setText(Messages.SyncFileTree_7);
        this.downButton.setLayoutData((Object)new GridData(0x1000000, 128, false, false));
        this.downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TableItem[] selectedPatternItems = SyncFileTree.this.patternTable.getSelection();
                if (selectedPatternItems.length != 1) {
                    return;
                }
                int patternIndex = SyncFileTree.this.patternTable.getSelectionIndex();
                if (SyncFileTree.this.filter.demote((ResourceMatcher)selectedPatternItems[0].getData())) {
                    ++patternIndex;
                }
                SyncFileTree.this.update();
                SyncFileTree.this.patternTable.select(patternIndex);
            }
        });
        this.deleteButton = new Button(patternTableComposite, 8);
        this.deleteButton.setText(Messages.SyncFileTree_8);
        this.deleteButton.setLayoutData((Object)new GridData(0x1000000, 1024, false, false));
        this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TableItem[] selectedPatternItems;
                TableItem[] tableItemArray = selectedPatternItems = SyncFileTree.this.patternTable.getSelection();
                int n = selectedPatternItems.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem selectedPatternItem = tableItemArray[n2];
                    ResourceMatcher selectedPattern = (ResourceMatcher)selectedPatternItem.getData();
                    SyncFileTree.this.filter.removePattern(selectedPattern);
                    ++n2;
                }
                SyncFileTree.this.update();
            }
        });
        Composite patternEnterComposite = new Composite(composite, 4);
        patternEnterComposite.setLayout((Layout)new GridLayout(4, false));
        patternEnterComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        new Label(patternEnterComposite, 0).setText(Messages.SyncFileTree_9);
        this.newPattern = new Text(patternEnterComposite, 0);
        this.newPattern.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.excludeButton = new Button(patternEnterComposite, 8);
        this.excludeButton.setText(Messages.SyncFileTree_10);
        this.excludeButton.setForeground(excludeRed);
        this.excludeButton.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        this.excludeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SyncFileTree.this.enterNewPattern(SyncFileFilter.PatternType.EXCLUDE);
            }
        });
        this.includeButton = new Button(patternEnterComposite, 8);
        this.includeButton.setText(Messages.SyncFileTree_11);
        this.includeButton.setForeground(includeGreen);
        this.includeButton.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        this.includeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SyncFileTree.this.enterNewPattern(SyncFileFilter.PatternType.INCLUDE);
            }
        });
        new Label(patternEnterComposite, 0).setText(Messages.SyncFileTree_12);
        this.specialFiltersCombo = new Combo(patternEnterComposite, 8);
        this.specialFiltersCombo.setLayoutData((Object)new GridData(4, 4, true, true));
        for (String filterName : this.specialFilterNameToPatternMap.keySet()) {
            this.specialFiltersCombo.add(filterName);
        }
        this.specialFiltersCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SyncFileTree.this.newPattern.setText(SyncFileTree.this.specialFiltersCombo.getText());
                SyncFileTree.this.specialFiltersCombo.deselectAll();
            }
        });
        new Label(patternEnterComposite, 0).setVisible(false);
        new Label(patternEnterComposite, 0).setVisible(false);
        this.patternErrorLabel = new Label(patternEnterComposite, 0);
        this.patternErrorLabel.setForeground(excludeRed);
        this.patternErrorLabel.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        Composite buttonComposite = new Composite(composite, 4);
        buttonComposite.setLayout((Layout)new GridLayout(2, false));
        buttonComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.cancelButton = new Button(buttonComposite, 8);
        this.cancelButton.setText(Messages.SyncFileTree_13);
        this.cancelButton.setLayoutData((Object)new GridData(131072, 0, true, false));
        this.cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SyncFileTree.this.getShell().close();
            }
        });
        this.okButton = new Button(buttonComposite, 8);
        this.okButton.setText(Messages.SyncFileTree_14);
        this.okButton.setLayoutData((Object)new GridData(131072, 0, false, false));
        this.okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (SyncFileTree.this.modify_default_filter) {
                    SyncManager.saveDefaultFileFilter((SyncFileFilter)SyncFileTree.this.filter);
                } else {
                    SyncManager.saveFileFilter((IProject)SyncFileTree.this.project, (SyncFileFilter)SyncFileTree.this.filter);
                }
                SyncFileTree.this.getShell().close();
            }
        });
        this.update();
        return composite;
    }

    private void formatAsHeader(Label widget) {
        FontData[] fontData;
        FontData[] fontDataArray = fontData = widget.getFont().getFontData();
        int n = fontData.length;
        int n2 = 0;
        while (n2 < n) {
            FontData data = fontDataArray[n2];
            data.setStyle(1);
            ++n2;
        }
        final Font newFont = new Font((Device)display, fontData);
        widget.setFont(newFont);
        widget.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                newFont.dispose();
            }
        });
    }

    private void enterNewPattern(SyncFileFilter.PatternType type) {
        String pattern = this.newPattern.getText();
        if (pattern.isEmpty()) {
            return;
        }
        if (this.specialFilterNameToPatternMap.get(pattern) != null) {
            this.filter.addPattern(this.specialFilterNameToPatternMap.get(pattern), type);
        } else {
            RegexResourceMatcher matcher = null;
            try {
                matcher = new RegexResourceMatcher(pattern);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                this.patternErrorLabel.setText(Messages.SyncFileTree_15);
                display.timerExec(3000, new Runnable(){

                    public void run() {
                        if (SyncFileTree.this.patternErrorLabel.isDisposed()) {
                            return;
                        }
                        SyncFileTree.this.patternErrorLabel.setText("");
                    }
                });
                return;
            }
            this.filter.addPattern((ResourceMatcher)matcher, type);
        }
        this.newPattern.setText("");
        this.update();
    }

    private void update() {
        boolean showRemote = this.showRemoteButton.getSelection();
        if (showRemote) {
            if (!((SFTTreeContentProvider)this.treeViewer.getContentProvider()).isConnected()) {
                showRemote = false;
                this.remoteErrorLabel.setText(Messages.SyncFileTree_19);
            } else {
                this.remoteErrorLabel.setText("");
            }
        }
        this.showRemoteButton.setSelection(showRemote);
        ((SFTTreeContentProvider)this.treeViewer.getContentProvider()).setShowRemoteFiles(showRemote);
        this.patternTable.removeAll();
        ResourceMatcher[] resourceMatcherArray = this.filter.getPatterns();
        int n = resourceMatcherArray.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceMatcher pattern = resourceMatcherArray[n2];
            TableItem ti = new TableItem(this.patternTable, 16384);
            ti.setData((Object)pattern);
            String[] tableValues = new String[]{pattern.toString(), pattern instanceof PathResourceMatcher ? Messages.SyncFileTree_16 : (pattern instanceof RegexResourceMatcher ? Messages.SyncFileTree_17 : Messages.SyncFileTree_18)};
            ti.setText(tableValues);
            if (this.filter.getPatternType(pattern) == SyncFileFilter.PatternType.INCLUDE) {
                ti.setForeground(includeGreen);
            } else {
                ti.setForeground(excludeRed);
            }
            ++n2;
        }
        this.treeViewer.refresh();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SFTTreeContentProvider
    implements ITreeContentProvider {
        private final RemoteContentProvider remoteFiles;
        private boolean showRemoteFiles = false;

        public SFTTreeContentProvider() {
            IConfiguration bconf = ManagedBuildManager.getBuildInfo((IResource)SyncFileTree.this.project).getDefaultConfiguration();
            BuildScenario bs = BuildConfigurationManager.getInstance().getBuildScenarioForBuildConfiguration(bconf);
            this.remoteFiles = bs == null ? null : new RemoteContentProvider(bs.getRemoteConnection(), (IPath)new Path(bs.getLocation()), SyncFileTree.this.project);
        }

        public boolean getShowRemoteFiles() {
            return this.showRemoteFiles;
        }

        public void setShowRemoteFiles(boolean b) {
            this.showRemoteFiles = b;
        }

        public Object[] getChildren(Object element) {
            ArrayList<IResource> children = new ArrayList<IResource>();
            if (element instanceof IFolder) {
                int n;
                int n2;
                Object[] objectArray;
                block7: {
                    if (((IFolder)element).isAccessible()) {
                        try {
                            objectArray = ((IFolder)element).members();
                            n2 = objectArray.length;
                            n = 0;
                            while (n < n2) {
                                IResource localChild = objectArray[n];
                                children.add(localChild);
                                ++n;
                            }
                        }
                        catch (CoreException coreException) {
                            if ($assertionsDisabled) break block7;
                            throw new AssertionError();
                        }
                    }
                }
                if (this.showRemoteFiles && this.remoteFiles != null) {
                    objectArray = this.remoteFiles.getChildren(element);
                    n2 = objectArray.length;
                    n = 0;
                    while (n < n2) {
                        IResource remoteChild = objectArray[n];
                        this.addUniqueResource(children, remoteChild);
                        ++n;
                    }
                }
            }
            return children.toArray();
        }

        public Object getParent(Object element) {
            return ((IResource)element).getParent();
        }

        public boolean hasChildren(Object element) {
            Object[] obj = this.getChildren(element);
            return obj == null ? false : obj.length > 0;
        }

        public Object[] getElements(Object element) {
            ArrayList<IResource> children = new ArrayList<IResource>();
            if (element instanceof IProject && ((IProject)element).isAccessible()) {
                int n;
                int n2;
                Object[] objectArray;
                block6: {
                    try {
                        objectArray = ((IProject)element).members();
                        n2 = objectArray.length;
                        n = 0;
                        while (n < n2) {
                            IResource localChild = objectArray[n];
                            children.add(localChild);
                            ++n;
                        }
                    }
                    catch (CoreException coreException) {
                        if ($assertionsDisabled) break block6;
                        throw new AssertionError();
                    }
                }
                if (this.showRemoteFiles && this.remoteFiles != null) {
                    objectArray = this.remoteFiles.getElements(element);
                    n2 = objectArray.length;
                    n = 0;
                    while (n < n2) {
                        IResource remoteChild = objectArray[n];
                        this.addUniqueResource(children, remoteChild);
                        ++n;
                    }
                }
            }
            return children.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer element, Object arg1, Object arg2) {
        }

        private boolean addUniqueResource(Collection<IResource> resList, IResource newRes) {
            for (IResource res : resList) {
                if (!res.getProjectRelativePath().equals((Object)newRes.getProjectRelativePath())) continue;
                return false;
            }
            resList.add(newRes);
            return true;
        }

        public boolean isConnected() {
            if (this.remoteFiles == null) {
                return false;
            }
            return this.remoteFiles.isOpen();
        }
    }

    private class SFTTreeLabelProvider
    implements ILabelProvider {
        private final Image folderImage = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
        private final Image fileImage = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");

        private SFTTreeLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof IFolder) {
                return this.folderImage;
            }
            return this.fileImage;
        }

        public String getText(Object element) {
            return ((IResource)element).getName();
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String arg1) {
            return false;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private class SyncCheckboxTreeViewer
    extends CheckboxTreeViewer {
        public SyncCheckboxTreeViewer(Composite parent) {
            super(parent);
        }

        public boolean isExpandable(Object element) {
            if (!super.isExpandable(element)) {
                return false;
            }
            return !SyncFileTree.this.filter.shouldIgnore((IResource)element);
        }
    }
}

