/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.sync.ui;

import java.util.EnumSet;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ptp.rdt.sync.core.PathResourceMatcher;
import org.eclipse.ptp.rdt.sync.core.ResourceMatcher;
import org.eclipse.ptp.rdt.sync.core.SyncFileFilter;
import org.eclipse.ptp.rdt.sync.core.SyncFlag;
import org.eclipse.ptp.rdt.sync.core.SyncManager;
import org.eclipse.ptp.rdt.sync.ui.RDTSyncUIPlugin;
import org.eclipse.ptp.rdt.sync.ui.SyncFileTree;
import org.eclipse.ptp.rdt.sync.ui.messages.Messages;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;

public class SyncMenuOperation
extends AbstractHandler
implements IElementUpdater {
    private static final String SYNC_COMMAND_PARAMETER_ID = "org.eclipse.ptp.rdt.sync.ui.syncCommand.syncModeParameter";
    private static final String syncActiveCommand = "sync_active";
    private static final String syncAllCommand = "sync_all";
    private static final String setNoneCommand = "set_none";
    private static final String setActiveCommand = "set_active";
    private static final String setAllCommand = "set_all";
    private static final String syncAutoCommand = "sync_auto";
    private static final String syncFileList = "sync_file_list";
    private static final String syncDefaultFileList = "sync_default_file_list";
    private static final String syncExcludeCommand = "sync_exclude";
    private static final String syncIncludeCommand = "sync_include";

    public Object execute(ExecutionEvent event) {
        String command = event.getParameter(SYNC_COMMAND_PARAMETER_ID);
        IProject project = this.getProject();
        if (project == null) {
            RDTSyncUIPlugin.getDefault().logErrorMessage(Messages.SyncMenuOperation_0);
            return null;
        }
        try {
            if (command.equals(syncActiveCommand)) {
                SyncManager.sync(null, (IProject)project, (EnumSet)SyncFlag.FORCE, null);
            } else if (command.equals(syncAllCommand)) {
                SyncManager.syncAll(null, (IProject)project, (EnumSet)SyncFlag.FORCE, null);
            } else if (command.equals(setActiveCommand)) {
                SyncManager.setSyncMode((IProject)project, (SyncManager.SYNC_MODE)SyncManager.SYNC_MODE.ACTIVE);
                SyncManager.sync(null, (IProject)project, (EnumSet)SyncFlag.FORCE, null);
            } else if (command.equals(setAllCommand)) {
                SyncManager.setSyncMode((IProject)project, (SyncManager.SYNC_MODE)SyncManager.SYNC_MODE.ALL);
                SyncManager.syncAll(null, (IProject)project, (EnumSet)SyncFlag.FORCE, null);
            } else if (command.equals(setNoneCommand)) {
                SyncManager.setSyncMode((IProject)project, (SyncManager.SYNC_MODE)SyncManager.SYNC_MODE.NONE);
            } else if (command.equals(syncAutoCommand)) {
                SyncManager.setSyncAuto((!SyncManager.getSyncAuto() ? 1 : 0) != 0);
                if (SyncManager.getSyncAuto()) {
                    SyncManager.SYNC_MODE syncMode = SyncManager.getSyncMode((IProject)project);
                    if (syncMode == SyncManager.SYNC_MODE.ACTIVE) {
                        SyncManager.sync(null, (IProject)project, (EnumSet)SyncFlag.FORCE, null);
                    } else if (syncMode == SyncManager.SYNC_MODE.ALL) {
                        SyncManager.syncAll(null, (IProject)project, (EnumSet)SyncFlag.FORCE, null);
                    }
                }
            } else if (command.equals(syncExcludeCommand) || command.equals(syncIncludeCommand)) {
                SyncFileFilter sff = SyncManager.getFileFilter((IProject)project);
                IStructuredSelection sel = this.getSelectedElements();
                SyncFileFilter.PatternType type = SyncFileFilter.PatternType.EXCLUDE;
                if (command.equals(syncIncludeCommand)) {
                    type = SyncFileFilter.PatternType.INCLUDE;
                }
                Object[] objectArray = sel.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    assert (element instanceof IFolder || element instanceof IFile);
                    IPath path = ((IResource)element).getProjectRelativePath();
                    sff.addPattern((ResourceMatcher)new PathResourceMatcher(path), type);
                    ++n2;
                }
                SyncManager.saveFileFilter((IProject)project, (SyncFileFilter)sff);
            } else if (command.equals(syncFileList)) {
                new SyncFileTree(project).open();
            } else if (command.equals(syncDefaultFileList)) {
                new SyncFileTree(project, true).open();
            }
        }
        catch (CoreException coreException) {
            RDTSyncUIPlugin.getDefault().logErrorMessage(Messages.SyncMenuOperation_1);
        }
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        if (window != null) {
            ICommandService service = (ICommandService)window.getService(ICommandService.class);
            service.refreshElements(event.getCommand().getId(), null);
        }
        return null;
    }

    public void updateElement(UIElement element, Map parameters) {
        String command = (String)parameters.get(SYNC_COMMAND_PARAMETER_ID);
        if (command == null) {
            RDTSyncUIPlugin.getDefault().logErrorMessage(Messages.SyncMenuOperation_2);
            return;
        }
        IProject project = this.getProject();
        if (project == null) {
            RDTSyncUIPlugin.getDefault().logErrorMessage(Messages.SyncMenuOperation_0);
            return;
        }
        SyncManager.SYNC_MODE syncMode = SyncManager.getSyncMode((IProject)project);
        if (command.equals(setActiveCommand) && syncMode == SyncManager.SYNC_MODE.ACTIVE || command.equals(setAllCommand) && syncMode == SyncManager.SYNC_MODE.ALL || command.equals(setNoneCommand) && syncMode == SyncManager.SYNC_MODE.NONE || command.equals(syncAutoCommand) && SyncManager.getSyncAuto()) {
            element.setChecked(true);
        } else {
            element.setChecked(false);
        }
    }

    private IProject getProject() {
        IStructuredSelection selection = this.getSelectedElements();
        if (selection == null) {
            return null;
        }
        Object firstElement = selection.getFirstElement();
        if (!(firstElement instanceof IAdaptable)) {
            return null;
        }
        Object o = ((IAdaptable)firstElement).getAdapter(IResource.class);
        if (o == null) {
            return null;
        }
        IResource resource = (IResource)o;
        return resource.getProject();
    }

    private IStructuredSelection getSelectedElements() {
        IWorkbenchWindow wnd = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage pg = wnd.getActivePage();
        ISelection sel = pg.getSelection();
        if (!(sel instanceof IStructuredSelection)) {
            return null;
        }
        return (IStructuredSelection)sel;
    }
}

