/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.ui.typehierarchy;

import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.typehierarchy.Messages;
import org.eclipse.cdt.internal.ui.typehierarchy.TypeHierarchyUI;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.actions.SelectionDispatchAction;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ptp.internal.rdt.core.typehierarchy.ITypeHierarchyService;
import org.eclipse.ptp.internal.rdt.ui.typehierarchy.TypeHierarchyUtil;
import org.eclipse.ptp.rdt.core.serviceproviders.IIndexServiceProvider;
import org.eclipse.ptp.services.core.IService;
import org.eclipse.ptp.services.core.IServiceConfiguration;
import org.eclipse.ptp.services.core.IServiceProvider;
import org.eclipse.ptp.services.core.ServiceModelManager;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.texteditor.ITextEditor;

public class OpenTypeHierarchyAction
extends SelectionDispatchAction {
    private ITextEditor fEditor;

    public OpenTypeHierarchyAction(IWorkbenchSite site) {
        super(site);
        this.setText(Messages.OpenTypeHierarchyAction_label);
        this.setToolTipText(Messages.OpenTypeHierarchyAction_tooltip);
    }

    public OpenTypeHierarchyAction(ITextEditor editor) {
        this((IWorkbenchSite)editor.getSite());
        this.fEditor = editor;
        this.setEnabled(this.fEditor != null && CUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(editor.getEditorInput()) != null);
    }

    public void run(ITextSelection sel) {
        IService indexingService;
        IProject project = ((CEditor)this.fEditor).getInputCElement().getCProject().getProject();
        ServiceModelManager smm = ServiceModelManager.getInstance();
        IServiceConfiguration serviceConfig = smm.getActiveConfiguration(project);
        IServiceProvider serviceProvider = serviceConfig.getServiceProvider(indexingService = smm.getService("org.eclipse.ptp.rdt.core.CIndexingService"));
        if (serviceProvider instanceof IIndexServiceProvider) {
            ITypeHierarchyService service = ((IIndexServiceProvider)serviceProvider).getTypeHierarchyService();
            TypeHierarchyUtil.open(service, this.fEditor, sel);
        }
    }

    public void run(IStructuredSelection selection) {
        Object selectedObject;
        ICElement elem;
        if (!selection.isEmpty() && (elem = (ICElement)this.getAdapter(selectedObject = selection.getFirstElement(), ICElement.class)) != null) {
            IService indexingService;
            IProject project = elem.getCProject().getProject();
            ServiceModelManager smm = ServiceModelManager.getInstance();
            IServiceConfiguration serviceConfig = smm.getActiveConfiguration(project);
            IServiceProvider serviceProvider = serviceConfig.getServiceProvider(indexingService = smm.getService("org.eclipse.ptp.rdt.core.CIndexingService"));
            if (serviceProvider instanceof IIndexServiceProvider) {
                ITypeHierarchyService service = ((IIndexServiceProvider)serviceProvider).getTypeHierarchyService();
                TypeHierarchyUtil.open(service, elem, this.getSite().getWorkbenchWindow());
            }
        }
    }

    public void selectionChanged(ITextSelection sel) {
    }

    public void selectionChanged(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            this.setEnabled(false);
            return;
        }
        Object selectedObject = selection.getFirstElement();
        ICElement elem = (ICElement)this.getAdapter(selectedObject, ICElement.class);
        if (elem != null) {
            this.setEnabled(TypeHierarchyUI.isValidInput((ICElement)elem));
        } else {
            this.setEnabled(false);
        }
    }

    private Object getAdapter(Object object, Class desiredClass) {
        if (desiredClass.isInstance(object)) {
            return object;
        }
        if (object instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)object;
            return adaptable.getAdapter(desiredClass);
        }
        return null;
    }
}

