/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.core.rmsystem;

import org.eclipse.ptp.rm.core.rmsystem.AbstractRemoteResourceManagerConfiguration;
import org.eclipse.ptp.rm.core.rmsystem.IToolRMConfiguration;
import org.eclipse.ptp.services.core.IServiceProvider;

public abstract class AbstractToolRMConfiguration
extends AbstractRemoteResourceManagerConfiguration
implements IToolRMConfiguration {
    public static final String EMPTY_STRING = "";
    private static final String TAG_LAUNCH_CMD = "launchCmd";
    private static final String TAG_DEBUG_CMD = "debugCmd";
    private static final String TAG_DISCOVER_CMD = "discoverCmd";
    private static final String TAG_PERIODIC_MONITOR_CMD = "periodicMonitorCmd";
    private static final String TAG_PERIODIC_MONITOR_TIME = "periodicMonitorTime";
    private static final String TAG_CONTINUOUS_MONITOR_CMD = "continuousMonitorCmd";
    private static final String TAG_REMOTE_INSTALL_PATH = "remoteInstallPath";
    private static final String TAG_USE_TOOL_DEFAULTS = "useToolDefaults";
    private static final String TAG_USE_INSTALL_DEFAULTS = "useInstallDefaults";
    private static final String TAG_COMMANDS_ENABLED = "commandsEnabled";
    private final int fCapabilities;

    public AbstractToolRMConfiguration(int capabilities, String namespace, IServiceProvider provider) {
        super(namespace, provider);
        this.fCapabilities = capabilities;
    }

    public int getCapabilities() {
        return this.fCapabilities;
    }

    public boolean getCommandsEnabled() {
        return this.getBoolean(TAG_COMMANDS_ENABLED, true);
    }

    public String getContinuousMonitorCmd() {
        return this.getString(TAG_CONTINUOUS_MONITOR_CMD, EMPTY_STRING);
    }

    public String getDebugCmd() {
        return this.getString(TAG_DEBUG_CMD, EMPTY_STRING);
    }

    public String getDiscoverCmd() {
        return this.getString(TAG_DISCOVER_CMD, EMPTY_STRING);
    }

    public String getLaunchCmd() {
        return this.getString(TAG_LAUNCH_CMD, EMPTY_STRING);
    }

    public String getPeriodicMonitorCmd() {
        return this.getString(TAG_PERIODIC_MONITOR_CMD, EMPTY_STRING);
    }

    public int getPeriodicMonitorTime() {
        return this.getInt(TAG_PERIODIC_MONITOR_TIME, 0);
    }

    public String getRemoteInstallPath() {
        return this.getString(TAG_REMOTE_INSTALL_PATH, EMPTY_STRING);
    }

    public boolean getUseInstallDefaults() {
        return this.getBoolean(TAG_USE_INSTALL_DEFAULTS, true);
    }

    public boolean getUseToolDefaults() {
        return this.getBoolean(TAG_USE_TOOL_DEFAULTS, true);
    }

    public boolean hasContinuousMonitorCmd() {
        return (this.fCapabilities & 8) != 0 && this.getContinuousMonitorCmd() != null && !this.getContinuousMonitorCmd().trim().equals(EMPTY_STRING);
    }

    public boolean hasDebugCmd() {
        return (this.fCapabilities & 1) != 0 && this.getDebugCmd() != null && !this.getDebugCmd().trim().equals(EMPTY_STRING);
    }

    public boolean hasDiscoverCmd() {
        return (this.fCapabilities & 2) != 0 && this.getDiscoverCmd() != null && !this.getDiscoverCmd().trim().equals(EMPTY_STRING);
    }

    public boolean hasLaunchCmd() {
        return (this.fCapabilities & 1) != 0 && this.getLaunchCmd() != null && !this.getLaunchCmd().trim().equals(EMPTY_STRING);
    }

    public boolean hasPeriodicMonitorCmd() {
        return (this.fCapabilities & 4) != 0 && this.getPeriodicMonitorCmd() != null && !this.getPeriodicMonitorCmd().trim().equals(EMPTY_STRING);
    }

    public boolean needsDebuggerLaunchHelp() {
        return true;
    }

    public void setCommandsEnabled(boolean commandsEnabled) {
        this.putBoolean(TAG_COMMANDS_ENABLED, commandsEnabled);
    }

    public void setContinuousMonitorCmd(String continuousMonitorCmd) {
        this.putString(TAG_CONTINUOUS_MONITOR_CMD, continuousMonitorCmd);
    }

    public void setDebugCmd(String debugCmd) {
        this.putString(TAG_DEBUG_CMD, debugCmd);
    }

    public void setDiscoverCmd(String discoverCmd) {
        this.putString(TAG_DISCOVER_CMD, discoverCmd);
    }

    public void setLaunchCmd(String launchCmd) {
        this.putString(TAG_LAUNCH_CMD, launchCmd);
    }

    public void setPeriodicMonitorCmd(String periodicMonitorCmd) {
        this.putString(TAG_PERIODIC_MONITOR_CMD, periodicMonitorCmd);
    }

    public void setPeriodicMonitorTime(int periodicMonitorTime) {
        this.putInt(TAG_PERIODIC_MONITOR_TIME, periodicMonitorTime);
    }

    public void setRemoteInstallPath(String remoteInstallPath) {
        this.putString(TAG_REMOTE_INSTALL_PATH, remoteInstallPath);
    }

    public void setUseInstallDefaults(boolean useInstallDefaults) {
        this.putBoolean(TAG_USE_INSTALL_DEFAULTS, useInstallDefaults);
    }

    public void setUseToolDefaults(boolean useToolDefaults) {
        this.putBoolean(TAG_USE_TOOL_DEFAULTS, useToolDefaults);
    }
}

