/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.lml_jaxb.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.ptp.core.util.CoreExceptionUtils;
import org.eclipse.ptp.rm.lml.core.JobStatusData;
import org.eclipse.ptp.rm.lml.internal.core.model.Row;
import org.eclipse.ptp.rm.lml_jaxb.actions.AbstractStatusAction;
import org.eclipse.ptp.rm.lml_jaxb.actions.ActionUtils;
import org.eclipse.ui.IViewPart;

public abstract class AbstractControlAction
extends AbstractStatusAction {
    protected String operation;

    public void run(IAction action) {
        Job j = new Job(this.operation){

            protected IStatus run(IProgressMonitor monitor) {
                for (Row row : AbstractControlAction.this.selected) {
                    JobStatusData status = row.status;
                    try {
                        ActionUtils.callDoControl(status, AbstractControlAction.this.operation, AbstractControlAction.this.view, monitor);
                        if (!monitor.isCanceled()) continue;
                        break;
                    }
                    catch (CoreException t) {
                        return CoreExceptionUtils.getErrorStatus((String)AbstractControlAction.this.operation, (Throwable)t);
                    }
                }
                return Status.OK_STATUS;
            }
        };
        j.setUser(true);
        j.schedule();
    }

    protected void validate(IAction action) {
        for (Row row : this.selected) {
            if (row.status == null) {
                action.setEnabled(false);
                return;
            }
            if (row.status.isInteractive()) {
                action.setEnabled(false);
                return;
            }
            if (!AbstractControlAction.operationSupported(row.status, this.operation, (IViewPart)this.view)) {
                action.setEnabled(false);
                return;
            }
            if (this.validateState(row.status)) continue;
            action.setEnabled(false);
            return;
        }
        action.setEnabled(true);
    }

    protected abstract boolean validateState(JobStatusData var1);
}

