/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IASTCompletionNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IIndexInclude;
import org.eclipse.cdt.core.index.IndexLocationFactory;
import org.eclipse.cdt.core.model.AbstractLanguage;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.CoreModelUtil;
import org.eclipse.cdt.core.model.IBuffer;
import org.eclipse.cdt.core.model.ICContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IContributedModelBuilder;
import org.eclipse.cdt.core.model.IFunctionDeclaration;
import org.eclipse.cdt.core.model.IInclude;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.INamespace;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.core.model.IProblemRequestor;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITemplate;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IUsing;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.core.model.LanguageManager;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.FileContent;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfoProvider;
import org.eclipse.cdt.core.parser.IncludeFileContentProvider;
import org.eclipse.cdt.core.parser.ParserUtil;
import org.eclipse.cdt.core.parser.ScannerInfo;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.internal.core.dom.parser.ASTTranslationUnit;
import org.eclipse.cdt.internal.core.index.IndexBasedFileContentProvider;
import org.eclipse.cdt.internal.core.model.ASTHolderTUInfo;
import org.eclipse.cdt.internal.core.model.BufferManager;
import org.eclipse.cdt.internal.core.model.CElement;
import org.eclipse.cdt.internal.core.model.CElementInfo;
import org.eclipse.cdt.internal.core.model.CModelBuilder2;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.CreateIncludeOperation;
import org.eclipse.cdt.internal.core.model.CreateNamespaceOperation;
import org.eclipse.cdt.internal.core.model.DebugLogConstants;
import org.eclipse.cdt.internal.core.model.IBufferFactory;
import org.eclipse.cdt.internal.core.model.Openable;
import org.eclipse.cdt.internal.core.model.OpenableInfo;
import org.eclipse.cdt.internal.core.model.SourceManipulationInfo;
import org.eclipse.cdt.internal.core.model.TranslationUnitInfo;
import org.eclipse.cdt.internal.core.model.Util;
import org.eclipse.cdt.internal.core.model.WorkingCopy;
import org.eclipse.cdt.internal.core.parser.InternalParserUtil;
import org.eclipse.cdt.internal.core.parser.ParserLogService;
import org.eclipse.cdt.internal.core.parser.scanner.InternalFileContentProvider;
import org.eclipse.cdt.internal.core.pdom.indexer.ProjectIndexerIncludeResolutionHeuristics;
import org.eclipse.cdt.internal.core.pdom.indexer.ProjectIndexerInputAdapter;
import org.eclipse.cdt.internal.core.util.ICanceler;
import org.eclipse.cdt.internal.core.util.MementoTokenizer;
import org.eclipse.cdt.utils.UNCPathConverter;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.content.IContentType;

public class TranslationUnit
extends Openable
implements ITranslationUnit {
    private URI location = null;
    private String contentTypeId;
    protected IProblemRequestor problemRequestor;
    SourceManipulationInfo sourceManipulationInfo = null;
    private ILanguage fLanguageOfContext;
    private static final int[] CTX_LINKAGES = new int[]{1, 2};

    public TranslationUnit(ICElement parent, IFile file, String idType) {
        super(parent, (IResource)file, 60);
        this.setContentTypeID(idType);
    }

    public TranslationUnit(ICElement parent, URI uri, String idType) {
        super(parent, null, uri.toString(), 60);
        this.location = uri;
        this.setContentTypeID(idType);
    }

    @Override
    public ITranslationUnit getTranslationUnit() {
        return this;
    }

    @Override
    public IInclude createInclude(String includeName, boolean isStd, ICElement sibling, IProgressMonitor monitor) throws CModelException {
        CreateIncludeOperation op = new CreateIncludeOperation(includeName, isStd, this);
        if (sibling != null) {
            op.createBefore(sibling);
        }
        op.runOperation(monitor);
        return this.getInclude(includeName);
    }

    @Override
    public IUsing createUsing(String usingName, boolean isDirective, ICElement sibling, IProgressMonitor monitor) throws CModelException {
        CreateIncludeOperation op = new CreateIncludeOperation(usingName, isDirective, this);
        if (sibling != null) {
            op.createBefore(sibling);
        }
        op.runOperation(monitor);
        return this.getUsing(usingName);
    }

    @Override
    public INamespace createNamespace(String namespace, ICElement sibling, IProgressMonitor monitor) throws CModelException {
        CreateNamespaceOperation op = new CreateNamespaceOperation(namespace, this);
        if (sibling != null) {
            op.createBefore(sibling);
        }
        op.runOperation(monitor);
        return this.getNamespace(namespace);
    }

    @Override
    public ICElement getElementAtLine(int line) throws CModelException {
        ICElement[] celements;
        ICElement[] iCElementArray = celements = this.getChildren();
        int n = celements.length;
        int n2 = 0;
        while (n2 < n) {
            ICElement celement = iCElementArray[n2];
            ISourceRange range = ((ISourceReference)((Object)celement)).getSourceRange();
            int startLine = range.getStartLine();
            int endLine = range.getEndLine();
            if (line >= startLine && line <= endLine) {
                return celement;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public ICElement getElementAtOffset(int pos) throws CModelException {
        ICElement e = this.getSourceElementAtOffset(pos);
        if (e == this) {
            return null;
        }
        return e;
    }

    @Override
    public ICElement[] getElementsAtOffset(int pos) throws CModelException {
        ICElement[] e = this.getSourceElementsAtOffset(pos);
        if (e.length == 1 && e[0] == this) {
            return CElement.NO_ELEMENTS;
        }
        return e;
    }

    @Override
    public ICElement getElement(String qname) {
        int n;
        if (qname == null || qname.length() == 0) {
            return null;
        }
        try {
            ICElement[] celements;
            ICElement[] iCElementArray = celements = this.getChildren();
            n = celements.length;
            int n2 = 0;
            while (n2 < n) {
                ICElement celement = iCElementArray[n2];
                if (qname.equals(celement.getElementName())) {
                    return celement;
                }
                ++n2;
            }
        }
        catch (CModelException cModelException) {}
        String[] names = qname.split("::");
        ICElement current = this;
        String[] stringArray = names;
        int n3 = names.length;
        n = 0;
        while (n < n3) {
            String name = stringArray[n];
            if (current instanceof IParent) {
                try {
                    ICElement[] celements = ((IParent)((Object)current)).getChildren();
                    current = null;
                    ICElement[] iCElementArray = celements;
                    int n4 = celements.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        ICElement celement = iCElementArray[n5];
                        if (name.equals(celement.getElementName())) {
                            current = celement;
                            break;
                        }
                        ++n5;
                    }
                }
                catch (CModelException cModelException) {
                    current = null;
                }
            } else {
                current = null;
            }
            ++n;
        }
        return current;
    }

    @Override
    public IInclude getInclude(String name) {
        try {
            ICElement[] celements;
            ICElement[] iCElementArray = celements = this.getChildren();
            int n = celements.length;
            int n2 = 0;
            while (n2 < n) {
                ICElement celement = iCElementArray[n2];
                if (celement.getElementType() == 75 && name.equals(celement.getElementName())) {
                    return (IInclude)celement;
                }
                ++n2;
            }
        }
        catch (CModelException cModelException) {}
        return null;
    }

    @Override
    public IInclude[] getIncludes() throws CModelException {
        ICElement[] celements = this.getChildren();
        ArrayList<ICElement> aList = new ArrayList<ICElement>();
        ICElement[] iCElementArray = celements;
        int n = celements.length;
        int n2 = 0;
        while (n2 < n) {
            ICElement celement = iCElementArray[n2];
            if (celement.getElementType() == 75) {
                aList.add(celement);
            }
            ++n2;
        }
        return aList.toArray(new IInclude[0]);
    }

    @Override
    public IUsing getUsing(String name) {
        try {
            ICElement[] celements;
            ICElement[] iCElementArray = celements = this.getChildren();
            int n = celements.length;
            int n2 = 0;
            while (n2 < n) {
                ICElement celement = iCElementArray[n2];
                if (celement.getElementType() == 62 && name.equals(celement.getElementName())) {
                    return (IUsing)celement;
                }
                ++n2;
            }
        }
        catch (CModelException cModelException) {}
        return null;
    }

    @Override
    public IUsing[] getUsings() throws CModelException {
        ICElement[] celements = this.getChildren();
        ArrayList<ICElement> aList = new ArrayList<ICElement>();
        ICElement[] iCElementArray = celements;
        int n = celements.length;
        int n2 = 0;
        while (n2 < n) {
            ICElement celement = iCElementArray[n2];
            if (celement.getElementType() == 62) {
                aList.add(celement);
            }
            ++n2;
        }
        return aList.toArray(new IUsing[0]);
    }

    @Override
    public INamespace getNamespace(String name) {
        try {
            String[] names = name.split("::");
            ICElement current = this;
            int j = 0;
            while (j < names.length) {
                if (current instanceof IParent) {
                    ICElement[] celements = ((IParent)((Object)current)).getChildren();
                    current = null;
                    ICElement[] iCElementArray = celements;
                    int n = celements.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ICElement celement = iCElementArray[n2];
                        if (celement.getElementType() == 61 && name.equals(celement.getElementName())) {
                            current = celement;
                            break;
                        }
                        ++n2;
                    }
                } else {
                    current = null;
                }
                ++j;
            }
            if (current instanceof INamespace) {
                return (INamespace)current;
            }
        }
        catch (CModelException cModelException) {}
        return null;
    }

    @Override
    public INamespace[] getNamespaces() throws CModelException {
        ICElement[] celements = this.getChildren();
        ArrayList<ICElement> elementList = new ArrayList<ICElement>();
        ICElement[] iCElementArray = celements;
        int n = celements.length;
        int n2 = 0;
        while (n2 < n) {
            ICElement celement = iCElementArray[n2];
            if (celement.getElementType() == 61) {
                elementList.add(celement);
            }
            ++n2;
        }
        return elementList.toArray(new INamespace[0]);
    }

    protected void setLocationURI(URI loc) {
        this.location = loc;
    }

    @Override
    public IPath getLocation() {
        if (this.location == null) {
            IFile file = this.getFile();
            if (file != null) {
                return file.getLocation();
            }
            return null;
        }
        return UNCPathConverter.toPath(this.location);
    }

    @Override
    public URI getLocationURI() {
        if (this.location == null) {
            IFile file = this.getFile();
            if (file != null) {
                this.location = file.getLocationURI();
            } else {
                return null;
            }
        }
        return this.location;
    }

    public IFile getFile() {
        IResource res = this.getResource();
        if (res instanceof IFile) {
            return (IFile)res;
        }
        return null;
    }

    @Override
    public void copy(ICElement container, ICElement sibling, String rename, boolean force, IProgressMonitor monitor) throws CModelException {
        this.getSourceManipulationInfo().copy(container, sibling, rename, force, monitor);
    }

    @Override
    public void delete(boolean force, IProgressMonitor monitor) throws CModelException {
        this.getSourceManipulationInfo().delete(force, monitor);
    }

    @Override
    public void move(ICElement container, ICElement sibling, String rename, boolean force, IProgressMonitor monitor) throws CModelException {
        this.getSourceManipulationInfo().move(container, sibling, rename, force, monitor);
    }

    @Override
    public void rename(String name, boolean force, IProgressMonitor monitor) throws CModelException {
        this.getSourceManipulationInfo().rename(name, force, monitor);
    }

    @Override
    public String getSource() throws CModelException {
        return this.getSourceManipulationInfo().getSource();
    }

    @Override
    public ISourceRange getSourceRange() throws CModelException {
        return this.getSourceManipulationInfo().getSourceRange();
    }

    protected TranslationUnitInfo getTranslationUnitInfo() throws CModelException {
        return (TranslationUnitInfo)this.getElementInfo();
    }

    protected SourceManipulationInfo getSourceManipulationInfo() {
        if (this.sourceManipulationInfo == null) {
            this.sourceManipulationInfo = new SourceManipulationInfo(this);
        }
        return this.sourceManipulationInfo;
    }

    @Override
    protected CElementInfo createElementInfo() {
        return new TranslationUnitInfo(this);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ITranslationUnit)) {
            return false;
        }
        return super.equals(o) && !((ITranslationUnit)o).isWorkingCopy();
    }

    @Override
    public IWorkingCopy findSharedWorkingCopy() {
        return CModelManager.getDefault().findSharedWorkingCopy(null, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CElementInfo getElementInfo(IProgressMonitor monitor) throws CModelException {
        CModelManager manager = CModelManager.getDefault();
        CElementInfo info = (CElementInfo)manager.getInfo(this);
        if (info != null) {
            return info;
        }
        TranslationUnit translationUnit = this;
        synchronized (translationUnit) {
            info = this.createElementInfo();
            this.openWhenClosed(info, monitor);
        }
        return info;
    }

    @Override
    protected boolean buildStructure(OpenableInfo info, IProgressMonitor pm, Map<ICElement, CElementInfo> newElements, IResource underlyingResource) throws CModelException {
        ITranslationUnit original;
        IResource r;
        TranslationUnitInfo unitInfo = (TranslationUnitInfo)info;
        this.parse(newElements, pm);
        if (this.isWorkingCopy() && (r = (original = ((IWorkingCopy)((Object)this)).getOriginalElement()).getResource()) != null && r instanceof IFile) {
            unitInfo.fTimestamp = ((IFile)r).getModificationStamp();
        }
        return unitInfo.isStructureKnown();
    }

    @Override
    public char[] getContents() {
        try {
            IBuffer buffer = this.getBuffer();
            return buffer == null ? null : buffer.getCharacters();
        }
        catch (CModelException cModelException) {
            return new char[0];
        }
    }

    @Override
    public IWorkingCopy getSharedWorkingCopy(IProgressMonitor monitor, IProblemRequestor requestor) throws CModelException {
        return CModelManager.getDefault().getSharedWorkingCopy(null, this, requestor, monitor);
    }

    @Override
    public IWorkingCopy getWorkingCopy() throws CModelException {
        return this.getWorkingCopy(null, null);
    }

    @Override
    public IWorkingCopy getWorkingCopy(IProgressMonitor monitor) throws CModelException {
        return this.getWorkingCopy(monitor, null);
    }

    @Override
    public IWorkingCopy getWorkingCopy(IProgressMonitor monitor, IBufferFactory factory) throws CModelException {
        IFile file = this.getFile();
        WorkingCopy workingCopy = file != null ? new WorkingCopy(this.getParent(), file, this.getContentTypeId(), factory) : new WorkingCopy(this.getParent(), this.getLocationURI(), this.getContentTypeId(), factory);
        workingCopy.open(monitor);
        return workingCopy;
    }

    @Override
    protected boolean hasBuffer() {
        return true;
    }

    @Override
    protected void openParent(CElementInfo childInfo, Map<ICElement, CElementInfo> newElements, IProgressMonitor pm) throws CModelException {
        block2: {
            try {
                super.openParent(childInfo, newElements, pm);
            }
            catch (CModelException e) {
                if (this.isWorkingCopy()) break block2;
                throw e;
            }
        }
    }

    @Override
    public boolean isConsistent() throws CModelException {
        return this.isOpen() && CModelManager.getDefault().getElementsOutOfSynchWithBuffers().get(this) == null;
    }

    @Override
    public void makeConsistent(IProgressMonitor monitor, boolean forced) throws CModelException {
        this.makeConsistent(forced, monitor);
    }

    protected IASTTranslationUnit makeConsistent(boolean computeAST, IProgressMonitor monitor) throws CModelException {
        if (!computeAST && this.isConsistent()) {
            return null;
        }
        CModelManager manager = CModelManager.getDefault();
        boolean hadTemporaryCache = manager.hasTemporaryCache();
        CElementInfo info = computeAST ? new ASTHolderTUInfo(this) : this.createElementInfo();
        try {
            Map<ICElement, CElementInfo> newElements = manager.getTemporaryCache();
            this.openWhenClosed(info, monitor);
            if (newElements.get(this) == null) {
                for (ICElement element : newElements.keySet()) {
                    if (!(element instanceof Openable)) continue;
                    ((Openable)element).closeBuffer();
                }
                throw this.newNotPresentException();
            }
            if (!hadTemporaryCache) {
                manager.putInfos(this, newElements);
            }
        }
        finally {
            if (!hadTemporaryCache) {
                manager.resetTemporaryCache();
            }
        }
        if (info instanceof ASTHolderTUInfo) {
            IASTTranslationUnit ast = ((ASTHolderTUInfo)info).fAST;
            ((ASTHolderTUInfo)info).fAST = null;
            return ast;
        }
        return null;
    }

    @Override
    protected boolean isSourceElement() {
        return true;
    }

    @Override
    public boolean isWorkingCopy() {
        return false;
    }

    @Override
    protected IBuffer openBuffer(IProgressMonitor pm) throws CModelException {
        IBuffer buffer;
        BufferManager bufManager;
        block20: {
            bufManager = this.getBufferManager();
            buffer = this.getBufferFactory().createBuffer(this);
            if (buffer == null) {
                return null;
            }
            if (buffer.getCharacters() == null) {
                IResource resource = this.getResource();
                if (resource != null && resource.getType() == 1) {
                    buffer.setContents(Util.getResourceContentsAsCharArray((IFile)resource));
                } else {
                    IPath path = this.getLocation();
                    File file = path.toFile();
                    if (file != null && file.isFile()) {
                        FileInputStream stream = null;
                        try {
                            try {
                                stream = new FileInputStream(file);
                                buffer.setContents(Util.getInputStreamAsCharArray(stream, (int)file.length(), null));
                            }
                            catch (IOException iOException) {
                                buffer.setContents(new char[0]);
                                if (stream != null) {
                                    try {
                                        ((InputStream)stream).close();
                                    }
                                    catch (IOException iOException2) {}
                                }
                                break block20;
                            }
                        }
                        catch (Throwable throwable) {
                            if (stream != null) {
                                try {
                                    ((InputStream)stream).close();
                                }
                                catch (IOException iOException) {}
                            }
                            throw throwable;
                        }
                        if (stream != null) {
                            try {
                                ((InputStream)stream).close();
                            }
                            catch (IOException iOException) {}
                        }
                    } else {
                        buffer.setContents(new char[0]);
                    }
                }
            }
        }
        bufManager.addBuffer(buffer);
        buffer.addBufferChangedListener(this);
        return buffer;
    }

    @Override
    public Map<?, ?> parse() {
        throw new UnsupportedOperationException("Deprecated method");
    }

    private void parse(Map<ICElement, CElementInfo> newElements, IProgressMonitor monitor) {
        boolean quickParseMode = !CCorePlugin.getDefault().useStructuralParseMode();
        IContributedModelBuilder mb = LanguageManager.getInstance().getContributedModelBuilderFor((ITranslationUnit)this);
        if (mb == null) {
            this.parseUsingCModelBuilder(newElements, quickParseMode, monitor);
        } else {
            this.parseUsingContributedModelBuilder(mb, quickParseMode, monitor);
        }
    }

    private void parseUsingCModelBuilder(Map<ICElement, CElementInfo> newElements, boolean quickParseMode, IProgressMonitor monitor) {
        try {
            new CModelBuilder2(this, newElements, monitor).parse(quickParseMode);
        }
        catch (OperationCanceledException oce) {
            if (this.isWorkingCopy()) {
                throw oce;
            }
        }
        catch (Exception exception) {
            Util.debugLog("Exception in CModelBuilder", DebugLogConstants.MODEL);
        }
    }

    private void parseUsingContributedModelBuilder(IContributedModelBuilder mb, boolean quickParseMode, IProgressMonitor monitor) {
        CModelManager.getDefault().removeChildrenInfo(this);
        try {
            mb.parse(quickParseMode);
        }
        catch (Exception exception) {
            Util.debugLog("Exception in contributed model builder", DebugLogConstants.MODEL);
        }
    }

    public IProblemRequestor getProblemRequestor() {
        return this.problemRequestor;
    }

    @Override
    public boolean isHeaderUnit() {
        return TranslationUnit.isHeaderContentType(this.contentTypeId);
    }

    @Override
    public boolean isSourceUnit() {
        return TranslationUnit.isSourceContentType(this.contentTypeId);
    }

    private static boolean isHeaderContentType(String contentType) {
        return "org.eclipse.cdt.core.cHeader".equals(contentType) || "org.eclipse.cdt.core.cxxHeader".equals(contentType);
    }

    private static boolean isSourceContentType(String contentType) {
        if (TranslationUnit.isHeaderContentType(contentType)) {
            return false;
        }
        return "org.eclipse.cdt.core.cSource".equals(contentType) || "org.eclipse.cdt.core.cxxSource".equals(contentType) || "org.eclipse.cdt.core.asmSource".equals(contentType) || LanguageManager.getInstance().isContributedContentType(contentType);
    }

    @Override
    public boolean isCLanguage() {
        return "org.eclipse.cdt.core.cSource".equals(this.contentTypeId) || "org.eclipse.cdt.core.cHeader".equals(this.contentTypeId);
    }

    @Override
    public boolean isCXXLanguage() {
        return "org.eclipse.cdt.core.cxxSource".equals(this.contentTypeId) || "org.eclipse.cdt.core.cxxHeader".equals(this.contentTypeId);
    }

    @Override
    public boolean isASMLanguage() {
        return "org.eclipse.cdt.core.asmSource".equals(this.contentTypeId);
    }

    @Override
    public boolean exists() {
        IResource res = this.getResource();
        if (res != null) {
            return res.exists();
        }
        if (this.location != null) {
            try {
                IFileStore fileStore = EFS.getStore((URI)this.location);
                IFileInfo info = fileStore.fetchInfo();
                return info.exists();
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
            }
        }
        return false;
    }

    @Override
    public ILanguage getLanguage() throws CoreException {
        ILanguage language = null;
        ICProject cProject = this.getCProject();
        IProject project = cProject.getProject();
        ICProjectDescription description = CoreModel.getDefault().getProjectDescription(project, false);
        ICConfigurationDescription configuration = description == null ? null : description.getActiveConfiguration();
        IFile file = this.getFile();
        if (file != null) {
            language = LanguageManager.getInstance().getLanguageForFile(file, configuration, this.contentTypeId);
        } else {
            String filename = this.getElementName();
            language = LanguageManager.getInstance().getLanguageForFile((IPath)new Path(filename), this.getCProject().getProject(), configuration, this.contentTypeId);
        }
        return language;
    }

    @Override
    public String getContentTypeId() {
        return this.contentTypeId;
    }

    protected void setContentTypeID(String id) {
        this.contentTypeId = id;
    }

    @Override
    protected void closing(Object info) throws CModelException {
        IContentType cType = CCorePlugin.getContentType(this.getCProject().getProject(), this.getElementName());
        if (cType != null) {
            this.setContentTypeID(cType.getId());
        }
        super.closing(info);
    }

    @Override
    public void setIsStructureKnown(boolean wasSuccessful) {
        try {
            this.getElementInfo().setIsStructureKnown(wasSuccessful);
        }
        catch (CModelException cModelException) {}
    }

    @Override
    public IASTTranslationUnit getAST() throws CoreException {
        return this.getAST(null, 0, null);
    }

    @Override
    public IASTTranslationUnit getAST(IIndex index, int style) throws CoreException {
        return this.getAST(index, style, null);
    }

    public IASTTranslationUnit getAST(IIndex index, int style, IProgressMonitor monitor) throws CoreException {
        ILanguage language;
        IScannerInfo scanInfo;
        boolean incompleteIndex = index != null && !index.isFullyInitialized();
        IIndexFile[] contextToHeader = this.getContextToHeader(index, style);
        ITranslationUnit configureWith = this.getConfigureWith(contextToHeader);
        if (configureWith == this) {
            contextToHeader = null;
        }
        if ((scanInfo = configureWith.getScannerInfo((style & 8) == 0)) == null) {
            return null;
        }
        FileContent fileContent = FileContent.create(this);
        if (fileContent == null) {
            return null;
        }
        this.fLanguageOfContext = language = configureWith.getLanguage();
        if (language == null) {
            return null;
        }
        IncludeFileContentProvider crf = this.getIncludeFileContentProvider(style, index, language.getLinkageID(), contextToHeader);
        int options = 0;
        if ((style & 1) != 0) {
            options |= 1;
        }
        if ((style & 0x40) != 0) {
            options |= 0x10;
        }
        if ((style & 0x80) != 0) {
            options |= 0x20;
        }
        if (this.isSourceUnit()) {
            options |= 8;
        }
        IParserLogService log = monitor instanceof ICanceler ? new ParserLogService(DebugLogConstants.PARSER, (ICanceler)monitor) : ParserUtil.getParserLogService();
        ASTTranslationUnit ast = (ASTTranslationUnit)((AbstractLanguage)language).getASTTranslationUnit(fileContent, scanInfo, crf, index, options, log);
        ast.setOriginatingTranslationUnit(this);
        ast.setBasedOnIncompleteIndex(incompleteIndex);
        return ast;
    }

    private IncludeFileContentProvider getIncludeFileContentProvider(int style, IIndex index, int linkageID, IIndexFile[] contextToHeader) {
        ICProject cprj = this.getCProject();
        ProjectIndexerInputAdapter pathResolver = new ProjectIndexerInputAdapter(cprj);
        IncludeFileContentProvider fileContentsProvider = (style & 4) != 0 ? IncludeFileContentProvider.getEmptyFilesProvider() : IncludeFileContentProvider.getSavedFilesProvider();
        if (index != null && (style & 2) != 0) {
            IndexBasedFileContentProvider ibcf = new IndexBasedFileContentProvider(index, pathResolver, linkageID, fileContentsProvider);
            ibcf.setContextToHeaderGap(contextToHeader);
            fileContentsProvider = ibcf;
        }
        if (fileContentsProvider instanceof InternalFileContentProvider) {
            ProjectIndexerIncludeResolutionHeuristics heuristics = new ProjectIndexerIncludeResolutionHeuristics(cprj.getProject(), pathResolver);
            ((InternalFileContentProvider)fileContentsProvider).setIncludeResolutionHeuristics(heuristics);
        }
        return fileContentsProvider;
    }

    public IIndexFile[] getContextToHeader(IIndex index, int style) {
        if (index != null && (style & 0x20) != 0) {
            try {
                this.fLanguageOfContext = null;
                IIndexFileLocation ifl = IndexLocationFactory.getIFL(this);
                if (ifl != null) {
                    IIndexFile best = null;
                    IIndexFile contextOfBest = null;
                    int bestScore = -1;
                    int[] nArray = CTX_LINKAGES;
                    int n = CTX_LINKAGES.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int linkageID = nArray[n2];
                        IIndexFile[] iIndexFileArray = index.getFiles(linkageID, ifl);
                        int n3 = iIndexFileArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IIndexFile indexFile = iIndexFileArray[n4];
                            int score = indexFile.getMacros().length * 2;
                            IIndexFile context = this.getParsedInContext(indexFile);
                            if (this.isSourceFile(context)) {
                                ++score;
                            }
                            if (score > bestScore) {
                                bestScore = score;
                                best = indexFile;
                                contextOfBest = context;
                            }
                            ++n4;
                        }
                        ++n2;
                    }
                    if (best != null && contextOfBest != best) {
                        return new IIndexFile[]{contextOfBest, best};
                    }
                }
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
            }
        }
        return null;
    }

    private IIndexFile getParsedInContext(IIndexFile indexFile) throws CoreException {
        HashSet<IIndexFile> visited = new HashSet<IIndexFile>();
        while (visited.add(indexFile)) {
            IIndexInclude include = indexFile.getParsedInContext();
            if (include == null) break;
            indexFile = include.getIncludedBy();
        }
        return indexFile;
    }

    private boolean isSourceFile(IIndexFile indexFile) throws CoreException {
        String path = indexFile.getLocation().getURI().getPath();
        IContentType cType = CCorePlugin.getContentType(this.getCProject().getProject(), path);
        if (cType == null) {
            return false;
        }
        return TranslationUnit.isSourceContentType(cType.getId());
    }

    private ITranslationUnit getConfigureWith(IIndexFile[] contextToHeader) throws CoreException {
        ITranslationUnit configureWith;
        if (contextToHeader != null && (configureWith = CoreModelUtil.findTranslationUnitForLocation(contextToHeader[0].getLocation(), this.getCProject())) != null) {
            return configureWith;
        }
        return this;
    }

    @Override
    public IASTCompletionNode getCompletionNode(IIndex index, int style, int offset) throws CoreException {
        ILanguage language;
        IScannerInfo scanInfo;
        IIndexFile[] contextToHeader = this.getContextToHeader(index, style);
        ITranslationUnit configureWith = this.getConfigureWith(contextToHeader);
        if (configureWith == this) {
            contextToHeader = null;
        }
        if ((scanInfo = configureWith.getScannerInfo((style & 8) == 0)) == null) {
            return null;
        }
        FileContent fileContent = FileContent.create(this);
        this.fLanguageOfContext = language = configureWith.getLanguage();
        if (language != null) {
            IASTTranslationUnit ast;
            IncludeFileContentProvider crf = this.getIncludeFileContentProvider(style, index, language.getLinkageID(), contextToHeader);
            IASTCompletionNode result = language.getCompletionNode(fileContent, scanInfo, crf, index, ParserUtil.getParserLogService(), offset);
            if (result != null && (ast = result.getTranslationUnit()) != null) {
                ast.setIsHeaderUnit(!this.isSourceUnit());
                ((ASTTranslationUnit)ast).setOriginatingTranslationUnit(this);
            }
            return result;
        }
        return null;
    }

    @Override
    @Deprecated
    public CodeReader getCodeReader() {
        IPath location = this.getLocation();
        if (location == null) {
            return new CodeReader(this.getContents());
        }
        if (this.isWorkingCopy()) {
            return new CodeReader(location.toOSString(), this.getContents());
        }
        IResource res = this.getResource();
        try {
            if (res instanceof IFile) {
                return InternalParserUtil.createWorkspaceFileReader(location.toOSString(), (IFile)res, null);
            }
            return InternalParserUtil.createExternalFileReader(location.toOSString(), null);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
        catch (IOException e) {
            CCorePlugin.log(e);
        }
        return null;
    }

    @Override
    public IScannerInfo getScannerInfo(boolean force) {
        IScannerInfo scanInfo;
        IResource infoResource;
        IResource resource = this.getResource();
        ICProject project = this.getCProject();
        IProject rproject = project.getProject();
        Object object = infoResource = resource != null ? resource : rproject;
        if (!force && CoreModel.isScannerInformationEmpty(infoResource)) {
            return null;
        }
        IScannerInfoProvider provider = CCorePlugin.getDefault().getScannerInfoProvider(rproject);
        if (provider != null && (scanInfo = provider.getScannerInformation(infoResource)) != null) {
            return scanInfo;
        }
        if (force) {
            return new ScannerInfo();
        }
        return null;
    }

    public ILanguage getLanguageOfContext() throws CoreException {
        ILanguage result = this.fLanguageOfContext;
        return result != null ? result : this.getLanguage();
    }

    @Override
    public IPath getPath() {
        if (this.getFile() != null) {
            return super.getPath();
        }
        IPath path = this.getLocation();
        if (path != null) {
            return path;
        }
        return super.getPath();
    }

    @Override
    public ICElement getHandleFromMemento(String token, MementoTokenizer memento) {
        switch (token.charAt(0)) {
            case '[': {
                ICElement[] children;
                int elementType;
                String elementName;
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                token = memento.nextToken();
                if (token.charAt(0) != '#') {
                    elementName = token;
                    if (!memento.hasMoreTokens()) {
                        return null;
                    }
                    token = memento.nextToken();
                } else {
                    elementName = "";
                }
                if (token.charAt(0) != '#' || !memento.hasMoreTokens()) {
                    return null;
                }
                String typeString = memento.nextToken();
                try {
                    elementType = Integer.parseInt(typeString);
                }
                catch (NumberFormatException nfe) {
                    CCorePlugin.log(nfe);
                    return null;
                }
                token = null;
                Object[] mementoParams = new String[]{};
                if (memento.hasMoreTokens()) {
                    ArrayList<String> params = new ArrayList<String>();
                    while ((token = memento.nextToken()).charAt(0) == '(') {
                        if (!memento.hasMoreTokens()) {
                            params.add("");
                            token = null;
                            break;
                        }
                        params.add(memento.nextToken());
                        token = null;
                        if (memento.hasMoreTokens()) continue;
                    }
                    mementoParams = params.toArray(new String[params.size()]);
                }
                CElement element = null;
                try {
                    children = this.getChildren();
                }
                catch (CModelException e) {
                    CCorePlugin.log((Throwable)((Object)e));
                    return null;
                }
                block5 : switch (elementType) {
                    case 70: 
                    case 71: 
                    case 73: 
                    case 74: 
                    case 88: 
                    case 89: 
                    case 90: 
                    case 91: {
                        ICElement[] iCElementArray = children;
                        int n = children.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ICElement element2 = iCElementArray[n2];
                            if (elementType == element2.getElementType() && elementName.equals(element2.getElementName())) {
                                assert (element2 instanceof IFunctionDeclaration);
                                Object[] functionParams = ((IFunctionDeclaration)element2).getParameterTypes();
                                if (Arrays.equals(functionParams, mementoParams)) {
                                    element = (CElement)element2;
                                    break block5;
                                }
                            }
                            ++n2;
                        }
                        break;
                    }
                    case 83: 
                    case 85: 
                    case 87: {
                        ICElement[] iCElementArray = children;
                        int n = children.length;
                        int n3 = 0;
                        while (n3 < n) {
                            ICElement element2 = iCElementArray[n3];
                            if (elementType == element2.getElementType() && elementName.equals(element2.getElementName())) {
                                assert (element2 instanceof ITemplate);
                                Object[] templateParams = ((ITemplate)((Object)element2)).getTemplateParameterTypes();
                                if (Arrays.equals(templateParams, mementoParams)) {
                                    element = (CElement)element2;
                                    break block5;
                                }
                            }
                            ++n3;
                        }
                        break;
                    }
                    default: {
                        ICElement[] iCElementArray = children;
                        int n = children.length;
                        int n4 = 0;
                        while (n4 < n) {
                            ICElement element2 = iCElementArray[n4];
                            if (elementType == element2.getElementType() && elementName.equals(element2.getElementName())) {
                                element = (CElement)element2;
                                break block5;
                            }
                            ++n4;
                        }
                        break block5;
                    }
                }
                if (element == null) break;
                if (token != null) {
                    return element.getHandleFromMemento(token, memento);
                }
                return element.getHandleFromMemento(memento);
            }
        }
        return null;
    }

    @Override
    public void getHandleMemento(StringBuilder buff) {
        if (this.getResource() == null) {
            ((CElement)((Object)this.getCProject())).getHandleMemento(buff);
            buff.append(this.getHandleMementoDelimiter());
            IPath fileLocation = this.getLocation();
            if (fileLocation != null) {
                TranslationUnit.escapeMementoName(buff, fileLocation.toPortableString());
            }
        } else if (this.getParent() instanceof ICContainer) {
            super.getHandleMemento(buff);
        } else {
            ((CElement)((Object)this.getCProject())).getHandleMemento(buff);
            buff.append(this.getHandleMementoDelimiter());
            IPath projectPath = this.getResource().getFullPath().removeFirstSegments(1);
            if (projectPath != null) {
                TranslationUnit.escapeMementoName(buff, projectPath.toPortableString());
            }
        }
    }

    @Override
    protected char getHandleMementoDelimiter() {
        return '{';
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public int getIndex() {
        return 0;
    }

    @Override
    @Deprecated
    public IWorkingCopy findSharedWorkingCopy(IBufferFactory bufferFactory) {
        return CModelManager.getDefault().findSharedWorkingCopy(bufferFactory, this);
    }

    @Override
    @Deprecated
    public IWorkingCopy getSharedWorkingCopy(IProgressMonitor monitor, IBufferFactory factory, IProblemRequestor requestor) throws CModelException {
        return CModelManager.getDefault().getSharedWorkingCopy(factory, this, requestor, monitor);
    }

    @Override
    @Deprecated
    public IWorkingCopy getSharedWorkingCopy(IProgressMonitor monitor, IBufferFactory factory) throws CModelException {
        return CModelManager.getDefault().getSharedWorkingCopy(factory, this, null, monitor);
    }
}

