/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom;

import java.lang.reflect.Field;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPEnumeration;
import org.eclipse.cdt.core.index.IIndexFileSet;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownBinding;
import org.eclipse.cdt.internal.core.index.IIndexFragment;
import org.eclipse.cdt.internal.core.index.IIndexFragmentBinding;
import org.eclipse.cdt.internal.core.index.IIndexScope;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.db.IString;
import org.eclipse.cdt.internal.core.pdom.dom.IPDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMFile;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMName;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNamedNode;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.core.runtime.CoreException;

public abstract class PDOMBinding
extends PDOMNamedNode
implements IPDOMBinding {
    public static final PDOMBinding[] EMPTY_PDOMBINDING_ARRAY = new PDOMBinding[0];
    private static final int FIRST_DECL_OFFSET = 12;
    private static final int FIRST_DEF_OFFSET = 16;
    private static final int FIRST_REF_OFFSET = 20;
    private static final int LOCAL_TO_FILE = 24;
    protected static final int RECORD_SIZE = 28;
    private byte hasDeclaration = (byte)-1;

    protected PDOMBinding(PDOMLinkage linkage, PDOMNode parent, char[] name) throws CoreException {
        super(linkage, parent, name);
    }

    public PDOMBinding(PDOMLinkage linkage, long record) {
        super(linkage, record);
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(PDOMBinding.class)) {
            return this;
        }
        return null;
    }

    public static boolean isOrphaned(PDOM pdom, long record) throws CoreException {
        Database db = pdom.getDB();
        return db.getRecPtr(record + 12L) == 0L && db.getRecPtr(record + 16L) == 0L && db.getRecPtr(record + 20L) == 0L;
    }

    @Override
    public final boolean hasDeclaration() throws CoreException {
        if (this.hasDeclaration == -1) {
            Database db = this.getDB();
            if (db.getRecPtr(this.record + 12L) != 0L || db.getRecPtr(this.record + 16L) != 0L) {
                this.hasDeclaration = 1;
                return true;
            }
            this.hasDeclaration = 0;
            return false;
        }
        return this.hasDeclaration != 0;
    }

    public final void addDeclaration(PDOMName name) throws CoreException {
        PDOMName first = this.getFirstDeclaration();
        if (first != null) {
            first.setPrevInBinding(name);
            name.setNextInBinding(first);
        }
        this.setFirstDeclaration(name);
    }

    public final void addDefinition(PDOMName name) throws CoreException {
        PDOMName first = this.getFirstDefinition();
        if (first != null) {
            first.setPrevInBinding(name);
            name.setNextInBinding(first);
        }
        this.setFirstDefinition(name);
    }

    public final void addReference(PDOMName name) throws CoreException {
        PDOMName first = this.getFirstReference();
        if (first != null) {
            first.setPrevInBinding(name);
            name.setNextInBinding(first);
        }
        this.setFirstReference(name);
    }

    public PDOMName getFirstDeclaration() throws CoreException {
        long namerec = this.getDB().getRecPtr(this.record + 12L);
        return namerec != 0L ? new PDOMName((PDOMLinkage)this.getLinkage(), namerec) : null;
    }

    public void setFirstDeclaration(PDOMName name) throws CoreException {
        long namerec = name != null ? name.getRecord() : 0L;
        this.getDB().putRecPtr(this.record + 12L, namerec);
    }

    public PDOMName getFirstDefinition() throws CoreException {
        long namerec = this.getDB().getRecPtr(this.record + 16L);
        return namerec != 0L ? new PDOMName((PDOMLinkage)this.getLinkage(), namerec) : null;
    }

    public void setFirstDefinition(PDOMName name) throws CoreException {
        long namerec = name != null ? name.getRecord() : 0L;
        this.getDB().putRecPtr(this.record + 16L, namerec);
    }

    public PDOMName getFirstReference() throws CoreException {
        long namerec = this.getDB().getRecPtr(this.record + 20L);
        return namerec != 0L ? new PDOMName((PDOMLinkage)this.getLinkage(), namerec) : null;
    }

    public void setFirstReference(PDOMName name) throws CoreException {
        long namerec = name != null ? name.getRecord() : 0L;
        this.getDB().putRecPtr(this.record + 20L, namerec);
    }

    @Override
    public final PDOMFile getLocalToFile() throws CoreException {
        long filerec = PDOMBinding.getLocalToFileRec(this.getDB(), this.record);
        return filerec == 0L ? null : new PDOMFile((PDOMLinkage)this.getLinkage(), filerec);
    }

    public final long getLocalToFileRec() throws CoreException {
        return PDOMBinding.getLocalToFileRec(this.getDB(), this.record);
    }

    public static long getLocalToFileRec(Database db, long record) throws CoreException {
        return db.getRecPtr(record + 24L);
    }

    public final void setLocalToFileRec(long rec) throws CoreException {
        this.getDB().putRecPtr(this.record + 24L, rec);
    }

    @Override
    public String getName() {
        try {
            return super.getDBName().getString();
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return "";
        }
    }

    @Override
    public char[] getNameCharArray() {
        try {
            return super.getNameCharArray();
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return CharArrayUtils.EMPTY;
        }
    }

    public IIndexScope getParent() {
        try {
            IIndexFragmentBinding parent = this.getParentBinding();
            if (parent instanceof IIndexScope) {
                return (IIndexScope)((Object)parent);
            }
        }
        catch (CoreException ce) {
            CCorePlugin.log(ce);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final IIndexScope getScope() {
        try {
            IIndexFragmentBinding parent = this.getParentBinding();
            while (true) {
                if (parent == null) {
                    return null;
                }
                if (parent instanceof ICPPClassType) {
                    return (IIndexScope)((ICPPClassType)((Object)parent)).getCompositeScope();
                }
                if (parent instanceof ICPPUnknownBinding) {
                    return (IIndexScope)((Object)((ICPPUnknownBinding)((Object)parent)).asScope());
                }
                if (!(parent instanceof ICPPEnumeration)) {
                    if (!(parent instanceof IIndexScope)) return null;
                    return (IIndexScope)((Object)parent);
                }
                ICPPEnumeration enumeration = (ICPPEnumeration)((Object)parent);
                if (enumeration.isScoped()) {
                    return (IIndexScope)((Object)enumeration.asScope());
                }
                parent = ((PDOMNamedNode)((Object)parent)).getParentBinding();
            }
        }
        catch (DOMException dOMException) {
            return null;
        }
        catch (CoreException ce) {
            CCorePlugin.log(ce);
        }
        return null;
    }

    @Override
    public IIndexFragment getFragment() {
        return this.getPDOM();
    }

    @Override
    protected abstract int getRecordSize();

    public final String toString() {
        String name = this.toStringBase();
        return String.valueOf(name) + " " + PDOMBinding.getConstantNameForValue((PDOMLinkage)this.getLinkage(), this.getNodeType());
    }

    protected String toStringBase() {
        if (this instanceof IType) {
            return ASTTypeUtil.getType((IType)((Object)this));
        }
        if (this instanceof IFunction) {
            IFunctionType t = null;
            t = ((IFunction)((Object)this)).getType();
            if (t != null) {
                return String.valueOf(this.getName()) + ASTTypeUtil.getParameterTypeString(t);
            }
            return String.valueOf(this.getName()) + "()";
        }
        return this.getName();
    }

    protected static String getConstantNameForValue(PDOMLinkage linkage, int value) {
        Field[] fields;
        Class<?> c = linkage.getClass();
        Field[] fieldArray = fields = c.getFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            try {
                int fvalue;
                field.setAccessible(true);
                if ((field.getModifiers() & 8) != 0 && Integer.TYPE.equals(field.getType()) && (fvalue = field.getInt(null)) == value) {
                    return field.getName();
                }
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            ++n2;
        }
        return Integer.toString(value);
    }

    public PDOMName getScopeName() {
        try {
            PDOMName name = this.getFirstDefinition();
            if (name == null) {
                name = this.getFirstDeclaration();
            }
            return name;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return null;
        }
    }

    @Override
    public String[] getQualifiedName() {
        return new String[]{this.getName()};
    }

    @Override
    public final boolean isFileLocal() throws CoreException {
        return this.getDB().getRecPtr(this.record + 24L) != 0L;
    }

    @Override
    public boolean hasDefinition() throws CoreException {
        return this.getDB().getRecPtr(this.record + 16L) != 0L;
    }

    private static int comparePDOMBindingQNs(PDOMBinding b0, PDOMBinding b1) {
        try {
            int cmp = 0;
            do {
                long l2;
                IString s1;
                IString s0;
                if ((cmp = (s0 = b0.getDBName()).compare(s1 = b1.getDBName(), true)) != 0) continue;
                long l1 = b0.getLocalToFileRec();
                if (l1 != (l2 = b1.getLocalToFileRec())) {
                    return l1 < l2 ? -1 : 1;
                }
                b0 = (PDOMBinding)b0.getParentBinding();
                b1 = (PDOMBinding)b1.getParentBinding();
                if (b0 != null && b1 != null) continue;
                int n = b0 == b1 ? 0 : (cmp = b0 == null ? -1 : 1);
            } while (cmp == 0 && b1 != null && b0 != null);
            return cmp;
        }
        catch (CoreException ce) {
            CCorePlugin.log(ce);
            return -1;
        }
    }

    public int pdomCompareTo(PDOMBinding other) {
        int cmp = PDOMBinding.comparePDOMBindingQNs(this, other);
        if (cmp == 0) {
            int t2;
            int t1 = this.getNodeType();
            return t1 < (t2 = other.getNodeType()) ? -1 : (t1 > t2 ? 1 : 0);
        }
        return cmp;
    }

    public final boolean pdomEquals(PDOMBinding other) {
        return this.pdomCompareTo(other) == 0;
    }

    @Override
    public final int getBindingConstant() {
        return this.getNodeType();
    }

    public void update(PDOMLinkage linkage, IBinding newBinding) throws CoreException {
    }

    @Override
    public final void delete(PDOMLinkage linkage) throws CoreException {
        assert (false);
    }

    public int getAdditionalNameFlags(int standardFlags, IASTName name) {
        return 0;
    }

    public final IBinding getBinding(IASTName name, boolean resolve) {
        return this.getBinding(name, resolve, null);
    }

    public IBinding getBinding(IASTName name, boolean resolve, IIndexFileSet fileSet) {
        return null;
    }

    public final IBinding[] getBindings(IASTName name, boolean resolve, boolean prefix) {
        return this.getBindings(new IScope.ScopeLookupData(name, resolve, prefix));
    }

    @Deprecated
    public IBinding[] getBindings(IASTName name, boolean resolve, boolean prefix, IIndexFileSet fileSet) {
        return IBinding.EMPTY_BINDING_ARRAY;
    }

    public IBinding[] getBindings(IScope.ScopeLookupData lookup) {
        return IBinding.EMPTY_BINDING_ARRAY;
    }
}

