/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBase;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.core.parser.util.ObjectMap;
import org.eclipse.cdt.internal.core.dom.parser.ISerializableType;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateParameterMap;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPUnknownBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPDeferredClassInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.index.IIndexFragment;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPDeferredClassInstance;
import org.eclipse.core.runtime.CoreException;

public class CPPDeferredClassInstance
extends CPPUnknownBinding
implements ICPPDeferredClassInstance,
ISerializableType {
    private final ICPPTemplateArgument[] fArguments;
    private final ICPPClassTemplate fClassTemplate;
    private final ICPPScope fLookupScope;

    public CPPDeferredClassInstance(ICPPClassTemplate template, ICPPTemplateArgument[] arguments, ICPPScope lookupScope) {
        super(template.getNameCharArray());
        this.fArguments = arguments;
        this.fClassTemplate = template;
        this.fLookupScope = lookupScope;
    }

    public CPPDeferredClassInstance(ICPPClassTemplate template, ICPPTemplateArgument[] arguments) {
        this(template, arguments, null);
    }

    @Override
    public IBinding getOwner() {
        return this.fClassTemplate.getOwner();
    }

    @Override
    public ICPPClassTemplate getClassTemplate() {
        return (ICPPClassTemplate)this.getSpecializedBinding();
    }

    @Override
    public boolean isExplicitSpecialization() {
        return false;
    }

    @Override
    public CPPDeferredClassInstance clone() {
        CPPDeferredClassInstance cloned = (CPPDeferredClassInstance)super.clone();
        return cloned;
    }

    @Override
    public boolean isSameType(IType type) {
        if (type == this) {
            return true;
        }
        if (type instanceof ITypedef) {
            return type.isSameType(this);
        }
        ICPPClassTemplate classTemplate = this.getClassTemplate();
        if (type instanceof ICPPDeferredClassInstance) {
            ICPPDeferredClassInstance rhs = (ICPPDeferredClassInstance)type;
            if (!classTemplate.isSameType((IType)((Object)rhs.getSpecializedBinding()))) {
                return false;
            }
            return CPPTemplates.haveSameArguments(this, rhs);
        }
        return false;
    }

    @Override
    public int getKey() {
        return this.getClassTemplate().getKey();
    }

    @Override
    public ICPPBase[] getBases() {
        return ICPPBase.EMPTY_BASE_ARRAY;
    }

    @Override
    public IField[] getFields() {
        return IField.EMPTY_FIELD_ARRAY;
    }

    @Override
    public IField findField(String name) {
        return null;
    }

    @Override
    public ICPPField[] getDeclaredFields() {
        return ICPPField.EMPTY_CPPFIELD_ARRAY;
    }

    @Override
    public ICPPMethod[] getMethods() {
        return ICPPMethod.EMPTY_CPPMETHOD_ARRAY;
    }

    @Override
    public ICPPMethod[] getAllDeclaredMethods() {
        return ICPPMethod.EMPTY_CPPMETHOD_ARRAY;
    }

    @Override
    public ICPPMethod[] getDeclaredMethods() {
        return ICPPMethod.EMPTY_CPPMETHOD_ARRAY;
    }

    @Override
    public ICPPConstructor[] getConstructors() {
        return ICPPConstructor.EMPTY_CONSTRUCTOR_ARRAY;
    }

    @Override
    public IBinding[] getFriends() {
        return IBinding.EMPTY_BINDING_ARRAY;
    }

    @Override
    public final IScope getCompositeScope() {
        return this.asScope();
    }

    @Override
    public ICPPClassType[] getNestedClasses() {
        return ICPPClassType.EMPTY_CLASS_ARRAY;
    }

    @Override
    public boolean isAnonymous() {
        return false;
    }

    @Override
    public boolean isFinal() {
        return false;
    }

    @Override
    @Deprecated
    public IType[] getArguments() {
        return CPPTemplates.getArguments(this.getTemplateArguments());
    }

    @Override
    public ICPPTemplateArgument[] getTemplateArguments() {
        return this.fArguments;
    }

    @Override
    public ICPPTemplateDefinition getTemplateDefinition() {
        return this.fClassTemplate;
    }

    @Override
    public ObjectMap getArgumentMap() {
        return ObjectMap.EMPTY_MAP;
    }

    @Override
    public CPPTemplateParameterMap getTemplateParameterMap() {
        ICPPTemplateParameter[] params = this.fClassTemplate.getTemplateParameters();
        int size = Math.min(this.fArguments.length, params.length);
        CPPTemplateParameterMap map = new CPPTemplateParameterMap(size);
        int i = 0;
        while (i < size) {
            map.put(params[i], this.fArguments[i]);
            ++i;
        }
        return map;
    }

    @Override
    public IBinding getSpecializedBinding() {
        return this.getTemplateDefinition();
    }

    @Override
    public IScope getScope() throws DOMException {
        return this.fClassTemplate.getScope();
    }

    @Override
    public ICPPScope asScope() {
        if (this.fLookupScope != null) {
            return this.fLookupScope;
        }
        return super.asScope();
    }

    @Override
    public String toString() {
        return ASTTypeUtil.getType(this, true);
    }

    @Override
    public void marshal(ITypeMarshalBuffer buffer) throws CoreException {
        int firstByte = 14;
        buffer.putByte((byte)firstByte);
        buffer.marshalBinding(this.fClassTemplate);
        buffer.putShort((short)this.fArguments.length);
        ICPPTemplateArgument[] iCPPTemplateArgumentArray = this.fArguments;
        int n = this.fArguments.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPTemplateArgument arg = iCPPTemplateArgumentArray[n2];
            buffer.marshalTemplateArgument(arg);
            ++n2;
        }
    }

    public static ICPPDeferredClassInstance unmarshal(IIndexFragment fragment, int firstByte, ITypeMarshalBuffer buffer) throws CoreException {
        IBinding template = buffer.unmarshalBinding();
        int argcount = buffer.getShort() & 0xFFFF;
        ICPPTemplateArgument[] args = new ICPPTemplateArgument[argcount];
        int i = 0;
        while (i < argcount) {
            args[i] = buffer.unmarshalTemplateArgument();
            ++i;
        }
        return new PDOMCPPDeferredClassInstance(fragment, (ICPPClassTemplate)template, args);
    }
}

