/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameterMap;
import org.eclipse.cdt.internal.core.dom.parser.ISerializableEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.cdt.internal.core.dom.parser.ProblemType;
import org.eclipse.cdt.internal.core.dom.parser.Value;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBasicType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.TypeOfDependentExpression;
import org.eclipse.core.runtime.CoreException;

public class EvalUnaryTypeID
extends CPPEvaluation {
    private final int fOperator;
    private final IType fOrigType;
    private IType fType;

    public EvalUnaryTypeID(int operator, IType type) {
        this.fOperator = operator;
        this.fOrigType = type;
    }

    public int getOperator() {
        return this.fOperator;
    }

    public IType getArgument() {
        return this.fOrigType;
    }

    @Override
    public boolean isInitializerList() {
        return false;
    }

    @Override
    public boolean isFunctionSet() {
        return false;
    }

    @Override
    public boolean isTypeDependent() {
        if (this.fOperator == 3) {
            return CPPTemplates.isDependentType(this.fOrigType);
        }
        return false;
    }

    @Override
    public boolean isValueDependent() {
        switch (this.fOperator) {
            case 0: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                return CPPTemplates.isDependentType(this.fOrigType);
            }
            case 1: 
            case 3: {
                return false;
            }
        }
        return false;
    }

    @Override
    public IType getTypeOrFunctionSet(IASTNode point) {
        if (this.fType == null) {
            this.fType = this.computeType(point);
        }
        return this.fType;
    }

    private IType computeType(IASTNode point) {
        switch (this.fOperator) {
            case 0: 
            case 2: {
                return CPPVisitor.get_SIZE_T(point);
            }
            case 1: {
                return CPPVisitor.get_type_info(point);
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                return CPPBasicType.BOOLEAN;
            }
            case 3: {
                if (this.isTypeDependent()) {
                    return new TypeOfDependentExpression(this);
                }
                return this.fOrigType;
            }
        }
        return ProblemType.UNKNOWN_FOR_EXPRESSION;
    }

    @Override
    public IValue getValue(IASTNode point) {
        if (this.isValueDependent()) {
            return Value.create(this);
        }
        return Value.evaluateUnaryTypeIdExpression(this.fOperator, this.fOrigType, point);
    }

    @Override
    public IASTExpression.ValueCategory getValueCategory(IASTNode point) {
        return this.fOperator == 1 ? IASTExpression.ValueCategory.LVALUE : IASTExpression.ValueCategory.PRVALUE;
    }

    @Override
    public void marshal(ITypeMarshalBuffer buffer, boolean includeValue) throws CoreException {
        buffer.putByte((byte)15);
        buffer.putByte((byte)this.fOperator);
        buffer.marshalType(this.fOrigType);
    }

    public static ISerializableEvaluation unmarshal(int firstByte, ITypeMarshalBuffer buffer) throws CoreException {
        int op = buffer.getByte();
        IType arg = buffer.unmarshalType();
        return new EvalUnaryTypeID(op, arg);
    }

    @Override
    public ICPPEvaluation instantiate(ICPPTemplateParameterMap tpMap, int packOffset, ICPPClassSpecialization within, int maxdepth, IASTNode point) {
        IType type = CPPTemplates.instantiateType(this.fOrigType, tpMap, packOffset, within, point);
        if (type == this.fOrigType) {
            return this;
        }
        return new EvalUnaryTypeID(this.fOperator, type);
    }

    @Override
    public int determinePackSize(ICPPTemplateParameterMap tpMap) {
        return CPPTemplates.determinePackSize(this.fOrigType, tpMap);
    }

    @Override
    public boolean referencesTemplateParameter() {
        return false;
    }
}

