/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IContributedModelBuilder;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.parser.IToken;
import org.eclipse.cdt.core.parser.OffsetLimitReachedException;
import org.eclipse.cdt.internal.core.model.AsmLabel;
import org.eclipse.cdt.internal.core.model.CElement;
import org.eclipse.cdt.internal.core.model.Include;
import org.eclipse.cdt.internal.core.model.Macro;
import org.eclipse.cdt.internal.core.model.SourceManipulation;
import org.eclipse.cdt.internal.core.model.SourceManipulationInfo;
import org.eclipse.cdt.internal.core.model.TranslationUnit;
import org.eclipse.cdt.internal.core.parser.scanner.ILexerLog;
import org.eclipse.cdt.internal.core.parser.scanner.Lexer;
import org.eclipse.cdt.internal.core.parser.scanner.Token;

public class AsmModelBuilder
implements IContributedModelBuilder {
    private static final Map<String, AsmDirective> fgDirectives = new HashMap<String, AsmDirective>();
    private TranslationUnit fTranslationUnit;
    private char fLineSeparatorChar;
    private Map<String, Counter> fGlobals;
    private Map<String, Counter> fLabels;
    private int fLastLabelEndOffset;
    private AsmLabel fLastGlobalLabel;
    private SourceManipulation fLastLabel;
    private Lexer fLexer;

    static {
        fgDirectives.put("globl", AsmDirective.GLOBAL);
        fgDirectives.put("global", AsmDirective.GLOBAL);
        fgDirectives.put("ascii", AsmDirective.DATA);
        fgDirectives.put("asciz", AsmDirective.DATA);
        fgDirectives.put("byte", AsmDirective.DATA);
        fgDirectives.put("long", AsmDirective.DATA);
        fgDirectives.put("word", AsmDirective.DATA);
    }

    public AsmModelBuilder(ITranslationUnit tu) {
        this.fTranslationUnit = (TranslationUnit)tu;
    }

    public void setLineSeparatorCharacter(char lineSeparatorChar) {
        this.fLineSeparatorChar = lineSeparatorChar;
    }

    @Override
    public void parse(boolean quickParseMode) throws Exception {
        char[] source = this.fTranslationUnit.getContents();
        if (source == null) {
            return;
        }
        this.buildModel(source);
        this.fTranslationUnit.setIsStructureKnown(true);
        this.fGlobals = null;
        this.fLabels = null;
        this.fLexer = null;
    }

    private void buildModel(char[] source) throws CModelException {
        this.fGlobals = new HashMap<String, Counter>();
        this.fLabels = new HashMap<String, Counter>();
        this.fLastLabel = null;
        this.fLastGlobalLabel = null;
        this.fLastLabelEndOffset = 0;
        Lexer.LexerOptions lexerOptions = new Lexer.LexerOptions();
        this.fLexer = new Lexer(source, lexerOptions, (ILexerLog)new LexerLog(), null);
        boolean firstTokenOnLine = true;
        boolean expectInstruction = true;
        boolean inInstruction = false;
        IToken token = this.nextToken();
        while (token != null) {
            switch (token.getType()) {
                case 138: {
                    if (!this.fLexer.currentTokenIsFirstOnLine()) break;
                    this.parsePPDirective(this.fTranslationUnit);
                    break;
                }
                case 50: {
                    firstTokenOnLine = false;
                    if (!expectInstruction) break;
                    expectInstruction = false;
                    token = this.nextToken();
                    if (token == null || token.getType() != 1) break;
                    String text = token.getImage();
                    if (AsmModelBuilder.isGlobalDirective(text)) {
                        firstTokenOnLine = this.parseGlobalDirective();
                        break;
                    }
                    if (!AsmModelBuilder.isDataDirective(text)) break;
                    inInstruction = true;
                    break;
                }
                case 1: {
                    if (firstTokenOnLine) {
                        char nextChar = source[token.getEndOffset()];
                        if (nextChar == ':') {
                            this.createLabel(this.fTranslationUnit, token);
                            expectInstruction = true;
                        } else {
                            expectInstruction = false;
                            inInstruction = true;
                        }
                        firstTokenOnLine = false;
                        break;
                    }
                    if (!expectInstruction) break;
                    expectInstruction = false;
                    inInstruction = true;
                    break;
                }
                case -99: {
                    if (firstTokenOnLine) break;
                    firstTokenOnLine = true;
                    if (!inInstruction) break;
                    this.fLastLabelEndOffset = this.fLexer.currentToken().getEndOffset();
                    break;
                }
                default: {
                    expectInstruction = false;
                    firstTokenOnLine = false;
                    if (this.fLineSeparatorChar == '\u0000' || token.getLength() != 1 || token.getCharImage()[0] != this.fLineSeparatorChar) break;
                    firstTokenOnLine = true;
                }
            }
            if (firstTokenOnLine) {
                expectInstruction = true;
                inInstruction = false;
            }
            token = this.nextToken();
        }
        if (!firstTokenOnLine && inInstruction) {
            this.fLastLabelEndOffset = this.fLexer.currentToken().getEndOffset();
        }
        if (this.fLastLabel != null) {
            this.fixupLastLabel();
        }
        if (this.fLastGlobalLabel != null) {
            this.fixupLastGlobalLabel();
        }
    }

    protected IToken nextToken() {
        Token token;
        try {
            token = this.fLexer.nextToken();
            if (token.getType() == 144) {
                token = null;
            }
        }
        catch (OffsetLimitReachedException offsetLimitReachedException) {
            token = null;
        }
        return token;
    }

    private boolean parseGlobalDirective() {
        IToken t;
        boolean eol = false;
        while ((t = this.nextToken()) != null) {
            switch (t.getType()) {
                case 1: {
                    this.registerGlobalLabel(t.getImage());
                    break;
                }
                case -99: {
                    eol = true;
                    break;
                }
                default: {
                    if (this.fLineSeparatorChar == '\u0000' || t.getLength() != 1 || t.getCharImage()[0] != this.fLineSeparatorChar) break;
                    eol = true;
                }
            }
            if (!eol) continue;
        }
        return eol;
    }

    private static final boolean isDataDirective(String directive) {
        return fgDirectives.get(directive) == AsmDirective.DATA;
    }

    private static final boolean isGlobalDirective(String directive) {
        return fgDirectives.get(directive) == AsmDirective.GLOBAL;
    }

    protected void registerGlobalLabel(String labelName) {
        Counter counter = this.fGlobals.get(labelName);
        if (counter == null) {
            counter = new Counter();
            this.fGlobals.put(labelName, counter);
        }
        ++counter.fCount;
    }

    private int getGlobalLabelIndex(String labelName) {
        Counter counter = this.fGlobals.get(labelName);
        if (counter == null) {
            return 0;
        }
        return counter.fCount;
    }

    protected int registerLabel(String labelName) {
        Counter counter = this.fLabels.get(labelName);
        if (counter == null) {
            counter = new Counter();
            this.fLabels.put(labelName, counter);
        }
        return counter.fCount++;
    }

    protected void createLabel(CElement parent, IToken token) throws CModelException {
        boolean global;
        String labelName = token.getImage();
        int index = this.getGlobalLabelIndex(labelName);
        boolean bl = global = index > 0;
        if (!global) {
            index = this.registerLabel(labelName);
        }
        AsmLabel label = new AsmLabel(parent, labelName, global, index);
        SourceManipulationInfo labelInfo = label.getSourceManipulationInfo();
        labelInfo.setIdPos(token.getOffset(), token.getLength());
        labelInfo.setPos(token.getOffset(), token.getLength());
        if (this.fLastLabel != null) {
            this.fixupLastLabel();
        }
        if (global) {
            if (this.fLastGlobalLabel != null) {
                this.fixupLastGlobalLabel();
            }
            this.fLastGlobalLabel = label;
        } else if (this.fLastGlobalLabel != null) {
            parent = this.fLastGlobalLabel;
        }
        this.fLastLabel = label;
        parent.addChild(label);
    }

    private void fixupLastGlobalLabel() throws CModelException {
        if (this.fLastLabel != null && this.fLastLabel != this.fLastGlobalLabel) {
            SourceManipulationInfo globalLabelInfo = this.fLastGlobalLabel.getSourceManipulationInfo();
            SourceManipulationInfo labelInfo = this.fLastLabel.getSourceManipulationInfo();
            globalLabelInfo.setPos(globalLabelInfo.getStartPos(), labelInfo.getStartPos() + labelInfo.getLength() - globalLabelInfo.getStartPos());
        }
    }

    private void fixupLastLabel() throws CModelException {
        if (this.fLastLabelEndOffset > 0) {
            SourceManipulationInfo labelInfo = this.fLastLabel.getSourceManipulationInfo();
            labelInfo.setPos(labelInfo.getStartPos(), this.fLastLabelEndOffset - labelInfo.getStartPos());
            this.fLastLabelEndOffset = 0;
        }
    }

    private void parsePPDirective(CElement parent) throws CModelException {
        IToken token = this.nextToken();
        if (token != null && token.getType() == 1) {
            String image = token.getImage();
            if (image.equals("define")) {
                try {
                    this.parsePPDefine(parent);
                }
                catch (OffsetLimitReachedException offsetLimitReachedException) {}
                return;
            }
            if (image.equals("include")) {
                try {
                    this.parsePPInclude(parent);
                }
                catch (OffsetLimitReachedException offsetLimitReachedException) {}
                return;
            }
        }
        try {
            this.skipToNewLine();
        }
        catch (OffsetLimitReachedException offsetLimitReachedException) {}
    }

    protected int skipToNewLine() throws OffsetLimitReachedException {
        return this.fLexer.consumeLine(this.fLexer.currentToken().getEndOffset());
    }

    private void parsePPDefine(CElement parent) throws CModelException, OffsetLimitReachedException {
        int startOffset = this.fLexer.currentToken().getOffset();
        int nameStart = 0;
        int nameEnd = 0;
        String name = null;
        IToken t = this.nextToken();
        if (t.getType() == 1) {
            nameStart = this.fLexer.currentToken().getOffset();
            nameEnd = this.fLexer.currentToken().getEndOffset();
            name = t.getImage();
        }
        if (name == null) {
            return;
        }
        int endOffset = this.skipToNewLine();
        Macro macro = new Macro(parent, name);
        SourceManipulationInfo macroInfo = macro.getSourceManipulationInfo();
        macroInfo.setIdPos(nameStart, nameEnd - nameStart);
        macroInfo.setPos(startOffset, endOffset - startOffset);
        parent.addChild(macro);
    }

    private void parsePPInclude(CElement parent) throws CModelException, OffsetLimitReachedException {
        int startOffset = this.fLexer.currentToken().getOffset();
        int nameStart = 0;
        int nameEnd = 0;
        String name = null;
        boolean isStandard = false;
        IToken t = this.nextToken();
        switch (t.getType()) {
            case 42: {
                nameStart = this.fLexer.currentToken().getOffset();
                while ((t = this.nextToken()).getType() != 46) {
                }
                nameEnd = this.fLexer.currentToken().getEndOffset();
                name = new String(this.fLexer.getInputChars(nameStart + 1, nameEnd - 1));
                isStandard = true;
                break;
            }
            case 130: {
                nameStart = this.fLexer.currentToken().getOffset();
                nameEnd = this.fLexer.currentToken().getEndOffset();
                name = t.getImage().substring(1, t.getLength() - 1);
                break;
            }
            case 1: {
                nameStart = this.fLexer.currentToken().getOffset();
                nameEnd = this.fLexer.currentToken().getEndOffset();
                name = t.getImage();
            }
        }
        if (name == null) {
            return;
        }
        int endOffset = this.skipToNewLine();
        Include include = new Include((ICElement)parent, name, isStandard);
        SourceManipulationInfo includeInfo = include.getSourceManipulationInfo();
        includeInfo.setIdPos(nameStart, nameEnd - nameStart);
        includeInfo.setPos(startOffset, endOffset - startOffset);
        parent.addChild(include);
    }

    private static final class AsmDirective {
        private static final AsmDirective GLOBAL = new AsmDirective();
        private static final AsmDirective DATA = new AsmDirective();

        private AsmDirective() {
        }
    }

    private static final class Counter {
        int fCount;

        private Counter() {
        }
    }

    private static final class LexerLog
    implements ILexerLog {
        private LexerLog() {
        }

        @Override
        public void handleComment(boolean isBlockComment, int offset, int endOffset) {
        }

        @Override
        public void handleProblem(int problemID, char[] info, int offset, int endOffset) {
        }
    }
}

