/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.c;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IPDOMNode;
import org.eclipse.cdt.core.dom.IPDOMVisitor;
import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.cdt.internal.core.index.IIndexType;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.db.PDOMNodeLinkedList;
import org.eclipse.cdt.internal.core.pdom.dom.IPDOMMemberOwner;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.c.PDOMCEnumerator;
import org.eclipse.core.runtime.CoreException;

class PDOMCEnumeration
extends PDOMBinding
implements IEnumeration,
IIndexType,
IPDOMMemberOwner {
    private static final int OFFSET_ENUMERATOR_LIST = 28;
    private static final int OFFSET_MIN_VALUE = 32;
    private static final int OFFSET_MAX_VALUE = 40;
    protected static final int RECORD_SIZE = 48;
    private Long fMinValue;
    private Long fMaxValue;

    public PDOMCEnumeration(PDOMLinkage linkage, PDOMNode parent, IEnumeration enumeration) throws CoreException {
        super(linkage, parent, enumeration.getNameCharArray());
        this.storeValueBounds(enumeration);
    }

    public PDOMCEnumeration(PDOMLinkage linkage, long record) {
        super(linkage, record);
    }

    @Override
    public void update(PDOMLinkage linkage, IBinding newBinding) throws CoreException {
        this.storeValueBounds((IEnumeration)newBinding);
    }

    private void storeValueBounds(IEnumeration enumeration) throws CoreException {
        Database db = this.getDB();
        long minValue = enumeration.getMinValue();
        long maxValue = enumeration.getMaxValue();
        db.putLong(this.record + 32L, minValue);
        db.putLong(this.record + 40L, maxValue);
        this.fMinValue = minValue;
        this.fMaxValue = maxValue;
    }

    @Override
    protected int getRecordSize() {
        return 48;
    }

    @Override
    public int getNodeType() {
        return 10;
    }

    @Override
    public IEnumerator[] getEnumerators() {
        List<PDOMCEnumerator> result = this.getCachedEnumerators(true);
        return result.toArray(new IEnumerator[result.size()]);
    }

    private List<PDOMCEnumerator> getCachedEnumerators(boolean create) {
        List<PDOMCEnumerator> result;
        Long key = this.record;
        PDOM pdom = this.getPDOM();
        Reference cached = (Reference)pdom.getCachedResult(key);
        List<PDOMCEnumerator> list = result = cached == null ? null : (List<PDOMCEnumerator>)cached.get();
        if (result == null && create) {
            result = this.loadEnumerators();
            pdom.putCachedResult(key, new SoftReference<List<PDOMCEnumerator>>(result));
        }
        return result;
    }

    private List<PDOMCEnumerator> loadEnumerators() {
        final ArrayList<PDOMCEnumerator> result = new ArrayList<PDOMCEnumerator>();
        try {
            PDOMNodeLinkedList list = new PDOMNodeLinkedList((PDOMLinkage)this.getLinkage(), this.record + 28L);
            list.accept(new IPDOMVisitor(){

                @Override
                public boolean visit(IPDOMNode node) throws CoreException {
                    if (node instanceof PDOMCEnumerator) {
                        result.add((PDOMCEnumerator)node);
                    }
                    return true;
                }

                @Override
                public void leave(IPDOMNode node) {
                }
            });
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
        result.trimToSize();
        return result;
    }

    @Override
    public void accept(IPDOMVisitor visitor) throws CoreException {
        for (PDOMCEnumerator enumerator : this.getCachedEnumerators(true)) {
            visitor.visit(enumerator);
            visitor.leave(enumerator);
        }
    }

    @Override
    public void addChild(PDOMNode node) throws CoreException {
        if (node instanceof PDOMCEnumerator) {
            PDOMNodeLinkedList list = new PDOMNodeLinkedList((PDOMLinkage)this.getLinkage(), this.record + 28L);
            list.addMember(node);
            List<PDOMCEnumerator> cache = this.getCachedEnumerators(false);
            if (cache != null) {
                cache.add((PDOMCEnumerator)node);
            }
        }
    }

    @Override
    public boolean mayHaveChildren() {
        return true;
    }

    @Override
    public long getMinValue() {
        if (this.fMinValue != null) {
            return this.fMinValue;
        }
        long minValue = 0L;
        try {
            minValue = this.getDB().getLong(this.record + 32L);
        }
        catch (CoreException coreException) {}
        this.fMinValue = minValue;
        return minValue;
    }

    @Override
    public long getMaxValue() {
        if (this.fMaxValue != null) {
            return this.fMaxValue;
        }
        long maxValue = 0L;
        try {
            maxValue = this.getDB().getLong(this.record + 40L);
        }
        catch (CoreException coreException) {}
        this.fMaxValue = maxValue;
        return maxValue;
    }

    @Override
    public boolean isSameType(IType type) {
        PDOMNode node;
        if (type instanceof ITypedef) {
            return type.isSameType(this);
        }
        if (type instanceof PDOMNode && (node = (PDOMNode)((Object)type)).getPDOM() == this.getPDOM()) {
            return node.getRecord() == this.getRecord();
        }
        if (type instanceof IEnumeration) {
            IEnumeration etype = (IEnumeration)type;
            char[] nchars = etype.getNameCharArray();
            if (nchars.length == 0) {
                nchars = ASTTypeUtil.createNameForAnonymous(etype);
            }
            if (nchars == null || !CharArrayUtils.equals(nchars, this.getNameCharArray())) {
                return false;
            }
            return SemanticUtil.isSameOwner(this.getOwner(), etype.getOwner());
        }
        return false;
    }

    @Override
    public Object clone() {
        throw new IllegalArgumentException("Enums must not be cloned");
    }
}

