/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.core.jobs;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.ptp.core.jobs.IJobListener;
import org.eclipse.ptp.core.jobs.IJobStatus;

public class JobManager {
    private static final String ALL_JOBS = "ALL_JOBS";
    private static final JobManager fInstance = new JobManager();
    private final Map<String, ListenerList> fJobListeners = new HashMap<String, ListenerList>();

    public static JobManager getInstance() {
        return fInstance;
    }

    private JobManager() {
    }

    public void addListener(String qualifier, IJobListener listener) {
        ListenerList listeners = this.fJobListeners.get(qualifier);
        if (listeners == null) {
            listeners = new ListenerList();
            this.fJobListeners.put(qualifier, listeners);
        }
        listeners.add((Object)listener);
    }

    public void addListener(IJobListener listener) {
        ListenerList listeners = this.fJobListeners.get(ALL_JOBS);
        if (listeners == null) {
            listeners = new ListenerList();
            this.fJobListeners.put(ALL_JOBS, listeners);
        }
        listeners.add((Object)listener);
    }

    public void fireJobAdded(IJobStatus jobStatus) {
        Object listener;
        int n;
        int n2;
        Object[] objectArray;
        ListenerList listeners = this.fJobListeners.get(jobStatus.getControlId());
        if (listeners != null) {
            objectArray = listeners.getListeners();
            n2 = objectArray.length;
            n = 0;
            while (n < n2) {
                listener = objectArray[n];
                ((IJobListener)listener).jobAdded(jobStatus);
                ++n;
            }
        }
        if ((listeners = this.fJobListeners.get(ALL_JOBS)) != null) {
            objectArray = listeners.getListeners();
            n2 = objectArray.length;
            n = 0;
            while (n < n2) {
                listener = objectArray[n];
                ((IJobListener)listener).jobAdded(jobStatus);
                ++n;
            }
        }
    }

    public void fireJobChanged(IJobStatus jobStatus) {
        Object listener;
        int n;
        int n2;
        Object[] objectArray;
        ListenerList listeners = this.fJobListeners.get(jobStatus.getControlId());
        if (listeners != null) {
            objectArray = listeners.getListeners();
            n2 = objectArray.length;
            n = 0;
            while (n < n2) {
                listener = objectArray[n];
                ((IJobListener)listener).jobChanged(jobStatus);
                ++n;
            }
        }
        if ((listeners = this.fJobListeners.get(ALL_JOBS)) != null) {
            objectArray = listeners.getListeners();
            n2 = objectArray.length;
            n = 0;
            while (n < n2) {
                listener = objectArray[n];
                ((IJobListener)listener).jobChanged(jobStatus);
                ++n;
            }
        }
    }

    public void removeListener(IJobListener listener) {
        for (ListenerList listeners : this.fJobListeners.values()) {
            listeners.remove((Object)listener);
        }
    }

    public void removeListener(String qualifier, IJobListener listener) {
        ListenerList listeners = this.fJobListeners.get(qualifier);
        if (listeners != null) {
            listeners.remove((Object)listener);
        }
    }
}

