/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remote.rse.core;

import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.ptp.remote.core.IRemoteProcess;
import org.eclipse.ptp.remote.rse.core.RSEAdapterCorePlugin;

public class LocalProcessWrapper
implements IRemoteProcess {
    protected Process fProcess;
    protected ProcessMonitoringThread fMonitoringThread;

    private LocalProcessWrapper() {
    }

    public LocalProcessWrapper(Process process) {
        if (process == null) {
            throw new IllegalArgumentException("process argument to LocalProcessWrapper must not be null");
        }
        this.fProcess = process;
        this.fMonitoringThread = new ProcessMonitoringThread(process);
        this.fMonitoringThread.start();
    }

    public void destroy() {
        this.fProcess.destroy();
    }

    public int exitValue() {
        return this.fProcess.exitValue();
    }

    public InputStream getErrorStream() {
        return this.fProcess.getErrorStream();
    }

    public InputStream getInputStream() {
        return this.fProcess.getInputStream();
    }

    public OutputStream getOutputStream() {
        return this.fProcess.getOutputStream();
    }

    public int waitFor() throws InterruptedException {
        return this.fProcess.waitFor();
    }

    public boolean isCompleted() {
        return !this.fMonitoringThread.isAlive();
    }

    protected class ProcessMonitoringThread
    extends Thread {
        protected Process fProcessToMonitor;

        public ProcessMonitoringThread(Process process) {
            this.fProcessToMonitor = process;
        }

        public void run() {
            try {
                this.fProcessToMonitor.waitFor();
            }
            catch (InterruptedException e) {
                RSEAdapterCorePlugin.log(e);
            }
        }
    }
}

