/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.lml.internal.core.model;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.ptp.rm.lml.core.model.IUsagebarInterpreter;
import org.eclipse.ptp.rm.lml.internal.core.elements.JobPartType;
import org.eclipse.ptp.rm.lml.internal.core.elements.JobType;
import org.eclipse.ptp.rm.lml.internal.core.model.UsageAdapter;

public class UsagebarInterpreter
implements IUsagebarInterpreter {
    private final UsageAdapter usageAdapter;

    public UsagebarInterpreter(UsageAdapter usageAdapter) {
        this.usageAdapter = usageAdapter;
        JobComparator comp = new JobComparator();
        Collections.sort(usageAdapter.getJob(), comp);
    }

    @Override
    public int getLastCpuInNode(int node) {
        JobPartType jobPart;
        int jobPartId;
        JobType job;
        int jobId;
        double nodes = 0.0;
        int cpu = 0;
        List<JobType> jobList = this.usageAdapter.getJob();
        for (jobId = 0; jobId < jobList.size(); ++jobId) {
            job = jobList.get(jobId);
            nodes += this.getNodesByJob(job, job.getCpucount().intValue());
            cpu += job.getCpucount().intValue();
            if (nodes < (double)node) {
                continue;
            }
            nodes -= this.getNodesByJob(job, job.getCpucount().intValue());
            cpu -= job.getCpucount().intValue();
            break;
        }
        if (jobId == jobList.size()) {
            return cpu;
        }
        job = jobList.get(jobId);
        int cpuPerNode = this.usageAdapter.getCpuPerNode().intValue();
        if (job.getCpupernode() != null) {
            cpuPerNode = job.getCpupernode().intValue();
        }
        if (job.getJobpart() == null || job.getJobpart().size() == 0) {
            cpu = (int)((double)cpu + ((double)node - nodes) * (double)cpuPerNode);
            return cpu;
        }
        List<JobPartType> jobPartList = job.getJobpart();
        for (jobPartId = 0; jobPartId < jobPartList.size(); ++jobPartId) {
            int tmpCpuPerNode = cpuPerNode;
            JobPartType jobPart2 = jobPartList.get(jobPartId);
            if (jobPart2.getCpupernode() != null) {
                tmpCpuPerNode = jobPart2.getCpupernode().intValue();
            }
            double tmpNodes = (double)jobPart2.getCpucount().intValue() / (double)tmpCpuPerNode;
            nodes += tmpNodes;
            cpu += jobPart2.getCpucount().intValue();
            if (nodes < (double)node) {
                continue;
            }
            nodes -= tmpNodes;
            cpu -= jobPart2.getCpucount().intValue();
            break;
        }
        if (jobPartId == jobPartList.size()) {
            jobPartId = jobPartList.size() - 1;
        }
        if ((jobPart = jobPartList.get(jobPartId)).getCpupernode() != null) {
            cpuPerNode = jobPart.getCpupernode().intValue();
        }
        return (int)((double)cpu + ((double)node - nodes) * (double)cpuPerNode);
    }

    @Override
    public int getNodeCount() {
        int cpuPerNode = this.usageAdapter.getCpuPerNode().intValue();
        double nodes = 0.0;
        List<JobType> jobList = this.usageAdapter.getJob();
        int i = 0;
        while (i < jobList.size()) {
            int jobCpuPerNode;
            JobType job = jobList.get(i);
            int n = jobCpuPerNode = job.getCpupernode() == null ? cpuPerNode : job.getCpupernode().intValue();
            if (job.getJobpart().size() == 0) {
                nodes += (double)job.getCpucount().intValue() / (double)jobCpuPerNode;
            } else {
                List<JobPartType> jobPartList = job.getJobpart();
                int j = 0;
                while (j < jobPartList.size()) {
                    JobPartType jobPart = jobPartList.get(j);
                    int jobPartCpuPerNode = jobPart.getCpupernode() == null ? jobCpuPerNode : jobPart.getCpupernode().intValue();
                    nodes += (double)jobPart.getCpucount().intValue() / (double)jobPartCpuPerNode;
                    ++j;
                }
            }
            ++i;
        }
        return (int)Math.round(nodes);
    }

    @Override
    public int getNodecountAtCpu(int cpuCount) {
        List<JobType> jobList = this.usageAdapter.getJob();
        int i = 0;
        double nodes = 0.0;
        while (i < jobList.size() && cpuCount > 0) {
            nodes += this.getNodesByJob(jobList.get(i), cpuCount);
            cpuCount -= jobList.get(i).getCpucount().intValue();
            ++i;
        }
        if (Math.abs(nodes - (double)((int)nodes)) < 1.0E-5) {
            return (int)nodes;
        }
        return (int)nodes + 1;
    }

    protected double getNodesByJob(JobType job, int tillCpu) {
        int jobCpuPerNode;
        int cpuPerNode = this.usageAdapter.getCpuPerNode().intValue();
        double nodes = 0.0;
        int n = jobCpuPerNode = job.getCpupernode() == null ? cpuPerNode : job.getCpupernode().intValue();
        if (tillCpu < 0 || tillCpu > job.getCpucount().intValue()) {
            tillCpu = job.getCpucount().intValue();
        }
        if (job.getJobpart().size() == 0) {
            nodes = (double)tillCpu / (double)jobCpuPerNode;
        } else {
            List<JobPartType> jobPartList = job.getJobpart();
            int cpuSum = 0;
            int j = 0;
            while (j < jobPartList.size()) {
                int partCpuPerNode;
                JobPartType jobPart = jobPartList.get(j);
                int n2 = partCpuPerNode = jobPart.getCpupernode() == null ? jobCpuPerNode : jobPart.getCpupernode().intValue();
                if ((cpuSum += jobPart.getCpucount().intValue()) <= tillCpu) {
                    nodes += (double)jobPart.getCpucount().intValue() / (double)partCpuPerNode;
                } else {
                    nodes += (double)(tillCpu - (cpuSum - jobPart.getCpucount().intValue())) / (double)partCpuPerNode;
                    break;
                }
                ++j;
            }
        }
        return nodes;
    }

    public static class JobComparator
    implements Comparator<JobType> {
        private static final String emptyString = "empty";

        @Override
        public int compare(JobType o1, JobType o2) {
            if (o1 == null || o1.getOid() == null) {
                return 1;
            }
            if (o2 == null || o2.getOid() == null) {
                return -1;
            }
            if (o1.getOid().equals(emptyString)) {
                return 1;
            }
            if (o2.getOid().equals(emptyString)) {
                return -1;
            }
            return o2.getCpucount().intValue() - o1.getCpucount().intValue();
        }
    }
}

