/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.remote.rse.core.miners;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.utils.pty.PTY;
import org.eclipse.cdt.utils.spawner.ProcessFactory;
import org.eclipse.dstore.core.miners.Miner;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.ptp.internal.remote.rse.core.miners.CommandMinerThread;
import org.eclipse.rse.dstore.universal.miners.UniversalServerUtilities;
import org.eclipse.rse.internal.dstore.universal.miners.command.patterns.Patterns;

public class SpawnerMiner
extends Miner {
    public static final String SPAWN_ERROR = "spawnError";
    public static final String C_SPAWN_REDIRECTED = "C_SPAWN_REDIRECTED";
    public static final String C_SPAWN_NOT_REDIRECTED = "C_SPAWN_NOT_REDIRECTED";
    public static final String C_SPAWN_TTY = "C_SPAWN_TTY";
    public static final String T_SPAWNER_STRING_DESCRIPTOR = "Type.Spawner.String";
    public static final String LOG_TAG = "SpawnerMiner";
    private CommandMinerDescriptors fDescriptors = new CommandMinerDescriptors();
    boolean fSupportsCharConversion;
    private DataElement _status;
    private Map<DataElement, Process> fProcessMap = new HashMap<DataElement, Process>();
    public boolean _supportsCharConversion = true;
    private Patterns _patterns;

    public String getVersion() {
        return "0.0.2";
    }

    public DataElement handleCommand(DataElement theCommand) throws Exception {
        try {
            return this.doHandleCommand(theCommand);
        }
        catch (RuntimeException e) {
            UniversalServerUtilities.logError((String)LOG_TAG, (String)e.toString(), (Throwable)e, (DataStore)this._dataStore);
            this._dataStore.refresh(theCommand);
            this._dataStore.disconnectObject(theCommand);
            throw e;
        }
    }

    private DataElement doHandleCommand(DataElement theCommand) {
        DataElement status;
        String name = this.getCommandName(theCommand);
        this._status = status = this.getCommandStatus(theCommand);
        DataElement subject = this.getCommandArgument(theCommand, 0);
        if (name.equals(C_SPAWN_REDIRECTED)) {
            String cmd = this.getString(theCommand, 1);
            String directory = this.getString(theCommand, 2);
            File dir = new File(directory);
            int envSize = this.getInt(theCommand, 3);
            String[] envp = new String[envSize];
            int i = 0;
            while (i < envSize) {
                envp[i] = this.getString(theCommand, i + 4);
                ++i;
            }
            this.handleSpawnRedirected(subject, cmd, dir, envp, status);
            status.getDataStore().refresh(status);
            status.getDataStore().disconnectObject(status.getParent());
            return status;
        }
        if (name.equals("C_CANCEL")) {
            DataElement cancelStatus = this.getCommandStatus(subject);
            String commandName = subject.getName().trim();
            if (commandName.equals(C_SPAWN_REDIRECTED) || commandName.equals(C_SPAWN_NOT_REDIRECTED) || commandName.equals(C_SPAWN_TTY)) {
                this.handleSpawnCancel(cancelStatus);
            }
        } else if (name.equals("C_CHAR_CONVERSION")) {
            this.fSupportsCharConversion = true;
        }
        status.getDataStore().refresh(status);
        status.getDataStore().disconnectObject(status.getParent());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSpawnCancel(DataElement cancelStatus) {
        Process processToCancel = this.fProcessMap.get(cancelStatus);
        if (processToCancel != null) {
            processToCancel.destroy();
            Map<DataElement, Process> map = this.fProcessMap;
            synchronized (map) {
                this.fProcessMap.put(cancelStatus, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSpawnRedirected(DataElement subject, String cmd, File dir, String[] envp, DataElement status) {
        try {
            Process process = ProcessFactory.getFactory().exec(cmd.split(" "), envp, dir, new PTY());
            SpawnerMiner spawnerMiner = this;
            synchronized (spawnerMiner) {
                this.fProcessMap.put(status, process);
            }
            CommandMinerThread newCommand = new CommandMinerThread(subject, process, cmd, dir.getAbsolutePath(), status, this.getPatterns(), this.fDescriptors);
            newCommand.start();
        }
        catch (IOException e) {
            this._dataStore.createObject(status, SPAWN_ERROR, cmd, "");
            this.refreshStatus();
            SpawnerMiner.statusDone(status);
            UniversalServerUtilities.logError((String)LOG_TAG, (String)e.toString(), (Throwable)e, (DataStore)this._dataStore);
        }
    }

    public static DataElement statusDone(DataElement status) {
        status.setAttribute(2, "done");
        status.getDataStore().refresh(status);
        status.getDataStore().disconnectObject(status.getParent());
        return status;
    }

    private String getString(DataElement command, int index) {
        DataElement element = this.getCommandArgument(command, index);
        return element.getName();
    }

    private int getInt(DataElement command, int index) {
        DataElement element = this.getCommandArgument(command, index);
        Integer i = new Integer(element.getName());
        return i;
    }

    public void extendSchema(DataElement schemaRoot) {
        try {
            System.loadLibrary("spawner");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            return;
        }
        DataElement cancellable = this._dataStore.findObjectDescriptor("Cancellable");
        DataElement e0_cmd = this.createCommandDescriptor(schemaRoot, "Spawn process without redirection", C_SPAWN_REDIRECTED, false);
        this._dataStore.createReference(cancellable, e0_cmd, "abstracts", "abstracted by");
        this.fDescriptors = new CommandMinerDescriptors();
        this.fDescriptors._stdout = this._dataStore.createObjectDescriptor(schemaRoot, "stdout");
        this.fDescriptors._stderr = this._dataStore.createObjectDescriptor(schemaRoot, "stderr");
        this.fDescriptors._prompt = this._dataStore.createObjectDescriptor(schemaRoot, "prompt");
        this.fDescriptors._grep = this._dataStore.createObjectDescriptor(schemaRoot, "grep");
        this.fDescriptors._pathenvvar = this._dataStore.createObjectDescriptor(schemaRoot, "pathenvvar");
        this.fDescriptors._envvar = this._dataStore.createObjectDescriptor(schemaRoot, "envvar");
        this.fDescriptors._libenvvar = this._dataStore.createObjectDescriptor(schemaRoot, "libenvvar");
        this.fDescriptors._error = this._dataStore.createObjectDescriptor(schemaRoot, "error");
        this.fDescriptors._warning = this._dataStore.createObjectDescriptor(schemaRoot, "warning");
        this.fDescriptors._informational = this._dataStore.createObjectDescriptor(schemaRoot, "informational");
        this.fDescriptors._process = this._dataStore.createObjectDescriptor(schemaRoot, "process");
        this._dataStore.refresh(schemaRoot);
    }

    public void refreshStatus() {
        this._dataStore.refresh(this._status);
    }

    private Patterns getPatterns() {
        if (this._patterns == null) {
            this._patterns = new Patterns(this._dataStore);
        }
        return this._patterns;
    }

    public class CommandMinerDescriptors {
        public DataElement _stdout;
        public DataElement _stderr;
        public DataElement _prompt;
        public DataElement _grep;
        public DataElement _pathenvvar;
        public DataElement _envvar;
        public DataElement _libenvvar;
        public DataElement _error;
        public DataElement _warning;
        public DataElement _informational;
        public DataElement _process;

        public DataElement getDescriptorFor(String type) {
            DataElement descriptor = null;
            if (type.equals("stdout")) {
                descriptor = this._stdout;
            } else if (type.equals("pathenvvar")) {
                descriptor = this._pathenvvar;
            } else if (type.equals("envvar")) {
                descriptor = this._envvar;
            } else if (type.equals("libenvvar")) {
                descriptor = this._libenvvar;
            } else if (type.equals("error")) {
                descriptor = this._error;
            } else if (type.equals("warning")) {
                descriptor = this._warning;
            } else if (type.equals("informational")) {
                descriptor = this._informational;
            } else if (type.equals("process")) {
                descriptor = this._process;
            } else if (type.equals("grep")) {
                descriptor = this._grep;
            } else if (type.equals("stderr")) {
                descriptor = this._stderr;
            }
            return descriptor;
        }
    }
}

