/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.launch;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.ptp.rm.launch.internal.messages.Messages;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class RMLaunchPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.ptp.rm.launch";
    private static RMLaunchPlugin plugin;

    public static void errorDialog(String message, IStatus status) {
        RMLaunchPlugin.log(status);
        Shell shell = RMLaunchPlugin.getActiveWorkbenchShell();
        if (shell != null) {
            ErrorDialog.openError((Shell)shell, (String)Messages.Launch_common_Error, (String)message, (IStatus)status);
        }
    }

    public static void errorDialog(String message, Throwable t) {
        RMLaunchPlugin.log(t);
        Shell shell = RMLaunchPlugin.getActiveWorkbenchShell();
        if (shell != null) {
            Status status = new Status(4, RMLaunchPlugin.getUniqueIdentifier(), 1, t.getMessage(), null);
            ErrorDialog.openError((Shell)shell, (String)Messages.Launch_common_Error, (String)message, (IStatus)status);
        }
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow w = RMLaunchPlugin.getActiveWorkbenchWindow();
        if (w != null) {
            return w.getActivePage();
        }
        return null;
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = RMLaunchPlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return RMLaunchPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static RMLaunchPlugin getDefault() {
        return plugin;
    }

    public static String getUniqueIdentifier() {
        if (RMLaunchPlugin.getDefault() == null) {
            return PLUGIN_ID;
        }
        return RMLaunchPlugin.getDefault().getBundle().getSymbolicName();
    }

    public static void log(IStatus status) {
        RMLaunchPlugin.getDefault().getLog().log(status);
    }

    public static void log(Throwable e) {
        RMLaunchPlugin.log((IStatus)new Status(4, RMLaunchPlugin.getUniqueIdentifier(), 4, e.getMessage(), e));
    }

    public static void logErrorMessage(String message) {
        RMLaunchPlugin.log((IStatus)new Status(4, RMLaunchPlugin.getUniqueIdentifier(), 4, message, null));
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }
}

