/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core.callhierarchy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ClassTypeHelper;
import org.eclipse.cdt.utils.EFSExtensionManager;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ptp.internal.rdt.core.CModelUtil;
import org.eclipse.ptp.internal.rdt.core.callhierarchy.AbstractCallHierarchyService;
import org.eclipse.ptp.internal.rdt.core.callhierarchy.CalledByResult;
import org.eclipse.ptp.internal.rdt.core.callhierarchy.CallsToResult;
import org.eclipse.ptp.internal.rdt.core.index.IndexQueries;
import org.eclipse.ptp.internal.rdt.core.model.ICProjectFactory;
import org.eclipse.ptp.internal.rdt.core.model.IIndexLocationConverterFactory;
import org.eclipse.ptp.internal.rdt.core.model.LocalCProjectFactory;
import org.eclipse.ptp.internal.rdt.core.model.LocalIndexLocationConverterFactory;
import org.eclipse.ptp.internal.rdt.core.model.Scope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalCallHierarchyService
extends AbstractCallHierarchyService {
    private static IIndexLocationConverterFactory converterFactory = new LocalIndexLocationConverterFactory();
    private static final ICElement[] NO_ELEMENTS = new ICElement[0];

    @Override
    public CalledByResult findCalledBy(Scope scope, ICElement callee, IProgressMonitor pm) throws CoreException, InterruptedException {
        CalledByResult result = new CalledByResult();
        if (!(callee instanceof ISourceReference)) {
            return result;
        }
        ICProject[] projects = CoreModel.getDefault().getCModel().getCProjects();
        IIndex index = CCorePlugin.getIndexManager().getIndex(projects);
        index.acquireReadLock();
        try {
            LocalCallHierarchyService.findCalledBy(callee, index, result);
            CalledByResult calledByResult = result;
            return calledByResult;
        }
        finally {
            index.releaseReadLock();
        }
    }

    private static void findCalledBy(ICElement callee, IIndex index, CalledByResult result) throws CoreException {
        ICProject project = callee.getCProject();
        String path = EFSExtensionManager.getDefault().getPathFromURI(callee.getLocationURI());
        IIndexBinding calleeBinding = IndexQueries.elementToBinding(index, callee, path);
        if (calleeBinding != null) {
            LocalCallHierarchyService.findCalledBy1(index, (IBinding)calleeBinding, true, project, result);
            if (calleeBinding instanceof ICPPMethod) {
                ICPPMethod[] overriddenBindings;
                ICPPMethod[] iCPPMethodArray = overriddenBindings = ClassTypeHelper.findOverridden((ICPPMethod)((ICPPMethod)calleeBinding), null);
                int n = overriddenBindings.length;
                int n2 = 0;
                while (n2 < n) {
                    ICPPMethod overriddenBinding = iCPPMethodArray[n2];
                    LocalCallHierarchyService.findCalledBy1(index, (IBinding)overriddenBinding, false, project, result);
                    ++n2;
                }
            }
        }
    }

    private static void findCalledBy1(IIndex index, IBinding callee, boolean includeOrdinaryCalls, ICProject project, CalledByResult result) throws CoreException {
        LocalCallHierarchyService.findCalledBy2(index, callee, includeOrdinaryCalls, project, result);
        List<? extends IBinding> specializations = IndexQueries.findSpecializations(callee);
        for (IBinding iBinding : specializations) {
            LocalCallHierarchyService.findCalledBy2(index, iBinding, includeOrdinaryCalls, project, result);
        }
    }

    private static void findCalledBy2(IIndex index, IBinding callee, boolean includeOrdinaryCalls, ICProject project, CalledByResult result) throws CoreException {
        IIndexName[] names;
        IIndexName[] iIndexNameArray = names = index.findNames(callee, 12);
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            ICElement elem;
            IIndexName caller;
            IIndexName rname = iIndexNameArray[n2];
            if ((includeOrdinaryCalls || rname.couldBePolymorphicMethodCall()) && (caller = rname.getEnclosingDefinition()) != null && (elem = IndexQueries.getCElementForName(project, index, caller, converterFactory, (ICProjectFactory)new LocalCProjectFactory())) != null) {
                result.add(elem, rname);
            }
            ++n2;
        }
    }

    @Override
    public CallsToResult findCalls(Scope scope, ICElement caller, IProgressMonitor pm) throws CoreException, InterruptedException {
        ICProject[] projects = CoreModel.getDefault().getCModel().getCProjects();
        IIndex index = CCorePlugin.getIndexManager().getIndex(projects);
        index.acquireReadLock();
        try {
            CallsToResult callsToResult = this.findCalls(caller, index, pm);
            return callsToResult;
        }
        finally {
            index.releaseReadLock();
        }
    }

    private CallsToResult findCalls(ICElement caller, IIndex index, IProgressMonitor pm) throws CoreException {
        CallsToResult result = new CallsToResult();
        IIndexName callerName = IndexQueries.elementToName(index, caller);
        if (callerName != null) {
            IIndexName[] refs = callerName.getEnclosedNames();
            ICProject project = caller.getCProject();
            LocalCProjectFactory projectFactory = new LocalCProjectFactory();
            IIndexName[] iIndexNameArray = refs;
            int n = refs.length;
            int n2 = 0;
            while (n2 < n) {
                IIndexName name = iIndexNameArray[n2];
                IIndexBinding binding = index.findBinding((IName)name);
                if (this.isRelevantForCallHierarchy((IBinding)binding)) {
                    do {
                        ICElement[] defs = null;
                        if (binding instanceof ICPPMethod) {
                            defs = LocalCallHierarchyService.findOverriders(index, (ICPPMethod)binding, project, projectFactory);
                        }
                        if (defs == null) {
                            defs = IndexQueries.findRepresentative(index, (IBinding)binding, converterFactory, project, projectFactory);
                        }
                        if (defs == null || defs.length <= 0) continue;
                        result.add(defs, name);
                        break;
                    } while (binding instanceof ICPPSpecialization && (binding = ((ICPPSpecialization)binding).getSpecializedBinding()) != null);
                }
                ++n2;
            }
        }
        return result;
    }

    static ICElement[] findOverriders(IIndex index, ICPPMethod binding, ICProject project, ICProjectFactory projectFactory) throws CoreException {
        ICPPMethod[] virtualOverriders = ClassTypeHelper.findOverriders((IIndex)index, (ICPPMethod)binding);
        if (virtualOverriders.length > 0) {
            ArrayList<ICElement> list = new ArrayList<ICElement>();
            list.addAll(Arrays.asList(IndexQueries.findRepresentative(index, (IBinding)binding, converterFactory, project, projectFactory)));
            ICPPMethod[] iCPPMethodArray = virtualOverriders;
            int n = virtualOverriders.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPMethod overrider = iCPPMethodArray[n2];
                list.addAll(Arrays.asList(IndexQueries.findRepresentative(index, (IBinding)overrider, converterFactory, project, projectFactory)));
                ++n2;
            }
            return list.toArray(new ICElement[list.size()]);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ICElement[] findDefinitions(Scope scope, ICProject project, IWorkingCopy workingCopy, int selectionStart, int selectionLength, IProgressMonitor pm) throws CoreException {
        try {
            IIndex index = CCorePlugin.getIndexManager().getIndex(project, 3);
            index.acquireReadLock();
            try {
                IASTName name = IndexQueries.getSelectedName(index, (ITranslationUnit)workingCopy, selectionStart, selectionLength);
                if (name == null) return NO_ELEMENTS;
                IBinding binding = name.resolveBinding();
                if (!this.isRelevantForCallHierarchy(binding)) return NO_ELEMENTS;
                LocalCProjectFactory projectFactory = new LocalCProjectFactory();
                if (name.isDefinition()) {
                    ICElement elem = IndexQueries.getCElementForName(project, index, name, converterFactory, (ICProjectFactory)projectFactory);
                    if (elem != null) {
                        ICElement[] iCElementArray = new ICElement[]{elem};
                        return iCElementArray;
                    }
                    ICElement[] iCElementArray = NO_ELEMENTS;
                    return iCElementArray;
                }
                ICElement[] elems = IndexQueries.findAllDefinitions(index, binding, converterFactory, project, projectFactory);
                if (elems.length != 0) {
                    ICElement[] iCElementArray = elems;
                    return iCElementArray;
                }
                if (name.isDeclaration()) {
                    ICElement elem = IndexQueries.getCElementForName(project, index, name, converterFactory, (ICProjectFactory)projectFactory);
                    if (elem != null) {
                        ICElement[] iCElementArray = new ICElement[]{elem};
                        return iCElementArray;
                    }
                    ICElement[] iCElementArray = NO_ELEMENTS;
                    return iCElementArray;
                }
                ICElement elem = IndexQueries.findAnyDeclaration(index, project, binding, converterFactory, projectFactory);
                if (elem != null) {
                    ICElement[] iCElementArray = new ICElement[]{elem};
                    return iCElementArray;
                }
                if (binding instanceof ICPPSpecialization) {
                    ICElement[] iCElementArray = LocalCallHierarchyService.findSpecializationDeclaration(binding, project, index, projectFactory);
                    return iCElementArray;
                }
                ICElement[] iCElementArray = NO_ELEMENTS;
                return iCElementArray;
            }
            finally {
                index.releaseReadLock();
            }
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
            return NO_ELEMENTS;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        return NO_ELEMENTS;
    }

    private static ICElement[] findSpecializationDeclaration(IBinding binding, ICProject project, IIndex index, LocalCProjectFactory projectFactory) throws CoreException {
        while (binding instanceof ICPPSpecialization) {
            ICElement elem;
            IBinding original = ((ICPPSpecialization)binding).getSpecializedBinding();
            ICElement[] elems = IndexQueries.findAllDefinitions(index, original, converterFactory, project, projectFactory);
            if (elems.length == 0 && (elem = IndexQueries.findAnyDeclaration(index, project, original, converterFactory, projectFactory)) != null) {
                elems = new ICElement[]{elem};
            }
            if (elems.length > 0) {
                return elems;
            }
            binding = original;
        }
        return NO_ELEMENTS;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ICElement[] findDefinitions(Scope scope, ICElement input, IProgressMonitor pm) {
        try {
            ITranslationUnit tu = CModelUtil.getTranslationUnit(input);
            if (tu == null) return new ICElement[]{input};
            ICProject project = tu.getCProject();
            IIndex index = CCorePlugin.getIndexManager().getIndex(project, 3);
            index.acquireReadLock();
            try {
                ICElement[] result;
                String path;
                IIndexBinding binding;
                LocalCProjectFactory projectFactory = new LocalCProjectFactory();
                if (LocalCallHierarchyService.needToFindDefinition(input) && (binding = IndexQueries.elementToBinding(index, input, path = EFSExtensionManager.getDefault().getPathFromURI(input.getLocationURI()))) != null && (result = IndexQueries.findAllDefinitions(index, (IBinding)binding, converterFactory, project, projectFactory)).length > 0) {
                    ICElement[] iCElementArray = result;
                    return iCElementArray;
                }
                IIndexName name = IndexQueries.elementToName(index, input);
                if (name == null) return new ICElement[]{input};
                ICElement handle = IndexQueries.getCElementForName(tu, index, name, projectFactory);
                ICElement[] iCElementArray = new ICElement[]{handle};
                return iCElementArray;
            }
            finally {
                index.releaseReadLock();
            }
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
            return new ICElement[]{input};
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        return new ICElement[]{input};
    }

    private static boolean needToFindDefinition(ICElement elem) {
        switch (elem.getElementType()) {
            case 71: 
            case 73: 
            case 88: 
            case 90: {
                return true;
            }
        }
        return false;
    }

    @Override
    public Map<String, ICElement[]> findOverriders(Scope scope, ICElement input, IProgressMonitor pm) throws CoreException, InterruptedException {
        ITranslationUnit tu = CModelUtil.getTranslationUnit(input);
        ICProject project = tu.getCProject();
        IIndex index = CCorePlugin.getIndexManager().getIndex(project, 3);
        HashMap<String, ICElement[]> result = new HashMap<String, ICElement[]>();
        index.acquireReadLock();
        try {
            IIndexName methodName = IndexQueries.elementToName(index, input);
            if (methodName != null) {
                ICElement[] defs;
                LocalCProjectFactory projectFactory = new LocalCProjectFactory();
                IIndexBinding methodBinding = index.findBinding((IName)methodName);
                if (methodBinding instanceof ICPPMethod && (defs = LocalCallHierarchyService.findOverriders(index, (ICPPMethod)methodBinding, project, projectFactory)) != null && defs.length > 0) {
                    result.put(String.valueOf(methodBinding.getLinkage().getLinkageID()), defs);
                }
            }
        }
        finally {
            index.releaseReadLock();
        }
        return result;
    }
}

