/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core.miners;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTCompletionNode;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IIndexInclude;
import org.eclipse.cdt.core.index.IIndexLocationConverter;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.index.IWritableIndex;
import org.eclipse.cdt.internal.core.indexer.StandaloneFastIndexer;
import org.eclipse.cdt.internal.core.parser.util.ContentAssistMatcherFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.dstore.core.miners.Miner;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.dstore.core.server.ServerLogger;
import org.eclipse.ptp.internal.rdt.core.IRemoteIndexerInfoProvider;
import org.eclipse.ptp.internal.rdt.core.Serializer;
import org.eclipse.ptp.internal.rdt.core.callhierarchy.CalledByResult;
import org.eclipse.ptp.internal.rdt.core.callhierarchy.CallsToResult;
import org.eclipse.ptp.internal.rdt.core.contentassist.CompletionProposalComputer;
import org.eclipse.ptp.internal.rdt.core.contentassist.RemoteContentAssistInvocationContext;
import org.eclipse.ptp.internal.rdt.core.formatter.RemoteDefaultCodeFormatterOptions;
import org.eclipse.ptp.internal.rdt.core.formatter.RemoteMultiTextEdit;
import org.eclipse.ptp.internal.rdt.core.formatter.RemoteReplaceEdit;
import org.eclipse.ptp.internal.rdt.core.formatter.RemoteTextEdit;
import org.eclipse.ptp.internal.rdt.core.includebrowser.IIndexIncludeValue;
import org.eclipse.ptp.internal.rdt.core.includebrowser.IndexIncludeValue;
import org.eclipse.ptp.internal.rdt.core.index.IndexQueries;
import org.eclipse.ptp.internal.rdt.core.miners.IndexerThread;
import org.eclipse.ptp.internal.rdt.core.miners.OpenDeclarationHandler;
import org.eclipse.ptp.internal.rdt.core.miners.PositionCollector;
import org.eclipse.ptp.internal.rdt.core.miners.RemoteCHQueries;
import org.eclipse.ptp.internal.rdt.core.miners.RemoteFoldingRegionsHandler;
import org.eclipse.ptp.internal.rdt.core.miners.RemoteIndexFileLocation;
import org.eclipse.ptp.internal.rdt.core.miners.RemoteIndexManager;
import org.eclipse.ptp.internal.rdt.core.miners.ScopeManager;
import org.eclipse.ptp.internal.rdt.core.miners.SimpleLocationConverter;
import org.eclipse.ptp.internal.rdt.core.miners.URICreatorManager;
import org.eclipse.ptp.internal.rdt.core.miners.formatter.RemoteCodeFormatterVisitor;
import org.eclipse.ptp.internal.rdt.core.model.CModelBuilder2;
import org.eclipse.ptp.internal.rdt.core.model.CProject;
import org.eclipse.ptp.internal.rdt.core.model.ICProjectFactory;
import org.eclipse.ptp.internal.rdt.core.model.IIndexLocationConverterFactory;
import org.eclipse.ptp.internal.rdt.core.model.RemoteCProjectFactory;
import org.eclipse.ptp.internal.rdt.core.model.RemoteIndexLocationConverterFactory;
import org.eclipse.ptp.internal.rdt.core.model.WorkingCopy;
import org.eclipse.ptp.internal.rdt.core.navigation.FoldingRegionsResult;
import org.eclipse.ptp.internal.rdt.core.navigation.OpenDeclarationResult;
import org.eclipse.ptp.internal.rdt.core.search.RemoteSearchMatch;
import org.eclipse.ptp.internal.rdt.core.search.RemoteSearchQuery;
import org.eclipse.ptp.internal.rdt.core.typehierarchy.THGraph;
import org.eclipse.ptp.internal.rdt.core.typehierarchy.TypeHierarchyUtil;
import org.eclipse.rse.dstore.universal.miners.UniversalServerUtilities;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDTMiner
extends Miner {
    private static final String CANCELLED = "cancelled";
    public static final String CLASSNAME = "org.eclipse.ptp.internal.rdt.core.miners.CDTMiner";
    public static final String C_INDEX_REINDEX = "C_INDEX_REINDEX";
    public static final String C_INDEX_DELTA = "C_INDEX_DELTA";
    public static final String T_INDEX_STATUS_DESCRIPTOR = "Type.Index.Status";
    public static final String T_INDEX_STRING_DESCRIPTOR = "Type.Index.String";
    public static final String T_INDEX_FILENAME_DESCRIPTOR = "Type.Scope.Filename";
    public static final String T_INDEX_INT_DESCRIPTOR = "Type.Index.Int";
    public static final String T_INDEX_BOOLEAN_DESCRIPTOR = "Type.Index.Boolean";
    public static final String T_INDEX_DELTA_CHANGED = "Type.Index.Delta.Changed";
    public static final String T_INDEX_DELTA_ADDED = "Type.Index.Delta.Added";
    public static final String T_INDEX_DELTA_REMOVED = "Type.Index.Delta.Removed";
    public static final String T_INDEX_SCANNER_INFO_PROVIDER = "Type.Index.ScannerInfoProvider";
    public static final String C_REMOVE_INDEX_FILE = "C_REMOVE_INDEX_FILE";
    public static final String C_MOVE_INDEX_FILE = "C_MOVE_INDEX_FILE";
    public static final String T_MOVE_INDEX_FILE_RESULT = "Type.Index.MoveResult";
    public static final String T_INDEXING_ERROR = "Type.Indexing.Error";
    public static final String T_INDEXER_PROGRESS_INFO = "Type.Indexer.ProgressInfo";
    public static final String C_SCOPE_REGISTER = "C_SCOPE_REGISTER";
    public static final String C_SCOPE_UNREGISTER = "C_SCOPE_UNREGISTER";
    public static final String C_SCOPE_DELTA = "C_SCOPE_DELTA";
    public static final String C_SCOPE_COUNT_ELEMENTS = "C_SCOPE_COUNT_ELEMENTS";
    public static final String T_SCOPE_SCOPENAME_DESCRIPTOR = "Type.Scope.Scopename";
    public static final String T_SCOPE_CONFIG_LOCATION = "Type.Scope.ConfigLocation";
    public static final String C_CALL_HIERARCHY_GET_CALLS = "C_CALL_HIERARCHY_GET_CALLS";
    public static final String T_CALL_HIERARCHY_RESULT = "Type.CallHierarchy.Result";
    public static final String C_CALL_HIERARCHY_GET_CALLERS = "C_CALL_HIERARCHY_GET_CALLERS";
    public static final String C_CALL_HIERARCHY_GET_DEFINITIONS_FROM_ELEMENT = "C_CALL_HIERARCHY_GET_DEFINITIONS_FROM_ELEMENT";
    public static final String C_CALL_HIERARCHY_GET_DEFINITIONS_FROM_WORKING_COPY = "C_CALL_HIERARCHY_GET_DEFINITIONS_FROM_WORKING_COPY";
    public static final String C_CALL_HIERARCHY_GET_OVERRIDERS = "C_CALL_HIERARCHY_GET_OVERRIDERS";
    public static final String C_SEARCH_RUN_QUERY = "C_SEARCH_RUN_QUERY";
    public static final String C_SEARCH_RUN_QUERY2 = "C_SEARCH_RUN_QUERY2";
    public static final String T_SEARCH_RESULT = "Type.Search.Result";
    public static final String C_CONTENT_ASSIST_COMPUTE_PROPOSALS = "C_CONTENT_ASSIST_COMPUTE_PROPOSALS";
    public static final String C_TYPE_HIERARCHY_COMPUTE_TYPE_GRAPH = "C_TYPE_HIERARCHY_COMPUTE_TYPE_GRAPH";
    public static final String C_TYPE_HIERARCHY_FIND_INPUT1 = "C_TYPE_HIERARCHY_FIND_INPUT1";
    public static final String C_TYPE_HIERARCHY_FIND_INPUT2 = "C_TYPE_HIERARCHY_FIND_INPUT2";
    public static final String C_NAVIGATION_OPEN_DECLARATION = "C_NAVIGATION_OPEN_DECLARATION";
    public static final String T_NAVIGATION_RESULT = "Type.Navigation.Result";
    public static final String C_INCLUDES_FIND_INCLUDES_TO = "C_INCLUDES_FIND_INCLUDES_TO";
    public static final String T_INCLUDES_FIND_INCLUDES_TO_RESULT = "Type.Includes.Find.Includes.To.Result";
    public static final String C_INCLUDES_FIND_INCLUDED_BY = "C_INCLUDES_FIND_INCLUDED_BY";
    public static final String T_INCLUDES_FIND_INCLUDED_BY_RESULT = "Type.Includes.Find.Included.By.Result";
    public static final String C_INCLUDES_IS_INDEXED = "C_INCLUDES_IS_INDEXED";
    public static final String T_INCLUDES_IS_INDEXED_RESULT = "Type.Includes.Is.Indexed.Result";
    public static final String C_INCLUDES_FIND_INCLUDE = "C_INCLUDES_FIND_INCLUDE";
    public static final String T_INCLUDES_FIND_INCLUDE_RESULT = "Type.Includes.Find.Include.Result";
    public static final String C_SEMANTIC_HIGHTLIGHTING_COMPUTE_POSITIONS = "C_SEMANTIC_HIGHTLIGHTING_COMPUTE_POSITIONS";
    public static final String T_HIGHTLIGHTING_POSITIONS_RESULT = "Highlighting.Positions.Result";
    public static final String C_CODE_FOLDING_COMPUTE_REGIONS = "C_CODE_FOLDING_COMPUTE_REGIONS";
    public static final String T_CODE_FOLDING_RESULT = "Folding.Region.Result";
    public static final String C_CODE_FORMATTING = "C_CODE_FORMATTING";
    public static final String T_CODE_FORMATTING_RESULT = "Code.Formatting.Result";
    public static String LINE_SEPARATOR;
    public static final String DELIMITER = ";;;";
    public static final String C_MODEL_BUILDER = "C_MODEL_BUILDER";
    public static final String T_MODEL_RESULT = "Type.Model.Result";
    public static final String LOG_TAG = "CDTMiner";
    public static final boolean DEBUG = true;
    protected IndexerThread indexerThread = null;

    public String getVersion() {
        return "0.0.1";
    }

    public DataElement handleCommand(DataElement theCommand) {
        try {
            return this.doHandleCommand(theCommand);
        }
        catch (RuntimeException e) {
            UniversalServerUtilities.logError((String)LOG_TAG, (String)e.toString(), (Throwable)e, (DataStore)this._dataStore);
            this.getDataStore().refresh(theCommand);
            this.getDataStore().disconnectObject(theCommand);
            throw e;
        }
    }

    protected DataElement doHandleCommand(DataElement theCommand) {
        DataElement status;
        block137: {
            String name = this.getCommandName(theCommand);
            status = this.getCommandStatus(theCommand);
            if (name.equals(C_SCOPE_REGISTER)) {
                DataElement scopeName = this.getCommandArgument(theCommand, 1);
                String scheme = this.getString(theCommand, 2);
                String host = this.getString(theCommand, 3);
                String rootPath = this.getString(theCommand, 4);
                String mappedPath = this.getString(theCommand, 5);
                DataElement configLocation = this.getCommandArgument(theCommand, 6);
                ArrayList<DataElement> fileNames = new ArrayList<DataElement>();
                int i = 7;
                while (i < theCommand.getNestedSize() - 1) {
                    DataElement fileName = this.getCommandArgument(theCommand, i);
                    String type = fileName.getType();
                    if (type.equals(T_INDEX_FILENAME_DESCRIPTOR)) {
                        UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)"found a file", (DataStore)this._dataStore);
                        fileNames.add(fileName);
                    } else {
                        UniversalServerUtilities.logWarning((String)LOG_TAG, (String)"bad datatype in call to RegisterScope()", (DataStore)this._dataStore);
                    }
                    ++i;
                }
                UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)("about to register scope: " + scopeName), (DataStore)this._dataStore);
                this.handleRegisterScope(scopeName, scheme, host, configLocation.getName(), fileNames, rootPath, mappedPath, status);
            } else if (name.equals(C_SCOPE_UNREGISTER)) {
                DataElement scopeName = this.getCommandArgument(theCommand, 1);
                this.handleUnregisterScope(scopeName, status);
            } else if (name.equals(C_REMOVE_INDEX_FILE)) {
                DataElement scopeName = this.getCommandArgument(theCommand, 1);
                this.handleIndexFileRemove(scopeName, status);
            } else if (name.equals(C_INDEX_DELTA)) {
                IRemoteIndexerInfoProvider provider;
                String scopeName = this.getString(theCommand, 1);
                String scheme = this.getString(theCommand, 2);
                String rootPath = this.getString(theCommand, 3);
                String mappedPath = this.getString(theCommand, 4);
                String host = this.getString(theCommand, 5);
                try {
                    provider = (IRemoteIndexerInfoProvider)Serializer.deserialize(this.getString(theCommand, 6));
                }
                catch (IOException e) {
                    UniversalServerUtilities.logError((String)LOG_TAG, (String)e.toString(), (Throwable)e, (DataStore)this._dataStore);
                    status.getDataStore().refresh(status);
                    status.getDataStore().disconnectObject(status.getParent());
                    return status;
                }
                catch (ClassNotFoundException e) {
                    UniversalServerUtilities.logError((String)LOG_TAG, (String)e.toString(), (Throwable)e, (DataStore)this._dataStore);
                    status.getDataStore().refresh(status);
                    status.getDataStore().disconnectObject(status.getParent());
                    return status;
                }
                UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)("Indexing delta for scope: " + scopeName), (DataStore)this._dataStore);
                LinkedList<String> addedFiles = new LinkedList<String>();
                LinkedList<String> changedFiles = new LinkedList<String>();
                LinkedList<String> removedFiles = new LinkedList<String>();
                int i = 7;
                while (i < theCommand.getNestedSize() - 1) {
                    DataElement changeElement = this.getCommandArgument(theCommand, i);
                    String type = changeElement.getType();
                    String elementName = changeElement.getName();
                    if (type.equals(T_INDEX_DELTA_ADDED)) {
                        UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)("added a file: " + elementName), (DataStore)this._dataStore);
                        addedFiles.add(changeElement.getName());
                    } else if (type.equals(T_INDEX_DELTA_CHANGED)) {
                        UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)("changed a file: " + elementName), (DataStore)this._dataStore);
                        changedFiles.add(changeElement.getName());
                    } else if (type.equals(T_INDEX_DELTA_REMOVED)) {
                        UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)("removed a file: " + elementName), (DataStore)this._dataStore);
                        removedFiles.add(changeElement.getName());
                    } else {
                        UniversalServerUtilities.logWarning((String)LOG_TAG, (String)"bad datatype in call to RegisterScope()", (DataStore)this._dataStore);
                    }
                    ++i;
                }
                this.handleIndexDelta(scopeName, addedFiles, changedFiles, removedFiles, provider, scheme, host, rootPath, mappedPath, status);
                UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)"Indexing complete.", (DataStore)this._dataStore);
            } else if (name.equals(C_INDEX_REINDEX)) {
                try {
                    String scopeName = this.getString(theCommand, 1);
                    this.getString(theCommand, 2);
                    this.getString(theCommand, 3);
                    this.getString(theCommand, 4);
                    String newIndexLocation = this.getString(theCommand, 5);
                    IRemoteIndexerInfoProvider provider = (IRemoteIndexerInfoProvider)Serializer.deserialize(this.getString(theCommand, 6));
                    UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)("Reindexing scope " + scopeName), (DataStore)this._dataStore);
                    this.handleReindex(scopeName, newIndexLocation, provider, status);
                    UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)"Reindexing complete.", (DataStore)this._dataStore);
                }
                catch (IOException e) {
                    UniversalServerUtilities.logError((String)LOG_TAG, (String)e.toString(), (Throwable)e, (DataStore)this._dataStore);
                }
                catch (ClassNotFoundException e) {
                    UniversalServerUtilities.logError((String)LOG_TAG, (String)e.toString(), (Throwable)e, (DataStore)this._dataStore);
                }
            } else if (name.equals("C_CANCEL")) {
                DataElement subject = this.getCommandArgument(theCommand, 0);
                DataElement cancelStatus = this.getCommandStatus(subject);
                String commandName = subject.getName().trim();
                if (C_INDEX_REINDEX.equals(commandName) || C_INDEX_DELTA.equals(commandName)) {
                    this.handleIndexCancel(cancelStatus);
                } else {
                    CDTMiner.statusCancelled(cancelStatus);
                }
            } else if (name.equals(C_MOVE_INDEX_FILE)) {
                try {
                    String scopeName = this.getString(theCommand, 1);
                    String newIndexLocation = this.getString(theCommand, 2);
                    this.handleIndexFileMove(scopeName, newIndexLocation, status);
                }
                catch (IOException e) {
                    UniversalServerUtilities.logError((String)LOG_TAG, (String)e.toString(), (Throwable)e, (DataStore)this._dataStore);
                }
            } else if (name.equals(C_CALL_HIERARCHY_GET_CALLERS)) {
                try {
                    String scopeName = this.getString(theCommand, 1);
                    String scheme = this.getString(theCommand, 2);
                    this.getString(theCommand, 3);
                    this.getString(theCommand, 4);
                    String hostName = this.getString(theCommand, 5);
                    ICElement subject = (ICElement)Serializer.deserialize(this.getString(theCommand, 6));
                    String path = this.getString(theCommand, 7);
                    UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)"Getting callers...", (DataStore)this._dataStore);
                    this.handleGetCallers(scopeName, subject, path, scheme, hostName, status);
                    UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)"Finished getting callers.", (DataStore)this._dataStore);
                }
                catch (IOException e) {
                    UniversalServerUtilities.logError((String)LOG_TAG, (String)e.toString(), (Throwable)e, (DataStore)this._dataStore);
                }
                catch (ClassNotFoundException e) {
                    UniversalServerUtilities.logError((String)LOG_TAG, (String)e.toString(), (Throwable)e, (DataStore)this._dataStore);
                }
            } else if (name.equals(C_CALL_HIERARCHY_GET_CALLS)) {
                try {
                    String scopeName = this.getString(theCommand, 1);
                    this.getString(theCommand, 2);
                    this.getString(theCommand, 3);
                    this.getString(theCommand, 4);
                    String hostName = this.getString(theCommand, 5);
                    ICElement subject = (ICElement)Serializer.deserialize(this.getString(theCommand, 6));
                    String path = this.getString(theCommand, 7);
                    UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)"Getting callees...", (DataStore)this._dataStore);
                    this.handleGetCallees(scopeName, subject, path, hostName, status);
                    UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)"Finished getting callees.", (DataStore)this._dataStore);
                }
                catch (IOException e) {
                    UniversalServerUtilities.logError((String)LOG_TAG, (String)e.toString(), (Throwable)e, (DataStore)this._dataStore);
                }
                catch (ClassNotFoundException e) {
                    UniversalServerUtilities.logError((String)LOG_TAG, (String)e.toString(), (Throwable)e, (DataStore)this._dataStore);
                }
            } else if (name.equals(C_CALL_HIERARCHY_GET_DEFINITIONS_FROM_ELEMENT)) {
                try {
                    String scopeName = this.getString(theCommand, 1);
                    this.getString(theCommand, 2);
                    this.getString(theCommand, 3);
                    this.getString(theCommand, 4);
                    String hostName = this.getString(theCommand, 5);
                    ICElement subject = (ICElement)Serializer.deserialize(this.getString(theCommand, 6));
                    String path = this.getString(theCommand, 7);
                    UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)"Getting definitions...", (DataStore)this._dataStore);
                    this.handleGetDefinitions(scopeName, hostName, subject, path, status);
                    UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)"Finished getting definitions.", (DataStore)this._dataStore);
                }
                catch (IOException e) {
                    UniversalServerUtilities.logError((String)LOG_TAG, (String)e.toString(), (Throwable)e, (DataStore)this._dataStore);
                }
                catch (ClassNotFoundException e) {
                    UniversalServerUtilities.logError((String)LOG_TAG, (String)e.toString(), (Throwable)e, (DataStore)this._dataStore);
                }
            } else if (name.equals(C_CALL_HIERARCHY_GET_OVERRIDERS)) {
                try {
                    String scopeName = this.getString(theCommand, 1);
                    this.getString(theCommand, 2);
                    this.getString(theCommand, 3);
                    this.getString(theCommand, 4);
                    String hostName = this.getString(theCommand, 5);
                    ICElement subject = (ICElement)Serializer.deserialize(this.getString(theCommand, 6));
                    String path = this.getString(theCommand, 7);
                    UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)"Getting definitions...", (DataStore)this._dataStore);
                    this.handleGetOverriders(scopeName, hostName, subject, path, status);
                    UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)"Finished getting definitions.", (DataStore)this._dataStore);
                }
                catch (IOException e) {
                    UniversalServerUtilities.logError((String)LOG_TAG, (String)e.toString(), (Throwable)e, (DataStore)this._dataStore);
                }
                catch (ClassNotFoundException e) {
                    UniversalServerUtilities.logError((String)LOG_TAG, (String)e.toString(), (Throwable)e, (DataStore)this._dataStore);
                }
            } else if (name.equals(C_CALL_HIERARCHY_GET_DEFINITIONS_FROM_WORKING_COPY)) {
                try {
                    String scopeName = this.getString(theCommand, 1);
                    this.getString(theCommand, 2);
                    this.getString(theCommand, 3);
                    this.getString(theCommand, 4);
                    String hostName = this.getString(theCommand, 5);
                    ITranslationUnit unit = (ITranslationUnit)Serializer.deserialize(this.getString(theCommand, 6));
                    String path = this.getString(theCommand, 7);
                    int selectionStart = this.getInteger(theCommand, 8);
                    int selectionLength = this.getInteger(theCommand, 9);
                    UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)"Getting definitions...", (DataStore)this._dataStore);
                    this.handleGetDefinitions(scopeName, hostName, unit, path, selectionStart, selectionLength, status);
                    UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)"Finished getting definitions.", (DataStore)this._dataStore);
                }
                catch (IOException e) {
                    UniversalServerUtilities.logError((String)LOG_TAG, (String)e.toString(), (Throwable)e, (DataStore)this._dataStore);
                }
                catch (ClassNotFoundException e) {
                    UniversalServerUtilities.logError((String)LOG_TAG, (String)e.toString(), (Throwable)e, (DataStore)this._dataStore);
                }
            } else if (name.equals(C_SEARCH_RUN_QUERY)) {
                try {
                    String scopeName = this.getString(theCommand, 1);
                    String scheme = this.getString(theCommand, 2);
                    this.getString(theCommand, 3);
                    this.getString(theCommand, 4);
                    String hostName = this.getString(theCommand, 5);
                    RemoteSearchQuery query = (RemoteSearchQuery)Serializer.deserialize(this.getString(theCommand, 6));
                    UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)"Finding matches based on a pattern...", (DataStore)this._dataStore);
                    this.handleRunQuery(scopeName, query, scheme, hostName, status);
                    UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)"Finished finding matches", (DataStore)this._dataStore);
                }
                catch (IOException e) {
                    UniversalServerUtilities.logError((String)LOG_TAG, (String)e.toString(), (Throwable)e, (DataStore)this._dataStore);
                }
                catch (ClassNotFoundException e) {
                    UniversalServerUtilities.logError((String)LOG_TAG, (String)e.toString(), (Throwable)e, (DataStore)this._dataStore);
                }
            } else if (name.equals(C_SEARCH_RUN_QUERY2)) {
                try {
                    String scopeName = this.getString(theCommand, 1);
                    String scheme = this.getString(theCommand, 2);
                    this.getString(theCommand, 3);
                    this.getString(theCommand, 4);
                    String hostName = this.getString(theCommand, 5);
                    RemoteSearchQuery query = (RemoteSearchQuery)Serializer.deserialize(this.getString(theCommand, 6));
                    UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)"Finding matches based on a pattern...", (DataStore)this._dataStore);
                    this.handleRunQuery2(scopeName, query, scheme, hostName, status);
                    UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)"Finished finding matches", (DataStore)this._dataStore);
                }
                catch (IOException e) {
                    UniversalServerUtilities.logError((String)LOG_TAG, (String)e.toString(), (Throwable)e, (DataStore)this._dataStore);
                }
                catch (ClassNotFoundException e) {
                    UniversalServerUtilities.logError((String)LOG_TAG, (String)e.toString(), (Throwable)e, (DataStore)this._dataStore);
                }
            } else if (name.equals(C_CONTENT_ASSIST_COMPUTE_PROPOSALS)) {
                try {
                    String scopeName = this.getString(theCommand, 1);
                    RemoteContentAssistInvocationContext context = (RemoteContentAssistInvocationContext)Serializer.deserialize(this.getString(theCommand, 2));
                    ITranslationUnit unit = (ITranslationUnit)Serializer.deserialize(this.getString(theCommand, 3));
                    String path = this.getString(theCommand, 4);
                    UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)"Computing completions...", (DataStore)this._dataStore);
                    this.handleComputeCompletionProposals(scopeName, context, unit, path, status);
                }
                catch (IOException e) {
                    UniversalServerUtilities.logError((String)LOG_TAG, (String)e.toString(), (Throwable)e, (DataStore)this._dataStore);
                }
                catch (ClassNotFoundException e) {
                    UniversalServerUtilities.logError((String)LOG_TAG, (String)e.toString(), (Throwable)e, (DataStore)this._dataStore);
                }
            } else if (name.equals(C_TYPE_HIERARCHY_COMPUTE_TYPE_GRAPH)) {
                try {
                    String scopeName = this.getString(theCommand, 1);
                    this.getString(theCommand, 2);
                    this.getString(theCommand, 3);
                    this.getString(theCommand, 4);
                    String hostName = this.getString(theCommand, 5);
                    ICElement input = (ICElement)Serializer.deserialize(this.getString(theCommand, 6));
                    String path = this.getString(theCommand, 7);
                    UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)"Computing type graph...", (DataStore)this._dataStore);
                    this.handleComputeTypeGraph(scopeName, hostName, input, path, status);
                }
                catch (IOException e) {
                    UniversalServerUtilities.logError((String)LOG_TAG, (String)e.toString(), (Throwable)e, (DataStore)this._dataStore);
                }
                catch (ClassNotFoundException e) {
                    UniversalServerUtilities.logError((String)LOG_TAG, (String)e.toString(), (Throwable)e, (DataStore)this._dataStore);
                }
            } else if (name.equals(C_TYPE_HIERARCHY_FIND_INPUT1)) {
                try {
                    String scopeName = this.getString(theCommand, 1);
                    this.getString(theCommand, 2);
                    this.getString(theCommand, 3);
                    this.getString(theCommand, 4);
                    String hostName = this.getString(theCommand, 5);
                    ICElement input = (ICElement)Serializer.deserialize(this.getString(theCommand, 6));
                    String path = this.getString(theCommand, 7);
                    UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)"Finding type hierarchy input from element selection...", (DataStore)this._dataStore);
                    String projectName = input.getCProject().getElementName();
                    this.handleFindTypeHierarchyInput(scopeName, hostName, projectName, input, path, status);
                }
                catch (IOException e) {
                    UniversalServerUtilities.logError((String)LOG_TAG, (String)e.toString(), (Throwable)e, (DataStore)this._dataStore);
                }
                catch (ClassNotFoundException e) {
                    UniversalServerUtilities.logError((String)LOG_TAG, (String)e.toString(), (Throwable)e, (DataStore)this._dataStore);
                }
            } else if (name.equals(C_TYPE_HIERARCHY_FIND_INPUT2)) {
                try {
                    String scopeName = this.getString(theCommand, 1);
                    this.getString(theCommand, 2);
                    this.getString(theCommand, 3);
                    this.getString(theCommand, 4);
                    String hostName = this.getString(theCommand, 5);
                    ITranslationUnit unit = (ITranslationUnit)Serializer.deserialize(this.getString(theCommand, 6));
                    String path = this.getString(theCommand, 7);
                    int selectionStart = this.getInteger(theCommand, 8);
                    int selectionLength = this.getInteger(theCommand, 9);
                    UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)"Finding type hierarchy input from text selection...", (DataStore)this._dataStore);
                    String projectName = unit.getCProject().getElementName();
                    this.handleFindTypeHierarchyInput(scopeName, hostName, unit, path, projectName, selectionStart, selectionLength, status);
                }
                catch (IOException e) {
                    UniversalServerUtilities.logError((String)LOG_TAG, (String)e.toString(), (Throwable)e, (DataStore)this._dataStore);
                }
                catch (ClassNotFoundException e) {
                    UniversalServerUtilities.logError((String)LOG_TAG, (String)e.toString(), (Throwable)e, (DataStore)this._dataStore);
                }
            } else if (name.equals(C_NAVIGATION_OPEN_DECLARATION)) {
                try {
                    String scopeName = this.getString(theCommand, 1);
                    String scheme = this.getString(theCommand, 2);
                    this.getString(theCommand, 3);
                    this.getString(theCommand, 4);
                    ITranslationUnit unit = (ITranslationUnit)Serializer.deserialize(this.getString(theCommand, 5));
                    String path = this.getString(theCommand, 6);
                    String selectedText = this.getString(theCommand, 7);
                    int selectionStart = this.getInteger(theCommand, 8);
                    int selectionLength = this.getInteger(theCommand, 9);
                    UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)"Open declaration...", (DataStore)this._dataStore);
                    OpenDeclarationResult result = OpenDeclarationHandler.handleOpenDeclarationRemotely(scopeName, scheme, unit, path, selectedText, selectionStart, selectionLength, this._dataStore);
                    String resultString = Serializer.serialize(result);
                    status.getDataStore().createObject(status, T_NAVIGATION_RESULT, resultString);
                }
                catch (IOException e) {
                    UniversalServerUtilities.logError((String)LOG_TAG, (String)e.toString(), (Throwable)e, (DataStore)this._dataStore);
                    CDTMiner.statusDone(status);
                    break block137;
                }
                catch (ClassNotFoundException e) {
                    try {
                        UniversalServerUtilities.logError((String)LOG_TAG, (String)e.toString(), (Throwable)e, (DataStore)this._dataStore);
                        break block137;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        CDTMiner.statusDone(status);
                    }
                }
                CDTMiner.statusDone(status);
            } else if (name.equals(C_INCLUDES_FIND_INCLUDES_TO)) {
                try {
                    String scopeName = this.getString(theCommand, 1);
                    this.getString(theCommand, 2);
                    this.getString(theCommand, 3);
                    this.getString(theCommand, 4);
                    String hostName = this.getString(theCommand, 5);
                    IIndexFileLocation location = (IIndexFileLocation)Serializer.deserialize(this.getString(theCommand, 6));
                    UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)("Finding includes for location " + location), (DataStore)this._dataStore);
                    this.handleFindIncludesTo(scopeName, hostName, location, status);
                    UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)"Finished finding includes", (DataStore)this._dataStore);
                }
                catch (IOException e) {
                    UniversalServerUtilities.logError((String)LOG_TAG, (String)e.toString(), (Throwable)e, (DataStore)this._dataStore);
                }
                catch (ClassNotFoundException e) {
                    UniversalServerUtilities.logError((String)LOG_TAG, (String)e.toString(), (Throwable)e, (DataStore)this._dataStore);
                }
            } else if (name.equals(C_INCLUDES_FIND_INCLUDED_BY)) {
                try {
                    String scopeName = this.getString(theCommand, 1);
                    this.getString(theCommand, 2);
                    this.getString(theCommand, 3);
                    this.getString(theCommand, 4);
                    String hostName = this.getString(theCommand, 5);
                    IIndexFileLocation location = (IIndexFileLocation)Serializer.deserialize(this.getString(theCommand, 6));
                    UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)("Finding includes for location " + location), (DataStore)this._dataStore);
                    this.handleFindIncludedBy(scopeName, hostName, location, status);
                    UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)"Finished finding included by", (DataStore)this._dataStore);
                }
                catch (IOException e) {
                    UniversalServerUtilities.logError((String)LOG_TAG, (String)e.toString(), (Throwable)e, (DataStore)this._dataStore);
                }
                catch (ClassNotFoundException e) {
                    UniversalServerUtilities.logError((String)LOG_TAG, (String)e.toString(), (Throwable)e, (DataStore)this._dataStore);
                }
            } else if (name.equals(C_INCLUDES_FIND_INCLUDE)) {
                try {
                    String scopeName = this.getString(theCommand, 1);
                    this.getString(theCommand, 2);
                    this.getString(theCommand, 3);
                    this.getString(theCommand, 4);
                    String hostName = this.getString(theCommand, 5);
                    IIndexFileLocation location = (IIndexFileLocation)Serializer.deserialize(this.getString(theCommand, 6));
                    String includeName = this.getString(theCommand, 7);
                    int offset = this.getInteger(theCommand, 8);
                    UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)("Finding include for location " + location), (DataStore)this._dataStore);
                    this.handleFindInclude(scopeName, hostName, location, includeName, offset, status);
                    UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)"Finished finding include", (DataStore)this._dataStore);
                }
                catch (IOException e) {
                    UniversalServerUtilities.logError((String)LOG_TAG, (String)e.toString(), (Throwable)e, (DataStore)this._dataStore);
                }
                catch (ClassNotFoundException e) {
                    UniversalServerUtilities.logError((String)LOG_TAG, (String)e.toString(), (Throwable)e, (DataStore)this._dataStore);
                }
            } else if (name.equals(C_INCLUDES_IS_INDEXED)) {
                try {
                    String scopeName = this.getString(theCommand, 1);
                    this.getString(theCommand, 2);
                    this.getString(theCommand, 3);
                    this.getString(theCommand, 4);
                    String hostName = this.getString(theCommand, 5);
                    IIndexFileLocation location = (IIndexFileLocation)Serializer.deserialize(this.getString(theCommand, 6));
                    UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)("Finding if location is indexed: " + location), (DataStore)this._dataStore);
                    this.handleIsIndexed(scopeName, hostName, location, status);
                    UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)"Finished finding if location is indexed", (DataStore)this._dataStore);
                }
                catch (IOException e) {
                    UniversalServerUtilities.logError((String)LOG_TAG, (String)e.toString(), (Throwable)e, (DataStore)this._dataStore);
                }
                catch (ClassNotFoundException e) {
                    UniversalServerUtilities.logError((String)LOG_TAG, (String)e.toString(), (Throwable)e, (DataStore)this._dataStore);
                }
            } else if (name.equals(C_MODEL_BUILDER)) {
                try {
                    ITranslationUnit workingCopy = (ITranslationUnit)Serializer.deserialize(this.getString(theCommand, 1));
                    UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)("Model Builder: building working copy: " + workingCopy.getElementName() + "..."), (DataStore)this._dataStore);
                    this.handleGetModel(workingCopy, status);
                    UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)"Finished building model.", (DataStore)this._dataStore);
                }
                catch (IOException e) {
                    UniversalServerUtilities.logError((String)LOG_TAG, (String)e.toString(), (Throwable)e, (DataStore)this._dataStore);
                }
                catch (ClassNotFoundException e) {
                    UniversalServerUtilities.logError((String)LOG_TAG, (String)e.toString(), (Throwable)e, (DataStore)this._dataStore);
                }
            } else if (name.equals(C_SEMANTIC_HIGHTLIGHTING_COMPUTE_POSITIONS)) {
                try {
                    String scopeName = this.getString(theCommand, 1);
                    ITranslationUnit tu = (ITranslationUnit)Serializer.deserialize(this.getString(theCommand, 2));
                    this.handleComputeSemanticHightlightingPositions(scopeName, tu, status);
                }
                catch (IOException e) {
                    UniversalServerUtilities.logError((String)LOG_TAG, (String)e.toString(), (Throwable)e, (DataStore)this._dataStore);
                }
                catch (ClassNotFoundException e) {
                    UniversalServerUtilities.logError((String)LOG_TAG, (String)e.toString(), (Throwable)e, (DataStore)this._dataStore);
                }
            } else if (name.equals(C_CODE_FOLDING_COMPUTE_REGIONS)) {
                try {
                    String scopeName = this.getString(theCommand, 1);
                    ITranslationUnit tu = (ITranslationUnit)Serializer.deserialize(this.getString(theCommand, 2));
                    int docSize = this.getInteger(theCommand, 3);
                    boolean preprocessorFoldingEnabled = this.getBoolean(theCommand, 4);
                    boolean statementsFoldingEnabled = this.getBoolean(theCommand, 5);
                    this.handleComputeCodeFoldingRegions(scopeName, tu, status, statementsFoldingEnabled, preprocessorFoldingEnabled, docSize);
                }
                catch (IOException e) {
                    UniversalServerUtilities.logError((String)LOG_TAG, (String)e.toString(), (Throwable)e, (DataStore)this._dataStore);
                }
                catch (ClassNotFoundException e) {
                    UniversalServerUtilities.logError((String)LOG_TAG, (String)e.toString(), (Throwable)e, (DataStore)this._dataStore);
                }
            } else if (name.equals(C_CODE_FORMATTING)) {
                try {
                    String scopeName = this.getString(theCommand, 1);
                    ITranslationUnit tu = (ITranslationUnit)Serializer.deserialize(this.getString(theCommand, 2));
                    String source = this.getString(theCommand, 3);
                    RemoteDefaultCodeFormatterOptions preferences = (RemoteDefaultCodeFormatterOptions)Serializer.deserialize(this.getString(theCommand, 4));
                    int offset = this.getInteger(theCommand, 5);
                    int length = this.getInteger(theCommand, 6);
                    this.handleComputeCodeFormatting(scopeName, tu, source, preferences, offset, length, status);
                }
                catch (IOException e) {
                    UniversalServerUtilities.logError((String)LOG_TAG, (String)e.toString(), (Throwable)e, (DataStore)this._dataStore);
                }
                catch (ClassNotFoundException e) {
                    UniversalServerUtilities.logError((String)LOG_TAG, (String)e.toString(), (Throwable)e, (DataStore)this._dataStore);
                }
            }
        }
        status.getDataStore().refresh(status);
        status.getDataStore().disconnectObject(status.getParent());
        return status;
    }

    /*
     * Loose catch block
     */
    protected void handleComputeCodeFormatting(String scopeName, ITranslationUnit tu, String source, RemoteDefaultCodeFormatterOptions preferences, int offset, int length, DataElement status) {
        try {
            try {
                IIndex index = RemoteIndexManager.getInstance().getIndexForScope(scopeName, this._dataStore);
                index.acquireReadLock();
                try {
                    IASTTranslationUnit ast = tu.getAST(index, 6);
                    RemoteCodeFormatterVisitor codeFormatter = new RemoteCodeFormatterVisitor(preferences, offset, length, LOG_TAG, this._dataStore);
                    TextEdit edit = codeFormatter.format(source, ast);
                    RemoteTextEdit copy = this.copyEdit(edit);
                    String resultString = Serializer.serialize(copy);
                    status.getDataStore().createObject(status, T_CODE_FORMATTING_RESULT, resultString);
                }
                finally {
                    index.releaseReadLock();
                }
            }
            catch (IOException e) {
                UniversalServerUtilities.logError((String)LOG_TAG, (String)e.toString(), (Throwable)e, (DataStore)this._dataStore);
                CDTMiner.statusDone(status);
            }
            catch (CoreException e) {
                UniversalServerUtilities.logError((String)LOG_TAG, (String)e.toString(), (Throwable)e, (DataStore)this._dataStore);
                CDTMiner.statusDone(status);
            }
            catch (InterruptedException e) {
                UniversalServerUtilities.logError((String)LOG_TAG, (String)e.toString(), (Throwable)e, (DataStore)this._dataStore);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                CDTMiner.statusDone(status);
            }
        }
        finally {
            CDTMiner.statusDone(status);
        }
    }

    private RemoteTextEdit copyEdit(TextEdit edit) {
        MultiTextEdit source;
        RemoteTextEdit copy = null;
        if (edit instanceof MultiTextEdit) {
            source = (MultiTextEdit)edit;
            copy = new RemoteMultiTextEdit(source);
        } else if (edit instanceof ReplaceEdit) {
            source = (ReplaceEdit)edit;
            copy = new RemoteReplaceEdit((ReplaceEdit)source);
        } else {
            copy = new RemoteTextEdit(edit);
        }
        TextEdit[] children = edit.getChildren();
        int i = 0;
        while (i < children.length) {
            copy.addChild(this.copyEdit(children[i]));
            ++i;
        }
        return copy;
    }

    /*
     * Loose catch block
     */
    protected void handleComputeSemanticHightlightingPositions(String scopeName, ITranslationUnit tu, DataElement status) {
        try {
            try {
                IIndex index = RemoteIndexManager.getInstance().getIndexForScope(scopeName, this._dataStore);
                index.acquireReadLock();
                try {
                    IASTTranslationUnit ast = tu.getAST(index, 134);
                    PositionCollector collector = new PositionCollector(true);
                    ast.accept((ASTVisitor)collector);
                    ArrayList<ArrayList<Integer>> positionList = collector.getPositions();
                    String clumpedPositions = new String();
                    for (ArrayList<Integer> position : positionList) {
                        clumpedPositions = String.valueOf(clumpedPositions) + position.get(0) + "," + position.get(1) + "," + position.get(2) + ",";
                    }
                    String resultString = Serializer.serialize(clumpedPositions);
                    status.getDataStore().createObject(status, T_HIGHTLIGHTING_POSITIONS_RESULT, resultString);
                }
                finally {
                    index.releaseReadLock();
                }
            }
            catch (IOException e) {
                UniversalServerUtilities.logError((String)LOG_TAG, (String)e.toString(), (Throwable)e, (DataStore)this._dataStore);
                CDTMiner.statusDone(status);
            }
            catch (CoreException e) {
                UniversalServerUtilities.logError((String)LOG_TAG, (String)e.toString(), (Throwable)e, (DataStore)this._dataStore);
                CDTMiner.statusDone(status);
            }
            catch (InterruptedException e) {
                UniversalServerUtilities.logError((String)LOG_TAG, (String)e.toString(), (Throwable)e, (DataStore)this._dataStore);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                CDTMiner.statusDone(status);
            }
        }
        finally {
            CDTMiner.statusDone(status);
        }
    }

    /*
     * Loose catch block
     */
    protected void handleComputeCodeFoldingRegions(String scopeName, ITranslationUnit tu, DataElement status, boolean statementsFoldingEnabled, boolean preprocessorFoldingEnabled, int docSize) {
        try {
            IASTTranslationUnit ast;
            IIndex index;
            ArrayList<RemoteFoldingRegionsHandler.Branch> branches;
            Stack<RemoteFoldingRegionsHandler.StatementRegion> iral;
            block19: {
                block18: {
                    iral = new Stack<RemoteFoldingRegionsHandler.StatementRegion>();
                    branches = new ArrayList<RemoteFoldingRegionsHandler.Branch>();
                    index = RemoteIndexManager.getInstance().getIndexForScope(scopeName, this._dataStore);
                    index.acquireReadLock();
                    ast = tu.getAST(index, 134);
                    if (ast != null) break block18;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    index.releaseReadLock();
                    return;
                }
                String fileName = ast.getFilePath();
                if (fileName != null) break block19;
                index.releaseReadLock();
                return;
            }
            try {
                try {
                    RemoteFoldingRegionsHandler rfrh = new RemoteFoldingRegionsHandler();
                    FoldingRegionsResult result = new FoldingRegionsResult();
                    if (statementsFoldingEnabled) {
                        RemoteFoldingRegionsHandler.StatementVisitor sv = rfrh.createStatementVisitor(iral);
                        ast.accept((ASTVisitor)sv);
                        result.iral = iral;
                    }
                    if (preprocessorFoldingEnabled) {
                        rfrh.computePreprocessorFoldingStructure(ast, docSize, branches);
                        result.branches = branches;
                    }
                    String resultString = Serializer.serialize(result);
                    status.getDataStore().createObject(status, T_CODE_FOLDING_RESULT, resultString);
                }
                finally {
                    index.releaseReadLock();
                }
            }
            catch (IOException e) {
                UniversalServerUtilities.logError((String)LOG_TAG, (String)e.toString(), (Throwable)e, (DataStore)this._dataStore);
            }
            catch (CoreException e) {
                UniversalServerUtilities.logError((String)LOG_TAG, (String)e.toString(), (Throwable)e, (DataStore)this._dataStore);
            }
            catch (InterruptedException e) {
                UniversalServerUtilities.logError((String)LOG_TAG, (String)e.toString(), (Throwable)e, (DataStore)this._dataStore);
            }
        }
        finally {
            CDTMiner.statusDone(status);
        }
    }

    protected void handleIndexFileMove(String scopeName, String newIndexLocation, DataElement status) throws IOException {
        String actualLocation = RemoteIndexManager.getInstance().moveIndexFile(scopeName, newIndexLocation, this._dataStore);
        status.getDataStore().createObject(status, T_MOVE_INDEX_FILE_RESULT, actualLocation);
        CDTMiner.statusDone(status);
    }

    protected void handleIndexFileRemove(DataElement scopeName, DataElement status) {
        String scope = scopeName.getName();
        RemoteIndexManager.getInstance().removeIndexFile(scope, this._dataStore);
        CDTMiner.statusDone(status);
    }

    /*
     * Loose catch block
     */
    protected void handleGetModel(ITranslationUnit unit, DataElement status) {
        block14: {
            try {
                try {
                    IASTTranslationUnit ast;
                    UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)"Get model started", (DataStore)this._dataStore);
                    if (!(unit instanceof WorkingCopy)) break block14;
                    WorkingCopy workingCopy = (WorkingCopy)unit;
                    CModelBuilder2 builder = new CModelBuilder2(workingCopy, (IProgressMonitor)new NullProgressMonitor());
                    IIndex index = RemoteIndexManager.getInstance().getIndexForScope("__WORKSPACE_ROOT_SCOPE__", this._dataStore);
                    try {
                        index.acquireReadLock();
                        UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)"Got Read lock", (DataStore)this._dataStore);
                    }
                    catch (InterruptedException interruptedException) {
                        UniversalServerUtilities.logWarning((String)LOG_TAG, (String)"Unable to aquire read lock during model building", (DataStore)this._dataStore);
                        index = null;
                    }
                    try {
                        ast = workingCopy.getAST(index, 7);
                    }
                    finally {
                        index.releaseReadLock();
                        UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)"Lock released", (DataStore)this._dataStore);
                    }
                    builder.parse(ast);
                    String resultString = Serializer.serialize(workingCopy);
                    status.getDataStore().createObject(status, T_MODEL_RESULT, resultString);
                }
                catch (IOException e) {
                    UniversalServerUtilities.logError((String)LOG_TAG, (String)e.toString(), (Throwable)e, (DataStore)this._dataStore);
                    CDTMiner.statusDone(status);
                }
                catch (CoreException e) {
                    UniversalServerUtilities.logError((String)LOG_TAG, (String)e.toString(), (Throwable)e, (DataStore)this._dataStore);
                    CDTMiner.statusDone(status);
                }
                catch (DOMException e) {
                    UniversalServerUtilities.logError((String)LOG_TAG, (String)e.toString(), (Throwable)e, (DataStore)this._dataStore);
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    CDTMiner.statusDone(status);
                }
            }
            finally {
                CDTMiner.statusDone(status);
            }
        }
    }

    protected void handleFindIncludesTo(final String scopeName, final String hostName, final IIndexFileLocation location, final DataElement status) {
        Thread findIncludesToThread = new Thread(){

            public void run() {
                try {
                    try {
                        String scheme = location.getURI().getScheme();
                        IIndex index = RemoteIndexManager.getInstance().getIndexForScope(scopeName, CDTMiner.this._dataStore);
                        UniversalServerUtilities.logDebugMessage((String)CDTMiner.LOG_TAG, (String)"Acquiring read lock", (DataStore)CDTMiner.this._dataStore);
                        index.acquireReadLock();
                        try {
                            IIndexIncludeValue[] includesToReturn;
                            IIndexFile[] files = index.getFiles(location);
                            if (files.length == 0) {
                                UniversalServerUtilities.logDebugMessage((String)CDTMiner.LOG_TAG, (String)"No index files found", (DataStore)CDTMiner.this._dataStore);
                                includesToReturn = new IIndexIncludeValue[]{};
                            } else if (files.length == 1) {
                                IIndexInclude[] includes = index.findIncludes(files[0]);
                                if (includes == null) {
                                    includesToReturn = new IIndexIncludeValue[]{};
                                } else {
                                    includesToReturn = new IIndexIncludeValue[includes.length];
                                    int i = 0;
                                    while (i < includes.length) {
                                        includesToReturn[i] = new IndexIncludeValue(includes[i], CDTMiner.this.getLocationConverter(scheme, hostName));
                                        UniversalServerUtilities.logDebugMessage((String)CDTMiner.LOG_TAG, (String)("IndexIncludeValue to return: " + includesToReturn[i]), (DataStore)CDTMiner.this._dataStore);
                                        ++i;
                                    }
                                }
                            } else {
                                ArrayList<IndexIncludeValue> list = new ArrayList<IndexIncludeValue>();
                                HashSet<IIndexFileLocation> handled = new HashSet<IIndexFileLocation>();
                                int i = 0;
                                while (i < files.length) {
                                    if (CDTMiner.isCancelled(status)) break;
                                    IIndexInclude[] includes = index.findIncludes(files[i]);
                                    int j = 0;
                                    while (j < includes.length) {
                                        if (CDTMiner.isCancelled(status)) break;
                                        IIndexInclude indexInclude = includes[j];
                                        if (handled.add(indexInclude.getIncludesLocation())) {
                                            IndexIncludeValue value = new IndexIncludeValue(indexInclude, CDTMiner.this.getLocationConverter(scheme, hostName));
                                            list.add(value);
                                            UniversalServerUtilities.logDebugMessage((String)CDTMiner.LOG_TAG, (String)("IndexIncludeValue to return: " + value), (DataStore)CDTMiner.this._dataStore);
                                        }
                                        ++j;
                                    }
                                    ++i;
                                }
                                includesToReturn = list.toArray(new IIndexIncludeValue[list.size()]);
                            }
                            String resultString = Serializer.serialize(includesToReturn);
                            status.getDataStore().createObject(status, CDTMiner.T_INCLUDES_FIND_INCLUDES_TO_RESULT, resultString);
                        }
                        finally {
                            if (index != null) {
                                index.releaseReadLock();
                            }
                            UniversalServerUtilities.logDebugMessage((String)CDTMiner.LOG_TAG, (String)"Released read lock", (DataStore)CDTMiner.this._dataStore);
                        }
                    }
                    catch (Exception e) {
                        UniversalServerUtilities.logError((String)CDTMiner.LOG_TAG, (String)e.toString(), (Throwable)e, (DataStore)CDTMiner.this._dataStore);
                        CDTMiner.statusDone(status);
                    }
                }
                finally {
                    CDTMiner.statusDone(status);
                }
            }
        };
        findIncludesToThread.start();
    }

    public static boolean isCancelled(DataElement status) {
        return status.getAttribute(2).equals(CANCELLED);
    }

    protected void handleFindInclude(final String scopeName, final String hostName, final IIndexFileLocation location, final String name, final int offset, final DataElement status) {
        Thread findIncludeThread = new Thread(){

            public void run() {
                try {
                    try {
                        String scheme = location.getURI().getScheme();
                        IIndex index = RemoteIndexManager.getInstance().getIndexForScope(scopeName, CDTMiner.this._dataStore);
                        UniversalServerUtilities.logDebugMessage((String)CDTMiner.LOG_TAG, (String)"Acquiring read lock", (DataStore)CDTMiner.this._dataStore);
                        index.acquireReadLock();
                        try {
                            IndexIncludeValue includeToReturn = null;
                            IIndexFile[] files = index.getFiles(location);
                            if (files.length == 0) {
                                UniversalServerUtilities.logDebugMessage((String)CDTMiner.LOG_TAG, (String)"No index files found", (DataStore)CDTMiner.this._dataStore);
                            } else {
                                IIndexInclude best = null;
                                int j = 0;
                                while (j < files.length) {
                                    if (CDTMiner.isCancelled(status)) break;
                                    IIndexFile file = files[j];
                                    IIndexInclude[] includes = index.findIncludes(file);
                                    int bestDiff = Integer.MAX_VALUE;
                                    int i = 0;
                                    while (i < includes.length) {
                                        IIndexInclude candidate;
                                        int diff;
                                        if (CDTMiner.isCancelled(status) || (diff = Math.abs((candidate = includes[i]).getNameOffset() - offset)) > bestDiff) break;
                                        if (candidate.getName().endsWith(name)) {
                                            bestDiff = diff;
                                            best = candidate;
                                        }
                                        ++i;
                                    }
                                    if (best != null) {
                                        includeToReturn = new IndexIncludeValue(best, CDTMiner.this.getLocationConverter(scheme, hostName));
                                        break;
                                    }
                                    ++j;
                                }
                            }
                            String resultString = Serializer.serialize(includeToReturn);
                            status.getDataStore().createObject(status, CDTMiner.T_INCLUDES_FIND_INCLUDE_RESULT, resultString);
                        }
                        finally {
                            if (index != null) {
                                index.releaseReadLock();
                            }
                            UniversalServerUtilities.logDebugMessage((String)CDTMiner.LOG_TAG, (String)"Released read lock", (DataStore)CDTMiner.this._dataStore);
                        }
                    }
                    catch (Exception e) {
                        UniversalServerUtilities.logError((String)CDTMiner.LOG_TAG, (String)e.toString(), (Throwable)e, (DataStore)CDTMiner.this._dataStore);
                        CDTMiner.statusDone(status);
                    }
                }
                finally {
                    CDTMiner.statusDone(status);
                }
            }
        };
        findIncludeThread.start();
    }

    protected void handleFindIncludedBy(final String scopeName, final String hostName, final IIndexFileLocation location, final DataElement status) {
        Thread findIncludeThread = new Thread(){

            public void run() {
                try {
                    try {
                        String scheme = location.getURI().getScheme();
                        IIndex index = RemoteIndexManager.getInstance().getIndexForScope(scopeName, CDTMiner.this._dataStore);
                        UniversalServerUtilities.logDebugMessage((String)CDTMiner.LOG_TAG, (String)"Acquiring read lock", (DataStore)CDTMiner.this._dataStore);
                        index.acquireReadLock();
                        try {
                            IIndexIncludeValue[] includesToReturn;
                            IIndexFile[] files = index.getFiles(location);
                            if (files.length == 0) {
                                UniversalServerUtilities.logDebugMessage((String)CDTMiner.LOG_TAG, (String)"No index files found", (DataStore)CDTMiner.this._dataStore);
                                includesToReturn = new IIndexIncludeValue[]{};
                            } else if (files.length == 1) {
                                IIndexInclude[] includes = index.findIncludedBy(files[0]);
                                if (includes == null) {
                                    includesToReturn = new IIndexIncludeValue[]{};
                                } else {
                                    includesToReturn = new IIndexIncludeValue[includes.length];
                                    int i = 0;
                                    while (i < includes.length) {
                                        includesToReturn[i] = new IndexIncludeValue(includes[i], CDTMiner.this.getLocationConverter(scheme, hostName));
                                        UniversalServerUtilities.logDebugMessage((String)CDTMiner.LOG_TAG, (String)("IndexIncludeValue to return: " + includesToReturn[i]), (DataStore)CDTMiner.this._dataStore);
                                        ++i;
                                    }
                                }
                            } else {
                                ArrayList<IndexIncludeValue> list = new ArrayList<IndexIncludeValue>();
                                HashSet<IIndexFileLocation> handled = new HashSet<IIndexFileLocation>();
                                int i = 0;
                                while (i < files.length) {
                                    if (CDTMiner.isCancelled(status)) break;
                                    IIndexInclude[] includes = index.findIncludedBy(files[i]);
                                    int j = 0;
                                    while (j < includes.length) {
                                        if (CDTMiner.isCancelled(status)) break;
                                        IIndexInclude indexInclude = includes[j];
                                        if (handled.add(indexInclude.getIncludedByLocation())) {
                                            IndexIncludeValue value = new IndexIncludeValue(indexInclude, CDTMiner.this.getLocationConverter(scheme, hostName));
                                            list.add(value);
                                            UniversalServerUtilities.logDebugMessage((String)CDTMiner.LOG_TAG, (String)("IndexIncludeValue to return: " + value), (DataStore)CDTMiner.this._dataStore);
                                        }
                                        ++j;
                                    }
                                    ++i;
                                }
                                includesToReturn = list.toArray(new IIndexIncludeValue[list.size()]);
                            }
                            String resultString = Serializer.serialize(includesToReturn);
                            status.getDataStore().createObject(status, CDTMiner.T_INCLUDES_FIND_INCLUDED_BY_RESULT, resultString);
                        }
                        finally {
                            if (index != null) {
                                index.releaseReadLock();
                            }
                            UniversalServerUtilities.logDebugMessage((String)CDTMiner.LOG_TAG, (String)"Released read lock", (DataStore)CDTMiner.this._dataStore);
                        }
                    }
                    catch (Exception e) {
                        UniversalServerUtilities.logError((String)CDTMiner.LOG_TAG, (String)e.toString(), (Throwable)e, (DataStore)CDTMiner.this._dataStore);
                        CDTMiner.statusDone(status);
                    }
                }
                finally {
                    CDTMiner.statusDone(status);
                }
            }
        };
        findIncludeThread.start();
    }

    protected void handleIsIndexed(String scopeName, String hostName, IIndexFileLocation location, DataElement status) {
        try {
            try {
                IIndex index = RemoteIndexManager.getInstance().getIndexForScope(scopeName, this._dataStore);
                UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)"Acquiring read lock", (DataStore)this._dataStore);
                index.acquireReadLock();
                try {
                    IIndexFile[] files = index.getFiles(location);
                    UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)("Found " + files.length + " index files"), (DataStore)this._dataStore);
                    String resultString = Serializer.serialize(new Boolean(files.length > 0));
                    status.getDataStore().createObject(status, T_INCLUDES_IS_INDEXED_RESULT, resultString);
                }
                finally {
                    if (index != null) {
                        index.releaseReadLock();
                    }
                    UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)"Released read lock", (DataStore)this._dataStore);
                }
            }
            catch (Exception e) {
                UniversalServerUtilities.logError((String)LOG_TAG, (String)e.toString(), (Throwable)e, (DataStore)this._dataStore);
                CDTMiner.statusDone(status);
            }
        }
        finally {
            CDTMiner.statusDone(status);
        }
    }

    protected void handleFindTypeHierarchyInput(String scopeName, String hostName, ITranslationUnit unit, String path, String projectName, int selectionStart, int selectionLength, DataElement status) {
        try {
            try {
                String scheme = unit.getLocationURI().getScheme();
                UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)("File: " + unit.getLocationURI()), (DataStore)this._dataStore);
                UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)("Element: " + unit.getElementName()), (DataStore)this._dataStore);
                IASTName name = null;
                IIndex project_index = RemoteIndexManager.getInstance().getIndexForScope(scopeName, this._dataStore);
                UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)"Acquiring read lock for project_index", (DataStore)this._dataStore);
                project_index.acquireReadLock();
                try {
                    name = IndexQueries.getSelectedName(project_index, unit, selectionStart, selectionLength);
                }
                finally {
                    UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)"Releasing read lock for project_index", (DataStore)this._dataStore);
                    project_index.releaseReadLock();
                }
                IIndex index = RemoteIndexManager.getInstance().getIndexForScope("__WORKSPACE_ROOT_SCOPE__", this._dataStore);
                UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)"Acquiring read lock for workspace_scope_index", (DataStore)this._dataStore);
                index.acquireReadLock();
                try {
                    IBinding binding;
                    RemoteIndexLocationConverterFactory converter = new RemoteIndexLocationConverterFactory(scheme, hostName, this._dataStore);
                    ICElement[] result = null;
                    CProject project = new CProject(projectName);
                    if (name != null && TypeHierarchyUtil.isValidInput(binding = name.resolveBinding())) {
                        ICElement input;
                        ICElement member = null;
                        if (!TypeHierarchyUtil.isValidTypeInput(binding)) {
                            member = TypeHierarchyUtil.findDeclaration(project, index, name, binding, converter, new RemoteCProjectFactory());
                            name = null;
                            binding = TypeHierarchyUtil.findTypeBinding(binding);
                        }
                        if (TypeHierarchyUtil.isValidTypeInput(binding) && (input = TypeHierarchyUtil.findDefinition(project, index, name, binding, converter, new RemoteCProjectFactory())) != null) {
                            result = new ICElement[]{input, member};
                        }
                    }
                    if (result != null) {
                        UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)"Found input.", (DataStore)this._dataStore);
                        UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)("Details: " + result.toString()), (DataStore)this._dataStore);
                    }
                    String resultString = Serializer.serialize(result);
                    status.getDataStore().createObject(status, T_SEARCH_RESULT, resultString);
                }
                finally {
                    UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)"Releasing read lock for workspace_scope_index", (DataStore)this._dataStore);
                    index.releaseReadLock();
                }
            }
            catch (Exception e) {
                UniversalServerUtilities.logError((String)LOG_TAG, (String)e.toString(), (Throwable)e, (DataStore)this._dataStore);
                CDTMiner.statusDone(status);
            }
        }
        finally {
            CDTMiner.statusDone(status);
        }
    }

    protected void handleFindTypeHierarchyInput(String scopeName, String hostName, String projectName, ICElement input, String path, DataElement status) {
        try {
            try {
                String scheme = input.getLocationURI().getScheme();
                UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)("File: " + input.getLocationURI()), (DataStore)this._dataStore);
                UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)("Element: " + input.getElementName()), (DataStore)this._dataStore);
                RemoteIndexLocationConverterFactory converter = new RemoteIndexLocationConverterFactory(scheme, hostName, this._dataStore);
                IIndex project_index = RemoteIndexManager.getInstance().getIndexForScope(scopeName, this._dataStore);
                IIndexBinding binding = null;
                CProject project = new CProject(projectName);
                ICElement[] result = null;
                ICElement member = input;
                UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)"Acquiring read lock for project_index", (DataStore)this._dataStore);
                project_index.acquireReadLock();
                try {
                    IIndexName name = IndexQueries.remoteElementToName(project_index, member, path);
                    if (name != null) {
                        member = IndexQueries.getCElementForName((ICProject)project, project_index, name, (IIndexLocationConverterFactory)converter, (ICProjectFactory)new RemoteCProjectFactory());
                        binding = project_index.findBinding((IName)name);
                        binding = TypeHierarchyUtil.findTypeBinding((IBinding)binding);
                    }
                }
                finally {
                    UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)"Releasing read lock for project_index", (DataStore)this._dataStore);
                    project_index.releaseReadLock();
                }
                if (binding != null && TypeHierarchyUtil.isValidTypeInput(binding)) {
                    IIndex workspace_scope_index = RemoteIndexManager.getInstance().getIndexForScope("__WORKSPACE_ROOT_SCOPE__", this._dataStore);
                    UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)"Acquiring read lock for workspace_scope_index", (DataStore)this._dataStore);
                    workspace_scope_index.acquireReadLock();
                    try {
                        ICElement definition = TypeHierarchyUtil.findDefinition(project, workspace_scope_index, null, (IBinding)binding, converter, new RemoteCProjectFactory());
                        if (input != null) {
                            result = new ICElement[]{definition, member};
                        }
                    }
                    finally {
                        UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)"Releasing read lock for workspace_scope_index", (DataStore)this._dataStore);
                        workspace_scope_index.releaseReadLock();
                    }
                }
                if (result != null) {
                    UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)"Found input.", (DataStore)this._dataStore);
                }
                String resultString = Serializer.serialize(result);
                status.getDataStore().createObject(status, T_SEARCH_RESULT, resultString);
            }
            catch (Exception e) {
                UniversalServerUtilities.logError((String)LOG_TAG, (String)e.toString(), (Throwable)e, (DataStore)this._dataStore);
                CDTMiner.statusDone(status);
            }
        }
        finally {
            CDTMiner.statusDone(status);
        }
    }

    protected void handleComputeTypeGraph(final String scopeName, final String hostName, final ICElement input, final String path, final DataElement status) {
        Thread typeGraphThread = new Thread(){

            public void run() {
                try {
                    try {
                        String scheme = input.getLocationURI().getScheme();
                        UniversalServerUtilities.logDebugMessage((String)CDTMiner.LOG_TAG, (String)("File: " + input.getLocationURI()), (DataStore)CDTMiner.this._dataStore);
                        UniversalServerUtilities.logDebugMessage((String)CDTMiner.LOG_TAG, (String)("Element: " + input.getElementName()), (DataStore)CDTMiner.this._dataStore);
                        IIndex index = RemoteIndexManager.getInstance().getIndexForScope(scopeName, CDTMiner.this._dataStore);
                        UniversalServerUtilities.logDebugMessage((String)CDTMiner.LOG_TAG, (String)"Acquiring read lock", (DataStore)CDTMiner.this._dataStore);
                        index.acquireReadLock();
                        NullProgressMonitor monitor = new NullProgressMonitor();
                        CancellationThread cancellationThread = new CancellationThread(status, (IProgressMonitor)monitor);
                        try {
                            cancellationThread.start();
                            THGraph graph = new THGraph();
                            graph.setLocationConverterFactory(new RemoteIndexLocationConverterFactory(scheme, hostName, CDTMiner.this._dataStore));
                            RemoteCProjectFactory projectFactory = new RemoteCProjectFactory(input.getCProject());
                            graph.defineInputNode(index, input, projectFactory, path);
                            graph.addSuperClasses(index, (IProgressMonitor)monitor, projectFactory);
                            graph.addSubClasses(index, (IProgressMonitor)monitor, projectFactory);
                            UniversalServerUtilities.logDebugMessage((String)CDTMiner.LOG_TAG, (String)("Found " + graph.getLeaveNodes().size() + " leaf node(s)."), (DataStore)CDTMiner.this._dataStore);
                            String resultString = Serializer.serialize(graph);
                            status.getDataStore().createObject(status, CDTMiner.T_SEARCH_RESULT, resultString);
                        }
                        finally {
                            cancellationThread.setDone(true);
                            index.releaseReadLock();
                        }
                    }
                    catch (Exception e) {
                        UniversalServerUtilities.logError((String)CDTMiner.LOG_TAG, (String)e.toString(), (Throwable)e, (DataStore)CDTMiner.this._dataStore);
                        CDTMiner.statusDone(status);
                    }
                }
                finally {
                    CDTMiner.statusDone(status);
                }
            }
        };
        typeGraphThread.start();
    }

    protected void handleComputeCompletionProposals(String scopeName, RemoteContentAssistInvocationContext context, ITranslationUnit unit, String path, DataElement status) {
        try {
            try {
                UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)("File: " + unit.getLocationURI()), (DataStore)this._dataStore);
                UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)("Offset: " + context.getInvocationOffset()), (DataStore)this._dataStore);
                IIndex index = RemoteIndexManager.getInstance().getIndexForScope(scopeName, this._dataStore);
                UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)"Acquiring read lock", (DataStore)this._dataStore);
                index.acquireReadLock();
                try {
                    List<Object> proposals;
                    int style = 34;
                    int offset = context.getInvocationOffset();
                    ContentAssistMatcherFactory.getInstance().setShowCamelCaseMatches(context.getShowCamelCaseMatches());
                    IASTCompletionNode completionNode = unit.getCompletionNode(index, style, offset);
                    context.setCompletionNode(completionNode);
                    if (completionNode == null) {
                        proposals = Collections.emptyList();
                    } else {
                        String prefix = completionNode.getPrefix();
                        if (prefix == null || prefix.equals("")) {
                            prefix = context.computeIdentifierPrefix().toString();
                        }
                        CompletionProposalComputer computer = new CompletionProposalComputer();
                        proposals = computer.computeCompletionProposals(context, completionNode, prefix);
                    }
                    UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)("Found " + proposals.size() + " proposal(s)."), (DataStore)this._dataStore);
                    String resultString = Serializer.serialize(proposals);
                    status.getDataStore().createObject(status, T_SEARCH_RESULT, resultString);
                }
                finally {
                    index.releaseReadLock();
                }
            }
            catch (Exception e) {
                UniversalServerUtilities.logError((String)LOG_TAG, (String)e.toString(), (Throwable)e, (DataStore)this._dataStore);
                CDTMiner.statusDone(status);
            }
        }
        finally {
            CDTMiner.statusDone(status);
        }
    }

    protected void handleRunQuery(final String scopeName, final RemoteSearchQuery query, final String scheme, final String hostName, final DataElement status) {
        Thread searchThread = new Thread(){

            public void run() {
                NullProgressMonitor monitor = new NullProgressMonitor();
                CancellationThread cancellationThread = new CancellationThread(status, (IProgressMonitor)monitor);
                cancellationThread.start();
                try {
                    try {
                        ICProject[] projects = query.getProjects();
                        UniversalServerUtilities.logDebugMessage((String)CDTMiner.LOG_TAG, (String)("Searching for: \"" + query + "\""), (DataStore)CDTMiner.this._dataStore);
                        if (projects == null) {
                            UniversalServerUtilities.logDebugMessage((String)CDTMiner.LOG_TAG, (String)("scope: " + scopeName), (DataStore)CDTMiner.this._dataStore);
                        } else {
                            UniversalServerUtilities.logDebugMessage((String)CDTMiner.LOG_TAG, (String)("scope: " + query.getScopeDescription()), (DataStore)CDTMiner.this._dataStore);
                        }
                        UniversalServerUtilities.logDebugMessage((String)CDTMiner.LOG_TAG, (String)"Getting index", (DataStore)CDTMiner.this._dataStore);
                        IWritableIndex[] indexList = projects == null ? RemoteIndexManager.getInstance().getIndexListForScope(scopeName, CDTMiner.this._dataStore) : RemoteIndexManager.getInstance().getIndexListForProjects(projects, CDTMiner.this._dataStore);
                        UniversalServerUtilities.logDebugMessage((String)CDTMiner.LOG_TAG, (String)"Acquiring read lock", (DataStore)CDTMiner.this._dataStore);
                        IStatus exceptionStatus = query.runWithIndex(indexList, CDTMiner.this.getLocationConverter(scheme, hostName), (IProgressMonitor)monitor);
                        if (exceptionStatus != Status.OK_STATUS) {
                            UniversalServerUtilities.logError((String)CDTMiner.LOG_TAG, (String)exceptionStatus.getMessage(), null, (DataStore)CDTMiner.this._dataStore);
                        }
                        cancellationThread.setDone(true);
                        List<RemoteSearchMatch> matches = query.getMatches();
                        UniversalServerUtilities.logDebugMessage((String)CDTMiner.LOG_TAG, (String)("Found " + matches.size() + " match(es)"), (DataStore)CDTMiner.this._dataStore);
                        String resultString = Serializer.serialize(matches);
                        status.getDataStore().createObject(status, CDTMiner.T_SEARCH_RESULT, resultString);
                    }
                    catch (Exception e) {
                        UniversalServerUtilities.logError((String)CDTMiner.LOG_TAG, (String)e.toString(), (Throwable)e, (DataStore)CDTMiner.this._dataStore);
                        cancellationThread.setDone(true);
                        CDTMiner.statusDone(status);
                    }
                }
                finally {
                    cancellationThread.setDone(true);
                    CDTMiner.statusDone(status);
                }
            }
        };
        searchThread.start();
    }

    protected void handleRunQuery2(final String scopeName, final RemoteSearchQuery query, final String scheme, final String hostName, final DataElement status) {
        Thread searchThread = new Thread(){

            public void run() {
                NullProgressMonitor monitor = new NullProgressMonitor();
                CancellationThread cancellationThread = new CancellationThread(status, (IProgressMonitor)monitor);
                cancellationThread.start();
                try {
                    try {
                        ICProject[] projects = query.getProjects();
                        UniversalServerUtilities.logDebugMessage((String)CDTMiner.LOG_TAG, (String)("Searching for: \"" + query + "\""), (DataStore)CDTMiner.this._dataStore);
                        if (projects == null) {
                            UniversalServerUtilities.logDebugMessage((String)CDTMiner.LOG_TAG, (String)("scope: " + scopeName), (DataStore)CDTMiner.this._dataStore);
                        } else {
                            UniversalServerUtilities.logDebugMessage((String)CDTMiner.LOG_TAG, (String)("scope: " + query.getScopeDescription()), (DataStore)CDTMiner.this._dataStore);
                        }
                        UniversalServerUtilities.logDebugMessage((String)CDTMiner.LOG_TAG, (String)"Getting index", (DataStore)CDTMiner.this._dataStore);
                        IWritableIndex[] indexList = projects == null ? RemoteIndexManager.getInstance().getIndexListForScope(scopeName, CDTMiner.this._dataStore) : RemoteIndexManager.getInstance().getIndexListForProjects(projects, CDTMiner.this._dataStore);
                        UniversalServerUtilities.logDebugMessage((String)CDTMiner.LOG_TAG, (String)"Acquiring read lock", (DataStore)CDTMiner.this._dataStore);
                        IStatus exceptionStatus = query.runWithIndex(indexList, CDTMiner.this.getLocationConverter(scheme, hostName), (IProgressMonitor)monitor);
                        if (exceptionStatus != Status.OK_STATUS) {
                            UniversalServerUtilities.logError((String)CDTMiner.LOG_TAG, (String)exceptionStatus.getMessage(), null, (DataStore)CDTMiner.this._dataStore);
                        }
                        query.setfConverter(null);
                        String resultString = Serializer.serialize(query);
                        status.getDataStore().createObject(status, CDTMiner.T_SEARCH_RESULT, resultString);
                    }
                    catch (Exception e) {
                        UniversalServerUtilities.logError((String)CDTMiner.LOG_TAG, (String)e.toString(), (Throwable)e, (DataStore)CDTMiner.this._dataStore);
                        cancellationThread.setDone(true);
                        CDTMiner.statusDone(status);
                    }
                }
                finally {
                    cancellationThread.setDone(true);
                    CDTMiner.statusDone(status);
                }
            }
        };
        searchThread.start();
    }

    private IIndexLocationConverter getLocationConverter(String scheme, String hostName) {
        return new SimpleLocationConverter(scheme, hostName, this._dataStore);
    }

    private boolean getBoolean(DataElement theCommand, int i) {
        DataElement element = this.getCommandArgument(theCommand, i);
        return Boolean.parseBoolean(element.getName());
    }

    protected String getString(DataElement command, int index) {
        DataElement element = this.getCommandArgument(command, index);
        return element.getName();
    }

    private int getInteger(DataElement command, int index) {
        DataElement element = this.getCommandArgument(command, index);
        return Integer.parseInt(element.getName());
    }

    public void extendSchema(DataElement schemaRoot) {
        ServerLogger.DEBUG = true;
        UniversalServerUtilities.logInfo((String)LOG_TAG, (String)"Extended schema from CDTMiner", (DataStore)this._dataStore);
        DataElement cancellable = this._dataStore.findObjectDescriptor("Cancellable");
        this.createCommandDescriptor(schemaRoot, "Register Scope", C_SCOPE_REGISTER, false);
        this.createCommandDescriptor(schemaRoot, "Unregister Scope", C_SCOPE_UNREGISTER, false);
        DataElement rcmd = this.createCommandDescriptor(schemaRoot, "Reindex", C_INDEX_REINDEX, false);
        this._dataStore.createReference(cancellable, rcmd, "abstracts", "abstracted by");
        DataElement dcmd = this.createCommandDescriptor(schemaRoot, "Index Delta", C_INDEX_DELTA, false);
        this._dataStore.createReference(cancellable, dcmd, "abstracts", "abstracted by");
        this.createCommandDescriptor(schemaRoot, "Remove Index File", C_REMOVE_INDEX_FILE, false);
        this.createCommandDescriptor(schemaRoot, "Move Index File", C_MOVE_INDEX_FILE, false);
        this.createCommandDescriptor(schemaRoot, "Get Callers", C_CALL_HIERARCHY_GET_CALLERS, false);
        this.createCommandDescriptor(schemaRoot, "Get Calls", C_CALL_HIERARCHY_GET_CALLS, false);
        this.createCommandDescriptor(schemaRoot, "Get definitions from element", C_CALL_HIERARCHY_GET_DEFINITIONS_FROM_ELEMENT, false);
        this.createCommandDescriptor(schemaRoot, "Get definitions from working copy", C_CALL_HIERARCHY_GET_DEFINITIONS_FROM_WORKING_COPY, false);
        this.createCommandDescriptor(schemaRoot, "Get overriders from element", C_CALL_HIERARCHY_GET_OVERRIDERS, false);
        this.createCommandDescriptor(schemaRoot, "Run query", C_SEARCH_RUN_QUERY, false);
        this.createCommandDescriptor(schemaRoot, "Run query2", C_SEARCH_RUN_QUERY2, false);
        this.createCommandDescriptor(schemaRoot, "Compute completion proposals", C_CONTENT_ASSIST_COMPUTE_PROPOSALS, false);
        this.createCommandDescriptor(schemaRoot, "Compute type graph", C_TYPE_HIERARCHY_COMPUTE_TYPE_GRAPH, false);
        this.createCommandDescriptor(schemaRoot, "Find input from element", C_TYPE_HIERARCHY_FIND_INPUT1, false);
        this.createCommandDescriptor(schemaRoot, "Find input from text selection", C_TYPE_HIERARCHY_FIND_INPUT2, false);
        this.createCommandDescriptor(schemaRoot, "Compute added & removed positions for semantic highlighting", C_SEMANTIC_HIGHTLIGHTING_COMPUTE_POSITIONS, false);
        this.createCommandDescriptor(schemaRoot, "Compute code folding regions for the Remote C Editor", C_CODE_FOLDING_COMPUTE_REGIONS, false);
        this.createCommandDescriptor(schemaRoot, "Open declaration", C_NAVIGATION_OPEN_DECLARATION, false);
        this.createCommandDescriptor(schemaRoot, "Find includes to", C_INCLUDES_FIND_INCLUDES_TO, false);
        this.createCommandDescriptor(schemaRoot, "Find included by", C_INCLUDES_FIND_INCLUDED_BY, false);
        this.createCommandDescriptor(schemaRoot, "Is indexed", C_INCLUDES_IS_INDEXED, false);
        this.createCommandDescriptor(schemaRoot, "Find include", C_INCLUDES_FIND_INCLUDE, false);
        this.createCommandDescriptor(schemaRoot, "Get model", C_MODEL_BUILDER, false);
        this.createCommandDescriptor(schemaRoot, "Compute code formatting", C_CODE_FORMATTING, false);
        this._dataStore.refresh(schemaRoot);
    }

    protected void handleGetDefinitions(String scopeName, String hostName, ICElement subject, String path, DataElement status) {
        try {
            try {
                String scheme = subject.getLocationURI().getScheme();
                UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)("Getting definitions for subject " + subject.getElementName()), (DataStore)this._dataStore);
                UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)("scope: " + scopeName), (DataStore)this._dataStore);
                UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)("path: " + subject.getLocationURI()), (DataStore)this._dataStore);
                UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)"Getting index", (DataStore)this._dataStore);
                IIndex index = RemoteIndexManager.getInstance().getIndexForScope(scopeName, this._dataStore);
                UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)"Acquiring read lock", (DataStore)this._dataStore);
                index.acquireReadLock();
                try {
                    ICElement[] definitions = null;
                    if (subject instanceof ISourceReference) {
                        IIndexName name;
                        RemoteIndexLocationConverterFactory converter;
                        ICElement[] result;
                        IIndexBinding binding;
                        ISourceReference input = (ISourceReference)subject;
                        ITranslationUnit tu = input.getTranslationUnit();
                        if (CDTMiner.needToFindDefinition(subject) && (binding = IndexQueries.elementToBinding(index, subject, path)) != null && (result = IndexQueries.findAllDefinitions(index, (IBinding)binding, converter = new RemoteIndexLocationConverterFactory(scheme, hostName, this._dataStore), subject.getCProject(), new RemoteCProjectFactory())).length > 0) {
                            definitions = result;
                        }
                        if (definitions == null && (name = IndexQueries.remoteElementToName(index, subject, path)) != null) {
                            ICElement handle = IndexQueries.getCElementForName(tu, index, name, new RemoteCProjectFactory());
                            definitions = new ICElement[]{handle};
                        }
                    }
                    String resultString = Serializer.serialize(definitions);
                    status.getDataStore().createObject(status, T_CALL_HIERARCHY_RESULT, resultString);
                }
                finally {
                    index.releaseReadLock();
                }
            }
            catch (Exception e) {
                UniversalServerUtilities.logError((String)LOG_TAG, (String)e.toString(), (Throwable)e, (DataStore)this._dataStore);
                CDTMiner.statusDone(status);
            }
        }
        finally {
            CDTMiner.statusDone(status);
        }
    }

    private void handleGetDefinitions(String scopeName, String hostName, ITranslationUnit workingCopy, String path, int selectionStart, int selectionLength, DataElement status) {
        try {
            try {
                String scheme = workingCopy.getLocationURI().getScheme();
                UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)("Getting definitions for subject " + workingCopy.getElementName()), (DataStore)this._dataStore);
                UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)("scope: " + scopeName), (DataStore)this._dataStore);
                UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)("path: " + workingCopy.getLocationURI()), (DataStore)this._dataStore);
                UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)("offset: " + selectionStart), (DataStore)this._dataStore);
                UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)("length: " + selectionLength), (DataStore)this._dataStore);
                UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)"Getting index", (DataStore)this._dataStore);
                IIndex index = RemoteIndexManager.getInstance().getIndexForScope(scopeName, this._dataStore);
                UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)"Acquiring read lock", (DataStore)this._dataStore);
                index.acquireReadLock();
                try {
                    ICElement[] definitions = null;
                    workingCopy.getCProject();
                    RemoteIndexLocationConverterFactory converter = new RemoteIndexLocationConverterFactory(scheme, hostName, this._dataStore);
                    definitions = CDTMiner.findDefinitions(index, workingCopy, selectionStart, selectionLength, converter);
                    String resultString = Serializer.serialize(definitions);
                    status.getDataStore().createObject(status, T_CALL_HIERARCHY_RESULT, resultString);
                }
                finally {
                    index.releaseReadLock();
                }
            }
            catch (Exception e) {
                UniversalServerUtilities.logError((String)LOG_TAG, (String)e.toString(), (Throwable)e, (DataStore)this._dataStore);
                CDTMiner.statusDone(status);
            }
        }
        finally {
            CDTMiner.statusDone(status);
        }
    }

    private static ICElement[] findDefinitions(IIndex index, ITranslationUnit workingCopy, int selectionStart, int selectionLength, IIndexLocationConverterFactory converter) throws CoreException {
        IBinding binding;
        ICElement[] no_elements = new ICElement[]{};
        ICProject project = workingCopy.getCProject();
        IASTName name = IndexQueries.getSelectedName(index, workingCopy, selectionStart, selectionLength);
        if (name != null && RemoteCHQueries.isRelevantForCallHierarchy(binding = name.resolveBinding())) {
            if (name.isDefinition()) {
                ICElement elem = IndexQueries.getCElementForName(project, index, name, converter, (ICProjectFactory)new RemoteCProjectFactory());
                if (elem != null) {
                    return new ICElement[]{elem};
                }
                return no_elements;
            }
            ICElement[] elems = IndexQueries.findAllDefinitions(index, binding, converter, project, new RemoteCProjectFactory());
            if (elems.length != 0) {
                return elems;
            }
            if (name.isDeclaration()) {
                ICElement elem = IndexQueries.getCElementForName(project, index, name, converter, (ICProjectFactory)new RemoteCProjectFactory());
                if (elem != null) {
                    return new ICElement[]{elem};
                }
                return no_elements;
            }
            ICElement elem = IndexQueries.findAnyDeclaration(index, project, binding, converter, new RemoteCProjectFactory());
            if (elem != null) {
                return new ICElement[]{elem};
            }
            if (binding instanceof ICPPSpecialization) {
                return CDTMiner.findSpecializationDeclaration(binding, project, index, converter);
            }
            return no_elements;
        }
        return no_elements;
    }

    private static ICElement[] findSpecializationDeclaration(IBinding binding, ICProject project, IIndex index, IIndexLocationConverterFactory converter) throws CoreException {
        while (binding instanceof ICPPSpecialization) {
            ICElement elem;
            IBinding original = ((ICPPSpecialization)binding).getSpecializedBinding();
            ICElement[] elems = IndexQueries.findAllDefinitions(index, original, converter, project, new RemoteCProjectFactory());
            if (elems.length == 0 && (elem = IndexQueries.findAnyDeclaration(index, project, original, converter, new RemoteCProjectFactory())) != null) {
                elems = new ICElement[]{elem};
            }
            if (elems.length > 0) {
                return elems;
            }
            binding = original;
        }
        return new ICElement[0];
    }

    protected void handleGetOverriders(String scopeName, String hostName, ICElement subject, String path, DataElement status) {
        UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)("Getting overriders for subject " + subject.getElementName()), (DataStore)this._dataStore);
        UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)("scope: " + scopeName), (DataStore)this._dataStore);
        UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)("path: " + subject.getLocationURI()), (DataStore)this._dataStore);
        try {
            try {
                UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)"Getting index", (DataStore)this._dataStore);
                String scheme = subject.getLocationURI().getScheme();
                IIndex index = RemoteIndexManager.getInstance().getIndexForScope(scopeName, this._dataStore);
                RemoteIndexLocationConverterFactory converter = new RemoteIndexLocationConverterFactory(scheme, hostName, this._dataStore);
                Map<String, ICElement[]> result = RemoteCHQueries.handleGetOverriders(index, subject, path, this._dataStore, converter);
                String resultString = Serializer.serialize(result);
                status.getDataStore().createObject(status, T_CALL_HIERARCHY_RESULT, resultString);
            }
            catch (Exception e) {
                UniversalServerUtilities.logError((String)LOG_TAG, (String)e.toString(), (Throwable)e, (DataStore)this._dataStore);
                CDTMiner.statusDone(status);
            }
        }
        finally {
            CDTMiner.statusDone(status);
        }
    }

    private static boolean needToFindDefinition(ICElement elem) {
        switch (elem.getElementType()) {
            case 71: 
            case 73: 
            case 88: 
            case 90: {
                return true;
            }
        }
        return false;
    }

    private IIndexFileLocation createLocation(String scheme, String hostName, IIndexFileLocation location) throws URISyntaxException {
        URI uri = location.getURI();
        String path = uri.getPath();
        URI newURI = null;
        if (scheme == null || scheme.equals("")) {
            scheme = ScopeManager.getInstance().getSchemeForFile(path);
        }
        newURI = URICreatorManager.getDefault(this._dataStore).createURI(scheme, hostName, path);
        return new RemoteIndexFileLocation(null, newURI);
    }

    protected void handleUnregisterScope(DataElement scopeName, DataElement status) {
        String scope = scopeName.getName();
        ScopeManager.getInstance().removeScope(scope);
        CDTMiner.statusDone(status);
    }

    protected void handleGetCallers(final String scopeName, final ICElement subject, final String path, final String scheme, final String hostName, final DataElement status) {
        Thread getCallersThread = new Thread(){

            public void run() {
                String subjectName = subject.getElementName();
                UniversalServerUtilities.logDebugMessage((String)CDTMiner.LOG_TAG, (String)("Getting callers for subject " + subjectName), (DataStore)CDTMiner.this._dataStore);
                UniversalServerUtilities.logDebugMessage((String)CDTMiner.LOG_TAG, (String)("scope: " + scopeName), (DataStore)CDTMiner.this._dataStore);
                UniversalServerUtilities.logDebugMessage((String)CDTMiner.LOG_TAG, (String)("path: " + subject.getLocationURI()), (DataStore)CDTMiner.this._dataStore);
                try {
                    try {
                        CalledByResult result = new CalledByResult();
                        UniversalServerUtilities.logDebugMessage((String)CDTMiner.LOG_TAG, (String)"Getting index", (DataStore)CDTMiner.this._dataStore);
                        IIndex project_index = RemoteIndexManager.getInstance().getIndexForScope(scopeName, CDTMiner.this._dataStore);
                        IIndex workspace_scope_index = RemoteIndexManager.getInstance().getIndexForScope("__WORKSPACE_ROOT_SCOPE__", CDTMiner.this._dataStore);
                        if (subject != null) {
                            RemoteIndexLocationConverterFactory converter = new RemoteIndexLocationConverterFactory(scheme, hostName, CDTMiner.this._dataStore);
                            RemoteCHQueries.findCalledBy(subject, path, project_index, workspace_scope_index, scheme, hostName, result, CDTMiner.this._dataStore, converter, status);
                        }
                        String resultString = Serializer.serialize(result);
                        status.getDataStore().createObject(status, CDTMiner.T_CALL_HIERARCHY_RESULT, resultString);
                    }
                    catch (Exception e) {
                        UniversalServerUtilities.logError((String)CDTMiner.LOG_TAG, (String)e.toString(), (Throwable)e, (DataStore)CDTMiner.this._dataStore);
                        CDTMiner.statusDone(status);
                    }
                }
                finally {
                    CDTMiner.statusDone(status);
                }
            }
        };
        getCallersThread.start();
    }

    protected void handleGetCallees(final String scopeName, final ICElement subject, final String path, final String hostName, final DataElement status) {
        Thread getCalleesThread = new Thread(){

            public void run() {
                String subjectName = subject.getElementName();
                String scheme = subject.getLocationURI().getScheme();
                UniversalServerUtilities.logDebugMessage((String)CDTMiner.LOG_TAG, (String)("Getting callees for subject " + subjectName), (DataStore)CDTMiner.this._dataStore);
                UniversalServerUtilities.logDebugMessage((String)CDTMiner.LOG_TAG, (String)("scope: " + scopeName), (DataStore)CDTMiner.this._dataStore);
                UniversalServerUtilities.logDebugMessage((String)CDTMiner.LOG_TAG, (String)("path: " + subject.getLocationURI()), (DataStore)CDTMiner.this._dataStore);
                try {
                    try {
                        UniversalServerUtilities.logDebugMessage((String)CDTMiner.LOG_TAG, (String)"Getting index", (DataStore)CDTMiner.this._dataStore);
                        IIndex project_index = RemoteIndexManager.getInstance().getIndexForScope(scopeName, CDTMiner.this._dataStore);
                        IIndex workspace_scope_index = RemoteIndexManager.getInstance().getIndexForScope("__WORKSPACE_ROOT_SCOPE__", CDTMiner.this._dataStore);
                        RemoteIndexLocationConverterFactory converter = new RemoteIndexLocationConverterFactory(scheme, hostName, CDTMiner.this._dataStore);
                        CallsToResult result = RemoteCHQueries.findCalls(subject, path, project_index, workspace_scope_index, scheme, hostName, CDTMiner.this._dataStore, converter, status);
                        String resultString = Serializer.serialize(result);
                        status.getDataStore().createObject(status, CDTMiner.T_CALL_HIERARCHY_RESULT, resultString);
                    }
                    catch (Exception e) {
                        UniversalServerUtilities.logError((String)CDTMiner.LOG_TAG, (String)e.toString(), (Throwable)e, (DataStore)CDTMiner.this._dataStore);
                        CDTMiner.statusDone(status);
                    }
                }
                finally {
                    CDTMiner.statusDone(status);
                }
            }
        };
        getCalleesThread.start();
    }

    protected void handleIndexDelta(String scopeName, List<String> addedFiles, List<String> changedFiles, List<String> removedFiles, IRemoteIndexerInfoProvider provider, String scheme, String host, String rootPath, String mappedPath, DataElement status) {
        StandaloneFastIndexer indexer = RemoteIndexManager.getInstance().getIndexerForScope(scopeName, provider, this._dataStore, status);
        if (indexer != null) {
            ScopeManager scopeManager = ScopeManager.getInstance();
            for (String file : addedFiles) {
                scopeManager.addFileToScope(scopeName, scheme, host, file, rootPath, mappedPath);
            }
            for (String file : changedFiles) {
                scopeManager.addFileToScope(scopeName, scheme, host, file, rootPath, mappedPath);
            }
            for (String file : removedFiles) {
                scopeManager.removeFileFromScope(scopeName, file);
            }
            if (this.indexerThread != null) {
                try {
                    this.indexerThread.join();
                }
                catch (InterruptedException e) {
                    UniversalServerUtilities.logError((String)LOG_TAG, (String)"Indexer thread got interrupted", (Throwable)e, (DataStore)this._dataStore);
                }
                catch (NullPointerException nullPointerException) {}
            }
            this.indexerThread = IndexerThread.createIndexDeltaThread(indexer, addedFiles, changedFiles, removedFiles, status, this);
            this.indexerThread.start();
        }
    }

    protected void handleReindex(String scopeName, String newIndexLocation, IRemoteIndexerInfoProvider provider, DataElement status) {
        RemoteIndexManager indexManager = RemoteIndexManager.getInstance();
        indexManager.setIndexFileLocation(scopeName, newIndexLocation);
        StandaloneFastIndexer indexer = indexManager.getIndexerForScope(scopeName, provider, this._dataStore, status);
        if (indexer != null) {
            Set<String> sources = ScopeManager.getInstance().getFilesForScope(scopeName);
            LinkedList<String> sourcesList = new LinkedList<String>(sources);
            if (this.indexerThread != null) {
                try {
                    this.indexerThread.join();
                }
                catch (InterruptedException e) {
                    UniversalServerUtilities.logError((String)LOG_TAG, (String)"Indexer thread got interrupted", (Throwable)e, (DataStore)this._dataStore);
                }
            }
            this.indexerThread = IndexerThread.createReindexThread(indexer, sourcesList, status, this);
            this.indexerThread.start();
        }
    }

    protected void handleIndexCancel(DataElement status) {
        if (this.indexerThread != null) {
            this.indexerThread.cancel();
        }
        CDTMiner.statusDone(status);
    }

    protected void handleRegisterScope(DataElement scopeName, String scheme, String host, String configLocation, List<DataElement> fileNames, String rootPath, String mappedPath, DataElement status) {
        String scope = scopeName.getName();
        Iterator<DataElement> iterator = fileNames.iterator();
        LinkedHashSet<String> files = new LinkedHashSet<String>();
        UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)("Added scope " + scope + " at " + configLocation + " Files:\n"), (DataStore)this._dataStore);
        while (iterator.hasNext()) {
            DataElement element = iterator.next();
            String fileName = element.getName();
            files.add(fileName);
            UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)(String.valueOf(fileName) + "\n"), (DataStore)this._dataStore);
        }
        ScopeManager.getInstance().addScope(scope, scheme, host, files, rootPath, mappedPath);
        RemoteIndexManager.getInstance().setIndexFileLocation(scope, configLocation);
        CDTMiner.statusDone(status);
    }

    public static DataElement statusWorking(DataElement status) {
        status.setAttribute(2, "working");
        status.getDataStore().refresh(status);
        return status;
    }

    public static DataElement statusWorked(DataElement status, int numWorked) {
        status.setAttribute(2, new Integer(numWorked).toString());
        status.getDataStore().refresh(status);
        return status;
    }

    public static DataElement statusDone(DataElement status) {
        status.setAttribute(2, "done");
        status.getDataStore().refresh(status);
        status.getDataStore().disconnectObject(status.getParent());
        return status;
    }

    public static DataElement statusCancelled(DataElement status) {
        status.setAttribute(2, CANCELLED);
        status.getDataStore().refresh(status);
        status.getDataStore().disconnectObject(status.getParent());
        return status;
    }

    public DataStore getDataStore() {
        return this._dataStore;
    }

    private class CancellationThread
    extends Thread {
        private boolean cancelled = false;
        private boolean done = false;
        private DataElement fStatus;
        private IProgressMonitor fMonitor;

        public CancellationThread(DataElement status, IProgressMonitor monitor) {
            this.fStatus = status;
            this.fMonitor = monitor;
        }

        private CancellationThread() {
        }

        public void setDone(boolean isDone) {
            this.done = isDone;
        }

        public void run() {
            while (!this.cancelled & !this.done) {
                if (this.fStatus.getAttribute(2).equals(CDTMiner.CANCELLED)) {
                    this.fMonitor.setCanceled(true);
                    continue;
                }
                try {
                    CancellationThread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

