/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom;

import org.eclipse.cdt.core.index.IndexerSetupParticipant;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.settings.model.CProjectDescriptionEvent;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionListener;
import org.eclipse.cdt.internal.core.pdom.PDOMManager;
import org.eclipse.cdt.internal.core.settings.model.CProjectDescriptionManager;
import org.eclipse.core.resources.IProject;

public class CProjectDescriptionListener
implements ICProjectDescriptionListener {
    private PDOMManager fIndexManager;
    private IndexerSetupParticipant fIndexerSetupParticipant;

    public CProjectDescriptionListener(PDOMManager manager) {
        this.fIndexManager = manager;
        this.fIndexerSetupParticipant = this.createIndexerSetupParticipant();
        manager.addIndexerSetupParticipant(this.fIndexerSetupParticipant);
    }

    private IndexerSetupParticipant createIndexerSetupParticipant() {
        return new IndexerSetupParticipant(){

            @Override
            public boolean postponeIndexerSetup(ICProject project) {
                return !CProjectDescriptionListener.this.isProjectCreationComplete(project.getProject());
            }
        };
    }

    @Override
    public void handleEvent(CProjectDescriptionEvent event) {
        ICProjectDescription old = event.getOldCProjectDescription();
        ICProjectDescription act = event.getNewCProjectDescription();
        if (act != null) {
            ICProject project;
            if (this.completedProjectCreation(old, act)) {
                ICProject project2 = this.getProject(event);
                if (project2 != null) {
                    this.fIndexerSetupParticipant.notifyIndexerSetup(project2);
                }
            } else if (old != null && this.changedDefaultSettingConfiguration(old, act) && (project = this.getProject(event)) != null) {
                this.fIndexManager.reindex(project);
            }
        }
    }

    private boolean changedDefaultSettingConfiguration(ICProjectDescription old, ICProjectDescription act) {
        ICConfigurationDescription oldConfig = old.getDefaultSettingConfiguration();
        ICConfigurationDescription newConfig = act.getDefaultSettingConfiguration();
        if (oldConfig != null && newConfig != null) {
            String oldID = oldConfig.getId();
            String newID = newConfig.getId();
            if (oldID != null && newID != null && !oldID.equals(newID)) {
                return true;
            }
        }
        return false;
    }

    private ICProject getProject(CProjectDescriptionEvent event) {
        IProject project = event.getProject();
        if (project != null && project.isOpen()) {
            return CoreModel.getDefault().create(project);
        }
        return null;
    }

    protected boolean isProjectCreationComplete(IProject project) {
        ICProjectDescription desc = CProjectDescriptionManager.getInstance().getProjectDescription(project.getProject(), false, false);
        return desc == null || !desc.isCdtProjectCreating();
    }

    private boolean completedProjectCreation(ICProjectDescription old, ICProjectDescription act) {
        return (old == null || old.isCdtProjectCreating()) && !act.isCdtProjectCreating();
    }
}

