/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.core;

import java.io.File;
import java.net.URL;
import java.util.HashSet;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchDelegate;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.ptp.core.ModelManager;
import org.eclipse.ptp.core.Preferences;
import org.eclipse.ptp.core.messages.Messages;
import org.eclipse.ptp.core.util.DebugUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class PTPCorePlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.ptp.core";
    private static PTPCorePlugin fPlugin;
    private ResourceBundle resourceBundle;

    public static PTPCorePlugin getDefault() {
        return fPlugin;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = PTPCorePlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public static String getUniqueIdentifier() {
        if (PTPCorePlugin.getDefault() == null) {
            return PLUGIN_ID;
        }
        return PTPCorePlugin.getDefault().getBundle().getSymbolicName();
    }

    public static void log(IStatus status) {
        PTPCorePlugin.getDefault().getLog().log(status);
    }

    public static void log(String msg) {
        if (DebugUtil.RM_TRACING) {
            System.err.println(msg);
        }
        PTPCorePlugin.log((IStatus)new Status(4, PTPCorePlugin.getUniqueIdentifier(), 4, msg, null));
    }

    public static void log(Throwable e) {
        PTPCorePlugin.log((IStatus)new Status(4, PTPCorePlugin.getUniqueIdentifier(), 4, Messages.PTPCorePlugin_0, e));
    }

    public PTPCorePlugin() {
        fPlugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("org.eclipse.ptp.core.ParallelPluginResources");
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public String locateFragmentFile(String fragment, String file) {
        Bundle[] frags = Platform.getFragments((Bundle)Platform.getBundle((String)PLUGIN_ID));
        if (frags != null) {
            String os = Platform.getOS();
            String arch = Platform.getOSArch();
            String frag_os_arch = String.valueOf(fragment) + "." + os + "." + arch;
            int i = 0;
            while (i < frags.length) {
                Bundle frag = frags[i];
                URL path = frag.getEntry("/");
                try {
                    String file_path;
                    File f;
                    URL local_path = FileLocator.toFileURL((URL)path);
                    String str_path = local_path.getPath();
                    int idx = str_path.indexOf(frag_os_arch);
                    if (idx > 0 && (f = new File(file_path = String.valueOf(str_path) + "bin/" + file)).exists()) {
                        return file_path;
                    }
                }
                catch (Exception exception) {}
                ++i;
            }
        }
        return null;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.setDefaultLaunchDelegates();
        DebugUtil.configurePluginDebugOptions();
        ResourcesPlugin.getWorkspace().addSaveParticipant(PTPCorePlugin.getUniqueIdentifier(), new ISaveParticipant(){

            public void saving(ISaveContext saveContext) throws CoreException {
                Preferences.savePreferences(PTPCorePlugin.getUniqueIdentifier());
            }

            public void rollback(ISaveContext saveContext) {
            }

            public void prepareToSave(ISaveContext saveContext) throws CoreException {
            }

            public void doneSaving(ISaveContext saveContext) {
            }
        });
        ModelManager.getInstance().start();
    }

    public void stop(BundleContext context) throws Exception {
        try {
            ModelManager.getInstance().shutdown();
            Preferences.savePreferences(PTPCorePlugin.getUniqueIdentifier());
            ResourcesPlugin.getWorkspace().removeSaveParticipant(PTPCorePlugin.getUniqueIdentifier());
        }
        finally {
            super.stop(context);
            fPlugin = null;
        }
    }

    private void setDefaultLaunchDelegates() {
        block9: {
            int n;
            ILaunchConfigurationType localCfg;
            block8: {
                ILaunchManager launchMgr = DebugPlugin.getDefault().getLaunchManager();
                HashSet<String> debugSet = new HashSet<String>();
                debugSet.add("debug");
                localCfg = launchMgr.getLaunchConfigurationType("org.eclipse.ptp.launch.parallelLaunch");
                try {
                    ILaunchDelegate[] delegates;
                    if (localCfg.getPreferredDelegate(debugSet) != null) break block8;
                    ILaunchDelegate[] iLaunchDelegateArray = delegates = localCfg.getDelegates(debugSet);
                    n = delegates.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ILaunchDelegate delegate = iLaunchDelegateArray[n2];
                        if ("org.eclipse.ptp.rm.launch.parallelLaunch".equals(delegate.getId())) {
                            localCfg.setPreferredDelegate(debugSet, delegate);
                            break;
                        }
                        ++n2;
                    }
                }
                catch (CoreException coreException) {}
            }
            HashSet<String> runSet = new HashSet<String>();
            runSet.add("run");
            try {
                ILaunchDelegate[] delegates;
                if (localCfg.getPreferredDelegate(runSet) != null) break block9;
                ILaunchDelegate[] iLaunchDelegateArray = delegates = localCfg.getDelegates(runSet);
                int n3 = delegates.length;
                n = 0;
                while (n < n3) {
                    ILaunchDelegate delegate = iLaunchDelegateArray[n];
                    if ("org.eclipse.ptp.rm.launch.parallelLaunch".equals(delegate.getId())) {
                        localCfg.setPreferredDelegate(runSet, delegate);
                        break;
                    }
                    ++n;
                }
            }
            catch (CoreException coreException) {}
        }
    }
}

