/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.server.dstore.core;

import org.eclipse.core.runtime.Path;
import org.eclipse.ptp.internal.rdt.core.callhierarchy.ICallHierarchyService;
import org.eclipse.ptp.internal.rdt.core.callhierarchy.RemoteCallHierarchyService;
import org.eclipse.ptp.internal.rdt.core.includebrowser.IIncludeBrowserService;
import org.eclipse.ptp.internal.rdt.core.includebrowser.RemoteIncludeBrowserService;
import org.eclipse.ptp.internal.rdt.core.index.IIndexLifecycleService;
import org.eclipse.ptp.internal.rdt.core.index.RemoteIndexLifecycleService;
import org.eclipse.ptp.internal.rdt.core.model.IModelBuilderService;
import org.eclipse.ptp.internal.rdt.core.model.RemoteModelBuilderService;
import org.eclipse.ptp.internal.rdt.core.subsystems.ICIndexSubsystem;
import org.eclipse.ptp.internal.rdt.core.typehierarchy.ITypeHierarchyService;
import org.eclipse.ptp.internal.rdt.core.typehierarchy.RemoteTypeHierarchyService;
import org.eclipse.ptp.internal.rdt.ui.contentassist.IContentAssistService;
import org.eclipse.ptp.internal.rdt.ui.contentassist.RemoteContentAssistService;
import org.eclipse.ptp.internal.rdt.ui.editor.IRemoteCCodeFoldingService;
import org.eclipse.ptp.internal.rdt.ui.editor.IRemoteCodeFormattingService;
import org.eclipse.ptp.internal.rdt.ui.editor.IRemoteSemanticHighlightingService;
import org.eclipse.ptp.internal.rdt.ui.editor.RemoteCCodeFoldingService;
import org.eclipse.ptp.internal.rdt.ui.editor.RemoteCodeFormattingService;
import org.eclipse.ptp.internal.rdt.ui.editor.RemoteSemanticHighlightingService;
import org.eclipse.ptp.internal.rdt.ui.navigation.INavigationService;
import org.eclipse.ptp.internal.rdt.ui.navigation.RemoteNavigationService;
import org.eclipse.ptp.internal.rdt.ui.search.ISearchService;
import org.eclipse.ptp.internal.rdt.ui.search.RemoteSearchService;
import org.eclipse.ptp.rdt.server.dstore.core.RemoteToolsCIndexSubsystem;
import org.eclipse.ptp.rdt.server.dstore.messages.Messages;
import org.eclipse.ptp.rdt.ui.serviceproviders.IRemoteToolsIndexServiceProvider;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.PTPRemoteCorePlugin;
import org.eclipse.ptp.services.core.IServiceProvider;
import org.eclipse.ptp.services.core.IServiceProviderWorkingCopy;
import org.eclipse.ptp.services.core.ServiceProvider;

public class RemoteToolsCIndexServiceProvider
extends ServiceProvider
implements IRemoteToolsIndexServiceProvider,
IServiceProviderWorkingCopy {
    protected IIndexLifecycleService fIndexLifecycleService = null;
    protected INavigationService fNavigationService = null;
    protected ICallHierarchyService fCallHierarchyService = null;
    protected ITypeHierarchyService fTypeHierarchyService = null;
    protected IIncludeBrowserService fIncludeBrowserService = null;
    protected IModelBuilderService fModelBuilderService = null;
    protected RemoteSearchService fSearchService = null;
    protected IContentAssistService fContentAssistService = null;
    protected RemoteSemanticHighlightingService fRemoteSemanticHighlightingService = null;
    protected RemoteCCodeFoldingService fRemoteCCodeFoldingService = null;
    protected IRemoteCodeFormattingService fRemoteCodeFormattingService = null;
    protected RemoteToolsCIndexSubsystem fSubsystem = null;
    protected boolean fIsDirty = false;
    protected RemoteToolsCIndexServiceProvider fProvider = null;
    protected boolean fIsConfigured = false;
    public static final String NAME = Messages.RemoteToolsCIndexServiceProvider_0;
    public static final String SERVICE_ID = "org.eclipse.ptp.rdt.core.CIndexingService";
    public static final String SERVICE_ID_KEY = "service-name";
    public static final String CONNECTION_NAME_KEY = "connection-name";
    public static final String INDEX_LOCATION_KEY = "index-location";

    public RemoteToolsCIndexServiceProvider() {
    }

    public RemoteToolsCIndexServiceProvider(RemoteToolsCIndexServiceProvider provider) {
        this.fProvider = provider;
        this.setProperties(provider.getProperties());
        this.setDescriptor(provider.getDescriptor());
    }

    public boolean isRemote() {
        return true;
    }

    public IServiceProviderWorkingCopy copy() {
        return new RemoteToolsCIndexServiceProvider(this);
    }

    public synchronized ICallHierarchyService getCallHierarchyService() {
        if (!this.isConfigured()) {
            return null;
        }
        if (this.fCallHierarchyService == null) {
            this.fCallHierarchyService = new RemoteCallHierarchyService((ICIndexSubsystem)this.fSubsystem);
        }
        return this.fCallHierarchyService;
    }

    public String getConnectionName() {
        return this.getString(CONNECTION_NAME_KEY, null);
    }

    public IContentAssistService getContentAssistService() {
        if (!this.isConfigured()) {
            return null;
        }
        if (this.fContentAssistService == null) {
            this.fContentAssistService = new RemoteContentAssistService((ICIndexSubsystem)this.fSubsystem);
        }
        return this.fContentAssistService;
    }

    public synchronized IIncludeBrowserService getIncludeBrowserService() {
        if (!this.isConfigured()) {
            return null;
        }
        if (this.fIncludeBrowserService == null) {
            this.fIncludeBrowserService = new RemoteIncludeBrowserService((ICIndexSubsystem)this.fSubsystem);
        }
        return this.fIncludeBrowserService;
    }

    public synchronized IIndexLifecycleService getIndexLifeCycleService() {
        if (!this.isConfigured()) {
            return null;
        }
        if (this.fIndexLifecycleService == null) {
            this.fIndexLifecycleService = new RemoteIndexLifecycleService((ICIndexSubsystem)this.fSubsystem);
        }
        return this.fIndexLifecycleService;
    }

    public String getIndexLocation() {
        this.initialize();
        return this.getString(INDEX_LOCATION_KEY, "");
    }

    public synchronized IModelBuilderService getModelBuilderService() {
        if (!this.isConfigured()) {
            return null;
        }
        if (this.fModelBuilderService == null) {
            this.fModelBuilderService = new RemoteModelBuilderService((ICIndexSubsystem)this.fSubsystem);
        }
        return this.fModelBuilderService;
    }

    public synchronized INavigationService getNavigationService() {
        if (!this.isConfigured()) {
            return null;
        }
        if (this.fNavigationService == null) {
            this.fNavigationService = new RemoteNavigationService((ICIndexSubsystem)this.fSubsystem);
        }
        return this.fNavigationService;
    }

    public IServiceProvider getOriginal() {
        return this.fProvider;
    }

    public IRemoteConnection getConnection() {
        if (!this.isConfigured()) {
            return null;
        }
        return this.getRemoteServices().getConnectionManager().getConnection(this.getConnectionName());
    }

    private IRemoteServices getRemoteServices() {
        if (!this.isConfigured()) {
            return null;
        }
        IRemoteServices services = PTPRemoteCorePlugin.getDefault().getRemoteServices(this.getServiceId());
        if (!services.isInitialized()) {
            services.initialize();
        }
        if (!services.isInitialized()) {
            return null;
        }
        return services;
    }

    public ISearchService getSearchService() {
        if (!this.isConfigured()) {
            return null;
        }
        if (this.fSearchService == null) {
            this.fSearchService = new RemoteSearchService((ICIndexSubsystem)this.fSubsystem);
        }
        return this.fSearchService;
    }

    public String getServiceId() {
        return this.getString(SERVICE_ID_KEY, null);
    }

    public synchronized ITypeHierarchyService getTypeHierarchyService() {
        if (!this.isConfigured()) {
            return null;
        }
        if (this.fTypeHierarchyService == null) {
            this.fTypeHierarchyService = new RemoteTypeHierarchyService((ICIndexSubsystem)this.fSubsystem);
        }
        return this.fTypeHierarchyService;
    }

    public boolean isConfigured() {
        this.initialize();
        return this.fIsConfigured;
    }

    public boolean isDirty() {
        return this.fIsDirty;
    }

    public void putString(String key, String value) {
        this.fIsDirty = true;
        super.putString(key, value);
    }

    public void save() {
        if (this.fProvider != null) {
            this.fProvider.setProperties(this.getProperties());
            this.fIsDirty = false;
        }
    }

    public void setConfigured(boolean isConfigured) {
        this.fIsConfigured = isConfigured;
    }

    public void setConnection(IRemoteConnection connection) {
        this.setConnection(connection, true);
    }

    public void setConnectionName(String connectionName) {
        this.putString(CONNECTION_NAME_KEY, connectionName);
    }

    public void setIndexLocation(String path) {
        this.putString(INDEX_LOCATION_KEY, path);
    }

    public void setServiceId(String serviceId) {
        this.putString(SERVICE_ID_KEY, serviceId);
    }

    public String toString() {
        return "RemoteToolsCIndexServiceProvider(" + this.getIndexLocation() + ")";
    }

    private void initialize() {
        IRemoteServices services;
        if (this.fSubsystem == null && this.getServiceId() != null && (services = PTPRemoteCorePlugin.getDefault().getRemoteServices(this.getServiceId())) != null) {
            if (!services.isInitialized()) {
                services.initialize();
            }
            if (services.isInitialized() && this.getConnectionName() != null) {
                IRemoteConnection connection = services.getConnectionManager().getConnection(this.getConnectionName());
                this.setConnection(connection, false);
            }
        }
    }

    private void setConnection(IRemoteConnection connection, boolean reset) {
        this.setServiceId(connection.getRemoteServices().getId());
        this.setConnectionName(connection.getName());
        if (reset) {
            Path workingDir = new Path(connection.getWorkingDirectory());
            this.setIndexLocation(workingDir.append(".eclipsesettings").toString());
        }
        if (this.fSubsystem != null) {
            this.fSubsystem.dispose();
        }
        this.fSubsystem = new RemoteToolsCIndexSubsystem(this);
        this.setConfigured(true);
    }

    public IRemoteSemanticHighlightingService getRemoteSemanticHighlightingService() {
        if (!this.isConfigured()) {
            return null;
        }
        if (this.fRemoteSemanticHighlightingService == null) {
            this.fRemoteSemanticHighlightingService = new RemoteSemanticHighlightingService((ICIndexSubsystem)this.fSubsystem);
        }
        return this.fRemoteSemanticHighlightingService;
    }

    public IRemoteCCodeFoldingService getRemoteCodeFoldingService() {
        if (!this.isConfigured()) {
            return null;
        }
        if (this.fRemoteCCodeFoldingService == null) {
            this.fRemoteCCodeFoldingService = new RemoteCCodeFoldingService((ICIndexSubsystem)this.fSubsystem);
        }
        return this.fRemoteCCodeFoldingService;
    }

    public IRemoteCodeFormattingService getRemoteCodeFormattingService() {
        if (!this.isConfigured()) {
            return null;
        }
        if (this.fRemoteCodeFormattingService == null) {
            this.fRemoteCodeFormattingService = new RemoteCodeFormattingService((ICIndexSubsystem)this.fSubsystem);
        }
        return this.fRemoteCodeFormattingService;
    }
}

