/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.sync.git.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.CheckoutCommand;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.MergeCommand;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.StatusCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.errors.AmbiguousObjectException;
import org.eclipse.jgit.errors.NotSupportedException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.storage.file.FileRepository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.RemoteSession;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.TransportGitSsh;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.QuotedString;
import org.eclipse.ptp.rdt.sync.core.BuildScenario;
import org.eclipse.ptp.rdt.sync.core.CommandRunner;
import org.eclipse.ptp.rdt.sync.core.MissingConnectionException;
import org.eclipse.ptp.rdt.sync.core.RDTSyncCorePlugin;
import org.eclipse.ptp.rdt.sync.core.RecursiveSubMonitor;
import org.eclipse.ptp.rdt.sync.core.RemoteExecutionException;
import org.eclipse.ptp.rdt.sync.core.RemoteSyncException;
import org.eclipse.ptp.rdt.sync.core.RemoteSyncMergeConflictException;
import org.eclipse.ptp.rdt.sync.core.SyncFileFilter;
import org.eclipse.ptp.rdt.sync.git.core.EclipseGitProgressTransformer;
import org.eclipse.ptp.rdt.sync.git.core.RmCommandCached;
import org.eclipse.ptp.rdt.sync.git.core.messages.Messages;
import org.eclipse.ptp.remote.core.AbstractRemoteProcess;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.exception.RemoteConnectionException;

public class GitRemoteSyncConnection {
    private final int MAX_FILES = 100;
    private static final String remoteProjectName = "eclipse_auto";
    private static final String commitMessage = Messages.GRSC_CommitMessage;
    public static final String gitDir = ".ptp-sync";
    private static final String gitArgs = "--git-dir=.ptp-sync --work-tree=.";
    private static final String remotePushBranch = "ptp-push";
    private final String localDirectory;
    private final BuildScenario buildScenario;
    private SyncFileFilter fileFilter;
    private Git git;
    private TransportGitSsh transport;
    private final IProject project;
    private boolean mergeMapInitialized = false;
    private Map<IPath, String[]> FileToMergePartsMap = new HashMap<IPath, String[]>();
    private int remoteGitVersion;

    public GitRemoteSyncConnection(IProject proj, String localDir, BuildScenario bs, SyncFileFilter filter, IProgressMonitor monitor) throws RemoteSyncException, MissingConnectionException {
        RecursiveSubMonitor subMon = RecursiveSubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            this.project = proj;
            this.localDirectory = localDir;
            this.buildScenario = bs;
            this.fileFilter = filter;
            try {
                subMon.subTask(Messages.GitRemoteSyncConnection_21);
                this.remoteGitVersion = this.getRemoteGitVersion((IProgressMonitor)subMon.newChild(10));
                subMon.subTask(Messages.GitRemoteSyncConnection_20);
                this.buildRepo((IProgressMonitor)subMon.newChild(80));
            }
            catch (IOException e) {
                throw new RemoteSyncException((Throwable)e);
            }
            catch (RemoteExecutionException e) {
                throw new RemoteSyncException((Throwable)e);
            }
            RemoteConfig remoteConfig = this.buildRemoteConfig(this.git.getRepository().getConfig());
            subMon.subTask(Messages.GitRemoteSyncConnection_4);
            this.buildTransport(remoteConfig, (IProgressMonitor)subMon.newChild(10));
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private RemoteConfig buildRemoteConfig(StoredConfig config) {
        RemoteConfig rconfig = null;
        try {
            rconfig = new RemoteConfig((Config)config, remoteProjectName);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        RefSpec refSpecFetch = new RefSpec("+refs/heads/master:refs/remotes/eclipse_auto/master");
        RefSpec refSpecPush = new RefSpec("+master:ptp-push");
        rconfig.addFetchRefSpec(refSpecFetch);
        rconfig.addPushRefSpec(refSpecPush);
        return rconfig;
    }

    private Git buildRepo(IProgressMonitor monitor) throws IOException, RemoteExecutionException, RemoteSyncException, MissingConnectionException {
        RecursiveSubMonitor subMon = RecursiveSubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            File localDir = new File(this.localDirectory);
            FileRepositoryBuilder repoBuilder = new FileRepositoryBuilder();
            File gitDirFile = new File(String.valueOf(this.localDirectory) + File.separator + gitDir);
            FileRepository repository = ((FileRepositoryBuilder)((FileRepositoryBuilder)repoBuilder.setWorkTree(localDir)).setGitDir(gitDirFile)).build();
            this.git = new Git((Repository)repository);
            if (!gitDirFile.exists()) {
                repository.create(false);
                subMon.subTask(Messages.GitRemoteSyncConnection_22);
                this.doCommit((IProgressMonitor)subMon.newChild(4));
            }
            subMon.subTask(Messages.GitRemoteSyncConnection_23);
            final Thread refreshThread = this.doRefresh((IProgressMonitor)subMon.newChild(1));
            Thread setDerivedThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        refreshThread.join();
                        GitRemoteSyncConnection.this.project.getFolder(GitRemoteSyncConnection.gitDir).setDerived(true, null);
                    }
                    catch (InterruptedException e) {
                        RDTSyncCorePlugin.log((Throwable)e);
                    }
                    catch (CoreException e) {
                        RDTSyncCorePlugin.log((Throwable)e);
                    }
                }
            }, "Set repo as derived thread");
            setDerivedThread.start();
            try {
                subMon.subTask(Messages.GitRemoteSyncConnection_24);
                CommandRunner.createRemoteDirectory((IRemoteConnection)this.buildScenario.getRemoteConnection(), (String)this.buildScenario.getLocation(this.project), (IProgressMonitor)subMon.newChild(5));
            }
            catch (CoreException e) {
                throw new RemoteSyncException((Throwable)e);
            }
            subMon.subTask(Messages.GitRemoteSyncConnection_25);
            boolean existingGitRepo = this.doRemoteInit((IProgressMonitor)subMon.newChild(5));
            subMon.subTask(Messages.GitRemoteSyncConnection_26);
            boolean needToCommitRemote = this.prepareRemoteForCommit((IProgressMonitor)subMon.newChild(85), !existingGitRepo);
            if (needToCommitRemote) {
                subMon.subTask(Messages.GitRemoteSyncConnection_27);
                this.commitRemoteFiles((IProgressMonitor)subMon.newChild(5));
            }
            Git git = this.git;
            return git;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private boolean doRemoteInit(IProgressMonitor monitor) throws IOException, RemoteExecutionException, RemoteSyncException, MissingConnectionException {
        try {
            String commands = "git --git-dir=.ptp-sync init && git --git-dir=.ptp-sync config core.preloadindex true";
            CommandRunner.CommandResults commandResults = null;
            try {
                commandResults = this.executeRemoteCommand(commands, monitor);
            }
            catch (InterruptedException e) {
                throw new RemoteExecutionException((Throwable)e);
            }
            catch (RemoteConnectionException e) {
                throw new RemoteExecutionException((Throwable)e);
            }
            if (commandResults.getExitCode() != 0) {
                throw new RemoteExecutionException(String.valueOf(Messages.GRSC_GitInitFailure) + commandResults.getStderr());
            }
            return commandResults.getStdout().contains("existing");
            {
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private boolean prepareRemoteForCommit(IProgressMonitor monitor, boolean includeUntrackedFiles) throws RemoteSyncException, MissingConnectionException {
        RecursiveSubMonitor subMon = RecursiveSubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            HashSet<String> filesToAdd = new HashSet<String>();
            HashSet<String> filesToDelete = new HashSet<String>();
            boolean needToCommit = false;
            subMon.subTask(Messages.GitRemoteSyncConnection_5);
            this.getRemoteFileStatus(filesToAdd, filesToDelete, (IProgressMonitor)subMon.newChild(50), includeUntrackedFiles);
            for (String fileName : filesToDelete) {
                if (!filesToAdd.contains(fileName)) continue;
                filesToAdd.remove(fileName);
            }
            subMon.subTask(Messages.GitRemoteSyncConnection_6);
            if (filesToAdd.size() > 0) {
                this.addRemoteFiles(filesToAdd, (IProgressMonitor)subMon.newChild(25));
                needToCommit = true;
            }
            subMon.subTask(Messages.GitRemoteSyncConnection_7);
            if (filesToDelete.size() > 0) {
                this.deleteRemoteFiles(filesToDelete, (IProgressMonitor)subMon.newChild(25));
                needToCommit = true;
            }
            boolean bl = needToCommit;
            return bl;
        }
        catch (IOException e) {
            throw new RemoteSyncException((Throwable)e);
        }
        catch (RemoteExecutionException e) {
            throw new RemoteSyncException((Throwable)e);
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private void commitRemoteFiles(IProgressMonitor monitor) throws RemoteSyncException, MissingConnectionException {
        try {
            String command = String.valueOf(this.gitCommand()) + " commit -m \"" + commitMessage + "\"";
            CommandRunner.CommandResults commandResults = null;
            try {
                commandResults = this.executeRemoteCommand(command, monitor);
            }
            catch (InterruptedException e) {
                throw new RemoteSyncException((Throwable)e);
            }
            catch (RemoteConnectionException e) {
                throw new RemoteSyncException((Throwable)e);
            }
            catch (IOException e) {
                throw new RemoteSyncException((Throwable)e);
            }
            if (commandResults.getExitCode() != 0) {
                throw new RemoteSyncException(String.valueOf(Messages.GRSC_GitCommitFailure) + commandResults.getStderr());
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private void deleteRemoteFiles(Set<String> filesToDelete, IProgressMonitor monitor) throws IOException, RemoteExecutionException, RemoteSyncException, MissingConnectionException {
        try {
            while (!filesToDelete.isEmpty()) {
                List<String> commandList = this.stringToList(String.valueOf(this.gitCommand()) + " rm --");
                int count = 1;
                String[] stringArray = filesToDelete.toArray(new String[0]);
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String fileName = stringArray[n2];
                    if (count++ % 100 == 0) break;
                    commandList.add(fileName);
                    filesToDelete.remove(fileName);
                    ++n2;
                }
                CommandRunner.CommandResults commandResults = null;
                try {
                    commandResults = this.executeRemoteCommand(commandList, monitor);
                }
                catch (InterruptedException e) {
                    throw new RemoteExecutionException((Throwable)e);
                }
                catch (RemoteConnectionException e) {
                    throw new RemoteExecutionException((Throwable)e);
                }
                if (commandResults.getExitCode() == 0) continue;
                throw new RemoteExecutionException(String.valueOf(Messages.GRSC_GitRmFailure) + commandResults.getStderr());
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private List<String> stringToList(String command) {
        return new ArrayList<String>(Arrays.asList(command.split(" ")));
    }

    private void addRemoteFiles(Set<String> filesToAdd, IProgressMonitor monitor) throws IOException, RemoteExecutionException, RemoteSyncException, MissingConnectionException {
        try {
            while (!filesToAdd.isEmpty()) {
                List<String> commandList = this.stringToList(String.valueOf(this.gitCommand()) + " add -f --");
                int count = 1;
                String[] stringArray = filesToAdd.toArray(new String[0]);
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String fileName = stringArray[n2];
                    if (count++ % 100 == 0) break;
                    commandList.add(fileName);
                    filesToAdd.remove(fileName);
                    ++n2;
                }
                CommandRunner.CommandResults commandResults = null;
                try {
                    commandResults = this.executeRemoteCommand(commandList, monitor);
                }
                catch (InterruptedException e) {
                    throw new RemoteExecutionException((Throwable)e);
                }
                catch (RemoteConnectionException e) {
                    throw new RemoteExecutionException((Throwable)e);
                }
                if (commandResults.getExitCode() != 0) {
                    throw new RemoteExecutionException(String.valueOf(Messages.GRSC_GitAddFailure) + commandResults.getStderr());
                }
                monitor.worked(count);
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private void getRemoteFileStatus(Set<String> filesToAdd, Set<String> filesToDelete, IProgressMonitor monitor, boolean includeUntrackedFiles) throws IOException, RemoteExecutionException, RemoteSyncException, MissingConnectionException {
        try {
            int fileNamePos;
            String deletePrefix;
            String command;
            if (this.remoteGitVersion >= 10700) {
                command = String.valueOf(this.gitCommand()) + " status --porcelain";
                deletePrefix = " D";
                fileNamePos = 3;
            } else {
                command = includeUntrackedFiles ? String.valueOf(this.gitCommand()) + " ls-files -t --modified --others --deleted" : String.valueOf(this.gitCommand()) + " ls-files -t --modified --deleted";
                deletePrefix = "R ";
                fileNamePos = 2;
            }
            CommandRunner.CommandResults commandResults = null;
            try {
                commandResults = this.executeRemoteCommand(command, monitor);
            }
            catch (InterruptedException e) {
                throw new RemoteExecutionException((Throwable)e);
            }
            catch (RemoteConnectionException e) {
                throw new RemoteExecutionException((Throwable)e);
            }
            if (commandResults.getExitCode() != 0) {
                throw new RemoteExecutionException(String.valueOf(Messages.GRSC_GitLsFilesFailure) + commandResults.getStderr());
            }
            BufferedReader statusReader = new BufferedReader(new StringReader(commandResults.getStdout()));
            String line = null;
            while ((line = statusReader.readLine()) != null) {
                if (this.remoteGitVersion < 10700 && (line.charAt(0) == ' ' || line.charAt(1) != ' ')) continue;
                String fn = line.substring(fileNamePos);
                if (this.fileFilter.shouldIgnore((IResource)this.project.getFile(fn = QuotedString.GIT_PATH.dequote(fn)))) continue;
                if (line.substring(0, 2).equals(deletePrefix)) {
                    filesToDelete.add(fn);
                    continue;
                }
                filesToAdd.add(fn);
            }
            statusReader.close();
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private Status getFileStatus(Set<String> filesToAdd, Set<String> filesToDelete, boolean includeUntrackedFiles) throws RemoteSyncException {
        Status status;
        StatusCommand statusCommand = this.git.status();
        try {
            status = statusCommand.call();
            filesToAdd.addAll(status.getModified());
            if (includeUntrackedFiles) {
                filesToAdd.addAll(status.getUntracked());
            }
            filesToDelete.addAll(status.getMissing());
        }
        catch (GitAPIException e) {
            throw new RemoteSyncException((Throwable)e);
        }
        HashSet<String> allFiles = new HashSet<String>();
        allFiles.addAll(filesToAdd);
        allFiles.addAll(filesToDelete);
        HashSet<String> filesToBeIgnored = new HashSet<String>();
        for (String fileName : allFiles) {
            if (!this.fileFilter.shouldIgnore((IResource)this.project.getFile(fileName))) continue;
            filesToBeIgnored.add(fileName);
        }
        filesToAdd.removeAll(filesToBeIgnored);
        filesToDelete.removeAll(filesToBeIgnored);
        return status;
    }

    private void buildTransport(RemoteConfig remoteConfig, IProgressMonitor monitor) {
        RecursiveSubMonitor subMon = RecursiveSubMonitor.convert((IProgressMonitor)monitor, (int)10);
        URIish uri = this.buildURI();
        try {
            try {
                subMon.subTask(Messages.GitRemoteSyncConnection_8);
                this.transport = (TransportGitSsh)Transport.open((Repository)this.git.getRepository(), (URIish)uri);
            }
            catch (NotSupportedException e) {
                throw new RuntimeException(e);
            }
            catch (TransportException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
        this.transport.setSshSessionFactory(new SshSessionFactory(){

            public RemoteSession getSession(URIish uri, CredentialsProvider credentialsProvider, FS fs, int tms) throws TransportException {
                return new PTPSession(uri);
            }
        });
        this.transport.applyConfig(remoteConfig);
    }

    private URIish buildURI() {
        return new URIish().setHost("none").setScheme("ssh").setPath(String.valueOf(this.buildScenario.getLocation(this.project)) + "/" + gitDir);
    }

    public void close() {
        this.transport.close();
        this.git.getRepository().close();
    }

    private boolean doCommit(IProgressMonitor monitor) throws RemoteSyncException {
        RecursiveSubMonitor subMon = RecursiveSubMonitor.convert((IProgressMonitor)monitor, (int)100);
        HashSet<String> filesToAdd = new HashSet<String>();
        HashSet<String> filesToRemove = new HashSet<String>();
        Status status = this.getFileStatus(filesToAdd, filesToRemove, true);
        boolean addedOrRemovedFiles = false;
        try {
            boolean indexHasDeletedFiles;
            subMon.subTask(Messages.GitRemoteSyncConnection_9);
            if (!filesToAdd.isEmpty()) {
                AddCommand addCommand = this.git.add();
                for (String fileName : filesToAdd) {
                    addCommand.addFilepattern(fileName);
                }
                addCommand.call();
                addedOrRemovedFiles = true;
            }
            subMon.worked(10);
            subMon.subTask(Messages.GitRemoteSyncConnection_10);
            if (!filesToRemove.isEmpty()) {
                RmCommandCached rmCommand = new RmCommandCached(this.git.getRepository());
                for (String fileName : filesToRemove) {
                    rmCommand.addFilepattern(fileName);
                }
                rmCommand.call();
                addedOrRemovedFiles = true;
            }
            subMon.worked(10);
            subMon.subTask(Messages.GitRemoteSyncConnection_11);
            boolean indexHasNewFiles = !status.getAdded().isEmpty();
            boolean indexHasModifiedFiles = !status.getChanged().isEmpty();
            boolean bl = indexHasDeletedFiles = !status.getRemoved().isEmpty();
            if (addedOrRemovedFiles || indexHasNewFiles || indexHasModifiedFiles || indexHasDeletedFiles || this.inMergeState()) {
                CommitCommand commitCommand = this.git.commit();
                commitCommand.setMessage(commitMessage);
                commitCommand.call();
                return true;
            }
            return false;
        }
        catch (GitAPIException e) {
            throw new RemoteSyncException((Throwable)e);
        }
        catch (IOException e) {
            throw new RemoteSyncException((Throwable)e);
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private boolean inMergeState() throws IOException {
        try {
            return this.git.getRepository().resolve("MERGE_HEAD") != null;
        }
        catch (AmbiguousObjectException e) {
            RDTSyncCorePlugin.log((Throwable)e);
            return true;
        }
    }

    private void readMergeConflictFiles() throws RemoteSyncException {
        String repoPath = this.git.getRepository().getWorkTree().getAbsolutePath();
        if (!repoPath.endsWith(File.separator)) {
            repoPath = String.valueOf(repoPath) + File.separator;
        }
        this.FileToMergePartsMap.clear();
        this.mergeMapInitialized = true;
        RevWalk walk = null;
        try {
            StatusCommand statusCommand = this.git.status();
            Status status = statusCommand.call();
            if (status.getConflicting().isEmpty()) {
                return;
            }
            try {
                walk = new RevWalk(this.git.getRepository());
                walk.setRevFilter(RevFilter.MERGE_BASE);
                ObjectId headSHA = this.git.getRepository().resolve("HEAD");
                ObjectId mergeHeadSHA = this.git.getRepository().resolve("MERGE_HEAD");
                RevCommit head = walk.parseCommit((AnyObjectId)headSHA);
                RevCommit mergeHead = walk.parseCommit((AnyObjectId)mergeHeadSHA);
                walk.markStart(head);
                walk.markStart(mergeHead);
                RevCommit mergeBase = walk.next();
                for (String s : status.getConflicting()) {
                    TreeWalk ancestorTreeWalk;
                    String localContents = "";
                    TreeWalk localTreeWalk = TreeWalk.forPath((Repository)this.git.getRepository(), (String)s, (RevTree)head.getTree());
                    if (localTreeWalk != null) {
                        ObjectId localId = localTreeWalk.getObjectId(0);
                        localContents = new String(this.git.getRepository().open((AnyObjectId)localId).getBytes());
                    }
                    String remoteContents = "";
                    TreeWalk remoteTreeWalk = TreeWalk.forPath((Repository)this.git.getRepository(), (String)s, (RevTree)mergeHead.getTree());
                    if (remoteTreeWalk != null) {
                        ObjectId remoteId = remoteTreeWalk.getObjectId(0);
                        remoteContents = new String(this.git.getRepository().open((AnyObjectId)remoteId).getBytes());
                    }
                    String ancestorContents = "";
                    if (mergeBase != null && (ancestorTreeWalk = TreeWalk.forPath((Repository)this.git.getRepository(), (String)s, (RevTree)mergeBase.getTree())) != null) {
                        ObjectId ancestorId = ancestorTreeWalk.getObjectId(0);
                        ancestorContents = new String(this.git.getRepository().open((AnyObjectId)ancestorId).getBytes());
                    }
                    String[] mergeParts = new String[]{localContents, remoteContents, ancestorContents};
                    this.FileToMergePartsMap.put((IPath)new Path(s), mergeParts);
                }
            }
            catch (IOException e) {
                throw new RemoteSyncException((Throwable)e);
            }
            catch (GitAPIException e) {
                throw new RemoteSyncException((Throwable)e);
            }
        }
        finally {
            if (walk != null) {
                walk.dispose();
            }
        }
    }

    public IProject getProject() {
        return this.project;
    }

    public IRemoteConnection getConnection() throws MissingConnectionException {
        return this.buildScenario.getRemoteConnection();
    }

    public String getLocalDirectory() {
        return this.localDirectory;
    }

    public String getRemoteDirectory() {
        return this.buildScenario.getLocation(this.project);
    }

    public void syncLocalToRemote(IProgressMonitor monitor) throws RemoteSyncException {
        RecursiveSubMonitor subMon = RecursiveSubMonitor.convert((IProgressMonitor)monitor, (int)10);
        subMon.subTask(Messages.GitRemoteSyncConnection_sync_local_to_remote);
        try {
            this.doCommit((IProgressMonitor)subMon.newChild(1));
            try {
                if (this.git.branchList().call().size() > 0) {
                    this.transport.push((ProgressMonitor)new EclipseGitProgressTransformer((IProgressMonitor)subMon.newChild(5)), null);
                    String command = String.valueOf(this.gitCommand()) + " merge " + remotePushBranch;
                    CommandRunner.CommandResults mergeResults = this.executeRemoteCommand(command, (IProgressMonitor)subMon.newChild(5));
                    if (mergeResults.getExitCode() != 0) {
                        throw new RemoteSyncException((Throwable)new RemoteExecutionException(String.valueOf(Messages.GRSC_GitMergeFailure) + mergeResults.getStderr()));
                    }
                }
            }
            catch (IOException e) {
                throw new RemoteSyncException((Throwable)e);
            }
            catch (InterruptedException e) {
                throw new RemoteSyncException((Throwable)e);
            }
            catch (RemoteConnectionException e) {
                throw new RemoteSyncException((Throwable)e);
            }
            catch (GitAPIException e) {
                throw new RemoteSyncException((Throwable)e);
            }
            catch (MissingConnectionException missingConnectionException) {
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    /*
     * Exception decompiling
     */
    public void syncRemoteToLocal(IProgressMonitor monitor, boolean includeUntrackedFiles) throws RemoteSyncException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void setFileFilter(SyncFileFilter sff) {
        this.fileFilter = sff;
    }

    public void sync(IProgressMonitor monitor, boolean includeUntrackedFiles) throws RemoteSyncException {
        RecursiveSubMonitor subMon = RecursiveSubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            try {
                block22: {
                    subMon.subTask(Messages.GitRemoteSyncConnection_12);
                    this.doCommit((IProgressMonitor)subMon.newChild(5));
                    subMon.subTask(Messages.GitRemoteSyncConnection_13);
                    if (this.prepareRemoteForCommit((IProgressMonitor)subMon.newChild(18), includeUntrackedFiles)) {
                        subMon.subTask(Messages.GitRemoteSyncConnection_14);
                        this.commitRemoteFiles((IProgressMonitor)subMon.newChild(18));
                    } else {
                        subMon.worked(18);
                    }
                    try {
                        try {
                            subMon.subTask(Messages.GitRemoteSyncConnection_15);
                            this.transport.fetch((ProgressMonitor)new EclipseGitProgressTransformer((IProgressMonitor)subMon.newChild(18)), null);
                            subMon.subTask(Messages.GitRemoteSyncConnection_16);
                            Ref remoteMasterRef = this.git.getRepository().getRef("refs/remotes/eclipse_auto/master");
                            MergeCommand mergeCommand = this.git.merge().include(remoteMasterRef);
                            mergeCommand.call();
                            this.readMergeConflictFiles();
                            if (!this.FileToMergePartsMap.isEmpty()) {
                                throw new RemoteSyncMergeConflictException(Messages.GitRemoteSyncConnection_2);
                            }
                        }
                        catch (TransportException e) {
                            if (!e.getMessage().startsWith("Remote does not have ")) {
                                throw new RemoteSyncException((Throwable)e);
                            }
                            subMon.setWorkRemaining(36);
                            break block22;
                        }
                    }
                    catch (Throwable throwable) {
                        subMon.setWorkRemaining(36);
                        throw throwable;
                    }
                    subMon.setWorkRemaining(36);
                }
                if (this.git.branchList().call().size() > 0) {
                    subMon.subTask(Messages.GitRemoteSyncConnection_17);
                    this.transport.push((ProgressMonitor)new EclipseGitProgressTransformer((IProgressMonitor)subMon.newChild(18)), null);
                    String command = String.valueOf(this.gitCommand()) + " merge " + remotePushBranch;
                    subMon.subTask(Messages.GitRemoteSyncConnection_18);
                    CommandRunner.CommandResults mergeResults = this.executeRemoteCommand(command, (IProgressMonitor)subMon.newChild(18));
                    if (mergeResults.getExitCode() != 0) {
                        throw new RemoteSyncException((Throwable)new RemoteExecutionException(String.valueOf(Messages.GRSC_GitMergeFailure) + mergeResults.getStderr()));
                    }
                }
            }
            catch (IOException e) {
                throw new RemoteSyncException((Throwable)e);
            }
            catch (InterruptedException e) {
                throw new RemoteSyncException((Throwable)e);
            }
            catch (RemoteConnectionException e) {
                throw new RemoteSyncException((Throwable)e);
            }
            catch (GitAPIException e) {
                throw new RemoteSyncException((Throwable)e);
            }
            catch (MissingConnectionException missingConnectionException) {
                if (monitor != null) {
                    monitor.done();
                }
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    public Set<IPath> getMergeConflictFiles() throws RemoteSyncException {
        if (!this.mergeMapInitialized) {
            this.readMergeConflictFiles();
        }
        return this.FileToMergePartsMap.keySet();
    }

    public String[] getMergeConflictParts(IFile localFile) throws RemoteSyncException {
        if (!this.mergeMapInitialized) {
            this.readMergeConflictFiles();
        }
        return this.FileToMergePartsMap.get(localFile.getProjectRelativePath());
    }

    public void setMergeAsResolved(IPath[] paths) throws RemoteSyncException {
        AddCommand addCommand = this.git.add();
        IPath[] iPathArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            IPath p = iPathArray[n2];
            addCommand.addFilepattern(p.toString());
            ++n2;
        }
        try {
            addCommand.call();
            StatusCommand statusCommand = this.git.status();
            Status status = statusCommand.call();
            IPath[] iPathArray2 = paths;
            int n3 = paths.length;
            int n4 = 0;
            while (n4 < n3) {
                IPath p = iPathArray2[n4];
                if (!status.getConflicting().contains(p.toString())) {
                    this.FileToMergePartsMap.remove(p);
                }
                ++n4;
            }
        }
        catch (GitAPIException e) {
            throw new RemoteSyncException((Throwable)e);
        }
    }

    public int getRemoteGitVersion(IProgressMonitor monitor) throws IOException, RemoteExecutionException, RemoteSyncException, MissingConnectionException {
        String command = String.valueOf(this.gitCommand()) + " --version";
        CommandRunner.CommandResults commandResults = null;
        try {
            try {
                IRemoteConnection conn = this.buildScenario.getRemoteConnection();
                commandResults = CommandRunner.executeRemoteCommand((IRemoteConnection)conn, (String)command, null, (IProgressMonitor)monitor);
            }
            catch (InterruptedException e) {
                throw new RemoteExecutionException((Throwable)e);
            }
            catch (RemoteConnectionException e) {
                throw new RemoteExecutionException((Throwable)e);
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
        if (commandResults.getExitCode() != 0) {
            throw new RemoteExecutionException(String.valueOf(Messages.GRSC_GitInitFailure) + commandResults.getStderr());
        }
        Matcher m = Pattern.compile("git version ([0-9]+)\\.([0-9]+)\\.([0-9]+).*").matcher(commandResults.getStdout().trim());
        if (m.matches()) {
            return Integer.parseInt(m.group(1)) * 10000 + Integer.parseInt(m.group(2)) * 100 + Integer.parseInt(m.group(3));
        }
        return 0;
    }

    public void checkout(IPath[] paths) throws RemoteSyncException {
        CheckoutCommand checkoutCommand = this.git.checkout();
        IPath[] iPathArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            IPath p = iPathArray[n2];
            checkoutCommand.addPath(p.toString());
            ++n2;
        }
        checkoutCommand.setStartPoint("HEAD");
        try {
            checkoutCommand.call();
        }
        catch (GitAPIException e) {
            throw new RemoteSyncException((Throwable)e);
        }
        this.doRefresh(null);
    }

    public void checkoutRemoteCopy(IPath[] paths) throws RemoteSyncException {
        CheckoutCommand checkoutCommand = this.git.checkout();
        IPath[] iPathArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            IPath p = iPathArray[n2];
            checkoutCommand.addPath(p.toString());
            ++n2;
        }
        checkoutCommand.setStartPoint("refs/remotes/eclipse_auto/master");
        try {
            checkoutCommand.call();
        }
        catch (GitAPIException e) {
            throw new RemoteSyncException((Throwable)e);
        }
        this.doRefresh(null);
    }

    private Thread doRefresh(final IProgressMonitor subMon) {
        Thread refreshWorkspaceThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    GitRemoteSyncConnection.this.project.refreshLocal(2, subMon);
                }
                catch (CoreException e) {
                    RDTSyncCorePlugin.log((String)Messages.GitRemoteSyncConnection_0, (Throwable)e);
                }
            }
        }, "Refresh workspace thread");
        refreshWorkspaceThread.start();
        return refreshWorkspaceThread;
    }

    private CommandRunner.CommandResults executeRemoteCommand(String command, IProgressMonitor monitor) throws RemoteSyncException, IOException, InterruptedException, RemoteConnectionException, MissingConnectionException {
        IRemoteConnection conn = this.buildScenario.getRemoteConnection();
        String remoteDirectory = this.buildScenario.getLocation(this.project);
        return CommandRunner.executeRemoteCommand((IRemoteConnection)conn, (String)command, (String)remoteDirectory, (IProgressMonitor)monitor);
    }

    private CommandRunner.CommandResults executeRemoteCommand(List<String> command, IProgressMonitor monitor) throws RemoteSyncException, IOException, InterruptedException, RemoteConnectionException, MissingConnectionException {
        IRemoteConnection conn = this.buildScenario.getRemoteConnection();
        String remoteDirectory = this.buildScenario.getLocation(this.project);
        return CommandRunner.executeRemoteCommand((IRemoteConnection)conn, command, (String)remoteDirectory, (IProgressMonitor)monitor);
    }

    private String gitCommand() {
        return "git --git-dir=.ptp-sync --work-tree=.";
    }

    public class PTPSession
    implements RemoteSession {
        private final URIish uri;

        public PTPSession(URIish uri) {
            this.uri = uri;
        }

        public Process exec(String command, int timeout) throws TransportException {
            LinkedList<String> commandList = new LinkedList<String>();
            commandList.add("sh");
            commandList.add("-c");
            commandList.add(command);
            try {
                IRemoteConnection connection = GitRemoteSyncConnection.this.buildScenario.getRemoteConnection();
                if (!connection.isOpen()) {
                    connection.open(null);
                }
                return (AbstractRemoteProcess)connection.getRemoteServices().getProcessBuilder(connection, commandList).start();
            }
            catch (IOException e) {
                throw new TransportException(this.uri, e.getMessage(), (Throwable)e);
            }
            catch (RemoteConnectionException e) {
                throw new TransportException(this.uri, e.getMessage(), (Throwable)e);
            }
            catch (MissingConnectionException e) {
                throw new TransportException(this.uri, String.valueOf(Messages.GitRemoteSyncConnection_3) + e.getConnectionName(), (Throwable)e);
            }
        }

        public void disconnect() {
        }
    }
}

