/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.sync.ui.wizards;

import java.util.EnumSet;
import org.eclipse.cdt.core.CCProjectNature;
import org.eclipse.cdt.core.CProjectNature;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.wizards.CDTCommonProjectWizard;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ptp.internal.rdt.sync.ui.SyncPluginImages;
import org.eclipse.ptp.rdt.sync.core.ISyncExceptionHandler;
import org.eclipse.ptp.rdt.sync.core.SyncFlag;
import org.eclipse.ptp.rdt.sync.core.SyncManager;
import org.eclipse.ptp.rdt.sync.ui.CommonSyncExceptionHandler;
import org.eclipse.ptp.rdt.sync.ui.RDTSyncUIPlugin;
import org.eclipse.ptp.rdt.sync.ui.messages.Messages;
import org.eclipse.ptp.rdt.sync.ui.wizards.NewRemoteSyncProjectWizardOperation;
import org.eclipse.ptp.rdt.sync.ui.wizards.SyncMainWizardPage;

public class NewRemoteSyncProjectWizard
extends CDTCommonProjectWizard {
    private static final String PREFIX = "CProjectWizard";
    private static final String wz_title = Messages.NewRemoteSyncProjectWizard_title;
    private static final String wz_desc = Messages.NewRemoteSyncProjectWizard_description;

    public NewRemoteSyncProjectWizard() {
        super(wz_title, wz_desc);
    }

    public void addPages() {
        this.fMainPage = new SyncMainWizardPage(CUIPlugin.getResourceString((String)PREFIX));
        this.fMainPage.setTitle(wz_title);
        this.fMainPage.setDescription(wz_desc);
        this.addPage((IWizardPage)this.fMainPage);
    }

    public String[] getNatures() {
        return new String[]{"org.eclipse.cdt.core.cnature", "org.eclipse.cdt.core.ccnature", "org.eclipse.ptp.rdt.sync.core.remoteSyncNature"};
    }

    public boolean performFinish() {
        boolean autoBuildWasSet = NewRemoteSyncProjectWizard.setAutoBuild(false);
        boolean success = false;
        IProject project = null;
        try {
            success = super.performFinish();
            if (success) {
                project = this.getProject(true);
                NewRemoteSyncProjectWizardOperation.run(project, (SyncMainWizardPage)this.fMainPage, null);
            }
        }
        finally {
            NewRemoteSyncProjectWizard.setAutoBuild(autoBuildWasSet);
        }
        if (success && project != null) {
            try {
                SyncManager.sync(null, (IProject)project, (EnumSet)SyncFlag.FORCE, (ISyncExceptionHandler)new CommonSyncExceptionHandler(false, true));
            }
            catch (CoreException e) {
                RDTSyncUIPlugin.log(Messages.NewRemoteSyncProjectWizard_0, e);
            }
        }
        return success;
    }

    private static boolean setAutoBuild(boolean shouldBeEnabled) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceDescription desc = workspace.getDescription();
        boolean isAutoBuilding = desc.isAutoBuilding();
        if (isAutoBuilding != shouldBeEnabled) {
            desc.setAutoBuilding(shouldBeEnabled);
            try {
                workspace.setDescription(desc);
            }
            catch (CoreException e) {
                RDTSyncUIPlugin.log(e);
            }
        }
        return isAutoBuilding;
    }

    protected IProject continueCreation(IProject prj) {
        try {
            CProjectNature.addCNature((IProject)prj, (IProgressMonitor)new NullProgressMonitor());
            CCProjectNature.addCCNature((IProject)prj, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException coreException) {}
        return prj;
    }

    protected void initializeDefaultPageImageDescriptor() {
        this.setDefaultPageImageDescriptor(SyncPluginImages.DESC_WIZBAN_NEW_REMOTE_C_PROJ);
    }
}

