/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.slurm.core.rtsystem;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.ptp.core.attributes.IAttribute;
import org.eclipse.ptp.core.attributes.IllegalValueException;
import org.eclipse.ptp.rm.core.proxy.AbstractRemoteProxyRuntimeClient;
import org.eclipse.ptp.rm.core.proxy.AbstractRemoteProxyRuntimeSystem;
import org.eclipse.ptp.rm.slurm.core.SLURMJobAttributes;
import org.eclipse.ptp.rm.slurm.core.SLURMLaunchConfiguration;
import org.eclipse.ptp.rm.slurm.core.rtsystem.SLURMProxyRuntimeClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SLURMRuntimeSystem
extends AbstractRemoteProxyRuntimeSystem {
    public SLURMRuntimeSystem(SLURMProxyRuntimeClient proxy) {
        super((AbstractRemoteProxyRuntimeClient)proxy);
    }

    public List<IAttribute<?, ?, ?>> getAttributes(ILaunchConfiguration configuration, String mode) throws CoreException {
        String jobExcNodeList;
        String jobReqNodeList;
        List attrs = super.getAttributes(configuration, mode);
        int jobnumProcs = configuration.getAttribute(SLURMLaunchConfiguration.ATTR_NUMPROCS, -1);
        try {
            attrs.add(SLURMJobAttributes.getJobNumberOfProcsAttributeDefinition().create(Integer.valueOf(jobnumProcs)));
        }
        catch (IllegalValueException illegalValueException) {}
        int jobNumNodes = configuration.getAttribute(SLURMLaunchConfiguration.ATTR_NUMNODES, -1);
        try {
            attrs.add(SLURMJobAttributes.getJobNumberOfNodesAttributeDefinition().create(Integer.valueOf(jobNumNodes)));
        }
        catch (IllegalValueException illegalValueException) {}
        int jobTimeLimit = configuration.getAttribute(SLURMLaunchConfiguration.ATTR_TIMELIMIT, -1);
        try {
            attrs.add(SLURMJobAttributes.getJobTimelimitAttributeDefinition().create(Integer.valueOf(jobTimeLimit)));
        }
        catch (IllegalValueException illegalValueException) {}
        String jobPartition = configuration.getAttribute(SLURMLaunchConfiguration.ATTR_JOBPARTITION, "");
        if (jobPartition.length() > 0) {
            attrs.add(SLURMJobAttributes.getJobPartitionAttributeDefinition().create(jobPartition));
        }
        if ((jobReqNodeList = configuration.getAttribute(SLURMLaunchConfiguration.ATTR_JOBREQNODELIST, "")).length() > 0) {
            attrs.add(SLURMJobAttributes.getJobReqNodeListAttributeDefinition().create(jobReqNodeList));
        }
        if ((jobExcNodeList = configuration.getAttribute(SLURMLaunchConfiguration.ATTR_JOBEXCNODELIST, "")).length() > 0) {
            attrs.add(SLURMJobAttributes.getJobExcNodeListAttributeDefinition().create(jobExcNodeList));
        }
        return attrs;
    }
}

