/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.lml.monitor.ui;

import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ptp.rm.lml.monitor.ui.LMLMonitorUIPlugin;

public class ExtensionUtils {
    private static final String EXTENSION_POINT = "monitors";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_NAME = "name";
    private static Map<String, String> fMonitorsByName = new TreeMap<String, String>();
    private static Map<String, String> fMonitorsByType = new TreeMap<String, String>();

    public static String getMonitorName(String type) {
        ExtensionUtils.loadExtensions();
        if (type != null) {
            return fMonitorsByType.get(type);
        }
        return null;
    }

    public static String[] getMonitorNames() {
        ExtensionUtils.loadExtensions();
        TreeSet<String> set = new TreeSet<String>();
        set.addAll(fMonitorsByName.keySet());
        return set.toArray(new String[0]);
    }

    public static String getMonitorType(String name) {
        ExtensionUtils.loadExtensions();
        if (name != null) {
            return fMonitorsByName.get(name);
        }
        return null;
    }

    public static String[] getMonitorTypes() {
        ExtensionUtils.loadExtensions();
        TreeSet<String> set = new TreeSet<String>();
        set.addAll(fMonitorsByType.keySet());
        return set.toArray(new String[0]);
    }

    private static void loadExtensions() {
        IExtensionRegistry registry;
        IExtensionPoint extensionPoint;
        if (fMonitorsByName.isEmpty() && (extensionPoint = (registry = Platform.getExtensionRegistry()).getExtensionPoint(LMLMonitorUIPlugin.getUniqueIdentifier(), EXTENSION_POINT)) != null) {
            IExtension[] iExtensionArray = extensionPoint.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension ext = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = ext.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement ce = iConfigurationElementArray[n4];
                    String type = ce.getAttribute(ATTR_TYPE);
                    String name = ce.getAttribute(ATTR_NAME);
                    if (type != null && name != null) {
                        fMonitorsByName.put(name, type);
                        fMonitorsByType.put(type, name);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }

    private ExtensionUtils() {
    }
}

