/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.jaxb.control.ui.utils;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.ptp.rm.jaxb.control.ui.ICellEditorUpdateModel;
import org.eclipse.ptp.rm.jaxb.control.ui.IUpdateModel;
import org.eclipse.ptp.rm.jaxb.control.ui.handlers.ControlStateListener;
import org.eclipse.ptp.rm.jaxb.control.ui.launch.IJAXBLaunchConfigurationTab;
import org.eclipse.ptp.rm.jaxb.control.ui.messages.Messages;
import org.eclipse.ptp.rm.jaxb.control.ui.model.ViewerUpdateModel;
import org.eclipse.ptp.rm.jaxb.control.ui.utils.ControlWidgetBuilderUtils;
import org.eclipse.ptp.rm.jaxb.control.ui.utils.UpdateModelFactory;
import org.eclipse.ptp.rm.jaxb.core.IVariableMap;
import org.eclipse.ptp.rm.jaxb.core.data.AttributeType;
import org.eclipse.ptp.rm.jaxb.core.data.AttributeViewerType;
import org.eclipse.ptp.rm.jaxb.core.data.BrowseType;
import org.eclipse.ptp.rm.jaxb.core.data.ButtonGroupType;
import org.eclipse.ptp.rm.jaxb.core.data.ColumnDataType;
import org.eclipse.ptp.rm.jaxb.core.data.CompositeType;
import org.eclipse.ptp.rm.jaxb.core.data.ControlStateRuleType;
import org.eclipse.ptp.rm.jaxb.core.data.ControlStateType;
import org.eclipse.ptp.rm.jaxb.core.data.FillLayoutType;
import org.eclipse.ptp.rm.jaxb.core.data.FontType;
import org.eclipse.ptp.rm.jaxb.core.data.FormAttachmentType;
import org.eclipse.ptp.rm.jaxb.core.data.FormDataType;
import org.eclipse.ptp.rm.jaxb.core.data.FormLayoutType;
import org.eclipse.ptp.rm.jaxb.core.data.GridDataType;
import org.eclipse.ptp.rm.jaxb.core.data.GridLayoutType;
import org.eclipse.ptp.rm.jaxb.core.data.LayoutDataType;
import org.eclipse.ptp.rm.jaxb.core.data.LayoutType;
import org.eclipse.ptp.rm.jaxb.core.data.PushButtonType;
import org.eclipse.ptp.rm.jaxb.core.data.RowDataType;
import org.eclipse.ptp.rm.jaxb.core.data.RowLayoutType;
import org.eclipse.ptp.rm.jaxb.core.data.TabControllerType;
import org.eclipse.ptp.rm.jaxb.core.data.TabFolderType;
import org.eclipse.ptp.rm.jaxb.core.data.TabItemType;
import org.eclipse.ptp.rm.jaxb.core.data.ViewerItemsType;
import org.eclipse.ptp.rm.jaxb.core.data.WidgetType;
import org.eclipse.ptp.rm.jaxb.ui.util.WidgetBuilderUtils;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LaunchTabBuilder {
    private final IJAXBLaunchConfigurationTab tab;
    private final IVariableMap rmVarMap;
    private static final Map<String, Button> sources = new HashMap<String, Button>();
    private static final Map<ControlStateType, Control> targets = new HashMap<ControlStateType, Control>();

    public static Object createLayoutData(LayoutDataType layoutData) {
        if (layoutData != null) {
            if (layoutData.getRowData() != null) {
                RowDataType rowData = layoutData.getRowData();
                return WidgetBuilderUtils.createRowData((Integer)rowData.getHeight(), (Integer)rowData.getWidth(), (Boolean)rowData.isExclude());
            }
            if (layoutData.getGridData() != null) {
                GridDataType gridData = layoutData.getGridData();
                int style = WidgetBuilderUtils.getStyle((String)gridData.getStyle());
                int hAlign = WidgetBuilderUtils.getStyle((String)gridData.getHorizontalAlign());
                int vAlign = WidgetBuilderUtils.getStyle((String)gridData.getVerticalAlign());
                return WidgetBuilderUtils.createGridData((Integer)style, (Boolean)gridData.isGrabExcessHorizontal(), (Boolean)gridData.isGrabExcessVertical(), (Integer)gridData.getWidthHint(), (Integer)gridData.getHeightHint(), (Integer)gridData.getMinWidth(), (Integer)gridData.getMinHeight(), (Integer)gridData.getHorizontalSpan(), (Integer)gridData.getVerticalSpan(), (Integer)hAlign, (Integer)vAlign, (Integer)gridData.getHorizontalIndent(), (Integer)gridData.getVerticalIndent());
            }
            if (layoutData.getFormData() != null) {
                FormDataType formData = layoutData.getFormData();
                FormAttachment top = null;
                FormAttachment bottom = null;
                FormAttachment left = null;
                FormAttachment right = null;
                FormAttachmentType fad = formData.getTop();
                if (fad != null) {
                    top = WidgetBuilderUtils.createFormAttachment((String)fad.getAlignment(), (Integer)fad.getDenominator(), (Integer)fad.getNumerator(), (Integer)fad.getOffset());
                }
                if ((fad = formData.getBottom()) != null) {
                    bottom = WidgetBuilderUtils.createFormAttachment((String)fad.getAlignment(), (Integer)fad.getDenominator(), (Integer)fad.getNumerator(), (Integer)fad.getOffset());
                }
                if ((fad = formData.getLeft()) != null) {
                    left = WidgetBuilderUtils.createFormAttachment((String)fad.getAlignment(), (Integer)fad.getDenominator(), (Integer)fad.getNumerator(), (Integer)fad.getOffset());
                }
                if ((fad = formData.getRight()) != null) {
                    right = WidgetBuilderUtils.createFormAttachment((String)fad.getAlignment(), (Integer)fad.getDenominator(), (Integer)fad.getNumerator(), (Integer)fad.getOffset());
                }
                return WidgetBuilderUtils.createFormData((Integer)formData.getHeight(), (Integer)formData.getWidth(), (FormAttachment)top, (FormAttachment)bottom, (FormAttachment)left, right);
            }
        }
        return null;
    }

    public static void initialize() {
        sources.clear();
        targets.clear();
    }

    public LaunchTabBuilder(IJAXBLaunchConfigurationTab tab) throws Throwable {
        this.tab = tab;
        this.rmVarMap = tab.getParent().getJobControl().getEnvironment();
    }

    public ColumnViewer addAttributeViewer(AttributeViewerType descriptor, Composite parent) {
        Layout layout = this.createLayout(descriptor.getLayout());
        Object data = LaunchTabBuilder.createLayoutData(descriptor.getLayoutData());
        int style = WidgetBuilderUtils.getStyle((String)descriptor.getStyle());
        Button showHide = WidgetBuilderUtils.createCheckButton((Composite)parent, (String)Messages.ToggleShowHideSelectedAttributes, null);
        CheckboxTableViewer viewer = null;
        if ("table".equals(descriptor.getType())) {
            viewer = this.addCheckboxTableViewer(parent, data, layout, style, descriptor);
        } else if ("tree".equals(descriptor.getType())) {
            viewer = this.addCheckboxTreeViewer(parent, data, layout, style, descriptor);
        }
        if (viewer != null) {
            Collection<ICellEditorUpdateModel> rows = this.addRows((ColumnViewer)viewer, descriptor);
            ViewerUpdateModel model = UpdateModelFactory.createModel((ColumnViewer)viewer, descriptor, this.tab);
            for (ICellEditorUpdateModel row : rows) {
                row.setViewer(model);
            }
            viewer.setInput(rows);
            showHide.addSelectionListener((SelectionListener)model);
            model.setShowAll(showHide);
            this.tab.getLocalWidgets().put(viewer, model);
            ControlStateType cst = descriptor.getControlState();
            if (cst != null) {
                targets.put(cst, viewer.getControl());
            }
        }
        return viewer;
    }

    public Composite build(Composite parent) throws Throwable {
        FontType fd;
        this.tab.getLocalWidgets().clear();
        TabControllerType top = this.tab.getController();
        Layout layout = this.createLayout(top.getLayout());
        Object data = LaunchTabBuilder.createLayoutData(top.getLayoutData());
        int style = WidgetBuilderUtils.getStyle((String)top.getStyle());
        Composite composite = WidgetBuilderUtils.createComposite((Composite)parent, (Integer)style, (Layout)layout, (Object)data);
        this.addChildren(top.getTabFolderOrCompositeOrWidget(), composite);
        String attr = top.getBackground();
        if (attr != null) {
            composite.setBackground(WidgetBuilderUtils.getColor((String)attr));
        }
        if ((fd = top.getFont()) != null) {
            composite.setFont(WidgetBuilderUtils.getFont((FontType)fd));
        }
        this.maybeWireWidgets();
        return composite;
    }

    private void addBrowse(BrowseType browse, Composite control) {
        IUpdateModel model = UpdateModelFactory.createModel(control, browse, this.tab, this.rmVarMap, targets);
        if (model != null) {
            this.tab.getLocalWidgets().put(model.getControl(), model);
        }
    }

    private void addButtonGroup(ButtonGroupType descriptor, Composite parent) {
        ControlStateType cst;
        IUpdateModel model;
        Layout layout = this.createLayout(descriptor.getLayout());
        Object data = LaunchTabBuilder.createLayoutData(descriptor.getLayoutData());
        int style = WidgetBuilderUtils.getStyle((String)descriptor.getStyle());
        Object control = null;
        control = descriptor.isGroup() ? WidgetBuilderUtils.createGroup((Composite)parent, (Integer)style, (Layout)layout, (Object)data, (String)descriptor.getTitle()) : WidgetBuilderUtils.createComposite((Composite)parent, (Integer)style, (Layout)layout, (Object)data);
        String tooltip = descriptor.getTooltip();
        if (tooltip != null) {
            control.setToolTipText(this.rmVarMap.getString(tooltip));
        }
        if ((model = UpdateModelFactory.createModel(descriptor, control, this.tab, this.rmVarMap, sources, targets)) != null) {
            this.tab.getLocalWidgets().put(control, model);
        }
        if ((cst = descriptor.getControlState()) != null) {
            targets.put(cst, (Control)control);
        }
    }

    private CheckboxTableViewer addCheckboxTableViewer(Composite parent, Object data, Layout layout, int style, AttributeViewerType descriptor) {
        Table t = WidgetBuilderUtils.createTable((Composite)parent, (Integer)(style |= 0x10020), (Object)data);
        CheckboxTableViewer viewer = new CheckboxTableViewer(t);
        ControlWidgetBuilderUtils.setupAttributeTable(viewer, descriptor.getColumnData(), null, descriptor.isSort(), descriptor.isTooltipEnabled(), descriptor.isHeaderVisible(), descriptor.isLinesVisible());
        return viewer;
    }

    private CheckboxTreeViewer addCheckboxTreeViewer(Composite parent, Object data, Layout layout, int style, AttributeViewerType descriptor) {
        Tree t = WidgetBuilderUtils.createTree((Composite)parent, (Integer)(style |= 0x10020), (Object)data);
        CheckboxTreeViewer viewer = new CheckboxTreeViewer(t);
        ControlWidgetBuilderUtils.setupAttributeTree(viewer, descriptor.getColumnData(), null, descriptor.isSort(), descriptor.isTooltipEnabled(), descriptor.isHeaderVisible(), descriptor.isLinesVisible());
        return viewer;
    }

    private void addChildren(List<Object> children, Composite control) {
        for (Object o : children) {
            if (o instanceof TabFolderType) {
                this.addFolder((TabFolderType)o, control);
                continue;
            }
            if (o instanceof CompositeType) {
                this.addComposite((CompositeType)o, control);
                continue;
            }
            if (o instanceof WidgetType) {
                this.addWidget((WidgetType)o, control);
                continue;
            }
            if (o instanceof ButtonGroupType) {
                this.addButtonGroup((ButtonGroupType)o, control);
                continue;
            }
            if (o instanceof PushButtonType) {
                this.addPushButton((PushButtonType)o, control);
                continue;
            }
            if (o instanceof BrowseType) {
                this.addBrowse((BrowseType)o, control);
                continue;
            }
            if (!(o instanceof AttributeViewerType)) continue;
            this.addAttributeViewer((AttributeViewerType)o, control);
        }
    }

    private Composite addComposite(CompositeType descriptor, Composite parent) {
        ControlStateType cst;
        FontType fd;
        Layout layout = this.createLayout(descriptor.getLayout());
        Object data = LaunchTabBuilder.createLayoutData(descriptor.getLayoutData());
        int style = WidgetBuilderUtils.getStyle((String)descriptor.getStyle());
        Object composite = null;
        composite = descriptor.isGroup() ? WidgetBuilderUtils.createGroup((Composite)parent, (Integer)style, (Layout)layout, (Object)data, (String)descriptor.getTitle()) : WidgetBuilderUtils.createComposite((Composite)parent, (Integer)style, (Layout)layout, (Object)data);
        this.addChildren(descriptor.getTabFolderOrCompositeOrWidget(), (Composite)composite);
        String attr = descriptor.getBackground();
        if (attr != null) {
            composite.setBackground(WidgetBuilderUtils.getColor((String)attr));
        }
        if ((fd = descriptor.getFont()) != null) {
            composite.setFont(WidgetBuilderUtils.getFont((FontType)fd));
        }
        if ((cst = descriptor.getControlState()) != null) {
            targets.put(cst, (Control)composite);
        }
        return composite;
    }

    private CTabFolder addFolder(TabFolderType descriptor, Composite parent) {
        ControlStateType cst;
        FontType fd;
        String tt;
        Object data;
        CTabFolder folder = new CTabFolder(parent, WidgetBuilderUtils.getStyle((String)descriptor.getStyle()));
        Layout layout = this.createLayout(descriptor.getLayout());
        if (layout != null) {
            folder.setLayout(layout);
        }
        if ((data = LaunchTabBuilder.createLayoutData(descriptor.getLayoutData())) != null) {
            folder.setLayoutData(data);
        }
        if ((tt = descriptor.getTooltip()) != null) {
            folder.setToolTipText(tt);
        }
        List items = descriptor.getItem();
        int index = 0;
        for (TabItemType i : items) {
            this.addItem(folder, i, index++);
        }
        String attr = descriptor.getBackground();
        if (attr != null) {
            folder.setBackground(WidgetBuilderUtils.getColor((String)attr));
        }
        if ((fd = descriptor.getFont()) != null) {
            folder.setFont(WidgetBuilderUtils.getFont((FontType)fd));
        }
        if ((cst = descriptor.getControlState()) != null) {
            targets.put(cst, (Control)folder);
        }
        return folder;
    }

    private void addItem(CTabFolder folder, TabItemType descriptor, int index) {
        FontType fd;
        String attr;
        Object data;
        int style = WidgetBuilderUtils.getStyle((String)descriptor.getStyle());
        Layout layout = this.createLayout(descriptor.getLayout());
        if (layout != null) {
            folder.setLayout(layout);
        }
        if ((data = LaunchTabBuilder.createLayoutData(descriptor.getLayoutData())) != null) {
            folder.setLayoutData(data);
        }
        CTabItem item = WidgetBuilderUtils.createTabItem((CTabFolder)folder, (Integer)style, (String)descriptor.getTitle(), (String)descriptor.getTooltip(), (Integer)index);
        Composite control = WidgetBuilderUtils.createComposite((Composite)folder, (Integer)style, (Layout)layout, (Object)data);
        item.setControl((Control)control);
        String tt = descriptor.getTooltip();
        if (tt != null) {
            item.setToolTipText(tt);
        }
        if ((attr = descriptor.getBackground()) != null) {
            control.setBackground(WidgetBuilderUtils.getColor((String)attr));
        }
        if ((fd = descriptor.getFont()) != null) {
            control.setFont(WidgetBuilderUtils.getFont((FontType)fd));
        }
        this.addChildren(descriptor.getCompositeOrTabFolderOrWidget(), control);
        ControlStateType cst = descriptor.getControlState();
        if (cst != null) {
            targets.put(cst, (Control)control);
        }
    }

    private void addPushButton(PushButtonType button, Composite control) {
        UpdateModelFactory.createPushButton(control, button, this.tab, this.rmVarMap, targets);
    }

    private Collection<ICellEditorUpdateModel> addRows(ColumnViewer viewer, AttributeViewerType descriptor) {
        AttributeType a;
        ViewerItemsType items = descriptor.getItems();
        List columnData = descriptor.getColumnData();
        ICellEditorUpdateModel model = null;
        TreeMap<String, ICellEditorUpdateModel> hash = new TreeMap<String, ICellEditorUpdateModel>();
        Map vars = null;
        if (items.isAllPredefined()) {
            vars = this.rmVarMap.getAttributes();
            for (String key : vars.keySet()) {
                a = (AttributeType)vars.get(key);
                if (!a.isVisible()) continue;
                model = UpdateModelFactory.createModel(a, viewer, (List<ColumnDataType>)columnData, this.tab);
                hash.put(key, model);
            }
        }
        if (items.isAllDiscovered()) {
            vars = this.rmVarMap.getDiscovered();
            for (String key : vars.keySet()) {
                a = (AttributeType)vars.get(key);
                if (!a.isVisible()) continue;
                model = UpdateModelFactory.createModel(a, viewer, (List<ColumnDataType>)columnData, this.tab);
                hash.put(key, model);
            }
        }
        for (String key : items.getInclude()) {
            if (hash.containsKey(key)) continue;
            a = (AttributeType)this.rmVarMap.getAttributes().get(key);
            if (a == null) {
                a = (AttributeType)this.rmVarMap.getDiscovered().get(key);
            }
            if (a == null || !a.isVisible()) continue;
            model = UpdateModelFactory.createModel(a, viewer, (List<ColumnDataType>)columnData, this.tab);
            hash.put(key, model);
        }
        for (String key : items.getExclude()) {
            hash.remove(key);
        }
        for (ICellEditorUpdateModel m : hash.values()) {
            this.tab.getLocalWidgets().put(m.getControl(), m);
        }
        return hash.values();
    }

    private void addWidget(WidgetType widget, Composite control) {
        IUpdateModel model = UpdateModelFactory.createModel(control, widget, this.tab, this.rmVarMap, sources, targets);
        if (model != null) {
            this.tab.getLocalWidgets().put(model.getControl(), model);
        }
    }

    private Layout createLayout(LayoutType layout) {
        if (layout != null) {
            if (layout.getFillLayout() != null) {
                FillLayoutType fillLayout = layout.getFillLayout();
                return WidgetBuilderUtils.createFillLayout((String)fillLayout.getType(), (Integer)fillLayout.getMarginHeight(), (Integer)fillLayout.getMarginWidth(), (Integer)fillLayout.getSpacing());
            }
            if (layout.getRowLayout() != null) {
                RowLayoutType rowLayout = layout.getRowLayout();
                return WidgetBuilderUtils.createRowLayout((String)rowLayout.getType(), (Boolean)rowLayout.isCenter(), (Boolean)rowLayout.isFill(), (Boolean)rowLayout.isJustify(), (Boolean)rowLayout.isPack(), (Boolean)rowLayout.isWrap(), (Integer)rowLayout.getMarginHeight(), (Integer)rowLayout.getMarginWidth(), (Integer)rowLayout.getMarginTop(), (Integer)rowLayout.getMarginBottom(), (Integer)rowLayout.getMarginLeft(), (Integer)rowLayout.getMarginRight(), (Integer)rowLayout.getSpacing());
            }
            if (layout.getGridLayout() != null) {
                GridLayoutType gridLayout = layout.getGridLayout();
                return WidgetBuilderUtils.createGridLayout((Integer)gridLayout.getNumColumns(), (Boolean)gridLayout.isMakeColumnsEqualWidth(), (Integer)gridLayout.getHorizontalSpacing(), (Integer)gridLayout.getVerticalSpacing(), (Integer)gridLayout.getMarginWidth(), (Integer)gridLayout.getMarginHeight(), (Integer)gridLayout.getMarginLeft(), (Integer)gridLayout.getMarginRight(), (Integer)gridLayout.getMarginTop(), (Integer)gridLayout.getMarginBottom());
            }
            if (layout.getFormLayout() != null) {
                FormLayoutType formLayout = layout.getFormLayout();
                return WidgetBuilderUtils.createFormLayout((Integer)formLayout.getMarginHeight(), (Integer)formLayout.getMarginWidth(), (Integer)formLayout.getMarginTop(), (Integer)formLayout.getMarginBottom(), (Integer)formLayout.getMarginLeft(), (Integer)formLayout.getMarginRight(), (Integer)formLayout.getSpacing());
            }
        }
        return null;
    }

    private void maybeWireWidgets() throws Throwable {
        HashSet<ControlStateListener> listeners = new HashSet<ControlStateListener>();
        for (ControlStateType cst : targets.keySet()) {
            Control target = targets.get(cst);
            ControlStateRuleType rule = cst.getEnableIf();
            if (rule != null) {
                listeners.add(new ControlStateListener(target, rule, ControlStateListener.Action.ENABLE, sources, this.tab.getParent().getVariableMap()));
            } else {
                rule = cst.getDisableIf();
                if (rule != null) {
                    listeners.add(new ControlStateListener(target, rule, ControlStateListener.Action.DISABLE, sources, this.tab.getParent().getVariableMap()));
                }
            }
            rule = cst.getHideIf();
            if (rule != null) {
                listeners.add(new ControlStateListener(target, rule, ControlStateListener.Action.HIDE, sources, this.tab.getParent().getVariableMap()));
                continue;
            }
            rule = cst.getShowIf();
            if (rule == null) continue;
            listeners.add(new ControlStateListener(target, rule, ControlStateListener.Action.SHOW, sources, this.tab.getParent().getVariableMap()));
        }
        HashSet<Button> dependSet = new HashSet<Button>();
        for (ControlStateListener listener : listeners) {
            dependSet.clear();
            listener.findCyclicalDependecies(dependSet);
        }
        this.tab.setListeners(listeners);
    }
}

