/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.launch;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IPersistableSourceLocator;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.ptp.core.ModelManager;
import org.eclipse.ptp.core.jobs.IJobControl;
import org.eclipse.ptp.core.jobs.IJobListener;
import org.eclipse.ptp.core.jobs.IJobStatus;
import org.eclipse.ptp.core.jobs.JobManager;
import org.eclipse.ptp.core.util.LaunchUtils;
import org.eclipse.ptp.debug.core.IPDebugConfiguration;
import org.eclipse.ptp.debug.core.IPDebugger;
import org.eclipse.ptp.debug.core.PTPDebugCorePlugin;
import org.eclipse.ptp.debug.core.launch.IPLaunch;
import org.eclipse.ptp.debug.core.launch.PLaunch;
import org.eclipse.ptp.debug.ui.PTPDebugUIPlugin;
import org.eclipse.ptp.launch.PTPLaunchPlugin;
import org.eclipse.ptp.launch.messages.Messages;
import org.eclipse.ptp.launch.rulesengine.IRuleAction;
import org.eclipse.ptp.launch.rulesengine.ISynchronizationRule;
import org.eclipse.ptp.launch.rulesengine.RuleActionFactory;
import org.eclipse.ptp.launch.rulesengine.RuleFactory;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteConnectionManager;
import org.eclipse.ptp.remote.core.IRemoteFileManager;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.PTPRemoteCorePlugin;
import org.eclipse.ptp.rmsystem.IResourceManager;
import org.eclipse.ptp.rmsystem.IResourceManagerComponentConfiguration;

public abstract class AbstractParallelLaunchConfigurationDelegate
extends LaunchConfigurationDelegate {
    private final IJobListener fJobListener = new JobListener();
    protected Map<String, JobSubmission> jobSubmissions = Collections.synchronizedMap(new HashMap());

    public static IRemoteFileManager getLocalFileManager(ILaunchConfiguration configuration) throws CoreException {
        IRemoteServices localServices = PTPRemoteCorePlugin.getDefault().getDefaultServices();
        assert (localServices != null);
        IRemoteConnectionManager lconnMgr = localServices.getConnectionManager();
        assert (lconnMgr != null);
        IRemoteConnection lconn = lconnMgr.getConnection("Local");
        assert (lconn != null);
        IRemoteFileManager localFileManager = localServices.getFileManager(lconn);
        assert (localFileManager != null);
        return localFileManager;
    }

    public static IRemoteFileManager getRemoteFileManager(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        IResourceManager rm = LaunchUtils.getResourceManager((ILaunchConfiguration)configuration);
        if (rm != null) {
            IRemoteConnection rconn;
            IRemoteConnectionManager rconnMgr;
            IResourceManagerComponentConfiguration conf = rm.getControlConfiguration();
            IRemoteServices remoteServices = PTPRemoteCorePlugin.getDefault().getRemoteServices(conf.getRemoteServicesId(), monitor);
            if (remoteServices != null && (rconnMgr = remoteServices.getConnectionManager()) != null && (rconn = rconnMgr.getConnection(conf.getConnectionName())) != null && rconn.isOpen()) {
                return remoteServices.getFileManager(rconn);
            }
        }
        return null;
    }

    public ILaunch getLaunch(ILaunchConfiguration configuration, String mode) throws CoreException {
        return new PLaunch(configuration, mode, null);
    }

    protected void copyExecutable(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        boolean copyExecutable = LaunchUtils.getCopyExecutable((ILaunchConfiguration)configuration);
        if (copyExecutable) {
            String remotePath = LaunchUtils.getExecutablePath((ILaunchConfiguration)configuration);
            String localPath = configuration.getAttribute("org.eclipse.ptp.launch.ATTR_LOCAL_EXECUTABLE_PATH", null);
            if (localPath == null) {
                throw new CoreException((IStatus)new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), Messages.AbstractParallelLaunchConfigurationDelegate_1));
            }
            this.copyFileToRemoteHost(localPath, remotePath, configuration, monitor);
        }
    }

    protected void copyFileFromRemoteHost(String remotePath, String localPath, ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)15);
        try {
            IRemoteFileManager localFileManager = AbstractParallelLaunchConfigurationDelegate.getLocalFileManager(configuration);
            IRemoteFileManager remoteFileManager = AbstractParallelLaunchConfigurationDelegate.getRemoteFileManager(configuration, (IProgressMonitor)progress.newChild(5));
            if (progress.isCanceled()) {
                throw new CoreException((IStatus)new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), Messages.AbstractParallelLaunchConfigurationDelegate_Operation_cancelled_by_user, null));
            }
            if (remoteFileManager == null) {
                throw new CoreException((IStatus)new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), Messages.AbstractParallelLaunchConfigurationDelegate_0));
            }
            IFileStore rres = remoteFileManager.getResource(remotePath);
            if (!rres.fetchInfo(0, (IProgressMonitor)progress.newChild(5)).exists()) {
                throw new CoreException((IStatus)new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), Messages.AbstractParallelLaunchConfigurationDelegate_Remote_resource_does_not_exist));
            }
            IFileStore lres = localFileManager.getResource(localPath);
            rres.copy(lres, 2, (IProgressMonitor)progress.newChild(5));
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    protected void copyFileToRemoteHost(String localPath, String remotePath, ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)15);
        try {
            IRemoteFileManager localFileManager = AbstractParallelLaunchConfigurationDelegate.getLocalFileManager(configuration);
            IRemoteFileManager remoteFileManager = AbstractParallelLaunchConfigurationDelegate.getRemoteFileManager(configuration, (IProgressMonitor)progress.newChild(5));
            if (progress.isCanceled()) {
                throw new CoreException((IStatus)new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), Messages.AbstractParallelLaunchConfigurationDelegate_Operation_cancelled_by_user, null));
            }
            if (remoteFileManager == null) {
                throw new CoreException((IStatus)new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), Messages.AbstractParallelLaunchConfigurationDelegate_0));
            }
            IFileStore lres = localFileManager.getResource(localPath);
            if (!lres.fetchInfo(0, (IProgressMonitor)progress.newChild(5)).exists()) {
                throw new CoreException((IStatus)new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), Messages.AbstractParallelLaunchConfigurationDelegate_Local_resource_does_not_exist));
            }
            IFileStore rres = remoteFileManager.getResource(remotePath);
            lres.copy(rres, 2, (IProgressMonitor)progress.newChild(5));
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    protected abstract void doCleanupLaunch(IPLaunch var1);

    protected abstract void doCompleteJobLaunch(IPLaunch var1, IPDebugger var2);

    protected void doPostLaunchSynchronization(ILaunchConfiguration configuration) throws CoreException {
        if (configuration.getAttribute("org.eclipse.ptp.launch.ATTR_SYNC_AFTER", false)) {
            List rulesList = configuration.getAttribute("org.eclipse.ptp.launch.ATTR_SYNC_RULES", new ArrayList());
            RuleActionFactory ruleActFactory = new RuleActionFactory(configuration, (IProgressMonitor)new NullProgressMonitor());
            for (Object ruleObj : rulesList) {
                ISynchronizationRule syncRule = RuleFactory.createRuleFromString((String)ruleObj);
                if (!syncRule.isDownloadRule()) continue;
                IRuleAction action = ruleActFactory.getAction(syncRule);
                action.run();
            }
        }
    }

    protected void doPreLaunchSynchronization(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        if (configuration.getAttribute("org.eclipse.ptp.launch.ATTR_SYNC_BEFORE", false)) {
            RuleActionFactory ruleActFactory = new RuleActionFactory(configuration, monitor);
            try {
                List rulesList = configuration.getAttribute("org.eclipse.ptp.launch.ATTR_SYNC_RULES", new ArrayList());
                for (Object ruleObj : rulesList) {
                    ISynchronizationRule syncRule = RuleFactory.createRuleFromString((String)ruleObj);
                    if (!syncRule.isUploadRule()) continue;
                    IRuleAction action = ruleActFactory.getAction(syncRule);
                    action.run();
                }
            }
            finally {
                if (monitor != null) {
                    monitor.done();
                }
            }
        }
    }

    protected IPDebugConfiguration getDebugConfig(ILaunchConfiguration config) throws CoreException {
        return PTPDebugCorePlugin.getDefault().getDebugConfiguration(LaunchUtils.getDebuggerID((ILaunchConfiguration)config));
    }

    protected void setDefaultSourceLocator(ILaunch launch, ILaunchConfiguration configuration) throws CoreException {
        if (launch.getSourceLocator() == null) {
            IPersistableSourceLocator sourceLocator;
            String id = configuration.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_ID, null);
            if (id == null) {
                sourceLocator = PTPDebugUIPlugin.createDefaultSourceLocator();
                sourceLocator.initializeDefaults(configuration);
            } else {
                sourceLocator = DebugPlugin.getDefault().getLaunchManager().newSourceLocator(id);
                String memento = configuration.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, null);
                if (memento == null) {
                    sourceLocator.initializeDefaults(configuration);
                } else {
                    sourceLocator.initializeFromMemento(memento);
                }
            }
            launch.setSourceLocator((ISourceLocator)sourceLocator);
        }
    }

    protected void setSourceLocator(ILaunch launch, ILaunchConfiguration config) throws CoreException {
        this.setDefaultSourceLocator(launch, config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void submitJob(ILaunchConfiguration configuration, String mode, IPLaunch launch, IPDebugger debugger, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        try {
            IResourceManager rm = LaunchUtils.getResourceManager((ILaunchConfiguration)configuration);
            if (rm == null) {
                throw new CoreException((IStatus)new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), Messages.AbstractParallelLaunchConfigurationDelegate_No_ResourceManager));
            }
            JobManager.getInstance().addListener(rm.getControlConfiguration().getUniqueName(), this.fJobListener);
            String jobId = rm.submitJob(configuration, mode, (IProgressMonitor)progress.newChild(5));
            if (rm.getJobStatus(jobId, (IProgressMonitor)progress.newChild(50)).equals("UNDETERMINED")) {
                throw new CoreException((IStatus)new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), Messages.AbstractParallelLaunchConfigurationDelegate_UnableToDetermineJobStatus));
            }
            launch.setJobControl((IJobControl)rm);
            launch.setJobId(jobId);
            JobSubmission jobSub = new JobSubmission(launch, debugger);
            Map<String, JobSubmission> map = this.jobSubmissions;
            synchronized (map) {
                this.jobSubmissions.put(jobId, jobSub);
            }
            jobSub.schedule();
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    protected void verifyDebuggerPath(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        String dbgPath = LaunchUtils.getDebuggerExePath((ILaunchConfiguration)configuration);
        if (dbgPath == null) {
            throw new CoreException((IStatus)new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), Messages.AbstractParallelLaunchConfigurationDelegate_debuggerPathNotSpecified));
        }
        try {
            this.verifyResource(dbgPath, configuration, monitor);
            if (monitor.isCanceled()) {
                throw new CoreException((IStatus)new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), Messages.AbstractParallelLaunchConfigurationDelegate_Operation_cancelled_by_user, null));
            }
        }
        catch (CoreException e) {
            throw new CoreException((IStatus)new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), Messages.AbstractParallelLaunchConfigurationDelegate_Debugger_path_not_found, (Throwable)new FileNotFoundException(e.getLocalizedMessage())));
        }
    }

    protected IPath verifyExecutablePath(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        if (LaunchUtils.getCopyExecutable((ILaunchConfiguration)configuration)) {
            return new Path(LaunchUtils.getExecutablePath((ILaunchConfiguration)configuration));
        }
        String exePath = LaunchUtils.getExecutablePath((ILaunchConfiguration)configuration);
        try {
            IPath path = this.verifyResource(exePath, configuration, monitor);
            if (monitor.isCanceled()) {
                throw new CoreException((IStatus)new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), Messages.AbstractParallelLaunchConfigurationDelegate_Operation_cancelled_by_user, null));
            }
            return path;
        }
        catch (CoreException e) {
            throw new CoreException((IStatus)new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), Messages.AbstractParallelLaunchConfigurationDelegate_Application_file_does_not_exist, (Throwable)new FileNotFoundException(e.getLocalizedMessage())));
        }
    }

    protected void verifyLaunchAttributes(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)30);
        try {
            this.verifyExecutablePath(configuration, (IProgressMonitor)progress.newChild(10));
            String workPath = LaunchUtils.getWorkingDirectory((ILaunchConfiguration)configuration);
            if (workPath != null) {
                this.verifyResource(workPath, configuration, monitor);
            }
            if (progress.isCanceled()) {
                throw new CoreException((IStatus)new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), Messages.AbstractParallelLaunchConfigurationDelegate_Operation_cancelled_by_user, null));
            }
            if (mode.equals("debug")) {
                this.verifyDebuggerPath(configuration, (IProgressMonitor)progress.newChild(10));
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    protected IProject verifyProject(ILaunchConfiguration configuration) throws CoreException {
        String proName = LaunchUtils.getProjectName((ILaunchConfiguration)configuration);
        if (proName == null) {
            throw new CoreException((IStatus)new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), Messages.AbstractParallelLaunchConfigurationDelegate_Project_not_specified));
        }
        IProject project = LaunchUtils.getProject((String)proName);
        if (project == null || !project.exists() || !project.isOpen()) {
            throw new CoreException((IStatus)new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), Messages.AbstractParallelLaunchConfigurationDelegate_Project_does_not_exist_or_is_not_a_project));
        }
        return project;
    }

    protected IPath verifyResource(String path, ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        return PTPLaunchPlugin.getDefault().verifyResource(path, configuration, monitor);
    }

    protected String verifyWorkDirectory(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        String workPath = LaunchUtils.getWorkingDirectory((ILaunchConfiguration)configuration);
        IPath path = workPath == null ? this.verifyExecutablePath(configuration, monitor).removeLastSegments(1) : this.verifyResource(workPath, configuration, monitor);
        if (monitor.isCanceled()) {
            throw new CoreException((IStatus)new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), Messages.AbstractParallelLaunchConfigurationDelegate_Operation_cancelled_by_user, null));
        }
        return path.toString();
    }

    private final class JobListener
    implements IJobListener {
        private JobListener() {
        }

        public void jobAdded(IJobStatus status) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void jobChanged(IJobStatus status) {
            JobSubmission jobSub;
            Map<String, JobSubmission> map = AbstractParallelLaunchConfigurationDelegate.this.jobSubmissions;
            synchronized (map) {
                jobSub = AbstractParallelLaunchConfigurationDelegate.this.jobSubmissions.get(status.getJobId());
            }
            if (jobSub != null) {
                jobSub.statusChanged();
            }
        }
    }

    private class JobSubmission
    extends Job {
        private final IPLaunch fLaunch;
        private final IPDebugger fDebugger;
        private final ReentrantLock fSubLock;
        private final Condition fSubCondition;

        public JobSubmission(IPLaunch launch, IPDebugger debugger) {
            super(launch.getJobId());
            this.fSubLock = new ReentrantLock();
            this.fSubCondition = this.fSubLock.newCondition();
            this.fLaunch = launch;
            this.fDebugger = debugger;
            this.setSystem(true);
        }

        public void statusChanged() {
            this.fSubLock.lock();
            try {
                this.fSubCondition.signalAll();
            }
            finally {
                this.fSubLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected IStatus run(IProgressMonitor monitor) {
            SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            try {
                String jobId;
                IResourceManager rm;
                block27: {
                    rm = ModelManager.getInstance().getResourceManagerFromUniqueName(this.fLaunch.getJobControl().getControlId());
                    jobId = this.fLaunch.getJobId();
                    this.fSubLock.lock();
                    try {
                        try {
                            while (rm.getJobStatus(jobId, (IProgressMonitor)subMon.newChild(50)).getState().equals("SUBMITTED") && !subMon.isCanceled()) {
                                try {
                                    this.fSubCondition.await(100L, TimeUnit.MILLISECONDS);
                                }
                                catch (InterruptedException interruptedException) {}
                            }
                        }
                        catch (CoreException coreException) {
                            this.fSubLock.unlock();
                            break block27;
                        }
                    }
                    catch (Throwable throwable) {
                        this.fSubLock.unlock();
                        throw throwable;
                    }
                    this.fSubLock.unlock();
                }
                if (!subMon.isCanceled()) {
                    block29: {
                        AbstractParallelLaunchConfigurationDelegate.this.doCompleteJobLaunch(this.fLaunch, this.fDebugger);
                        this.fSubLock.lock();
                        try {
                            try {
                                while (!rm.getJobStatus(jobId, (IProgressMonitor)subMon.newChild(50)).getState().equals("COMPLETED") && !subMon.isCanceled()) {
                                    try {
                                        this.fSubCondition.await(1000L, TimeUnit.MILLISECONDS);
                                    }
                                    catch (InterruptedException interruptedException) {}
                                }
                            }
                            catch (CoreException coreException) {
                                this.fSubLock.unlock();
                                break block29;
                            }
                        }
                        catch (Throwable throwable) {
                            this.fSubLock.unlock();
                            throw throwable;
                        }
                        this.fSubLock.unlock();
                    }
                    if (!subMon.isCanceled()) {
                        try {
                            AbstractParallelLaunchConfigurationDelegate.this.doPostLaunchSynchronization(this.fLaunch.getLaunchConfiguration());
                        }
                        catch (CoreException e) {
                            PTPLaunchPlugin.log(e);
                        }
                        AbstractParallelLaunchConfigurationDelegate.this.doCleanupLaunch(this.fLaunch);
                        Map<String, JobSubmission> map = AbstractParallelLaunchConfigurationDelegate.this.jobSubmissions;
                        synchronized (map) {
                            AbstractParallelLaunchConfigurationDelegate.this.jobSubmissions.remove(jobId);
                            if (AbstractParallelLaunchConfigurationDelegate.this.jobSubmissions.size() == 0) {
                                JobManager.getInstance().removeListener(rm.getControlConfiguration().getUniqueName(), AbstractParallelLaunchConfigurationDelegate.this.fJobListener);
                            }
                        }
                    }
                }
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            finally {
                if (monitor != null) {
                    monitor.done();
                }
            }
        }
    }
}

