/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.services;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.model.views.QueryParameters;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.services.Experiment;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.services.TraceManagerService;
import org.eclipse.tracecompass.tmf.core.TmfCommonConstants;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.project.model.TmfTraceType;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfContext;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperiment;

@Path(value="/experiments")
public class ExperimentManagerService {
    private static final Map<UUID, TmfExperiment> EXPERIMENTS = Collections.synchronizedMap(new HashMap());
    private static final Map<UUID, List<UUID>> TRACE_UUIDS = Collections.synchronizedMap(new HashMap());
    private static final String EXPERIMENTS_FOLDER = "Experiments";
    private static final String TRACES_FOLDER = "Traces";
    private static final String SUFFIX = "_exp";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"application/json"})
    public Response getExperiments() {
        Map<UUID, TmfExperiment> map = EXPERIMENTS;
        synchronized (map) {
            List experiments = Lists.transform(new ArrayList<Map.Entry<UUID, TmfExperiment>>(EXPERIMENTS.entrySet()), e -> Experiment.from((TmfExperiment)e.getValue(), (UUID)e.getKey()));
            return Response.ok((Object)experiments).build();
        }
    }

    @GET
    @Path(value="/{expUUID}")
    @Produces(value={"application/json"})
    public Response getExperiment(@PathParam(value="expUUID") UUID expUUID) {
        TmfExperiment experiment = EXPERIMENTS.get(expUUID);
        if (experiment != null) {
            return Response.ok((Object)Experiment.from(experiment, expUUID)).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @GET
    @Path(value="/{expUUID}/outputs")
    @Produces(value={"application/json"})
    public Response getOutputs(@PathParam(value="expUUID") UUID expUUID) {
        return Response.status((Response.Status)Response.Status.NOT_IMPLEMENTED).entity((Object)("Not implemented for " + expUUID)).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="/{expUUID}")
    @Produces(value={"application/json"})
    public Response deleteExperiment(@PathParam(value="expUUID") UUID expUUID) {
        TmfExperiment experiment = EXPERIMENTS.remove(expUUID);
        if (experiment == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        Experiment entity = Experiment.from(experiment, expUUID);
        TRACE_UUIDS.remove(expUUID);
        TmfSignalManager.dispatchSignal((TmfSignal)new TmfTraceClosedSignal((Object)this, (ITmfTrace)experiment));
        experiment.dispose();
        IResource resource = experiment.getResource();
        boolean deleteResources = true;
        Map<UUID, TmfExperiment> map = EXPERIMENTS;
        synchronized (map) {
            for (TmfExperiment e : EXPERIMENTS.values()) {
                if (!resource.equals((Object)e.getResource())) continue;
                deleteResources = false;
                break;
            }
        }
        if (deleteResources) {
            try {
                ResourcesPlugin.getWorkspace().run(mon -> {
                    TmfTraceManager.deleteSupplementaryFolder((ITmfTrace)experiment);
                    resource.delete(true, null);
                }, (ISchedulingRule)experiment.getResource().getProject(), 1, null);
            }
            catch (CoreException e) {
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
            }
        }
        return Response.ok((Object)entity).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response postExperiment(QueryParameters queryParameters) {
        IFolder resource;
        Map<String, Object> parameters = queryParameters.getParameters();
        Object nameObj = parameters.get("name");
        Object tracesObj = parameters.get("traces");
        if (!(nameObj instanceof String) || !(tracesObj instanceof List)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        String name = (String)nameObj;
        ArrayList<UUID> traceUUIDs = new ArrayList<UUID>();
        ArrayList<IResource> traceResources = new ArrayList<IResource>();
        for (Object uuidObj : (List)tracesObj) {
            if (!(uuidObj instanceof String)) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            UUID uuid2 = UUID.fromString((String)uuidObj);
            IResource traceResource = TraceManagerService.getTraceResource(uuid2);
            if (traceResource == null) {
                return Response.noContent().build();
            }
            traceResources.add(traceResource);
            traceUUIDs.add(uuid2);
        }
        UUID expUUID = UUID.nameUUIDFromBytes(Objects.requireNonNull(name.getBytes(Charset.defaultCharset())));
        try {
            resource = ExperimentManagerService.getExperimentResource(name);
            if (resource.exists()) {
                HashMultiset newTraceResources;
                HashMultiset oldTraceResources = HashMultiset.create(ExperimentManagerService.getTraceResources(resource));
                if (!oldTraceResources.equals((Object)(newTraceResources = HashMultiset.create(traceResources)))) {
                    TmfExperiment oldExperiment = new TmfExperiment(ITmfEvent.class, resource.getLocation().toOSString(), new ITmfTrace[0], 5000, (IResource)resource);
                    Experiment entity = Experiment.from(oldExperiment, expUUID);
                    oldExperiment.dispose();
                    return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)entity).build();
                }
                TmfExperiment experiment = EXPERIMENTS.get(expUUID);
                if (experiment != null) {
                    return Response.ok((Object)Experiment.from(experiment, expUUID)).build();
                }
            } else {
                ExperimentManagerService.createExperiment(resource, traceResources);
            }
            ExperimentManagerService.createSupplementaryFolder(resource);
        }
        catch (CoreException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
        ITmfTrace[] traces = Lists.transform(traceUUIDs, uuid -> TraceManagerService.createTraceInstance(uuid)).toArray(new ITmfTrace[0]);
        TmfExperiment experiment = new TmfExperiment(ITmfEvent.class, resource.getLocation().toOSString(), traces, 5000, (IResource)resource);
        experiment.indexTrace(false);
        ITmfContext ctx = experiment.seekEvent(0L);
        experiment.getNext(ctx);
        ctx.dispose();
        TmfSignalManager.dispatchSignal((TmfSignal)new TmfTraceOpenedSignal((Object)this, (ITmfTrace)experiment, null));
        TRACE_UUIDS.put(expUUID, traceUUIDs);
        EXPERIMENTS.put(expUUID, experiment);
        return Response.ok((Object)Experiment.from(experiment, expUUID)).build();
    }

    private static IFolder getExperimentResource(String name) throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(TmfCommonConstants.DEFAULT_TRACE_PROJECT_NAME);
        project.refreshLocal(2, null);
        IFolder experimentsFolder = project.getFolder(EXPERIMENTS_FOLDER);
        return experimentsFolder.getFolder(name);
    }

    private static List<IResource> getTraceResources(final IFolder folder) {
        final ArrayList<IResource> list = new ArrayList<IResource>();
        final IFolder tracesFolder = folder.getProject().getFolder(TRACES_FOLDER);
        try {
            folder.accept(new IResourceProxyVisitor(){

                public boolean visit(IResourceProxy resource) throws CoreException {
                    if (resource.getType() == 1) {
                        IResource traceResourceUnderExperiment = resource.requestResource();
                        IPath relativePath = traceResourceUnderExperiment.getProjectRelativePath().makeRelativeTo(folder.getProjectRelativePath());
                        IResource traceResource = tracesFolder.findMember(relativePath);
                        if (traceResource != null) {
                            list.add(traceResource);
                        }
                        return false;
                    }
                    return true;
                }
            }, 0);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        list.sort(Comparator.comparing(resource -> resource.getFullPath().toString()));
        return list;
    }

    private static void createExperiment(IFolder folder, List<IResource> traceResources) throws CoreException {
        ExperimentManagerService.createFolder(folder);
        for (IResource traceResource : traceResources) {
            ExperimentManagerService.addTrace(folder, traceResource);
        }
        folder.setPersistentProperty(TmfCommonConstants.TRACETYPE, "org.eclipse.linuxtools.tmf.core.experiment.generic");
    }

    private static void addTrace(IFolder folder, IResource traceResource) throws CoreException {
        IPath relativePath = traceResource.getProjectRelativePath().removeFirstSegments(1);
        IFile file = folder.getFile(relativePath);
        ExperimentManagerService.createFolder((IFolder)file.getParent());
        file.create((InputStream)new ByteArrayInputStream(new byte[0]), false, (IProgressMonitor)new NullProgressMonitor());
        file.setPersistentProperty(TmfCommonConstants.TRACETYPE, TmfTraceType.getTraceTypeId((IResource)traceResource));
    }

    private static void createSupplementaryFolder(IFolder folder) throws CoreException {
        IFolder supplRootFolder = folder.getProject().getFolder(".tracing");
        IFolder supplFolder = supplRootFolder.getFolder(String.valueOf(folder.getName()) + SUFFIX);
        ExperimentManagerService.createFolder(supplFolder);
        folder.setPersistentProperty(TmfCommonConstants.TRACE_SUPPLEMENTARY_FOLDER, supplFolder.getLocation().toOSString());
    }

    private static void createFolder(IFolder folder) throws CoreException {
        if (!folder.exists()) {
            if (folder.getParent() instanceof IFolder) {
                ExperimentManagerService.createFolder((IFolder)folder.getParent());
            }
            folder.create(true, true, null);
        }
    }

    public static @Nullable TmfExperiment getExperimentByUUID(UUID expUUID) {
        return EXPERIMENTS.get(expUUID);
    }

    public static List<UUID> getTraceUUIDs(UUID expUUID) {
        return TRACE_UUIDS.getOrDefault(expUUID, Collections.emptyList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isTraceInUse(UUID uuid) {
        Map<UUID, List<UUID>> map = TRACE_UUIDS;
        synchronized (map) {
            return TRACE_UUIDS.values().stream().anyMatch(traceUUIDs -> traceUUIDs.contains(uuid));
        }
    }
}

