/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.webapp;

import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import javax.servlet.Servlet;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.services.DataProviderService;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.services.Experiment;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.services.ExperimentManagerService;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.services.FilterService;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.services.Trace;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.services.TraceManagerService;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.services.XmlManagerService;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.webapp.CORSFilter;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.webapp.DataProviderDescriptorSerializer;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.webapp.ExperimentSerializer;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.webapp.OutputElementStyleSerializer;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.webapp.SeriesModelSerializer;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.webapp.TimeGraphEntryModelSerializer;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.webapp.TimeGraphRowModelSerializer;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.webapp.TimeGraphStateSerializer;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.webapp.TmfTreeModelSerializer;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.webapp.TraceSerializer;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.webapp.TraceServerConfiguration;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.webapp.VirtualTableLineSerializer;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.webapp.XYModelSerializer;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.table.IVirtualTableLine;
import org.eclipse.tracecompass.internal.tmf.core.model.DataProviderDescriptor;
import org.eclipse.tracecompass.tmf.core.TmfCommonConstants;
import org.eclipse.tracecompass.tmf.core.model.OutputElementStyle;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphEntryModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphRowModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphState;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.model.xy.ISeriesModel;
import org.eclipse.tracecompass.tmf.core.model.xy.ITmfXyModel;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;

public class WebApplication {
    private static final String CONTEXT_PATH = "/tsp/api";
    private static final String PATH_SPEC = "/*";
    private Server fServer;
    private final TraceServerConfiguration fConfig;

    public WebApplication() {
        this(TraceServerConfiguration.create());
    }

    public WebApplication(TraceServerConfiguration config) {
        this.fConfig = config;
    }

    public void start() throws Exception {
        IFolder tracesFolder;
        ServletContextHandler sch = new ServletContextHandler();
        sch.setContextPath(CONTEXT_PATH);
        ResourceConfig rc = new ResourceConfig();
        rc.register(TraceManagerService.class);
        rc.register(ExperimentManagerService.class);
        rc.register(DataProviderService.class);
        rc.register(FilterService.class);
        rc.register(XmlManagerService.class);
        rc.register(CORSFilter.class);
        rc.register((Object)WebApplication.registerCustomMappers());
        ServletContainer sc = new ServletContainer(rc);
        ServletHolder holder = new ServletHolder((Servlet)sc);
        sch.addServlet(holder, PATH_SPEC);
        this.fServer = new Server();
        ServerConnector connector = WebApplication.getConnector(this.fServer, this.fConfig);
        this.fServer.addConnector((Connector)connector);
        this.fServer.setHandler((Handler)sch);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(TmfCommonConstants.DEFAULT_TRACE_PROJECT_NAME);
        if (!project.exists()) {
            project.create(null);
            if (!project.isOpen()) {
                project.open(null);
            }
            IProjectDescription description = project.getDescription();
            description.setNatureIds(new String[]{"org.eclipse.linuxtools.tmf.project.nature"});
            project.setDescription(description, null);
        }
        if (!project.isOpen()) {
            project.open(null);
        }
        if (!(tracesFolder = project.getFolder("Traces")).exists()) {
            tracesFolder.create(true, true, null);
        }
        this.fServer.start();
        if (this.fConfig.getPort() != 8378) {
            this.fServer.join();
        }
    }

    private static ServerConnector getConnector(Server server, TraceServerConfiguration config) {
        ServerConnector serverConnector = null;
        if (config.useSSL()) {
            SslContextFactory.Server contextFactory = new SslContextFactory.Server();
            contextFactory.setKeyStorePath(config.getKeystore());
            contextFactory.setKeyStorePassword(config.getKeystorePass());
            contextFactory.setTrustAll(true);
            HttpConfiguration httpsConfig = new HttpConfiguration();
            httpsConfig.setSecureScheme("https");
            httpsConfig.setOutputBufferSize(32768);
            httpsConfig.setRequestHeaderSize(16384);
            httpsConfig.setResponseHeaderSize(16384);
            httpsConfig.setSendServerVersion(true);
            httpsConfig.setSendDateHeader(false);
            SslConnectionFactory connector = new SslConnectionFactory((SslContextFactory)contextFactory, HttpVersion.HTTP_1_1.asString());
            serverConnector = new ServerConnector(server, new ConnectionFactory[]{connector, new HttpConnectionFactory(httpsConfig)});
        } else {
            serverConnector = new ServerConnector(server);
        }
        serverConnector.setPort(config.getPort());
        return serverConnector;
    }

    private static JacksonJaxbJsonProvider registerCustomMappers() {
        ObjectMapper mapper = new ObjectMapper();
        JacksonJaxbJsonProvider provider = new JacksonJaxbJsonProvider();
        provider.setMapper(mapper);
        SimpleModule module = new SimpleModule();
        module.addSerializer(Trace.class, (JsonSerializer)new TraceSerializer());
        module.addSerializer(Experiment.class, (JsonSerializer)new ExperimentSerializer());
        module.addSerializer(DataProviderDescriptor.class, (JsonSerializer)new DataProviderDescriptorSerializer());
        module.addSerializer(ITmfXyModel.class, (JsonSerializer)new XYModelSerializer());
        module.addSerializer(ISeriesModel.class, (JsonSerializer)new SeriesModelSerializer());
        module.addSerializer(TimeGraphState.class, (JsonSerializer)new TimeGraphStateSerializer());
        module.addSerializer(TimeGraphRowModel.class, (JsonSerializer)new TimeGraphRowModelSerializer());
        module.addSerializer(TimeGraphEntryModel.class, (JsonSerializer)new TimeGraphEntryModelSerializer());
        module.addSerializer(TmfTreeDataModel.class, (JsonSerializer)new TmfTreeModelSerializer());
        module.addSerializer(OutputElementStyle.class, (JsonSerializer)new OutputElementStyleSerializer());
        module.addSerializer(IVirtualTableLine.class, (JsonSerializer)new VirtualTableLineSerializer());
        mapper.registerModule((Module)module);
        return provider;
    }

    public void stop() {
        try {
            this.fServer.stop();
            ResourcesPlugin.getWorkspace().getRoot().getProject(TmfCommonConstants.DEFAULT_TRACE_PROJECT_NAME).close(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

