/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.ISemanticProblem;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPEnumeration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPPointerToMemberType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPReferenceType;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPArithmeticConversion;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBasicType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBuiltinParameter;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPFunctionType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPImplicitFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPReferenceType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPScope;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.OverloadableOperator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CVQualifier;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;

class BuiltinOperators {
    private static final ICPPFunction[] EMPTY = new ICPPFunction[0];
    private static final int FIRST = 0;
    private static final int SECOND = 1;
    private static final IType PTR_DIFF = new CPPBasicType(IBasicType.Kind.eInt, 0);
    private final OverloadableOperator fOperator;
    private final boolean fUnary;
    private IType fType1;
    private IType fType2;
    private IType[][] fClassConversionTypes = new IType[2][];
    private boolean[] fIsClass = new boolean[2];
    private IScope fFileScope;
    private List<ICPPFunction> fResult;
    private Set<String> fSignatures;
    private Object[] fGlobalCandidates;

    public static ICPPFunction[] create(OverloadableOperator operator, ICPPEvaluation[] args, Object[] globCandidates) {
        if (operator == null || args == null || args.length == 0) {
            return EMPTY;
        }
        return new BuiltinOperators(operator, args, globCandidates).create();
    }

    BuiltinOperators(OverloadableOperator operator, ICPPEvaluation[] args, Object[] globCandidates) {
        IType type;
        IASTNode point = CPPSemantics.getCurrentLookupPoint();
        this.fFileScope = point == null ? new CPPScope.CPPScopeProblem(null, 10) : point.getTranslationUnit().getScope();
        this.fOperator = operator;
        this.fUnary = args.length < 2;
        this.fGlobalCandidates = globCandidates;
        if (args.length > 0 && !((type = args[0].getType()) instanceof ISemanticProblem)) {
            this.fType1 = type;
        }
        if (args.length > 1 && !((type = args[1].getType()) instanceof ISemanticProblem)) {
            this.fType2 = type;
        }
    }

    private ICPPFunction[] create() {
        switch (this.fOperator) {
            case PAREN: 
            case ARROW: 
            case COMMA: 
            case NEW: 
            case DELETE_ARRAY: 
            case DELETE: 
            case NEW_ARRAY: {
                return EMPTY;
            }
            case DECR: 
            case INCR: {
                this.opIncOrDec();
                break;
            }
            case STAR: {
                if (this.fUnary) {
                    this.opDeref();
                    break;
                }
                this.binaryPromotedArithmetic(true, ReturnType.CONVERT);
                break;
            }
            case DIV: {
                this.binaryPromotedArithmetic(true, ReturnType.CONVERT);
                break;
            }
            case PLUS: {
                if (this.fUnary) {
                    this.unaryPointer();
                    this.unaryPromotedArithmetic(true);
                    break;
                }
                this.binaryPromotedArithmetic(true, ReturnType.CONVERT);
                this.pointerArithmetic(false, false);
                break;
            }
            case BRACKET: {
                this.pointerArithmetic(true, false);
                break;
            }
            case MINUS: {
                if (this.fUnary) {
                    this.unaryPromotedArithmetic(true);
                    break;
                }
                this.binaryPromotedArithmetic(true, ReturnType.CONVERT);
                this.pointerArithmetic(false, true);
                break;
            }
            case BITCOMPLEMENT: {
                this.unaryPromotedArithmetic(false);
                break;
            }
            case ARROWSTAR: {
                this.opArrowStar();
                break;
            }
            case NOTEQUAL: 
            case EQUAL: {
                this.binaryPromotedArithmetic(true, ReturnType.USE_BOOL);
                this.comparison(true);
                break;
            }
            case GT: 
            case LT: 
            case GTEQUAL: 
            case LTEQUAL: {
                this.binaryPromotedArithmetic(true, ReturnType.USE_BOOL);
                this.comparison(false);
                break;
            }
            case AMPER: {
                if (this.fUnary) {
                    return EMPTY;
                }
                this.binaryPromotedArithmetic(false, ReturnType.CONVERT);
                break;
            }
            case BITOR: 
            case XOR: 
            case MOD: {
                this.binaryPromotedArithmetic(false, ReturnType.CONVERT);
                break;
            }
            case SHIFTR: 
            case SHIFTL: {
                this.binaryPromotedArithmetic(false, ReturnType.USE_FIRST);
                break;
            }
            case ASSIGN: {
                this.arithmeticAssignement(true, Assignment.WITHOUT_OPERATION);
                break;
            }
            case MINUSASSIGN: 
            case PLUSASSIGN: {
                this.arithmeticAssignement(true, Assignment.WITH_POINTER_OPERATION);
                break;
            }
            case DIVASSIGN: 
            case STARASSIGN: {
                this.arithmeticAssignement(true, Assignment.WITH_OPERATION);
                break;
            }
            case SHIFTLASSIGN: 
            case SHIFTRASSIGN: 
            case BITORASSIGN: 
            case AMPERASSIGN: 
            case XORASSIGN: 
            case MODASSIGN: {
                this.arithmeticAssignement(false, Assignment.WITH_OPERATION);
                break;
            }
            case OR: 
            case AND: {
                this.addFunction(CPPBasicType.BOOLEAN, CPPBasicType.BOOLEAN, CPPBasicType.BOOLEAN);
                break;
            }
            case NOT: {
                this.addFunction((IType)CPPBasicType.BOOLEAN, CPPBasicType.BOOLEAN);
                break;
            }
            case CONDITIONAL_OPERATOR: {
                this.binaryPromotedArithmetic(true, ReturnType.CONVERT);
                this.conditional();
            }
        }
        if (this.fResult == null) {
            return EMPTY;
        }
        return this.fResult.toArray(new ICPPFunction[this.fResult.size()]);
    }

    private void opIncOrDec() {
        IType[] types;
        IType[] iTypeArray = types = this.getClassConversionTypes(0);
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IType nested;
            CVQualifier cvq;
            IType type = iTypeArray[n2];
            if ((type = SemanticUtil.getNestedType(type, 1)) instanceof ICPPReferenceType && !(cvq = SemanticUtil.getCVQualifier(nested = ((ICPPReferenceType)type).getType())).isConst()) {
                nested = SemanticUtil.getNestedType(nested, 9);
                boolean ok = false;
                if (BuiltinOperators.isArithmetic(nested)) {
                    if (this.fOperator == OverloadableOperator.INCR || !BuiltinOperators.isBoolean(type)) {
                        ok = true;
                    }
                } else if (this.isPointer(nested) && !(SemanticUtil.getNestedType(nested = ((IPointerType)nested).getType(), 1) instanceof IFunctionType)) {
                    ok = true;
                }
                if (ok) {
                    if (this.fType2 != null) {
                        this.addFunction(type, type, this.fType2);
                    } else {
                        this.addFunction(type, type);
                    }
                }
            }
            ++n2;
        }
    }

    private void opDeref() {
        IType[] types;
        IType[] iTypeArray = types = this.getClassConversionTypes(0);
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            if (this.isPointer(type = SemanticUtil.getNestedType(type, 5))) {
                ICPPFunctionType ft;
                IType nested = SemanticUtil.getNestedType(((IPointerType)type).getType(), 1);
                if (nested instanceof ICPPFunctionType && ((ft = (ICPPFunctionType)nested).isConst() || ft.isVolatile())) {
                    return;
                }
                this.addFunction((IType)new CPPReferenceType(nested, false), type);
            }
            ++n2;
        }
    }

    private void unaryPointer() {
        IType[] types;
        IType[] iTypeArray = types = this.getClassConversionTypes(0);
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            if (this.isPointer(type = SemanticUtil.getNestedType(type, 5))) {
                this.addFunction(type, type);
            }
            ++n2;
        }
    }

    private void unaryPromotedArithmetic(boolean includeFloatingPoint) {
        IType[] types;
        IType[] iTypeArray = types = this.getClassConversionTypes(0);
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            if (BuiltinOperators.isFloatingPoint(type = SemanticUtil.getNestedType(type, 13))) {
                if (includeFloatingPoint) {
                    this.addFunction(type, type);
                }
            } else if ((type = CPPArithmeticConversion.promoteCppType(type)) != null) {
                this.addFunction(type, type);
            }
            ++n2;
        }
    }

    private void opArrowStar() {
        IType type;
        IType[] types;
        ArrayList<IPointerType> classPointers = null;
        ArrayList<ICPPPointerToMemberType> memberPointers = null;
        IType[] iTypeArray = types = this.getClassConversionTypes(0);
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IPointerType ptrType;
            type = iTypeArray[n2];
            if (this.isPointer(type = SemanticUtil.getNestedType(type, 5)) && SemanticUtil.getNestedType((ptrType = (IPointerType)type).getType(), 9) instanceof ICPPClassType) {
                if (classPointers == null) {
                    classPointers = new ArrayList<IPointerType>();
                }
                classPointers.add(ptrType);
            }
            ++n2;
        }
        if (classPointers == null) {
            return;
        }
        iTypeArray = types = this.getClassConversionTypes(1);
        n = types.length;
        n2 = 0;
        while (n2 < n) {
            type = iTypeArray[n2];
            if ((type = SemanticUtil.getNestedType(type, 5)) instanceof ICPPPointerToMemberType) {
                if (memberPointers == null) {
                    memberPointers = new ArrayList<ICPPPointerToMemberType>();
                }
                memberPointers.add((ICPPPointerToMemberType)type);
            }
            ++n2;
        }
        if (memberPointers == null) {
            return;
        }
        for (IPointerType clsPtr : classPointers) {
            IType cvClass = SemanticUtil.getNestedType(clsPtr.getType(), 1);
            CVQualifier cv1 = SemanticUtil.getCVQualifier(cvClass);
            ICPPClassType c1 = (ICPPClassType)SemanticUtil.getNestedType(cvClass, 9);
            for (ICPPPointerToMemberType memPtr : memberPointers) {
                ICPPClassType c2;
                IType t2 = SemanticUtil.getNestedType(memPtr.getMemberOfClass(), 1);
                if (!(t2 instanceof ICPPClassType) || SemanticUtil.calculateInheritanceDepth(c1, c2 = (ICPPClassType)t2) < 0) continue;
                IType cvt = SemanticUtil.getNestedType(memPtr.getType(), 1);
                CPPReferenceType rt = new CPPReferenceType(SemanticUtil.addQualifiers(cvt, cv1.isConst(), cv1.isVolatile(), cv1.isRestrict()), false);
                this.addFunction(rt, clsPtr, memPtr);
            }
        }
    }

    private void binaryPromotedArithmetic(boolean fltPt, ReturnType rstrat) {
        IType t;
        List<IType> p1 = null;
        List<IType> p2 = null;
        IType[] types1 = this.getClassConversionTypes(0);
        IType[] types2 = this.getClassConversionTypes(1);
        if (types1.length == 0 && types2.length == 0) {
            return;
        }
        Object object = types1;
        int n = types1.length;
        int n2 = 0;
        while (n2 < n) {
            t = object[n2];
            p1 = this.addPromotedArithmetic(t, fltPt, p1);
            ++n2;
        }
        object = types2;
        n = types2.length;
        n2 = 0;
        while (n2 < n) {
            t = object[n2];
            p2 = this.addPromotedArithmetic(t, fltPt, p2);
            ++n2;
        }
        p1 = this.addPromotedArithmetic(this.fType1, fltPt, p1);
        p2 = this.addPromotedArithmetic(this.fType2, fltPt, p2);
        if (p1 == null || p2 == null) {
            return;
        }
        for (IType t1 : p1) {
            for (IType t2 : p2) {
                IType rt = null;
                switch (rstrat) {
                    case USE_BOOL: {
                        rt = CPPBasicType.BOOLEAN;
                        break;
                    }
                    case USE_FIRST: {
                        rt = t1;
                        break;
                    }
                    case CONVERT: {
                        rt = CPPArithmeticConversion.convertCppOperandTypes(4, t1, t2);
                    }
                }
                this.addFunction(rt, t1, t2);
            }
        }
    }

    private List<IType> addPromotedArithmetic(IType t, boolean fltPt, List<IType> p1) {
        IType type = SemanticUtil.getNestedType(t, 13);
        if (BuiltinOperators.isFloatingPoint(type)) {
            if (!fltPt) {
                type = null;
            }
        } else {
            type = CPPArithmeticConversion.promoteCppType(type);
        }
        if (type != null) {
            if (p1 == null) {
                p1 = new ArrayList<IType>();
            }
            p1.add(type);
        }
        return p1;
    }

    private void pointerArithmetic(boolean useRef, boolean isDiff) {
        IType retType;
        IType ptrTarget;
        IType uqPtrTarget;
        IType type;
        IType[] types = this.getClassConversionTypes(0);
        if (types.length == 0 && !this.fIsClass[0]) {
            types = new IType[]{this.fType1};
        }
        IType[] iTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            type = iTypeArray[n2];
            if (this.isPointer(type = SemanticUtil.getNestedType(type, 5)) && !((uqPtrTarget = SemanticUtil.getNestedType(ptrTarget = ((IPointerType)type).getType(), 9)) instanceof IFunctionType)) {
                retType = useRef ? new CPPReferenceType(ptrTarget, false) : type;
                this.addFunction(retType, type, PTR_DIFF);
                if (isDiff) {
                    this.addFunction(PTR_DIFF, type, type);
                }
            }
            ++n2;
        }
        types = this.getClassConversionTypes(1);
        if (types.length == 0 && !this.fIsClass[1]) {
            types = new IType[]{this.fType2};
        }
        iTypeArray = types;
        n = types.length;
        n2 = 0;
        while (n2 < n) {
            type = iTypeArray[n2];
            if (this.isPointer(type = SemanticUtil.getNestedType(type, 5)) && !((uqPtrTarget = SemanticUtil.getNestedType(ptrTarget = ((IPointerType)type).getType(), 9)) instanceof IFunctionType)) {
                if (isDiff) {
                    this.addFunction(PTR_DIFF, type, type);
                } else {
                    retType = useRef ? new CPPReferenceType(ptrTarget, false) : type;
                    this.addFunction(retType, PTR_DIFF, type);
                }
            }
            ++n2;
        }
    }

    private void comparison(boolean ordered) {
        int i = 0;
        while (i <= 1) {
            IType[] types;
            IType[] iTypeArray = types = this.getClassConversionTypes(i);
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                IType type = iTypeArray[n2];
                if (this.isPointer(type = SemanticUtil.getNestedType(type, 13)) || this.isEnumeration(type) || !ordered && this.isPointerToMember(type)) {
                    this.addFunction(CPPBasicType.BOOLEAN, type, type);
                }
                ++n2;
            }
            ++i;
        }
    }

    private void arithmeticAssignement(boolean fltPt, Assignment assign) {
        IType[] types2 = this.getClassConversionTypes(1);
        if (types2.length == 0) {
            return;
        }
        IType refType = SemanticUtil.getNestedType(this.fType1, 1);
        if (refType instanceof ICPPReferenceType) {
            IType t = SemanticUtil.getNestedType(((ICPPReferenceType)refType).getType(), 1);
            if (!SemanticUtil.getCVQualifier(t).isConst()) {
                switch (assign) {
                    case WITHOUT_OPERATION: {
                        if (!this.isEnumeration(t) && !this.isPointerToMember(t) && !this.isPointer(t)) break;
                        this.addFunction(refType, refType, SemanticUtil.getNestedType(t, 17));
                        return;
                    }
                    case WITH_POINTER_OPERATION: {
                        if (!this.isPointer(t)) break;
                        this.addFunction(refType, refType, PTR_DIFF);
                        return;
                    }
                }
            }
            if (fltPt ? BuiltinOperators.isArithmetic(t) : BuiltinOperators.isIntegral(t)) {
                List<IType> p2 = null;
                IType[] iTypeArray = types2;
                int n = types2.length;
                int n2 = 0;
                while (n2 < n) {
                    IType t2 = iTypeArray[n2];
                    p2 = this.addPromotedArithmetic(t2, fltPt, p2);
                    ++n2;
                }
                if (p2 != null) {
                    for (IType t2 : p2) {
                        this.addFunction(refType, refType, t2);
                    }
                }
            }
        }
    }

    private void conditional() {
        int i = 0;
        while (i <= 1) {
            IType[] types;
            IType[] iTypeArray = types = this.getClassConversionTypes(i);
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                IType type = iTypeArray[n2];
                if (this.isPointer(type = SemanticUtil.getNestedType(type, 13)) || this.isScopedEnumeration(type) || this.isPointerToMember(type)) {
                    this.addFunction(type, type, type);
                }
                ++n2;
            }
            ++i;
        }
    }

    private void addFunction(IType returnType, IType p1) {
        this.addFunction(returnType, new IType[]{p1});
    }

    private void addFunction(IType returnType, IType p1, IType p2) {
        this.addFunction(returnType, new IType[]{p1, p2});
    }

    private void addFunction(IType returnType, IType[] parameterTypes) {
        ICPPParameter[] parameter = new ICPPParameter[parameterTypes.length];
        CPPFunctionType functionType = new CPPFunctionType(returnType, parameterTypes, null);
        String sig = ASTTypeUtil.getType(functionType, true);
        if (this.fSignatures == null) {
            this.fSignatures = new HashSet<String>();
            if (this.fGlobalCandidates != null) {
                Object[] objectArray = this.fGlobalCandidates;
                int n = this.fGlobalCandidates.length;
                int n2 = 0;
                while (n2 < n) {
                    Object cand = objectArray[n2];
                    if (cand instanceof IFunction && !(cand instanceof ICPPMethod)) {
                        this.fSignatures.add(ASTTypeUtil.getType(((IFunction)cand).getType(), true));
                    }
                    ++n2;
                }
            }
        }
        if (this.fSignatures.add(sig)) {
            int i = 0;
            while (i < parameterTypes.length) {
                IType t = parameterTypes[i];
                parameter[i] = new CPPBuiltinParameter(t);
                ++i;
            }
            if (this.fResult == null) {
                this.fResult = new ArrayList<ICPPFunction>();
            }
            this.fResult.add(new CPPImplicitFunction(this.fOperator.toCharArray(), this.fFileScope, functionType, parameter, true, false));
        }
    }

    private boolean isEnumeration(IType type) {
        return type instanceof IEnumeration;
    }

    private boolean isScopedEnumeration(IType type) {
        return type instanceof ICPPEnumeration && ((ICPPEnumeration)type).isScoped();
    }

    private boolean isPointer(IType type) {
        return type instanceof IPointerType && !(type instanceof ICPPPointerToMemberType);
    }

    private boolean isPointerToMember(IType type) {
        return type instanceof ICPPPointerToMemberType;
    }

    private static boolean isBoolean(IType type) {
        return type instanceof IBasicType && ((IBasicType)type).getKind() == IBasicType.Kind.eBoolean;
    }

    public static boolean isFloatingPoint(IType type) {
        if (type instanceof IBasicType) {
            IBasicType.Kind kind = ((IBasicType)type).getKind();
            switch (kind) {
                case eFloat: 
                case eDouble: 
                case eFloat128: 
                case eDecimal32: 
                case eDecimal64: 
                case eDecimal128: {
                    return true;
                }
                case eUnspecified: 
                case eVoid: 
                case eChar: 
                case eWChar: 
                case eInt: 
                case eBoolean: 
                case eChar16: 
                case eChar32: 
                case eNullPtr: 
                case eInt128: {
                    return false;
                }
            }
        }
        return false;
    }

    private static boolean isArithmetic(IType type) {
        if (type instanceof IBasicType) {
            IBasicType.Kind kind = ((IBasicType)type).getKind();
            switch (kind) {
                case eChar: 
                case eWChar: 
                case eInt: 
                case eFloat: 
                case eDouble: 
                case eBoolean: 
                case eChar16: 
                case eChar32: 
                case eInt128: 
                case eFloat128: 
                case eDecimal32: 
                case eDecimal64: 
                case eDecimal128: {
                    return true;
                }
                case eUnspecified: 
                case eVoid: 
                case eNullPtr: {
                    return false;
                }
            }
        }
        return false;
    }

    public static boolean isIntegral(IType type) {
        if (type instanceof IBasicType) {
            IBasicType.Kind kind = ((IBasicType)type).getKind();
            switch (kind) {
                case eChar: 
                case eWChar: 
                case eInt: 
                case eBoolean: 
                case eChar16: 
                case eChar32: 
                case eInt128: {
                    return true;
                }
                case eUnspecified: 
                case eVoid: 
                case eFloat: 
                case eDouble: 
                case eNullPtr: 
                case eFloat128: 
                case eDecimal32: 
                case eDecimal64: 
                case eDecimal128: {
                    return false;
                }
            }
        }
        return false;
    }

    private IType[] getClassConversionTypes(int idx) {
        IType[] result = this.fClassConversionTypes[idx];
        if (result == null) {
            IType type;
            result = IType.EMPTY_TYPE_ARRAY;
            IType iType = type = idx == 0 ? this.fType1 : this.fType2;
            if (type != null && (type = SemanticUtil.getNestedType(type, 13)) instanceof ICPPClassType) {
                this.fIsClass[idx] = true;
                try {
                    ICPPMethod[] ops = SemanticUtil.getConversionOperators((ICPPClassType)type);
                    result = new IType[ops.length];
                    int j = -1;
                    ICPPMethod[] iCPPMethodArray = ops;
                    int n = ops.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IType retType;
                        ICPPFunctionType functionType;
                        ICPPMethod op = iCPPMethodArray[n2];
                        if (!op.isExplicit() && (functionType = op.getType()) != null && (retType = functionType.getReturnType()) != null) {
                            result[++j] = retType;
                        }
                        ++n2;
                    }
                    result = ArrayUtil.trimAt(IType.class, result, j);
                }
                catch (DOMException dOMException) {
                    // empty catch block
                }
            }
            this.fClassConversionTypes[idx] = result;
        }
        return result;
    }

    private static enum Assignment {
        WITHOUT_OPERATION,
        WITH_POINTER_OPERATION,
        WITH_OPERATION;

    }

    private static enum ReturnType {
        CONVERT,
        USE_FIRST,
        USE_BOOL;

    }
}

