/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.python;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.ease.AbstractCodeFactory;
import org.eclipse.ease.ICodeFactory;
import org.eclipse.ease.Logger;
import org.eclipse.ease.lang.python.PythonHelper;
import org.eclipse.ease.modules.EnvironmentModule;
import org.eclipse.ease.modules.IEnvironment;
import org.eclipse.ease.modules.ModuleHelper;
import org.eclipse.ease.tools.StringTools;

public class PythonCodeFactory
extends AbstractCodeFactory {
    public static List<String> RESERVED_KEYWORDS = new ArrayList<String>();
    private static final List<Class<?>> PRIMITIVES = Arrays.asList(Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Boolean.TYPE, Character.TYPE);

    static {
        RESERVED_KEYWORDS.add("and");
        RESERVED_KEYWORDS.add("as");
        RESERVED_KEYWORDS.add("assert");
        RESERVED_KEYWORDS.add("break");
        RESERVED_KEYWORDS.add("class");
        RESERVED_KEYWORDS.add("continue");
        RESERVED_KEYWORDS.add("def");
        RESERVED_KEYWORDS.add("del");
        RESERVED_KEYWORDS.add("elif");
        RESERVED_KEYWORDS.add("else");
        RESERVED_KEYWORDS.add("except");
        RESERVED_KEYWORDS.add("exec");
        RESERVED_KEYWORDS.add("finally");
        RESERVED_KEYWORDS.add("for");
        RESERVED_KEYWORDS.add("from");
        RESERVED_KEYWORDS.add("global");
        RESERVED_KEYWORDS.add("if");
        RESERVED_KEYWORDS.add("import");
        RESERVED_KEYWORDS.add("in");
        RESERVED_KEYWORDS.add("is");
        RESERVED_KEYWORDS.add("lambda");
        RESERVED_KEYWORDS.add("not");
        RESERVED_KEYWORDS.add("or");
        RESERVED_KEYWORDS.add("pass");
        RESERVED_KEYWORDS.add("print");
        RESERVED_KEYWORDS.add("raise");
        RESERVED_KEYWORDS.add("return");
        RESERVED_KEYWORDS.add("try");
        RESERVED_KEYWORDS.add("while");
        RESERVED_KEYWORDS.add("with");
        RESERVED_KEYWORDS.add("yield");
        RESERVED_KEYWORDS.add("__import__");
        RESERVED_KEYWORDS.add("abs");
        RESERVED_KEYWORDS.add("all");
        RESERVED_KEYWORDS.add("any");
        RESERVED_KEYWORDS.add("ascii");
        RESERVED_KEYWORDS.add("bin");
        RESERVED_KEYWORDS.add("bool");
        RESERVED_KEYWORDS.add("bytearray");
        RESERVED_KEYWORDS.add("bytes");
        RESERVED_KEYWORDS.add("callable");
        RESERVED_KEYWORDS.add("chr");
        RESERVED_KEYWORDS.add("classmethod");
        RESERVED_KEYWORDS.add("compile");
        RESERVED_KEYWORDS.add("complex");
        RESERVED_KEYWORDS.add("delattr");
        RESERVED_KEYWORDS.add("dict");
        RESERVED_KEYWORDS.add("dir");
        RESERVED_KEYWORDS.add("divmod");
        RESERVED_KEYWORDS.add("enumerate");
        RESERVED_KEYWORDS.add("eval");
        RESERVED_KEYWORDS.add("exec");
        RESERVED_KEYWORDS.add("filter");
        RESERVED_KEYWORDS.add("float");
        RESERVED_KEYWORDS.add("format");
        RESERVED_KEYWORDS.add("frozenset");
        RESERVED_KEYWORDS.add("getattr");
        RESERVED_KEYWORDS.add("globals");
        RESERVED_KEYWORDS.add("hasattr");
        RESERVED_KEYWORDS.add("hash");
        RESERVED_KEYWORDS.add("help");
        RESERVED_KEYWORDS.add("hex");
        RESERVED_KEYWORDS.add("id");
        RESERVED_KEYWORDS.add("input");
        RESERVED_KEYWORDS.add("int");
        RESERVED_KEYWORDS.add("isinstance");
        RESERVED_KEYWORDS.add("issubclass");
        RESERVED_KEYWORDS.add("iter");
        RESERVED_KEYWORDS.add("len");
        RESERVED_KEYWORDS.add("list");
        RESERVED_KEYWORDS.add("locals");
        RESERVED_KEYWORDS.add("map");
        RESERVED_KEYWORDS.add("max");
        RESERVED_KEYWORDS.add("memoryview");
        RESERVED_KEYWORDS.add("min");
        RESERVED_KEYWORDS.add("next");
        RESERVED_KEYWORDS.add("object");
        RESERVED_KEYWORDS.add("oct");
        RESERVED_KEYWORDS.add("open");
        RESERVED_KEYWORDS.add("ord");
        RESERVED_KEYWORDS.add("pow");
        RESERVED_KEYWORDS.add("print");
        RESERVED_KEYWORDS.add("property");
        RESERVED_KEYWORDS.add("range");
        RESERVED_KEYWORDS.add("repr");
        RESERVED_KEYWORDS.add("reversed");
        RESERVED_KEYWORDS.add("round");
        RESERVED_KEYWORDS.add("set");
        RESERVED_KEYWORDS.add("setattr");
        RESERVED_KEYWORDS.add("slice");
        RESERVED_KEYWORDS.add("sorted");
        RESERVED_KEYWORDS.add("staticmethod");
        RESERVED_KEYWORDS.add("str");
        RESERVED_KEYWORDS.add("sum");
        RESERVED_KEYWORDS.add("super");
        RESERVED_KEYWORDS.add("tuple");
        RESERVED_KEYWORDS.add("type");
        RESERVED_KEYWORDS.add("vars");
        RESERVED_KEYWORDS.add("zip");
    }

    protected static String getPythonClassIdentifier(Class<?> cls) {
        if (PRIMITIVES.contains(cls)) {
            return String.format("gateway.jvm.%s", cls.getName());
        }
        return cls.getName();
    }

    private static String toSafeNameStatic(String name) {
        while (RESERVED_KEYWORDS.contains(name)) {
            name = String.valueOf(name) + "_";
        }
        return name;
    }

    private static String indent(String code, String indentation) {
        if (code.isEmpty()) {
            return code;
        }
        return String.valueOf(indentation) + code.replaceAll("\n", "\n" + indentation).trim() + "\n";
    }

    protected static String buildArrayConversions(List<ICodeFactory.Parameter> parameters) {
        return parameters.stream().map(PythonCodeFactory::buildArrayConversion).collect(Collectors.joining(StringTools.LINE_DELIMITER));
    }

    protected static String buildArrayConversion(ICodeFactory.Parameter parameter) {
        StringBuilder builder = new StringBuilder();
        if (parameter.getClazz().isArray()) {
            String arrayType = PythonCodeFactory.getPythonClassIdentifier(parameter.getClazz().getComponentType());
            String variableName = PythonCodeFactory.toSafeNameStatic(parameter.getName());
            builder.append(String.format("if %s is not None:", variableName)).append(StringTools.LINE_DELIMITER);
            builder.append("    try:").append(StringTools.LINE_DELIMITER);
            builder.append(String.format("        tmp = gateway.new_array(%s, len(%s))", arrayType, variableName)).append(StringTools.LINE_DELIMITER);
            builder.append(String.format("        for index, value in enumerate(%s):", variableName)).append(StringTools.LINE_DELIMITER);
            builder.append("            tmp[index] = value").append(StringTools.LINE_DELIMITER);
            builder.append(String.format("        %s =  tmp", variableName)).append(StringTools.LINE_DELIMITER);
            builder.append("    except NameError:").append(StringTools.LINE_DELIMITER);
            builder.append("        pass").append(StringTools.LINE_DELIMITER);
        }
        return builder.toString();
    }

    private static String buildNumberConversions(List<ICodeFactory.Parameter> parameters) {
        StringBuilder builder = new StringBuilder();
        for (ICodeFactory.Parameter parameter : parameters) {
            if (!Double.TYPE.equals(parameter.getClazz()) && !Double.class.equals((Object)parameter.getClazz()) && !Float.TYPE.equals(parameter.getClazz()) && !Float.class.equals((Object)parameter.getClazz())) continue;
            builder.append(parameter.getName()).append(" = (").append(parameter.getName()).append(" * 1.0) if ").append(parameter.getName()).append(" else ").append(parameter.getName()).append(StringTools.LINE_DELIMITER);
        }
        return builder.toString();
    }

    protected String toSafeName(String name) {
        return PythonCodeFactory.toSafeNameStatic(name);
    }

    protected String createFieldWrapper(IEnvironment environment, String identifier, Field field) {
        StringBuilder pythonCode = new StringBuilder();
        pythonCode.append("import sys").append(StringTools.LINE_DELIMITER);
        pythonCode.append("if \"py4j\" in sys.modules:").append(StringTools.LINE_DELIMITER);
        pythonCode.append("    ");
        pythonCode.append(field.getName());
        pythonCode.append(" = py4j.java_gateway.get_field(");
        pythonCode.append(identifier);
        pythonCode.append(", \"");
        pythonCode.append(field.getName());
        pythonCode.append("\")");
        pythonCode.append(StringTools.LINE_DELIMITER);
        pythonCode.append("else:").append(StringTools.LINE_DELIMITER);
        pythonCode.append("    ");
        pythonCode.append(field.getName());
        pythonCode.append(" = ");
        pythonCode.append(identifier);
        pythonCode.append(".");
        pythonCode.append(field.getName());
        pythonCode.append(StringTools.LINE_DELIMITER);
        return pythonCode.toString();
    }

    public String createFunctionWrapper(IEnvironment environment, String moduleVariable, Method method) {
        StringBuilder pythonCode = new StringBuilder();
        List parameters = ModuleHelper.getParameters((Method)method);
        StringBuilder methodSignature = new StringBuilder();
        StringBuilder methodCall = new StringBuilder();
        for (ICodeFactory.Parameter parameter : parameters) {
            methodSignature.append(", ").append(this.toSafeName(parameter.getName()));
            methodCall.append(", ").append(this.toSafeName(parameter.getName()));
            if (!parameter.isOptional()) continue;
            methodSignature.append(" = ").append(this.getDefaultValue(parameter));
        }
        if (methodSignature.length() > 2) {
            methodSignature.delete(0, 2);
            methodCall.delete(0, 2);
        }
        String body = this.buildMethodBody(parameters, method, moduleVariable, environment);
        for (String name : PythonCodeFactory.getMethodNames((Method)method)) {
            if (!this.isValidMethodName(name)) {
                Logger.error((String)"org.eclipse.ease.lang.python", (String)("The method name \"" + name + "\" from the module \"" + moduleVariable + "\" can not be wrapped because it's name is reserved"));
                continue;
            }
            if (name.isEmpty()) continue;
            pythonCode.append("def ").append(name).append('(').append((CharSequence)methodSignature).append("):\n");
            pythonCode.append(PythonCodeFactory.indent(body, "    "));
            pythonCode.append('\n');
            pythonCode.append(name).append(".__ease__ = True\n");
            pythonCode.append('\n');
        }
        return pythonCode.toString();
    }

    private String buildMethodBody(List<ICodeFactory.Parameter> parameters, Method method, String classIdentifier, IEnvironment environment) {
        StringBuilder body = new StringBuilder();
        String methodId = ((EnvironmentModule)environment).registerMethod(method);
        if (ModuleHelper.isDeprecated((AccessibleObject)method)) {
            body.append(EnvironmentModule.getWrappedVariableName((Object)environment)).append(".printError(\"" + method.getName() + "() is deprecated. Consider updating your code.\", True)").append(StringTools.LINE_DELIMITER);
        }
        body.append(PythonCodeFactory.buildArrayConversions(parameters)).append(StringTools.LINE_DELIMITER);
        body.append(PythonCodeFactory.buildNumberConversions(parameters)).append(StringTools.LINE_DELIMITER);
        body.append("if not ").append(EnvironmentModule.getWrappedVariableName((Object)environment)).append(".hasMethodCallback(\"").append(methodId).append("\"):").append(StringTools.LINE_DELIMITER);
        body.append("    return ").append(classIdentifier).append(".").append(method.getName()).append("(").append(this.buildParameterList(parameters)).append(")").append(StringTools.LINE_DELIMITER);
        body.append(StringTools.LINE_DELIMITER);
        body.append("else:").append(StringTools.LINE_DELIMITER);
        if (environment.getScriptEngine().getDescription().getID().startsWith("org.eclipse.ease.lang.python.py4j")) {
            body.append("    ").append("parameters_array = gateway.new_array(gateway.jvm.Object, ").append(parameters.size()).append(")").append(StringTools.LINE_DELIMITER);
            int index = 0;
            while (index < parameters.size()) {
                body.append("    if ").append(this.toSafeName(parameters.get(index).getName())).append(" != None:").append(StringTools.LINE_DELIMITER);
                body.append("        ").append("parameters_array[").append(index).append("] = ").append(this.toSafeName(parameters.get(index).getName())).append(StringTools.LINE_DELIMITER);
                ++index;
            }
            body.append("    ").append(EnvironmentModule.getWrappedVariableName((Object)environment)).append(".preMethodCallback(\"").append(methodId).append("\", parameters_array)").append(StringTools.LINE_DELIMITER);
        } else {
            body.append("    ").append(EnvironmentModule.getWrappedVariableName((Object)environment)).append(".preMethodCallback(\"").append(methodId).append("\"").append(parameters.isEmpty() ? "" : ", ").append(this.buildParameterList(parameters)).append(")").append(StringTools.LINE_DELIMITER);
        }
        body.append("    ").append("__result").append(" = ").append(classIdentifier).append(".").append(method.getName()).append("(").append(this.buildParameterList(parameters)).append(")").append(StringTools.LINE_DELIMITER);
        body.append("    ").append(EnvironmentModule.getWrappedVariableName((Object)environment)).append(".postMethodCallback(\"").append(methodId).append("\"").append(", ").append("__result").append(")").append(StringTools.LINE_DELIMITER);
        body.append("    return ").append("__result").append(StringTools.LINE_DELIMITER);
        return body.toString();
    }

    public String getSaveVariableName(String variableName) {
        return PythonHelper.getSaveName(variableName);
    }

    public String classInstantiation(Class<?> clazz, String[] parameters) {
        StringBuilder code = new StringBuilder();
        code.append(clazz.getCanonicalName());
        code.append('(');
        if (parameters != null) {
            String[] stringArray = parameters;
            int n = parameters.length;
            int n2 = 0;
            while (n2 < n) {
                String parameter = stringArray[n2];
                code.append(parameter);
                code.append(", ");
                ++n2;
            }
            if (parameters.length > 0) {
                code.delete(code.length() - 2, code.length());
            }
        }
        code.append(')');
        return code.toString();
    }

    public boolean isValidMethodName(String methodName) {
        return PythonHelper.isSaveName(methodName) && !RESERVED_KEYWORDS.contains(methodName);
    }

    protected String getNullString() {
        return "None";
    }

    protected String getTrueString() {
        return "True";
    }

    protected String getFalseString() {
        return "False";
    }

    protected String getSingleLineCommentToken() {
        return "# ";
    }

    protected String getMultiLineCommentStartToken() {
        return "\"\"\"";
    }

    protected String getMultiLineCommentEndToken() {
        return this.getMultiLineCommentStartToken();
    }

    protected Object getLanguageIdentifier() {
        return "Python";
    }

    public String createPep302WrapperCode(EnvironmentModule environment, Object instance, String identifier) {
        return this.createWrapper((IEnvironment)environment, instance, identifier, false, environment.getScriptEngine());
    }
}

