/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules.platform;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.ease.IExecutionListener;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.Script;
import org.eclipse.ease.modules.AbstractScriptModule;
import org.eclipse.ease.modules.ScriptParameter;
import org.eclipse.ease.modules.WrapToScript;
import org.eclipse.ease.modules.platform.FilesystemHandle;
import org.eclipse.ease.modules.platform.IFileHandle;
import org.eclipse.ease.modules.platform.ResourceHandle;
import org.eclipse.ease.tools.ResourceTools;
import org.eclipse.ease.tools.RunnableWithResult;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.eclipse.ui.views.navigator.ResourceComparator;
import org.eclipse.ui.wizards.datatransfer.FileSystemStructureProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;

public class ResourcesModule
extends AbstractScriptModule
implements IExecutionListener {
    public static final String MODULE_ID = "/System/Resources";
    @WrapToScript
    public static final int READ = 1;
    @WrapToScript
    public static final int WRITE = 2;
    @WrapToScript
    public static final int APPEND = 4;
    private final Collection<IFileHandle> fOpenHandles = new HashSet<IFileHandle>();
    private static final String LINE_DELIMITER = System.getProperty("line.separator");

    @WrapToScript
    public static IWorkspaceRoot getWorkspace() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    @WrapToScript
    public static IProject getProject(String name) {
        return ResourcesModule.getWorkspace().getProject(name);
    }

    @WrapToScript
    public Object getFile(String location, @ScriptParameter(defaultValue="true") boolean exists) {
        Object resource = ResourceTools.resolve((Object)location, (Object)this.getScriptEngine().getExecutedFile());
        if (exists) {
            return this.fileExists(resource) ? resource : null;
        }
        return resource;
    }

    @WrapToScript
    public static IProject createProject(String name) {
        IProject project = ResourcesModule.getProject(name);
        if (!project.exists()) {
            try {
                project.create((IProgressMonitor)new NullProgressMonitor());
                project.open((IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                return null;
            }
        }
        return project;
    }

    @WrapToScript
    public Object createFolder(Object location) throws CoreException {
        Object folder = ResourceTools.resolve((Object)location, (Object)this.getScriptEngine().getExecutedFile());
        if (folder instanceof File) {
            if (!((File)folder).exists() && ((File)folder).mkdirs()) {
                return folder;
            }
        } else if (folder instanceof IResource) {
            if (folder instanceof IFile) {
                folder = ((IResource)folder).getProject().getFolder(((IResource)folder).getProjectRelativePath());
            }
            if (folder instanceof IFolder && !((IFolder)folder).exists()) {
                ((IFolder)folder).create(true, true, (IProgressMonitor)new NullProgressMonitor());
                return folder;
            }
        }
        return null;
    }

    @WrapToScript
    public Object createFile(Object location) throws Exception {
        IFileHandle handle = this.getFileHandle(location, 2, false);
        return handle.getFile();
    }

    @WrapToScript
    public IFileHandle openFile(Object location, @ScriptParameter(defaultValue="1") int mode, @ScriptParameter(defaultValue="true") boolean autoClose) throws Exception {
        return this.getFileHandle(location, mode, autoClose);
    }

    @WrapToScript
    public boolean fileExists(Object location) {
        Object resource = ResourceTools.resolve((Object)location, (Object)this.getScriptEngine().getExecutedFile());
        return resource != null && ResourceTools.exists((Object)resource) && ResourceTools.isFile((Object)resource);
    }

    @WrapToScript
    public void closeFile(IFileHandle handle) {
        this.fOpenHandles.remove(handle);
        handle.close();
    }

    @WrapToScript
    public String readFile(Object location, @ScriptParameter(defaultValue="-1") int bytes) throws Exception {
        IFileHandle handle = this.getFileHandle(location, 1, false);
        if (handle != null) {
            String result = handle.read(bytes);
            if (!(location instanceof IFileHandle)) {
                handle.close();
            }
            return result;
        }
        throw new IOException("File \"" + location + "\" not found");
    }

    @WrapToScript
    public void copyFile(Object sourceLocation, Object targetLocation) throws Exception {
        IFileHandle inputFile = this.getFileHandle(sourceLocation, -1, false);
        IFileHandle targetFile = this.getFileHandle(targetLocation, -1, false);
        if (targetFile != null) {
            Files.copy(inputFile.getPath(), targetFile.getPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        if (targetFile.getFile() instanceof IResource) {
            ((IResource)targetFile.getFile()).getParent().refreshLocal(1, null);
        }
    }

    @WrapToScript
    public void deleteFile(Object source) throws CoreException {
        Object file = ResourceTools.resolve((Object)source, (Object)this.getScriptEngine().getExecutedFile());
        if (ResourceTools.isFile((Object)file)) {
            if (file instanceof IFile) {
                ((IFile)file).delete(true, (IProgressMonitor)new NullProgressMonitor());
            } else if (file instanceof File) {
                ((File)file).delete();
            }
        }
    }

    @WrapToScript
    public void deleteFolder(Object source) throws CoreException {
        Object folder = ResourceTools.resolve((Object)source, (Object)this.getScriptEngine().getExecutedFile());
        if (ResourceTools.isFolder((Object)folder)) {
            if (folder instanceof IFolder) {
                ((IFolder)folder).delete(true, (IProgressMonitor)new NullProgressMonitor());
            } else if (folder instanceof File) {
                ((File)folder).delete();
            }
        }
    }

    @WrapToScript
    public void deleteProject(Object source) throws CoreException {
        IProject localProject;
        Object project = ResourceTools.resolve((Object)source, (Object)this.getScriptEngine().getExecutedFile());
        if (project instanceof IProject) {
            ((IProject)project).delete(true, (IProgressMonitor)new NullProgressMonitor());
        } else if (source != null && (localProject = ResourcesModule.getProject(source.toString())) != null) {
            localProject.delete(true, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    @WrapToScript
    public String readLine(Object location) throws Exception {
        IFileHandle handle = this.getFileHandle(location, 1, false);
        if (handle != null) {
            String result = handle.readLine();
            if (!(location instanceof IFileHandle)) {
                handle.close();
            }
            return result;
        }
        throw new IOException("File \"" + location + "\" not found");
    }

    @WrapToScript
    public IFileHandle writeFile(Object location, Object data, @ScriptParameter(defaultValue="2") int mode, @ScriptParameter(defaultValue="true") boolean autoClose) throws Exception {
        IFileHandle handle = this.getFileHandle(location, mode, autoClose);
        if (handle != null) {
            if (data instanceof byte[]) {
                handle.write((byte[])data);
            } else if (data != null) {
                handle.write(data.toString());
            }
        } else {
            throw new IOException("Could not access resource: " + location);
        }
        return handle;
    }

    @WrapToScript
    public IFileHandle writeLine(Object location, String data, @ScriptParameter(defaultValue="2") int mode, @ScriptParameter(defaultValue="true") boolean autoClose) throws Exception {
        IFileHandle handle = this.getFileHandle(location, mode, autoClose);
        if (handle == null) {
            throw new IOException("Could not access resource: " + location);
        }
        handle.write(String.valueOf(data) + LINE_DELIMITER);
        return handle;
    }

    private IFileHandle getFileHandle(Object location, int mode, boolean autoClose) throws Exception {
        IFileHandle handle = null;
        if (location instanceof String && ((String)location).isEmpty()) {
            handle = null;
        } else if (location instanceof IFileHandle) {
            handle = (IFileHandle)location;
        } else if (location instanceof File) {
            handle = new FilesystemHandle((File)location, mode);
        } else if (location instanceof IFile) {
            handle = new ResourceHandle((IFile)location, mode);
        } else if (location != null) {
            handle = this.getFileHandle(ResourceTools.resolve((Object)location, (Object)this.getScriptEngine().getExecutedFile()), mode, autoClose);
        }
        if (handle != null && !handle.exists()) {
            handle.createFile(true);
        }
        if (handle != null && autoClose) {
            this.fOpenHandles.add(handle);
            this.getScriptEngine().addExecutionListener((IExecutionListener)this);
        }
        if (handle != null) {
            return handle;
        }
        throw new IOException("Could not locate file \"" + location + "\"");
    }

    @WrapToScript
    public String showFileSelectionDialog(@ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") Object rootFolder, final @ScriptParameter(defaultValue="0") int type, final @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") String title, final @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") String message) {
        Object root = ResourceTools.resolve((Object)rootFolder, (Object)this.getScriptEngine().getExecutedFile());
        if (rootFolder == null) {
            root = ResourcesModule.getWorkspace();
        }
        if (root instanceof File) {
            int mode;
            switch (type) {
                case 2: 
                case 4: {
                    mode = 8192;
                    break;
                }
                default: {
                    mode = 4096;
                }
            }
            final File dialogRoot = (File)root;
            RunnableWithResult<String> runnable = new RunnableWithResult<String>(){

                public String runWithTry() throws Throwable {
                    FileDialog dialog = new FileDialog(Display.getDefault().getActiveShell(), mode);
                    if (title != null) {
                        dialog.setText(title);
                    }
                    dialog.setFilterPath(dialogRoot.getAbsolutePath());
                    return dialog.open();
                }
            };
            Display.getDefault().syncExec((Runnable)runnable);
            return (String)runnable.getResult();
        }
        if (root instanceof IContainer) {
            final IContainer dialogRoot = (IContainer)root;
            RunnableWithResult<String> runnable = new RunnableWithResult<String>(){

                public String runWithTry() throws Throwable {
                    if (type == 2 || type == 4) {
                        SaveAsDialog dialog = new SaveAsDialog(Display.getDefault().getActiveShell());
                        if (!dialogRoot.equals((Object)ResourcesModule.getWorkspace())) {
                            dialog.setOriginalFile(dialogRoot.getFile((IPath)new Path("newFile")));
                        }
                        dialog.setTitle(title);
                        dialog.setMessage(message);
                        if (dialog.open() == 0) {
                            return "workspace:/" + dialog.getResult().toPortableString();
                        }
                    } else {
                        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(Display.getDefault().getActiveShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
                        dialog.setTitle(title);
                        dialog.setMessage(message);
                        dialog.setInput((Object)dialogRoot);
                        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
                        if (dialog.open() == 0) {
                            return "workspace:/" + ((IResource)dialog.getFirstResult()).getFullPath().toPortableString();
                        }
                    }
                    return null;
                }
            };
            Display.getDefault().syncExec((Runnable)runnable);
            return (String)runnable.getResult();
        }
        return null;
    }

    @WrapToScript
    public String showFolderSelectionDialog(@ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") Object rootFolder, final @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") String title, final @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") String message) {
        Object root = ResourceTools.resolve((Object)rootFolder, (Object)this.getScriptEngine().getExecutedFile());
        if (rootFolder == null) {
            root = ResourcesModule.getWorkspace();
        }
        if (root instanceof File) {
            final File dialogRoot = (File)root;
            RunnableWithResult<String> runnable = new RunnableWithResult<String>(){

                public String runWithTry() throws Throwable {
                    DirectoryDialog dialog = new DirectoryDialog(Display.getCurrent().getActiveShell());
                    if (title != null) {
                        dialog.setText(title);
                    }
                    if (message != null) {
                        dialog.setMessage(message);
                    }
                    dialog.setFilterPath(dialogRoot.getAbsolutePath());
                    return dialog.open();
                }
            };
            Display.getDefault().syncExec((Runnable)runnable);
            return (String)runnable.getResult();
        }
        if (root instanceof IContainer) {
            final IContainer dialogRoot = (IContainer)root;
            RunnableWithResult<String> runnable = new RunnableWithResult<String>(){

                public String runWithTry() throws Throwable {
                    ContainerSelectionDialog dialog = new ContainerSelectionDialog(Display.getDefault().getActiveShell(), dialogRoot, true, message);
                    dialog.setTitle(title);
                    if (dialog.open() == 0) {
                        return "workspace:/" + ((IPath)dialog.getResult()[0]).toPortableString();
                    }
                    return null;
                }
            };
            Display.getDefault().syncExec((Runnable)runnable);
            return (String)runnable.getResult();
        }
        return null;
    }

    @WrapToScript
    public Object[] findFiles(String pattern, @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") Object rootFolder, @ScriptParameter(defaultValue="true") boolean recursive) {
        Pattern regExp = !pattern.startsWith("^") ? Pattern.compile(pattern.replace("*", ".*").replace('?', '.')) : Pattern.compile(pattern);
        ArrayList<Object> result = new ArrayList<Object>();
        Object root = ResourceTools.resolve((Object)rootFolder, (Object)this.getScriptEngine().getExecutedFile());
        if (root == null) {
            root = ResourcesModule.getWorkspace();
        }
        if (root instanceof IContainer) {
            HashSet<IContainer> toVisit = new HashSet<IContainer>();
            toVisit.add((IContainer)root);
            do {
                IContainer container = (IContainer)toVisit.iterator().next();
                toVisit.remove(container);
                try {
                    IResource[] iResourceArray = container.members();
                    int n = iResourceArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResource child = iResourceArray[n2];
                        if (child instanceof IFile) {
                            if (regExp.matcher(child.getName()).matches()) {
                                result.add(child);
                            }
                        } else if (recursive && child instanceof IContainer) {
                            toVisit.add((IContainer)child);
                        }
                        ++n2;
                    }
                }
                catch (CoreException child) {
                    // empty catch block
                }
            } while (!toVisit.isEmpty());
        } else if (root instanceof File) {
            HashSet<File> toVisit = new HashSet<File>();
            toVisit.add((File)root);
            do {
                File container = (File)toVisit.iterator().next();
                toVisit.remove(container);
                File[] fileArray = container.listFiles();
                int n = fileArray.length;
                int n3 = 0;
                while (n3 < n) {
                    File child = fileArray[n3];
                    if (child.isFile()) {
                        if (regExp.matcher(child.getName()).matches()) {
                            result.add(child);
                        }
                    } else if (recursive && child.isDirectory()) {
                        toVisit.add(child);
                    }
                    ++n3;
                }
            } while (!toVisit.isEmpty());
        }
        return result.toArray(new Object[result.size()]);
    }

    @WrapToScript
    public IProject linkProject(Object location) throws CoreException, IOException {
        Object resolvedLocation = ResourceTools.resolve((Object)location, (Object)this.getScriptEngine().getExecutedFile());
        if (resolvedLocation instanceof IContainer) {
            throw new IOException("The folder to link is already part of the workspace: " + location);
        }
        if (resolvedLocation instanceof File) {
            if (((File)resolvedLocation).isDirectory()) {
                IProjectDescription description = this.getProjectDescription((File)resolvedLocation);
                IProject project = ResourcesModule.getProject(description.getName());
                project.create(description, null);
                project.open(null);
                return project;
            }
            throw new IOException("location is not a directory");
        }
        throw new IOException("Could not resolve file location \"" + location + "\"");
    }

    private IProjectDescription getProjectDescription(File rootPath) throws CoreException {
        Path projectPath = new Path(rootPath.getAbsoluteFile() + File.separator + ".project");
        return ResourcesPlugin.getWorkspace().loadProjectDescription((IPath)projectPath);
    }

    @WrapToScript
    public IProject importProject(Object location) throws InvocationTargetException, InterruptedException, IOException, CoreException {
        Object resolvedFile = ResourceTools.resolve((Object)location, (Object)this.getScriptEngine().getExecutedFile());
        if (resolvedFile instanceof File) {
            if (((File)resolvedFile).isDirectory()) {
                IProjectDescription projectDescription = this.getProjectDescription((File)resolvedFile);
                IProject project = ResourcesModule.createProject(projectDescription.getName());
                ImportOperation importOperation = new ImportOperation(project.getFullPath(), resolvedFile, (IImportStructureProvider)FileSystemStructureProvider.INSTANCE, file -> "ALL");
                importOperation.setCreateContainerStructure(false);
                importOperation.run((IProgressMonitor)new NullProgressMonitor());
                return project;
            }
            throw new IOException("location is not a directory");
        }
        throw new IOException("Could not resolve file location \"" + location + "\"");
    }

    @WrapToScript
    public void refreshResource(Object resource) throws CoreException {
        Object resolvedResource = ResourceTools.resolve((Object)resource);
        if (resolvedResource instanceof IResource) {
            ((IResource)resolvedResource).refreshLocal(2, null);
        }
    }

    @WrapToScript
    public String readStream(InputStream input) throws IOException {
        return ResourceTools.toString((InputStream)input);
    }

    @WrapToScript
    public void createProblemMarker(String severity, Object location, int lineNumber, String message, @ScriptParameter(defaultValue="org.eclipse.core.resources.problemmarker") String type, @ScriptParameter(defaultValue="true") boolean permanent) throws CoreException {
        Object file = ResourceTools.resolve((Object)location, (Object)this.getScriptEngine().getExecutedFile());
        if (file instanceof IFile) {
            int intSeverity = 0;
            if ("error".equals(severity)) {
                intSeverity = 2;
            }
            if ("warning".equals(severity)) {
                intSeverity = 1;
            }
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put("lineNumber", lineNumber);
            attributes.put("severity", intSeverity);
            attributes.put("message", message);
            attributes.put("transient", !permanent);
            MarkerUtilities.createMarker((IResource)((IFile)file), attributes, (String)type);
        }
    }

    public void notify(IScriptEngine engine, Script script, int status) {
        if (status == 2) {
            for (IFileHandle handle : this.fOpenHandles) {
                handle.close();
            }
            this.fOpenHandles.clear();
        }
    }

    @WrapToScript
    public Object zip(Object sourceLocation, Object zipLocation) throws IOException {
        Object sourceFile = ResourceTools.resolve((Object)sourceLocation, (Object)this.getScriptEngine().getExecutedFile());
        if (sourceFile instanceof IResource) {
            sourceFile = ((IResource)sourceFile).getLocation().toFile();
        }
        if (!(sourceFile instanceof File)) {
            throw new IOException("Cannot resolve source: " + sourceLocation);
        }
        final java.nio.file.Path sourceFilePath = ((File)sourceFile).toPath();
        Object zipFile = ResourceTools.resolve((Object)zipLocation, (Object)this.getScriptEngine().getExecutedFile());
        if (zipFile instanceof IFile) {
            zipFile = ((IFile)zipFile).getLocation().toFile();
        }
        if (!(zipFile instanceof File)) {
            throw new IOException("Cannot resolve target: " + zipLocation);
        }
        java.nio.file.Path zipFilePath = ((File)zipFile).toPath();
        URI uri = URI.create("jar:file:" + zipFilePath.toUri().getPath());
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("create", ((File)zipFile).exists() ? Boolean.FALSE.toString() : Boolean.TRUE.toString());
        Throwable throwable = null;
        Object var10_12 = null;
        try (final FileSystem fileSystem = FileSystems.newFileSystem(uri, env);){
            final java.nio.file.Path root = fileSystem.getPath("/", new String[0]);
            if (Files.isDirectory(((File)sourceFile).toPath(), new LinkOption[0])) {
                Files.walkFileTree(((File)sourceFile).toPath(), (FileVisitor<? super java.nio.file.Path>)new SimpleFileVisitor<java.nio.file.Path>(){

                    @Override
                    public FileVisitResult visitFile(java.nio.file.Path file, BasicFileAttributes attrs) throws IOException {
                        java.nio.file.Path relativePath = sourceFilePath.relativize(file);
                        java.nio.file.Path zipEntry = fileSystem.getPath(root.toString(), relativePath.toString());
                        Files.copy(file, zipEntry, StandardCopyOption.REPLACE_EXISTING);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult preVisitDirectory(java.nio.file.Path dir, BasicFileAttributes attrs) throws IOException {
                        java.nio.file.Path relativePath = sourceFilePath.relativize(dir);
                        java.nio.file.Path zipDirectory = fileSystem.getPath(root.toString(), relativePath.toString());
                        if (Files.notExists(zipDirectory, new LinkOption[0])) {
                            Files.createDirectories(zipDirectory, new FileAttribute[0]);
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            } else {
                if (Files.notExists(root, new LinkOption[0])) {
                    Files.createDirectories(root, new FileAttribute[0]);
                }
                java.nio.file.Path destinationPath = fileSystem.getPath(root.toString(), sourceFilePath.getFileName().toString());
                Files.copy(sourceFilePath, destinationPath, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        zipFile = ResourceTools.resolve((Object)zipLocation, (Object)this.getScriptEngine().getExecutedFile());
        if (zipFile instanceof IFile) {
            try {
                ((IFile)zipFile).getParent().refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return zipFile;
    }

    @WrapToScript
    public Object unzip(Object zipLocation, Object targetLocation) throws IOException {
        Object zipFile = ResourceTools.resolve((Object)zipLocation, (Object)this.getScriptEngine().getExecutedFile());
        if (zipFile instanceof IResource) {
            zipFile = ((IResource)zipFile).getLocation().toFile();
        }
        if (!(zipFile instanceof File)) {
            throw new IOException("Cannot resolve source: " + zipLocation);
        }
        java.nio.file.Path zipFilePath = ((File)zipFile).toPath();
        Object targetDirectory = ResourceTools.resolve((Object)targetLocation, (Object)this.getScriptEngine().getExecutedFile());
        if (targetDirectory instanceof IResource) {
            targetDirectory = ((IResource)targetDirectory).getLocation().toFile();
        }
        if (!(targetDirectory instanceof File)) {
            throw new IOException("Cannot resolve target: " + targetLocation);
        }
        if (!((File)targetDirectory).exists()) {
            Files.createDirectories(((File)targetDirectory).toPath(), new FileAttribute[0]);
        }
        final java.nio.file.Path targetDirectoryPath = ((File)targetDirectory).toPath();
        URI uri = URI.create("jar:file:" + zipFilePath.toUri().getPath());
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("create", Boolean.FALSE.toString());
        Throwable throwable = null;
        Object var10_12 = null;
        try (FileSystem fileSystem = FileSystems.newFileSystem(uri, env);){
            java.nio.file.Path root = fileSystem.getPath("/", new String[0]);
            Files.walkFileTree(root, (FileVisitor<? super java.nio.file.Path>)new SimpleFileVisitor<java.nio.file.Path>(){

                @Override
                public FileVisitResult visitFile(java.nio.file.Path file, BasicFileAttributes attrs) throws IOException {
                    java.nio.file.Path targetFile = Paths.get(targetDirectoryPath.toString(), file.toString());
                    Files.copy(file, targetFile, StandardCopyOption.REPLACE_EXISTING);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult preVisitDirectory(java.nio.file.Path dir, BasicFileAttributes attrs) throws IOException {
                    java.nio.file.Path targetDirectory = Paths.get(targetDirectoryPath.toString(), dir.toString());
                    if (Files.notExists(targetDirectory, new LinkOption[0])) {
                        Files.createDirectory(targetDirectory, new FileAttribute[0]);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        targetDirectory = ResourceTools.resolve((Object)targetLocation, (Object)this.getScriptEngine().getExecutedFile());
        if (targetDirectory instanceof IContainer) {
            try {
                ((IContainer)targetDirectory).getParent().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return targetDirectory;
    }

    @WrapToScript
    public String getChecksum(Object location) throws NoSuchAlgorithmException, IOException {
        Object resolvedLocation = ResourceTools.resolve((Object)location, (Object)this.getScriptEngine().getExecutedFile());
        Throwable throwable = null;
        Object var4_5 = null;
        try (InputStream input = ResourceTools.getInputStream((Object)resolvedLocation);){
            if (input != null) {
                int readBytes;
                MessageDigest digest = MessageDigest.getInstance("MD5");
                DigestInputStream digestInputStream = new DigestInputStream(input, digest);
                byte[] buffer = new byte[8192];
                while ((readBytes = digestInputStream.read(buffer)) > 0) {
                }
                return this.byteArrayToHexString(digest.digest());
            }
            throw new IOException("Location \"" + location + "\" cannot be accessed.");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private String byteArrayToHexString(byte[] bytes) {
        StringBuilder builder = new StringBuilder();
        byte[] byArray = bytes;
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            String token = Integer.toHexString(b);
            if (token.length() == 1) {
                builder.append('0');
            }
            builder.append(token.substring(Math.max(token.length() - 2, 0)));
            ++n2;
        }
        return builder.toString();
    }
}

