/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.ease.AbstractScriptEngine;
import org.eclipse.ease.IReplEngine;
import org.eclipse.ease.Script;
import org.eclipse.ease.ScriptObjectType;
import org.eclipse.ease.ScriptResult;
import org.eclipse.ease.debugging.model.EaseDebugLastExecutionResult;
import org.eclipse.ease.debugging.model.EaseDebugVariable;

public abstract class AbstractReplScriptEngine
extends AbstractScriptEngine
implements IReplEngine {
    private volatile boolean fTerminateOnIdle = true;
    private ScriptResult fLastExecutionResult = null;

    public AbstractReplScriptEngine(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setTerminateOnIdle(boolean terminate) {
        this.fTerminateOnIdle = terminate;
        if (this.getState() == 0) {
            this.setSystem(!terminate);
        }
        AbstractReplScriptEngine abstractReplScriptEngine = this;
        synchronized (abstractReplScriptEngine) {
            this.notifyAll();
        }
    }

    @Override
    public boolean getTerminateOnIdle() {
        return this.fTerminateOnIdle;
    }

    @Override
    protected boolean shallTerminate() {
        if (this.getTerminateOnIdle()) {
            return super.shallTerminate();
        }
        return this.getMonitor().isCanceled();
    }

    @Override
    public void terminate() {
        this.setTerminateOnIdle(true);
        super.terminate();
    }

    @Override
    public Collection<EaseDebugVariable> getDefinedVariables() {
        HashSet<EaseDebugVariable> result = new HashSet<EaseDebugVariable>();
        for (Map.Entry<String, Object> entry : this.getVariables().entrySet()) {
            if (!this.acceptVariable(entry.getValue())) continue;
            EaseDebugVariable variable = this.createVariable(entry.getKey(), entry.getValue());
            result.add(variable);
        }
        return result;
    }

    protected boolean acceptVariable(Object value) {
        return true;
    }

    protected Collection<EaseDebugVariable> getDefinedVariables(Object scope) {
        return null;
    }

    protected EaseDebugVariable createVariable(String name, Object value) {
        String referenceType = this.getTypeName(value);
        EaseDebugVariable variable = new EaseDebugVariable(name, value, referenceType);
        if ("Java Object".equals(referenceType)) {
            variable.setType(EaseDebugVariable.Type.JAVA_OBJECT);
        } else {
            variable.getValue().setVariables(this.getDefinedVariables(value));
        }
        return variable;
    }

    protected String getTypeName(Object object) {
        switch (this.getType(object)) {
            case NATIVE_ARRAY: {
                String languageName = this.getDescription().getSupportedScriptTypes().get(0).getName();
                return String.valueOf(languageName) + " Array";
            }
            case NATIVE_OBJECT: {
                String languageName = this.getDescription().getSupportedScriptTypes().get(0).getName();
                return String.valueOf(languageName) + " Object";
            }
            case NATIVE: {
                String languageName = this.getDescription().getSupportedScriptTypes().get(0).getName();
                return "Generic " + languageName;
            }
            case JAVA_OBJECT: {
                return "Java Object";
            }
            case JAVA_PRIMITIVE: {
                if (object instanceof Integer) {
                    return "int";
                }
                if (object instanceof Byte) {
                    return "byte";
                }
                if (object instanceof Short) {
                    return "short";
                }
                if (object instanceof Boolean) {
                    return "boolean";
                }
                if (object instanceof Character) {
                    return "char";
                }
                if (object instanceof Long) {
                    return "long";
                }
                if (object instanceof Double) {
                    return "double";
                }
                if (!(object instanceof Float)) break;
                return "float";
            }
        }
        return "";
    }

    @Override
    public ScriptObjectType getType(Object object) {
        if (object != null) {
            if (object instanceof Integer || object instanceof Byte || object instanceof Short || object instanceof Boolean || object instanceof Character || object instanceof Long || object instanceof Double || object instanceof Float) {
                return ScriptObjectType.JAVA_PRIMITIVE;
            }
            if (ScriptResult.VOID.equals(object)) {
                return ScriptObjectType.VOID;
            }
            return ScriptObjectType.JAVA_OBJECT;
        }
        return ScriptObjectType.NULL;
    }

    @Override
    public String toString(Object object) {
        if (ScriptResult.VOID.equals(object)) {
            return "<undefined>";
        }
        if (object != null) {
            return object.toString();
        }
        return "null";
    }

    protected final String buildArrayString(List<Object> elements) {
        StringBuilder output = new StringBuilder("[");
        for (Object element : elements) {
            output.append(", ").append(this.toString(element));
        }
        output.append(']');
        if (output.length() > 4) {
            output.delete(1, 3);
        }
        return output.toString();
    }

    protected final String buildObjectString(Map<String, Object> elements) {
        StringBuilder output = new StringBuilder("{");
        for (Map.Entry<String, Object> entry : elements.entrySet()) {
            output.append(", ").append(entry.getKey()).append(": ").append(this.toString(entry.getValue()));
        }
        output.append('}');
        if (output.length() > 4) {
            output.delete(1, 3);
        }
        return output.toString();
    }

    @Override
    protected void notifyExecutionListeners(Script script, int status) {
        if (4 == status) {
            this.fLastExecutionResult = script.getResult();
        }
        super.notifyExecutionListeners(script, status);
    }

    @Override
    public EaseDebugVariable getLastExecutionResult() {
        if (this.fLastExecutionResult != null) {
            if (ScriptResult.VOID.equals(this.fLastExecutionResult.getResult())) {
                return new EaseDebugLastExecutionResult("no method return value", ScriptResult.VOID, "");
            }
            if (this.fLastExecutionResult.hasException()) {
                return new EaseDebugLastExecutionResult("script exception", this.fLastExecutionResult.getException());
            }
            EaseDebugVariable variable = this.createVariable("script returned", this.fLastExecutionResult.getResult());
            return new EaseDebugLastExecutionResult(variable);
        }
        return new EaseDebugLastExecutionResult("no method return value", null, "");
    }

    @Override
    protected void teardownEngine() {
        this.fLastExecutionResult = null;
    }
}

