/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.ease.Activator;
import org.eclipse.ease.ICodeFactory;
import org.eclipse.ease.ICodeParser;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.IScriptEngineLaunchExtension;
import org.eclipse.ease.Logger;
import org.eclipse.ease.ScriptResult;
import org.eclipse.ease.modules.ModuleCategoryDefinition;
import org.eclipse.ease.modules.ModuleDefinition;
import org.eclipse.ease.service.EngineDescription;
import org.eclipse.ease.service.IScriptService;
import org.eclipse.ease.service.ScriptType;
import org.eclipse.ease.tools.ResourceTools;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;

public class ScriptService
implements IScriptService,
BundleListener {
    private static final String ENGINE = "engine";
    private static final String ENGINE_ID = "engineID";
    private static final Object EXTENSION_MODULE = "module";
    private static final Object EXTENSION_CATEGORY = "category";
    private static final String EXTENSION_LANGUAGE_ID = "org.eclipse.ease.language";
    private static final String EXTENSION_MODULES_ID = "org.eclipse.ease.modules";
    private static final String EXTENSION_SCRIPTTYPE_ID = "org.eclipse.ease.scriptType";
    private static final String SCRIPTTYPE_NAME = "name";
    private static final String LAUNCH_EXTENSION = "launchExtension";
    private static ScriptService fInstance = null;
    private Collection<ModuleDefinition> fAvailableModules = null;
    private Map<String, EngineDescription> fEngineDescriptions = null;
    private Map<String, ScriptType> fScriptTypes = null;
    private Map<String, ModuleCategoryDefinition> fAvailableModuleCategories = null;

    public static IScriptService getService() {
        try {
            return (IScriptService)PlatformUI.getWorkbench().getService(IScriptService.class);
        }
        catch (IllegalStateException e) {
            return ScriptService.getInstance();
        }
    }

    public static synchronized ScriptService getInstance() {
        if (fInstance == null) {
            fInstance = new ScriptService();
        }
        return fInstance;
    }

    private ScriptService() {
        Activator.getDefault().getContext().addBundleListener((BundleListener)this);
    }

    @Override
    public EngineDescription getEngineByID(String engineID) {
        return this.getEngineDescriptions().get(engineID);
    }

    @Override
    public synchronized Collection<ModuleDefinition> getAvailableModules() {
        if (this.fAvailableModules == null) {
            IConfigurationElement[] config;
            this.fAvailableModules = new HashSet<ModuleDefinition>();
            IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_MODULES_ID);
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                if (e.getName().equals(EXTENSION_MODULE)) {
                    ModuleDefinition definition = new ModuleDefinition(e);
                    if (definition.getModuleClass() != null) {
                        this.fAvailableModules.add(definition);
                    } else {
                        Logger.warning("org.eclipse.ease", "Module <" + definition.getName() + "> in plugin <" + definition.getBundleID() + "> could not be located!");
                    }
                }
                ++n2;
            }
        }
        return this.fAvailableModules;
    }

    @Override
    public Collection<EngineDescription> getEngines() {
        return this.getEngineDescriptions().values();
    }

    @Override
    public List<EngineDescription> getEngines(String scriptType) {
        ArrayList<EngineDescription> result = new ArrayList<EngineDescription>();
        for (EngineDescription description : this.getEngines()) {
            if (!description.supports(scriptType)) continue;
            result.add(description);
        }
        Collections.sort(result, (o1, o2) -> o2.getPriority() - o1.getPriority());
        return result;
    }

    private synchronized Map<String, EngineDescription> getEngineDescriptions() {
        if (this.fEngineDescriptions == null) {
            IConfigurationElement[] config;
            this.fEngineDescriptions = new HashMap<String, EngineDescription>();
            IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_LANGUAGE_ID);
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                if (ENGINE.equals(e.getName())) {
                    EngineDescription engine = new EngineDescription(e);
                    this.fEngineDescriptions.put(engine.getID(), engine);
                }
                ++n2;
            }
        }
        return this.fEngineDescriptions;
    }

    @Override
    public Collection<IScriptEngineLaunchExtension> getLaunchExtensions(EngineDescription engineDescription) {
        IConfigurationElement[] config;
        String targetEngineID = engineDescription.getID();
        HashSet<IScriptEngineLaunchExtension> extensions = new HashSet<IScriptEngineLaunchExtension>();
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_LANGUAGE_ID);
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            try {
                if (LAUNCH_EXTENSION.equals(e.getName())) {
                    Object extension;
                    String scriptType;
                    String engineID = e.getAttribute(ENGINE_ID);
                    if (engineID == null || engineID.matches("^\\*?$")) {
                        engineID = ".*";
                    }
                    if (targetEngineID.matches(engineID) && ((scriptType = e.getAttribute("scriptType")) == null || scriptType.isEmpty() || engineDescription.supports(scriptType)) && (extension = e.createExecutableExtension("class")) instanceof IScriptEngineLaunchExtension) {
                        extensions.add((IScriptEngineLaunchExtension)extension);
                    }
                }
            }
            catch (InvalidRegistryObjectException invalidRegistryObjectException) {
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            ++n2;
        }
        return extensions;
    }

    @Override
    public synchronized Map<String, ScriptType> getAvailableScriptTypes() {
        if (this.fScriptTypes == null) {
            IConfigurationElement[] config;
            this.fScriptTypes = new HashMap<String, ScriptType>();
            IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_SCRIPTTYPE_ID);
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                if ("scriptType".equals(e.getName())) {
                    this.fScriptTypes.put(e.getAttribute(SCRIPTTYPE_NAME), new ScriptType(e));
                }
                ++n2;
            }
        }
        return this.fScriptTypes;
    }

    @Override
    public ScriptType getScriptType(String location) {
        int pos;
        if (location == null) {
            return null;
        }
        Object resource = ResourceTools.resolve(location);
        try {
            IContentDescription description;
            if (resource instanceof IFile && (description = ((IFile)resource).getContentDescription()) != null) {
                IContentType contentType = description.getContentType();
                for (ScriptType scriptType : this.getAvailableScriptTypes().values()) {
                    if (!scriptType.getContentTypes().contains(contentType.getId())) continue;
                    return scriptType;
                }
            }
        }
        catch (CoreException description) {
            // empty catch block
        }
        if (location != null && (pos = location.lastIndexOf(46)) != -1) {
            String extension = location.substring(pos + 1);
            if (extension.contains("?")) {
                extension = extension.substring(0, extension.indexOf(63));
            }
            for (ScriptType scriptType : this.getAvailableScriptTypes().values()) {
                if (!scriptType.getDefaultExtension().equalsIgnoreCase(extension)) continue;
                return scriptType;
            }
            IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
            IContentType[] contentTypes = contentTypeManager.findContentTypesFor("foo." + extension);
            if (contentTypes != null) {
                for (ScriptType scriptType : this.getAvailableScriptTypes().values()) {
                    for (String contentTypeIdentifier : scriptType.getContentTypes()) {
                        IContentType[] iContentTypeArray = contentTypes;
                        int n = contentTypes.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IContentType candidate = iContentTypeArray[n2];
                            if (candidate.getId().equals(contentTypeIdentifier)) {
                                return scriptType;
                            }
                            ++n2;
                        }
                    }
                }
            }
        }
        return null;
    }

    @Override
    public EngineDescription getEngine(String scriptType) {
        List<EngineDescription> engines = this.getEngines(scriptType);
        if (!engines.isEmpty()) {
            return engines.get(0);
        }
        return null;
    }

    @Override
    public synchronized Map<String, ModuleCategoryDefinition> getAvailableModuleCategories() {
        if (this.fAvailableModuleCategories == null) {
            IConfigurationElement[] config;
            this.fAvailableModuleCategories = new HashMap<String, ModuleCategoryDefinition>();
            IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_MODULES_ID);
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                if (e.getName().equals(EXTENSION_CATEGORY)) {
                    ModuleCategoryDefinition definition = new ModuleCategoryDefinition(e);
                    this.fAvailableModuleCategories.put(definition.getId(), definition);
                }
                ++n2;
            }
        }
        return this.fAvailableModuleCategories;
    }

    @Override
    public ModuleDefinition getModuleDefinition(String moduleId) {
        for (ModuleDefinition definition : this.getAvailableModules()) {
            if (!definition.getId().equals(moduleId)) continue;
            return definition;
        }
        return null;
    }

    public static ICodeFactory getCodeFactory(IScriptEngine engine) {
        List<ScriptType> scriptTypes;
        EngineDescription description = engine.getDescription();
        if (description != null && !(scriptTypes = description.getSupportedScriptTypes()).isEmpty()) {
            return scriptTypes.get(0).getCodeFactory();
        }
        return null;
    }

    public static ICodeParser getCodeParser(IScriptEngine engine) {
        List<ScriptType> scriptTypes;
        EngineDescription description = engine.getDescription();
        if (description != null && !(scriptTypes = description.getSupportedScriptTypes()).isEmpty()) {
            return scriptTypes.get(0).getCodeParser();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bundleChanged(BundleEvent event) {
        int type = event.getType();
        if (type == 32 || type == 2 || type == 4 || type == 8) {
            ScriptService scriptService = this;
            synchronized (scriptService) {
                this.fAvailableModules = null;
                this.fEngineDescriptions = null;
                this.fScriptTypes = null;
                this.fAvailableModuleCategories = null;
            }
        }
    }

    @Override
    public Object executeScript(String scriptLocation, String engineID, String ... arguments) throws Throwable {
        EngineDescription engineDescription = null;
        ScriptService scriptService = ScriptService.getInstance();
        if (engineID != null) {
            engineDescription = scriptService.getEngineByID(engineID);
        } else {
            ScriptType scriptType = scriptService.getScriptType(scriptLocation);
            if (scriptType != null) {
                engineDescription = scriptService.getEngine(scriptType.getName());
            }
        }
        if (engineDescription != null) {
            ScriptResult scriptResult;
            IScriptEngine engine = engineDescription.createEngine();
            engine.setVariable("argv", arguments);
            Object scriptObject = ResourceTools.resolve(scriptLocation);
            if (scriptObject == null) {
                scriptObject = "include(\"" + scriptLocation + "\")";
            }
            if ((scriptResult = engine.executeSync(scriptObject)).hasException()) {
                throw scriptResult.getException();
            }
            return scriptResult.getResult();
        }
        throw new IllegalArgumentException("Cannot locate a matching script engine");
    }
}

