/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.timing.ui.views.segmentstore.density;

import java.text.Format;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Control;
import org.eclipse.tracecompass.analysis.timing.ui.views.segmentstore.density.AbstractSegmentStoreDensityViewer;
import org.eclipse.tracecompass.common.core.format.SubSecondTimeWithUnitFormat;
import org.eclipse.tracecompass.internal.analysis.timing.ui.views.segmentstore.density.BaseMouseProvider;
import org.eclipse.tracecompass.internal.analysis.timing.ui.views.segmentstore.density.Messages;
import org.eclipse.tracecompass.tmf.core.presentation.RGBAColor;
import org.eclipse.tracecompass.tmf.ui.viewers.TmfAbstractToolTipHandler;
import org.swtchart.Chart;
import org.swtchart.IAxis;
import org.swtchart.ISeries;

@Deprecated
public class SimpleTooltipProvider
extends BaseMouseProvider {
    private static final Format FORMAT = SubSecondTimeWithUnitFormat.getInstance();
    private static final String HTML_COLOR_TOOLTIP = "<span style=\"color:%s;\">%s</span>";
    private DensityToolTipHandler fToolTipHandler = new DensityToolTipHandler();

    public SimpleTooltipProvider(AbstractSegmentStoreDensityViewer densityViewer) {
        super(densityViewer);
        this.register();
    }

    @Override
    public void register() {
        this.fToolTipHandler.activateHoverHelp((Control)this.getChart().getPlotArea());
    }

    @Override
    public void deregister() {
        if (!this.getDensityViewer().getControl().isDisposed()) {
            this.fToolTipHandler.deactivateHoverHelp((Control)this.getChart().getPlotArea());
        }
    }

    private final class DensityToolTipHandler
    extends TmfAbstractToolTipHandler {
        private DensityToolTipHandler() {
        }

        public void fill(Control control, MouseEvent event, Point pt) {
            Chart chart = SimpleTooltipProvider.this.getChart();
            ISeries[] seriesSet = chart.getSeriesSet().getSeries();
            if (seriesSet.length != 0) {
                if (event == null || chart.getAxisSet().getXAxes().length == 0 || chart.getAxisSet().getYAxes().length == 0 || seriesSet.length == 0) {
                    return;
                }
                chart.getPlotArea().setToolTipText(null);
                long x1 = -1L;
                long x2 = -1L;
                ArrayList<String> names = new ArrayList<String>();
                ArrayList<Long> yValues = new ArrayList<Long>();
                ArrayList<RGB> colors = new ArrayList<RGB>();
                ISeries[] iSeriesArray = seriesSet;
                int n = seriesSet.length;
                int n2 = 0;
                while (n2 < n) {
                    ISeries ySeriesProvider = iSeriesArray[n2];
                    double[] xValues = ySeriesProvider.getXSeries();
                    if (xValues.length >= 2) {
                        double[] ySeries;
                        long y;
                        double delta = xValues[1] - xValues[0];
                        IAxis xAxis = chart.getAxisSet().getXAxis(0);
                        double coords = xAxis.getDataCoordinate(event.x);
                        int index = Arrays.binarySearch(xValues, coords);
                        if (index < 0) {
                            index = -index - 2;
                        }
                        if ((y = Math.round((ySeries = ySeriesProvider.getYSeries())[index])) > 0L) {
                            x1 = (long)xValues[index];
                            x2 = (long)((double)x1 + delta);
                            String id = ySeriesProvider.getId();
                            colors.add(SimpleTooltipProvider.this.getDensityViewer().getColorForItem(id));
                            names.add(id);
                            yValues.add(y);
                        }
                    }
                    ++n2;
                }
                if (!names.isEmpty()) {
                    this.addItem(Messages.SimpleTooltipProvider_duration, String.valueOf(FORMAT.format(x1)) + '-' + FORMAT.format(x2));
                    if (seriesSet.length == 1) {
                        this.addItem(null, TmfAbstractToolTipHandler.ToolTipString.fromString((String)String.valueOf(Messages.SimpleTooltipProvider_count)), TmfAbstractToolTipHandler.ToolTipString.fromDecimal((Number)((Number)yValues.get(0))));
                    } else {
                        int i = 0;
                        while (i < names.size()) {
                            String id = (String)names.get(i);
                            RGB color = SimpleTooltipProvider.this.getDensityViewer().getColorForItem(id);
                            this.addItem(null, TmfAbstractToolTipHandler.ToolTipString.fromHtml((String)String.format(SimpleTooltipProvider.HTML_COLOR_TOOLTIP, new RGBAColor(color.red, color.green, color.blue).toString(), id)), TmfAbstractToolTipHandler.ToolTipString.fromDecimal((Number)((Number)yValues.get(i))));
                            ++i;
                        }
                    }
                }
            }
        }
    }
}

