/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.callstack.ui.views.functiondensity;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.tracecompass.analysis.timing.ui.views.segmentstore.density.AbstractSegmentStoreDensityView;
import org.eclipse.tracecompass.analysis.timing.ui.views.segmentstore.density.AbstractSegmentStoreDensityViewer;
import org.eclipse.tracecompass.analysis.timing.ui.views.segmentstore.table.AbstractSegmentStoreTableViewer;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.incubator.internal.callstack.ui.views.functiondensity.FunctionDensityViewer;
import org.eclipse.tracecompass.incubator.internal.callstack.ui.views.functiondensity.FunctionTableViewer;
import org.eclipse.tracecompass.tmf.core.segment.SegmentDurationAspect;
import org.eclipse.tracecompass.tmf.core.segment.SegmentEndTimeAspect;
import org.eclipse.tracecompass.tmf.core.segment.SegmentStartTimeAspect;

public class FunctionDensityView
extends AbstractSegmentStoreDensityView {
    public static final @NonNull String ID = String.valueOf(FunctionDensityView.class.getPackage().getName()) + ".functionDensity";

    public FunctionDensityView() {
        super(ID);
    }

    protected AbstractSegmentStoreTableViewer createSegmentStoreTableViewer(Composite parent) {
        return new FunctionTableViewer(new TableViewer(parent, 0x10010000), this.getViewSite().getSecondaryId()){

            protected void createProviderColumns() {
                super.createProviderColumns();
                Table t = (Table)this.getControl();
                this.moveColumnTo(t, SegmentDurationAspect.SEGMENT_DURATION_ASPECT.getName(), 0);
                this.moveColumnTo(t, SegmentStartTimeAspect.SEGMENT_START_TIME_ASPECT.getName(), 1);
                this.moveColumnTo(t, SegmentEndTimeAspect.SEGMENT_END_TIME_ASPECT.getName(), 2);
            }

            private void moveColumnTo(Table t, String aspectName, int desiredIndex) {
                int[] order = t.getColumnOrder();
                int foundIndex = -1;
                int i = 0;
                while (i < t.getColumnCount()) {
                    TableColumn col = t.getColumn(i);
                    if (col.getText().equals(aspectName)) {
                        foundIndex = i;
                    }
                    ++i;
                }
                if (foundIndex == -1) {
                    return;
                }
                int tmp = order[desiredIndex];
                order[desiredIndex] = order[foundIndex];
                order[foundIndex] = tmp;
                t.setColumnOrder(order);
            }
        };
    }

    protected AbstractSegmentStoreDensityViewer createSegmentStoreDensityViewer(Composite parent) {
        return new FunctionDensityViewer((Composite)NonNullUtils.checkNotNull((Object)parent), this.getViewSite().getSecondaryId());
    }
}

