/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.tmf.ui.multiview.ui.view.xychart;

import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.tracecompass.incubator.internal.tmf.ui.multiview.ui.view.IMultiViewer;
import org.eclipse.tracecompass.incubator.internal.tmf.ui.multiview.ui.view.xychart.TreeViewer;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ui.signal.TmfTimeViewAlignmentInfo;
import org.eclipse.tracecompass.tmf.ui.signal.TmfTimeViewAlignmentSignal;
import org.eclipse.tracecompass.tmf.ui.viewers.ILegendImageProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.TmfTimeViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.TmfViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.AbstractSelectTreeViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.ICheckboxTreeViewerListener;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.TmfXYChartViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.XYChartLegendImageProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.linecharts.TmfCommonXAxisChartViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.linecharts.TmfFilteredXYChartViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.linecharts.TmfXYChartSettings;
import org.eclipse.tracecompass.tmf.ui.views.ManyEntriesSelectedDialogPreCheckedListener;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.dialogs.FilteredCheckboxTree;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.dialogs.IPreCheckStateListener;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.dialogs.TriStateFilteredCheckboxTree;

public class ChartMultiViewer
extends TmfTimeViewer
implements IMultiViewer {
    private static final int[] DEFAULT_WEIGHTS = new int[]{1, 3};
    private final SashForm fSashForm;
    private final TreeViewer fLeftViewer;
    private final TmfXYChartViewer fChartViewer;
    private final Composite fXYViewerContainer;

    public ChartMultiViewer(Composite parent, String providerId) {
        super(parent);
        this.fSashForm = new SashForm(parent, 0);
        this.fLeftViewer = new TreeViewer((Composite)this.fSashForm, providerId);
        this.fXYViewerContainer = new Composite((Composite)this.fSashForm, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.fXYViewerContainer.setLayout((Layout)layout);
        this.fChartViewer = new TmfFilteredXYChartViewer(this.fXYViewerContainer, new TmfXYChartSettings("", "", "", 1.0), providerId);
        this.fChartViewer.setTimeAxisVisible(false);
        this.fChartViewer.setSendTimeAlignSignals(true);
        this.fChartViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.fChartViewer.getSwtChart().getAxisSet().getXAxis(0).getTick().setVisible(false);
        this.fChartViewer.getControl().addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Control[] controlArray = ChartMultiViewer.this.fSashForm.getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control control = controlArray[n2];
                    if (control instanceof Sash) {
                        control.removePaintListener((PaintListener)this);
                        control.addListener(13, event -> TmfSignalManager.dispatchSignal((TmfSignal)new TmfTimeViewAlignmentSignal((Object)ChartMultiViewer.this.fSashForm, ChartMultiViewer.this.getTimeViewAlignmentInfo())));
                        break;
                    }
                    ++n2;
                }
            }
        });
        this.fSashForm.setWeights(DEFAULT_WEIGHTS);
        this.coupleSelectViewer();
    }

    public Control getControl() {
        return this.fSashForm;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.fLeftViewer.dispose();
        this.fSashForm.dispose();
    }

    public void refresh() {
        this.fLeftViewer.refresh();
        this.fChartViewer.refresh();
    }

    public void loadTrace(ITmfTrace trace) {
        super.loadTrace(trace);
        this.fLeftViewer.loadTrace(trace);
        this.fChartViewer.loadTrace(trace);
    }

    public TmfTimeViewAlignmentInfo getTimeViewAlignmentInfo() {
        if (this.fChartViewer == null) {
            return null;
        }
        return new TmfTimeViewAlignmentInfo(this.fChartViewer.getControl().getShell(), this.fSashForm.toDisplay(0, 0), this.getTimeAxisOffset());
    }

    public int getAvailableWidth(int requestedOffset) {
        if (this.fChartViewer == null) {
            return 0;
        }
        int pointAreaWidth = this.fChartViewer.getPointAreaWidth();
        int curTimeAxisOffset = this.getTimeAxisOffset();
        if (pointAreaWidth <= 0) {
            pointAreaWidth = this.fSashForm.getBounds().width - curTimeAxisOffset;
        }
        int endOffset = curTimeAxisOffset + pointAreaWidth;
        GridLayout layout = (GridLayout)this.fXYViewerContainer.getLayout();
        int endOffsetWithoutMargin = endOffset + layout.marginRight;
        int availableWidth = endOffsetWithoutMargin - requestedOffset;
        availableWidth = Math.min(this.fSashForm.getBounds().width, Math.max(0, availableWidth));
        return availableWidth;
    }

    public void performAlign(int offset, int width) {
        int total = this.fSashForm.getBounds().width;
        int plotAreaOffset = this.fChartViewer.getPointAreaOffset();
        int width1 = Math.max(0, offset - plotAreaOffset - this.fSashForm.getSashWidth());
        int width2 = Math.max(0, total - width1 - this.fSashForm.getSashWidth());
        if (width1 >= 0 && width2 > 0 || width1 > 0 && width2 >= 0) {
            this.fSashForm.setWeights(new int[]{width1, width2});
            this.fSashForm.layout();
        }
        Composite composite = this.fXYViewerContainer;
        GridLayout layout = (GridLayout)composite.getLayout();
        int timeAxisWidth = this.getAvailableWidth(offset);
        int marginSize = timeAxisWidth - width;
        layout.marginRight = Math.max(0, marginSize);
        composite.layout();
    }

    public void setStatusLineManager(IStatusLineManager statusLineManager) {
        this.fChartViewer.setStatusLineManager(statusLineManager);
    }

    public TmfXYChartViewer getChartViewer() {
        return this.fChartViewer;
    }

    public TmfViewer getLeftChildViewer() {
        return this.fLeftViewer;
    }

    private void coupleSelectViewer() {
        TreeViewer tree = this.fLeftViewer;
        TmfXYChartViewer chart = this.fChartViewer;
        if (tree instanceof AbstractSelectTreeViewer && chart instanceof TmfFilteredXYChartViewer) {
            XYChartLegendImageProvider legendImageProvider = new XYChartLegendImageProvider((TmfCommonXAxisChartViewer)chart);
            AbstractSelectTreeViewer selectTree = tree;
            selectTree.addTreeListener((ICheckboxTreeViewerListener)((TmfFilteredXYChartViewer)chart));
            selectTree.setLegendImageProvider((ILegendImageProvider)legendImageProvider);
            TriStateFilteredCheckboxTree checkboxTree = selectTree.getTriStateFilteredCheckboxTree();
            checkboxTree.addPreCheckStateListener((IPreCheckStateListener)new ManyEntriesSelectedDialogPreCheckedListener((FilteredCheckboxTree)checkboxTree));
        }
    }

    private int getTimeAxisOffset() {
        return this.fSashForm.getChildren()[0].getSize().x + this.fSashForm.getSashWidth() + this.fChartViewer.getPointAreaOffset();
    }
}

