/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.views.markers.CachedMarkerBuilder;
import org.eclipse.ui.internal.views.markers.CompatibilityMarkerFieldFilterGroup;
import org.eclipse.ui.internal.views.markers.MarkerEntry;
import org.eclipse.ui.internal.views.markers.MarkerFieldFilterGroup;
import org.eclipse.ui.internal.views.markers.MarkerResourceUtil;
import org.eclipse.ui.internal.views.markers.MarkerSupportInternalUtilities;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.views.markers.FilterConfigurationArea;
import org.eclipse.ui.views.markers.MarkerField;
import org.eclipse.ui.views.markers.internal.ContentGeneratorDescriptor;
import org.eclipse.ui.views.markers.internal.MarkerGroup;
import org.eclipse.ui.views.markers.internal.MarkerSupportRegistry;
import org.eclipse.ui.views.markers.internal.MarkerType;
import org.eclipse.ui.views.markers.internal.ProblemFilter;
import org.eclipse.ui.views.markers.internal.Util;

public class MarkerContentGenerator {
    private static final String TAG_COLUMN_VISIBILITY = "visible";
    private static final String TAG_FILTERS_SECTION = "filterGroups";
    private static final String TAG_GROUP_ENTRY = "filterGroup";
    private static final String TAG_AND = "andFilters";
    private static final String TAG_LEGACY_FILTER_ENTRY = "filter";
    private static final String TAG_MARKER_LIMIT = "markerLimit";
    private static final String TAG_MARKER_LIMIT_ENABLED = "markerLimitEnabled";
    private final Collection<MarkerFieldFilterGroup> FILTERS_CHANGED = Collections.emptySet();
    private ContentGeneratorDescriptor generatorDescriptor;
    private MarkerField[] visibleFields;
    private Collection<MarkerFieldFilterGroup> enabledFilters;
    private Collection<MarkerFieldFilterGroup> filters;
    private boolean andFilters;
    private int markerLimits = 100;
    private boolean markerLimitsEnabled = true;
    private IResource[] selectedResources = MarkerSupportInternalUtilities.EMPTY_RESOURCE_ARRAY;
    private Collection<IResource> currentResources = Collections.emptySet();
    private CachedMarkerBuilder builder;
    private String viewId;
    private IPropertyChangeListener filterPreferenceListener;
    private String initialDefaultCategoryName;

    public MarkerContentGenerator(ContentGeneratorDescriptor generatorDescriptor, CachedMarkerBuilder builder, String viewId) {
        this.generatorDescriptor = generatorDescriptor;
        this.viewId = viewId;
        this.setBuilder(builder);
    }

    void setBuilder(CachedMarkerBuilder builder) {
        this.builder = builder;
        this.initializePreferenceListener();
        this.builder.setGenerator(this);
    }

    CachedMarkerBuilder getBuilder() {
        return this.builder;
    }

    void requestMarkerUpdate() {
        if (this.builder != null) {
            this.builder.scheduleUpdate(0L);
        }
    }

    boolean allTypesSelected(Collection<MarkerType> selectedTypes) {
        return this.generatorDescriptor.allTypesSelected(selectedTypes);
    }

    MarkerField[] getAllFields() {
        return this.generatorDescriptor.getAllFields();
    }

    MarkerField[] getVisibleFields() {
        return this.visibleFields;
    }

    void setVisibleFields(Collection<MarkerField> visible) {
        MarkerField[] newFields = new MarkerField[visible.size()];
        visible.toArray(newFields);
        this.visibleFields = newFields;
    }

    Object[] getHiddenFields() {
        MarkerField element;
        MarkerField[] all = this.getAllFields();
        MarkerField[] visible = this.getVisibleFields();
        HashSet<MarkerField> hidden = new HashSet<MarkerField>();
        MarkerField[] markerFieldArray = all;
        int n = all.length;
        int n2 = 0;
        while (n2 < n) {
            element = markerFieldArray[n2];
            hidden.add(element);
            ++n2;
        }
        markerFieldArray = visible;
        n = visible.length;
        n2 = 0;
        while (n2 < n) {
            element = markerFieldArray[n2];
            hidden.remove(element);
            ++n2;
        }
        return hidden.toArray();
    }

    void saveState(IMemento memento, MarkerField[] displayedFields) {
        MarkerField[] markerFieldArray = displayedFields;
        int n = displayedFields.length;
        int n2 = 0;
        while (n2 < n) {
            MarkerField displayedField = markerFieldArray[n2];
            memento.createChild(TAG_COLUMN_VISIBILITY, displayedField.getConfigurationElement().getAttribute("id"));
            ++n2;
        }
    }

    void restoreState(IMemento memento) {
        Boolean limitsEnabled;
        this.initDefaults(memento);
        if (memento == null) {
            return;
        }
        Integer limits = memento.getInteger(TAG_MARKER_LIMIT);
        if (limits != null) {
            this.markerLimits = limits;
        }
        if ((limitsEnabled = memento.getBoolean(TAG_MARKER_LIMIT_ENABLED)) != null) {
            this.markerLimitsEnabled = limitsEnabled;
        }
        if (memento.getChildren(TAG_COLUMN_VISIBILITY).length != 0) {
            MarkerField element;
            IMemento[] visible = memento.getChildren(TAG_COLUMN_VISIBILITY);
            ArrayList<MarkerField> newVisible = new ArrayList<MarkerField>();
            MarkerField[] all = this.getAllFields();
            Hashtable<String, MarkerField> allTable = new Hashtable<String, MarkerField>();
            MarkerField[] markerFieldArray = all;
            int n = all.length;
            int n2 = 0;
            while (n2 < n) {
                element = markerFieldArray[n2];
                allTable.put(element.getConfigurationElement().getAttribute("id"), element);
                ++n2;
            }
            markerFieldArray = visible;
            n = visible.length;
            n2 = 0;
            while (n2 < n) {
                element = markerFieldArray[n2];
                String key = element.getID();
                MarkerField field = (MarkerField)allTable.get(key);
                if (field != null) {
                    newVisible.add(field);
                }
                ++n2;
            }
            this.visibleFields = new MarkerField[newVisible.size()];
            newVisible.toArray(this.visibleFields);
        }
    }

    private void initDefaults(IMemento memento) {
        IPreferenceStore store = IDEWorkbenchPlugin.getDefault().getPreferenceStore();
        this.markerLimitsEnabled = store.getBoolean("USE_MARKER_LIMITS");
        this.markerLimits = store.getInt("MARKER_LIMITS_VALUE");
        MarkerField[] initialFields = this.getInitialVisible();
        this.visibleFields = new MarkerField[initialFields.length];
        System.arraycopy(initialFields, 0, this.visibleFields, 0, initialFields.length);
        if (memento == null) {
            this.initialDefaultCategoryName = store.getString(String.valueOf(this.viewId) + "." + "INITIAL_DEFAULT_MARKER_GROUPING");
        }
    }

    Collection<FilterConfigurationArea> createFilterConfigurationFields() {
        ArrayList<FilterConfigurationArea> result = new ArrayList<FilterConfigurationArea>();
        MarkerField[] markerFieldArray = this.visibleFields;
        int n = this.visibleFields.length;
        int n2 = 0;
        while (n2 < n) {
            MarkerField visibleField = markerFieldArray[n2];
            FilterConfigurationArea area = MarkerSupportInternalUtilities.generateFilterArea(visibleField);
            if (area != null) {
                result.add(area);
            }
            ++n2;
        }
        return result;
    }

    String getCategoryName() {
        if (this.initialDefaultCategoryName != null) {
            return this.initialDefaultCategoryName;
        }
        return this.generatorDescriptor.getCategoryName();
    }

    Collection<MarkerFieldFilterGroup> getAllFilters() {
        if (this.filters == null || this.filters == this.FILTERS_CHANGED) {
            this.filters = this.getDeclaredFilters();
            this.loadFiltersPreference();
        }
        return this.filters;
    }

    Collection<MarkerFieldFilterGroup> getEnabledFilters() {
        if (this.enabledFilters == null || this.enabledFilters == this.FILTERS_CHANGED) {
            HashSet<MarkerFieldFilterGroup> enabled = new HashSet<MarkerFieldFilterGroup>();
            for (MarkerFieldFilterGroup next : this.getAllFilters()) {
                if (!next.isEnabled()) continue;
                enabled.add(next);
            }
            this.enabledFilters = enabled;
        }
        return this.enabledFilters;
    }

    protected void rebuildFilters() {
        this.filters = this.FILTERS_CHANGED;
        this.enabledFilters = this.FILTERS_CHANGED;
        this.requestMarkerUpdate();
    }

    void disableAllFilters() {
        Collection<MarkerFieldFilterGroup> allFilters = this.getEnabledFilters();
        for (MarkerFieldFilterGroup group : allFilters) {
            group.setEnabled(false);
        }
        allFilters.clear();
        this.writeFiltersPreference();
        this.requestMarkerUpdate();
    }

    void toggleFilter(MarkerFieldFilterGroup group) {
        Collection<MarkerFieldFilterGroup> enabled = this.getEnabledFilters();
        if (enabled.remove(group)) {
            group.setEnabled(false);
        } else {
            group.setEnabled(true);
            enabled.add(group);
        }
        this.writeFiltersPreference();
        this.requestMarkerUpdate();
    }

    void updateFilters(Collection<MarkerFieldFilterGroup> newFilters, boolean newAndFilters) {
        this.setAndFilters(newAndFilters);
        this.filters = newFilters;
        this.enabledFilters = this.FILTERS_CHANGED;
        this.writeFiltersPreference();
        this.requestMarkerUpdate();
    }

    void setAndFilters(boolean and) {
        this.andFilters = and;
    }

    boolean andFilters() {
        return this.andFilters;
    }

    public int getMarkerLimits() {
        return this.markerLimits;
    }

    public void setMarkerLimits(int markerLimits) {
        this.markerLimits = markerLimits;
    }

    public boolean isMarkerLimitsEnabled() {
        return this.markerLimitsEnabled;
    }

    public void setMarkerLimitsEnabled(boolean markerLimitsEnabled) {
        this.markerLimitsEnabled = markerLimitsEnabled;
    }

    Collection<MarkerFieldFilterGroup> getDeclaredFilters() {
        IConfigurationElement[] filterReferences;
        ArrayList<MarkerFieldFilterGroup> filterList = new ArrayList<MarkerFieldFilterGroup>();
        IConfigurationElement[] iConfigurationElementArray = filterReferences = this.generatorDescriptor.getFilterReferences();
        int n = filterReferences.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement filterReference = iConfigurationElementArray[n2];
            filterList.add(new MarkerFieldFilterGroup(filterReference, this));
            ++n2;
        }
        if (this.viewId != null && this.viewId.equals("org.eclipse.ui.views.ProblemView")) {
            Iterator<ProblemFilter> problemFilters = MarkerSupportRegistry.getInstance().getRegisteredFilters().iterator();
            while (problemFilters.hasNext()) {
                filterList.add(new CompatibilityMarkerFieldFilterGroup(problemFilters.next(), this));
            }
        }
        return filterList;
    }

    private String getLegacyFiltersPreferenceName() {
        if (this.viewId != null && this.viewId.equals("org.eclipse.ui.views.BookmarkView")) {
            return "BOOKMARKS_FILTERS";
        }
        if (this.viewId != null && this.viewId.equals("org.eclipse.ui.views.TaskList")) {
            return "TASKS_FILTERS";
        }
        return "PROBLEMS_FILTERS";
    }

    private void loadLimitSettings(IMemento memento) {
        Boolean limitsEnabled;
        if (memento == null) {
            return;
        }
        Integer limits = memento.getInteger(TAG_MARKER_LIMIT);
        if (limits != null) {
            this.markerLimits = limits;
        }
        if ((limitsEnabled = memento.getBoolean(TAG_MARKER_LIMIT_ENABLED)) != null) {
            this.markerLimitsEnabled = limitsEnabled;
        }
    }

    private void loadFilterSettings(IMemento memento) {
        IMemento[] children;
        if (memento == null) {
            return;
        }
        Boolean andValue = memento.getBoolean(TAG_AND);
        if (andValue != null) {
            this.setAndFilters(andValue);
        }
        IMemento[] iMementoArray = children = memento.getChildren(TAG_GROUP_ENTRY);
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento element = iMementoArray[n2];
            IMemento child = element;
            String id = child.getString("IMemento.internal.id");
            if (id != null && !this.loadGroupWithID(child, id)) {
                this.loadUserFilter(child);
            }
            ++n2;
        }
    }

    private void loadFiltersFrom(String mementoString) {
        if (mementoString.equals("")) {
            return;
        }
        try {
            XMLMemento root = XMLMemento.createReadRoot((Reader)new StringReader(mementoString));
            this.loadLimitSettings((IMemento)root);
            this.loadFilterSettings((IMemento)root);
        }
        catch (WorkbenchException e) {
            StatusManager.getManager().handle(e.getStatus());
        }
    }

    private void loadFiltersPreference() {
        this.loadFiltersFrom(IDEWorkbenchPlugin.getDefault().getPreferenceStore().getString(this.getMementoPreferenceName()));
        String legacyFilters = this.getLegacyFiltersPreferenceName();
        String migrationPreference = String.valueOf(legacyFilters) + "_MIGRATE";
        if (IDEWorkbenchPlugin.getDefault().getPreferenceStore().getBoolean(migrationPreference)) {
            return;
        }
        this.loadLegacyFiltersFrom(IDEWorkbenchPlugin.getDefault().getPreferenceStore().getString(legacyFilters));
        IDEWorkbenchPlugin.getDefault().getPreferenceStore().setValue(migrationPreference, true);
    }

    private String getMementoPreferenceName() {
        return CachedMarkerBuilder.getMementoPreferenceName(this.viewId);
    }

    private boolean loadGroupWithID(IMemento child, String id) {
        for (MarkerFieldFilterGroup group : this.getAllFilters()) {
            if (!id.equals(group.getID())) continue;
            group.loadSettings(child);
            return true;
        }
        return false;
    }

    private void loadLegacyFilter(IMemento child) {
        MarkerFieldFilterGroup newGroup = new MarkerFieldFilterGroup(null, this);
        newGroup.legacyLoadSettings(child);
        this.getAllFilters().add(newGroup);
    }

    private void loadLegacyFiltersFrom(String mementoString) {
        if (mementoString.equals("")) {
            return;
        }
        try {
            XMLMemento memento = XMLMemento.createReadRoot((Reader)new StringReader(mementoString));
            this.restoreLegacyFilters((IMemento)memento);
        }
        catch (WorkbenchException e) {
            StatusManager.getManager().handle(e.getStatus());
            return;
        }
    }

    private void loadUserFilter(IMemento child) {
        MarkerFieldFilterGroup newGroup = new MarkerFieldFilterGroup(null, this);
        newGroup.loadSettings(child);
        this.getAllFilters().add(newGroup);
    }

    private void restoreLegacyFilters(IMemento memento) {
        IMemento[] sections = null;
        if (memento != null) {
            sections = memento.getChildren(TAG_LEGACY_FILTER_ENTRY);
        }
        IMemento[] iMementoArray = sections;
        int n = sections.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento child = iMementoArray[n2];
            String id = child.getString("IMemento.internal.id");
            if (id != null) {
                this.loadLegacyFilter(child);
            }
            ++n2;
        }
    }

    private void writeFiltersPreference() {
        XMLMemento memento = XMLMemento.createWriteRoot((String)TAG_FILTERS_SECTION);
        this.writeLimitSettings(memento);
        this.writeFiltersSettings(memento);
        StringWriter writer = new StringWriter();
        try {
            memento.save((Writer)writer);
        }
        catch (IOException e) {
            IDEWorkbenchPlugin.getDefault().getLog().log(Util.errorStatus(e));
        }
        IDEWorkbenchPlugin.getDefault().getPreferenceStore().putValue(this.getMementoPreferenceName(), writer.toString());
        IDEWorkbenchPlugin.getDefault().savePluginPreferences();
    }

    private void initializePreferenceListener() {
        if (this.filterPreferenceListener == null) {
            this.filterPreferenceListener = event -> {
                if (event.getProperty().equals(this.getMementoPreferenceName())) {
                    this.rebuildFilters();
                }
            };
            IDEWorkbenchPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.filterPreferenceListener);
        }
    }

    private void writeLimitSettings(XMLMemento memento) {
        memento.putInteger(TAG_MARKER_LIMIT, this.markerLimits);
        memento.putBoolean(TAG_MARKER_LIMIT_ENABLED, this.markerLimitsEnabled);
    }

    private void writeFiltersSettings(XMLMemento memento) {
        memento.putBoolean(TAG_AND, this.andFilters());
        for (MarkerFieldFilterGroup group : this.getAllFilters()) {
            IMemento child = memento.createChild(TAG_GROUP_ENTRY, group.getID());
            group.saveFilterSettings(child);
        }
    }

    public String getId() {
        return this.generatorDescriptor.getId();
    }

    void setViewID(String viewId) {
        this.viewId = viewId;
    }

    public Object getViewId() {
        return this.viewId;
    }

    MarkerField[] getInitialVisible() {
        return this.generatorDescriptor.getInitialVisible();
    }

    MarkerGroup getMarkerGroup(String groupName) {
        for (MarkerGroup group : this.getMarkerGroups()) {
            if (!group.getId().equals(groupName)) continue;
            return group;
        }
        return null;
    }

    Collection<MarkerGroup> getMarkerGroups() {
        return this.generatorDescriptor.getMarkerGroups();
    }

    public Collection<MarkerType> getMarkerTypes() {
        return this.generatorDescriptor.getMarkerTypes();
    }

    public String[] getTypes() {
        Collection<MarkerType> types = this.getMarkerTypes();
        String[] ids = new String[types.size()];
        Iterator<MarkerType> iterator = types.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            ids[i++] = iterator.next().getId();
        }
        return ids;
    }

    String getName() {
        return this.generatorDescriptor.getName();
    }

    MarkerType getType(String typeId) {
        return this.generatorDescriptor.getType(typeId);
    }

    boolean select(MarkerEntry entry) {
        try {
            boolean bl = MarkerContentGenerator.select(entry, this.getSelectedResources(), this.getEnabledFilters(), this.andFilters());
            return bl;
        }
        finally {
            entry.clearCache();
        }
    }

    /*
     * Unable to fully structure code
     */
    static boolean select(MarkerEntry entry, IResource[] selResources, Collection<MarkerFieldFilterGroup> enabledFilters, boolean andFilters) {
        block2: {
            if (enabledFilters.size() <= 0) break block2;
            filtersIterator = enabledFilters.iterator();
            if (!andFilters) ** GOTO lbl12
            while (filtersIterator.hasNext()) {
                group = filtersIterator.next();
                if (group.selectByScope(entry, selResources) && group.selectByFilters(entry)) continue;
                return false;
            }
            return true;
lbl-1000:
            // 1 sources

            {
                group = filtersIterator.next();
                if (!group.selectByScope(entry, selResources) || !group.selectByFilters(entry)) continue;
                return true;
lbl12:
                // 2 sources

                ** while (filtersIterator.hasNext())
            }
lbl13:
            // 1 sources

            return false;
        }
        return true;
    }

    void internalUpdateSelectedElements(Object[] elements) {
        ArrayList<IResource> resourceCollection = new ArrayList<IResource>();
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof IResource) {
                resourceCollection.add((IResource)element);
            } else {
                MarkerResourceUtil.addResources(resourceCollection, (ResourceMapping)element);
            }
            ++n2;
        }
        IResource[] newSelection = new IResource[resourceCollection.size()];
        resourceCollection.toArray(newSelection);
        this.selectedResources = newSelection;
    }

    void updateSelectedResource(Object[] newElements, boolean forceUpdate) {
        if (forceUpdate || this.updateNeededForSelection(newElements)) {
            this.internalUpdateSelectedElements(newElements);
            this.requestMarkerUpdate();
        }
    }

    boolean updateNeededForSelection(Object[] newElements) {
        for (MarkerFieldFilterGroup filter : this.getEnabledFilters()) {
            int scope = filter.getScope();
            if (scope == 0 || scope == 4 || newElements == null || newElements.length < 1) continue;
            if (this.selectedResources.length == 0) {
                return true;
            }
            if (Arrays.equals(this.selectedResources, newElements)) continue;
            if (scope == 3) {
                Collection<IProject> oldProjects = MarkerResourceUtil.getProjectsAsCollection(this.selectedResources);
                Collection<IProject> newProjects = MarkerResourceUtil.getProjectsAsCollection(newElements);
                if (oldProjects.size() == newProjects.size() && newProjects.containsAll(oldProjects)) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    IResource[] getSelectedResources() {
        IResource[] selected = this.selectedResources;
        IResource[] resources = new IResource[selected.length];
        System.arraycopy(selected, 0, resources, 0, selected.length);
        return resources;
    }

    Collection<IResource> getResourcesForBuild() {
        this.currentResources = MarkerResourceUtil.computeResources(this.getSelectedResources(), this.getEnabledFilters(), this.andFilters());
        return this.currentResources;
    }

    Collection<MarkerEntry> generateMarkerEntries(IProgressMonitor monitor) {
        boolean includeSubTypes;
        LinkedList<MarkerEntry> result = new LinkedList<MarkerEntry>();
        String[] typeIds = this.getTypes();
        boolean cancelled = this.gatherMarkers(typeIds, includeSubTypes = this.builder.includeMarkerSubTypes(), result, monitor);
        if (cancelled) {
            result.clear();
        }
        return result;
    }

    boolean generateMarkerEntries(Collection<MarkerEntry> result, IProgressMonitor monitor) {
        String[] typeIds = this.getTypes();
        boolean includeSubTypes = this.builder.includeMarkerSubTypes();
        return this.gatherMarkers(typeIds, includeSubTypes, result, monitor);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    boolean gatherMarkers(String[] typeIds, boolean includeSubTypes, Collection<MarkerEntry> result, IProgressMonitor monitor) {
        try {
            Collection<IResource> resources = this.getResourcesForBuild();
            if (includeSubTypes) {
                String[] superTypes = MarkerResourceUtil.getMutuallyExclusiveSupersIds(typeIds);
                if (monitor.isCanceled()) {
                    return false;
                }
                String[] stringArray = superTypes;
                int n = superTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    String superType = stringArray[n2];
                    boolean success = this.internalGatherMarkers(resources, superType, includeSubTypes, result, monitor);
                    if (!success || monitor.isCanceled()) {
                        return false;
                    }
                    ++n2;
                }
            } else {
                String[] stringArray = typeIds;
                int n = typeIds.length;
                int n3 = 0;
                while (n3 < n) {
                    String typeId = stringArray[n3];
                    boolean success = this.internalGatherMarkers(resources, typeId, includeSubTypes, result, monitor);
                    if (!success || monitor.isCanceled()) {
                        return false;
                    }
                    ++n3;
                }
            }
        }
        catch (Exception e) {
            MarkerSupportInternalUtilities.showViewError(e);
            return false;
        }
        return true;
    }

    private boolean internalGatherMarkers(Collection<IResource> resources, String typeId, boolean includeSubTypes, Collection<MarkerEntry> result, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return false;
        }
        IResource[] selected = this.getSelectedResources();
        Collection<MarkerFieldFilterGroup> enabled = this.getEnabledFilters();
        boolean filtersAreANDed = this.andFilters();
        Iterator<IResource> iterator = resources.iterator();
        while (iterator.hasNext()) {
            IMarker[] markers = null;
            try {
                IResource resource = iterator.next();
                if (!resource.isAccessible()) continue;
                markers = resource.findMarkers(typeId, includeSubTypes, 2);
            }
            catch (CoreException e) {
                MarkerSupportInternalUtilities.logViewError((Exception)((Object)e));
            }
            if (markers == null) continue;
            if (monitor.isCanceled()) {
                return false;
            }
            MarkerEntry entry = null;
            int lenght = markers.length;
            int i = 0;
            while (i < lenght) {
                entry = new MarkerEntry(markers[i]);
                if (MarkerContentGenerator.select(entry, selected, enabled, filtersAreANDed)) {
                    result.add(entry);
                }
                entry.clearCache();
                if (i % 500 == 0 && monitor.isCanceled()) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    void dispose() {
        if (this.filterPreferenceListener != null) {
            IDEWorkbenchPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.filterPreferenceListener);
            this.filterPreferenceListener = null;
        }
    }
}

