/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.debugging;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.ease.ExitException;
import org.eclipse.ease.IDebugEngine;
import org.eclipse.ease.IExecutionListener;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.Logger;
import org.eclipse.ease.Script;
import org.eclipse.ease.debugging.DebugTracer;
import org.eclipse.ease.debugging.IScriptDebugFrame;
import org.eclipse.ease.debugging.IScriptRegistry;
import org.eclipse.ease.debugging.ScriptStackTrace;
import org.eclipse.ease.debugging.dispatcher.EventDispatchJob;
import org.eclipse.ease.debugging.dispatcher.IEventProcessor;
import org.eclipse.ease.debugging.events.AbstractEvent;
import org.eclipse.ease.debugging.events.IDebugEvent;
import org.eclipse.ease.debugging.events.debugger.EngineStartedEvent;
import org.eclipse.ease.debugging.events.debugger.EngineTerminatedEvent;
import org.eclipse.ease.debugging.events.debugger.EvaluateExpressionEvent;
import org.eclipse.ease.debugging.events.debugger.IDebuggerEvent;
import org.eclipse.ease.debugging.events.debugger.ResumedEvent;
import org.eclipse.ease.debugging.events.debugger.ScriptReadyEvent;
import org.eclipse.ease.debugging.events.debugger.StackFramesEvent;
import org.eclipse.ease.debugging.events.debugger.SuspendedEvent;
import org.eclipse.ease.debugging.events.debugger.VariablesEvent;
import org.eclipse.ease.debugging.events.model.BreakpointRequest;
import org.eclipse.ease.debugging.events.model.DisconnectRequest;
import org.eclipse.ease.debugging.events.model.EvaluateExpressionRequest;
import org.eclipse.ease.debugging.events.model.GetStackFramesRequest;
import org.eclipse.ease.debugging.events.model.GetVariablesRequest;
import org.eclipse.ease.debugging.events.model.ResumeRequest;
import org.eclipse.ease.debugging.events.model.SetVariablesRequest;
import org.eclipse.ease.debugging.events.model.SuspendRequest;
import org.eclipse.ease.debugging.events.model.TerminateRequest;
import org.eclipse.ease.debugging.model.EaseDebugStackFrame;

public abstract class AbstractEaseDebugger
implements IEventProcessor,
IExecutionListener {
    private EventDispatchJob fDispatcher;
    private IScriptRegistry fScriptRegistry;
    private IDebugEngine fEngine;
    protected final Map<Script, List<IBreakpoint>> fBreakpoints = new HashMap<Script, List<IBreakpoint>>();
    private final boolean fShowDynamicCode;
    private boolean fTerminated = false;
    private final Map<Object, ThreadState> fThreadStates = new HashMap<Object, ThreadState>();
    private final List<AbstractEvent> fEvaluationRequests = Collections.synchronizedList(new ArrayList());

    public AbstractEaseDebugger(IDebugEngine engine, boolean showDynamicCode) {
        this.fEngine = engine;
        this.fShowDynamicCode = showDynamicCode;
        this.fEngine.addExecutionListener(this);
    }

    protected EventDispatchJob getDispatcher() {
        return this.fDispatcher;
    }

    @Override
    public void setDispatcher(EventDispatchJob dispatcher) {
        this.fDispatcher = dispatcher;
        this.setScriptRegistry(dispatcher);
    }

    public void setScriptRegistry(IScriptRegistry registry) {
        this.fScriptRegistry = registry;
    }

    protected IScriptRegistry getScriptRegistry() {
        return this.fScriptRegistry;
    }

    public void fireDispatchEvent(IDebuggerEvent event) {
        if (this.fDispatcher != null) {
            this.fDispatcher.addEvent(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleEvent(IDebugEvent event) {
        if (!this.fTerminated) {
            DebugTracer.debug("Debugger", "process " + event);
            if (event instanceof BreakpointRequest) {
                if (((BreakpointRequest)event).isRemoveAllBreakpointsRequest()) {
                    this.fBreakpoints.clear();
                } else {
                    Script script = ((BreakpointRequest)event).getScript();
                    if (!this.fBreakpoints.containsKey(script)) {
                        this.fBreakpoints.put(script, new ArrayList());
                    }
                    if (((BreakpointRequest)event).getMode() == BreakpointRequest.Mode.ADD) {
                        IBreakpoint breakpoint = ((BreakpointRequest)event).getBreakpoint();
                        this.fBreakpoints.get(script).add(breakpoint);
                        this.breakpointAdded(script, breakpoint);
                    } else {
                        IBreakpoint breakpoint = ((BreakpointRequest)event).getBreakpoint();
                        this.fBreakpoints.get(script).remove(breakpoint);
                        this.breakpointRemoved(script, breakpoint);
                    }
                }
            } else if (event instanceof SuspendRequest) {
                ThreadState threadState = this.getThreadState(((AbstractEvent)event).getThread());
                threadState.fResumeType = 1;
            } else if (event instanceof TerminateRequest) {
                this.fEvaluationRequests.add((AbstractEvent)event);
                Iterator<ThreadState> iterator = this.fThreadStates.values().iterator();
                while (iterator.hasNext()) {
                    ThreadState threadState;
                    ThreadState threadState2 = threadState = iterator.next();
                    synchronized (threadState2) {
                        threadState.notify();
                    }
                }
            } else if (event instanceof DisconnectRequest) {
                this.fBreakpoints.clear();
                this.fDispatcher = null;
                for (Map.Entry<Object, ThreadState> entry : this.fThreadStates.entrySet()) {
                    ThreadState threadState;
                    this.resume(32, entry.getKey());
                    ThreadState threadState3 = threadState = entry.getValue();
                    synchronized (threadState3) {
                        threadState.notify();
                    }
                }
            } else if (event instanceof AbstractEvent) {
                ThreadState threadState;
                this.fEvaluationRequests.add((AbstractEvent)event);
                ThreadState threadState4 = threadState = this.getThreadState(((AbstractEvent)event).getThread());
                synchronized (threadState4) {
                    threadState.notify();
                }
            }
        }
    }

    protected void breakpointAdded(Script script, IBreakpoint breakpoint) {
    }

    protected void breakpointRemoved(Script script, IBreakpoint breakpoint) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void suspend(IDebuggerEvent event) {
        if (this.fDispatcher != null) {
            ThreadState threadState;
            ThreadState threadState2 = threadState = this.getThreadState(this.getThread());
            synchronized (threadState2) {
                threadState.fSuspended = true;
                this.fireDispatchEvent(event);
                DebugTracer.debug("Debugger", "\t engine suspended on state: " + threadState);
                try {
                    while (threadState.fSuspended) {
                        threadState.wait();
                        this.handleEventsInSuspendedState(threadState);
                    }
                }
                catch (InterruptedException e) {
                    threadState.fSuspended = false;
                }
                DebugTracer.debug("Debugger", "\t engine resumed");
                this.fireDispatchEvent(new ResumedEvent(this.getThread(), this.getThreadState((Object)this.getThread()).fResumeType));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void handleEventsInSuspendedState(ThreadState threadState) {
        var3_2 = this.fEvaluationRequests;
        synchronized (var3_2) {
            requests = new ArrayList<AbstractEvent>(this.fEvaluationRequests);
            // MONITOREXIT @DISABLED, blocks:[0, 3] lbl5 : MonitorExitStatement: MONITOREXIT : var3_2
            if (true) ** GOTO lbl48
        }
        do {
            if (threadState.equals(threadStateForRequest = this.getThreadState((request = (AbstractEvent)requests.remove(0)).getThread()))) {
                this.fEvaluationRequests.remove(request);
                if (request instanceof EvaluateExpressionRequest) {
                    try {
                        scope = ((EvaluateExpressionRequest)request).getContext();
                        result = scope.getDebugFrame().inject(((EvaluateExpressionRequest)request).getExpression());
                        this.fireDispatchEvent(new EvaluateExpressionEvent(((EvaluateExpressionRequest)request).getExpression(), result, null, ((EvaluateExpressionRequest)request).getListener()));
                    }
                    catch (Throwable e) {
                        this.fireDispatchEvent(new EvaluateExpressionEvent(((EvaluateExpressionRequest)request).getExpression(), null, e, ((EvaluateExpressionRequest)request).getListener()));
                    }
                } else if (request instanceof GetStackFramesRequest) {
                    this.fireDispatchEvent(new StackFramesEvent(this.getStacktrace(), this.getThread()));
                } else if (request instanceof GetVariablesRequest) {
                    requestor = ((GetVariablesRequest)request).getRequestor();
                    variables = this.getEngine().getVariables(requestor.getDebugFrame());
                    this.fireDispatchEvent(new VariablesEvent(requestor, variables));
                } else if (request instanceof SetVariablesRequest) {
                    requestor = ((SetVariablesRequest)request).getRequestor();
                    try {
                        if (requestor instanceof EaseDebugStackFrame) {
                            result = this.getEngine().inject(((SetVariablesRequest)request).getExpression());
                            requestor.getDebugFrame().setVariable(((SetVariablesRequest)request).getVariable().getName(), result);
                            variables = this.getEngine().getVariables(requestor.getDebugFrame());
                            this.fireDispatchEvent(new VariablesEvent(requestor, variables));
                        }
                    }
                    catch (Throwable e) {
                        Logger.error("org.eclipse.ease", "Could not change variable <" + ((SetVariablesRequest)request).getVariable().getName() + "> to \"" + ((SetVariablesRequest)request).getExpression() + "\"", e);
                    }
                } else if (request instanceof ResumeRequest) {
                    this.resume(((ResumeRequest)request).getType(), ((ResumeRequest)request).getThread());
                }
            }
            if (!(request instanceof TerminateRequest)) continue;
            throw new ExitException((Object)"Engine termination requested by user");
lbl48:
            // 2 sources

        } while (!requests.isEmpty());
    }

    protected void resume(int resumeType, Object thread) {
        ThreadState threadState = this.fThreadStates.get(thread);
        if (resumeType != 0) {
            threadState.fResumeType = resumeType;
            threadState.fResumeStack = threadState.fStacktrace.clone();
            threadState.fResumeLineNumber = threadState.fResumeStack.size() > 0 ? ((IScriptDebugFrame)threadState.fStacktrace.get(0)).getLineNumber() : 0;
        }
        threadState.fSuspended = false;
    }

    protected IDebugEngine getEngine() {
        return this.fEngine;
    }

    @Override
    public void notify(IScriptEngine engine, Script script, int status) {
        switch (status) {
            case 1: {
                this.fireDispatchEvent(new EngineStartedEvent());
                break;
            }
            case 2: {
                this.fireDispatchEvent(new EngineTerminatedEvent());
                this.fTerminated = true;
                this.fEngine.removeExecutionListener(this);
                this.fEngine = null;
                this.fDispatcher = null;
                this.fThreadStates.clear();
                this.fBreakpoints.clear();
                break;
            }
            case 3: 
            case 5: {
                if (!this.isTrackedScript(script)) break;
                this.suspend(new ScriptReadyEvent(script, this.getThread(), this.getThreadState((Object)this.getThread()).fStacktrace.isEmpty()));
                break;
            }
            case 4: 
            case 6: {
                break;
            }
        }
    }

    protected IBreakpoint getBreakpoint(Script script, int lineNumber) {
        List<IBreakpoint> breakpoints = this.fBreakpoints.get(script);
        if (breakpoints != null) {
            for (IBreakpoint breakpoint : breakpoints) {
                try {
                    int breakLocation;
                    if (!breakpoint.isEnabled() || lineNumber != (breakLocation = breakpoint.getMarker().getAttribute("lineNumber", -1))) continue;
                    return breakpoint;
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public boolean isTrackedScript(Script script) {
        return !script.isDynamic() || this.fShowDynamicCode;
    }

    public ScriptStackTrace getStacktrace() {
        return this.getThreadState((Object)this.getThread()).fStacktrace;
    }

    protected void setStacktrace(ScriptStackTrace stacktrace) {
        this.getThreadState((Object)this.getThread()).fStacktrace = stacktrace;
    }

    public ScriptStackTrace getExceptionStacktrace() {
        return this.getExceptionStacktrace(this.getThread());
    }

    public ScriptStackTrace getExceptionStacktrace(Object thread) {
        return this.getThreadState((Object)thread).fExceptionStacktrace;
    }

    protected void setExceptionStacktrace(ScriptStackTrace exceptionStacktrace) {
        this.getThreadState((Object)this.getThread()).fExceptionStacktrace = exceptionStacktrace;
    }

    protected Object getThread() {
        return Thread.currentThread();
    }

    protected void processLine(Script script, int lineNumber, boolean checkBreakpoints) {
        if (!this.isTrackedScript(script)) {
            return;
        }
        if (lineNumber < 1) {
            return;
        }
        if (this.getStacktrace().isEmpty()) {
            return;
        }
        DebugTracer.debug("Debugger", "\t... processing line " + script.getTitle() + ":" + lineNumber);
        Object thread = this.getThread();
        if (checkBreakpoints && this.isActiveBreakpoint(script, lineNumber)) {
            this.suspend(new SuspendedEvent(16, thread, this.getStacktrace()));
            return;
        }
        switch (this.getThreadState((Object)thread).fResumeType) {
            case 1: {
                this.suspend(new SuspendedEvent(8, thread, this.getStacktrace()));
                break;
            }
            case 2: {
                if (this.getThreadState((Object)thread).fResumeStack.size() > this.getStacktrace().size()) {
                    if (this.getStacktrace().isEmpty()) break;
                    this.suspend(new SuspendedEvent(8, thread, this.getStacktrace()));
                    break;
                }
                if (this.getThreadState((Object)thread).fResumeStack.size() != this.getStacktrace().size() || this.getThreadState((Object)thread).fResumeLineNumber == ((IScriptDebugFrame)this.getStacktrace().get(0)).getLineNumber()) break;
                this.suspend(new SuspendedEvent(8, thread, this.getStacktrace()));
                break;
            }
            case 4: {
                if (this.getThreadState((Object)thread).fResumeStack.size() <= this.getStacktrace().size()) break;
                this.suspend(new SuspendedEvent(8, thread, this.getStacktrace()));
            }
        }
    }

    protected boolean isActiveBreakpoint(Script script, int lineNumber) {
        IBreakpoint breakpoint = this.getBreakpoint(script, lineNumber);
        return breakpoint != null;
    }

    protected ThreadState getThreadState(Object thread) {
        if (!this.fThreadStates.containsKey(thread)) {
            this.fThreadStates.put(thread, new ThreadState());
        }
        return this.fThreadStates.get(thread);
    }

    public class ThreadState {
        public ScriptStackTrace fStacktrace = new ScriptStackTrace();
        public ScriptStackTrace fExceptionStacktrace = null;
        public int fResumeType;
        public int fResumeLineNumber = 0;
        public boolean fSuspended = false;
        public ScriptStackTrace fResumeStack = new ScriptStackTrace();
    }
}

