/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.pcap.core.trace;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.TreeMap;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.pcap.core.packet.BadPacketException;
import org.eclipse.tracecompass.internal.pcap.core.protocol.pcap.PcapPacket;
import org.eclipse.tracecompass.internal.pcap.core.trace.BadPcapFileException;
import org.eclipse.tracecompass.internal.pcap.core.util.PcapTimestampScale;

public abstract class PcapFile
implements Closeable {
    private long fCurrentRank = 0L;
    private long fTotalNumberPackets = -1L;
    private FileChannel fFileChannel;
    private Path fPcapFilePath;
    private ByteOrder fByteOrder = ByteOrder.LITTLE_ENDIAN;
    private int fMajorVersion;
    private int fMinorVersion;
    private TreeMap<Long, Long> fFileIndex = new TreeMap();

    public PcapFile(Path filePath) throws BadPcapFileException, IOException {
        this.fPcapFilePath = filePath;
        if (Files.notExists(this.fPcapFilePath, new LinkOption[0]) || !Files.isRegularFile(this.fPcapFilePath, new LinkOption[0]) || Files.size(this.fPcapFilePath) < 24L) {
            throw new BadPcapFileException("Bad Pcap File.");
        }
        if (!Files.isReadable(this.fPcapFilePath)) {
            throw new BadPcapFileException("File is not readable.");
        }
        this.fFileChannel = Objects.requireNonNull(FileChannel.open(this.fPcapFilePath, new OpenOption[0]));
    }

    public void init(ByteOrder byteOrder, int majorVersion, int minorVersion) {
        this.fByteOrder = byteOrder;
        this.fMajorVersion = majorVersion;
        this.fMinorVersion = minorVersion;
    }

    public abstract @Nullable PcapPacket parseNextPacket() throws IOException, BadPcapFileException, BadPacketException;

    public abstract boolean skipNextPacket() throws IOException, BadPcapFileException;

    public void seekPacket(long rank) throws IOException, BadPcapFileException {
        if (rank < 0L) {
            throw new IllegalArgumentException();
        }
        TreeMap<Long, Long> fileIndex = this.getFileIndex();
        Long positionInBytes = fileIndex.get(rank);
        if (positionInBytes != null) {
            this.getFileChannel().position(positionInBytes);
            this.setCurrentRank(rank);
        } else {
            long floorRank = fileIndex.floorKey(rank);
            this.setCurrentRank(floorRank);
            positionInBytes = fileIndex.get(floorRank);
            if (positionInBytes != null) {
                this.getFileChannel().position(positionInBytes);
                while (this.getCurrentRank() < rank && this.skipNextPacket()) {
                }
            }
        }
    }

    public abstract PcapTimestampScale getTimestampPrecision();

    public synchronized long getTotalNbPackets() throws IOException, BadPcapFileException {
        if (this.fTotalNumberPackets == -1L) {
            long rank = this.fCurrentRank;
            this.fCurrentRank = this.fFileIndex.floorKey(rank);
            while (this.skipNextPacket()) {
            }
            this.fTotalNumberPackets = this.fCurrentRank;
            this.fCurrentRank = rank;
            this.seekPacket(rank);
        }
        return this.fTotalNumberPackets;
    }

    public ByteOrder getByteOrder() {
        return this.fByteOrder;
    }

    public int getMajorVersion() {
        return this.fMajorVersion;
    }

    public int getMinorVersion() {
        return this.fMinorVersion;
    }

    public Path getPath() {
        return this.fPcapFilePath;
    }

    public long getCurrentRank() {
        return this.fCurrentRank;
    }

    public void setCurrentRank(long currentRank) {
        this.fCurrentRank = currentRank;
    }

    public TreeMap<Long, Long> getFileIndex() {
        return this.fFileIndex;
    }

    @Override
    public void close() throws IOException {
        this.getFileChannel().close();
    }

    public FileChannel getFileChannel() {
        return this.fFileChannel;
    }
}

