/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.tmf.ui.multiview.ui.view.xychart;

import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.tracecompass.incubator.internal.tmf.ui.multiview.ui.view.xychart.ChartMultiViewer;
import org.eclipse.tracecompass.incubator.internal.tmf.ui.multiview.ui.view.xychart.MouseDragZoomProvider;
import org.eclipse.tracecompass.internal.tmf.ui.Messages;
import org.eclipse.tracecompass.internal.tmf.ui.views.LockRangeDialog;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.TmfBaseProvider;
import org.eclipse.ui.IViewSite;

public class ActionsChartMultiViewer
extends ChartMultiViewer
implements ISelectionProvider,
MenuDetectListener {
    private final IViewSite fViewSite;
    private List<ISelectionChangedListener> fSelectionChangedListeners;
    private MenuManager fMenuManager;

    public ActionsChartMultiViewer(Composite parent, String providerId, IViewSite viewSite) {
        super(parent, providerId);
        this.fViewSite = viewSite;
        this.getChartViewer().setMouseDragZoomProvider((TmfBaseProvider)new MouseDragZoomProvider(this));
        this.fMenuManager = this.createContextMenus();
        this.fillContextMenu(this.fMenuManager);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (listener != null && !this.fSelectionChangedListeners.contains(listener)) {
            this.fSelectionChangedListeners.add(listener);
        }
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        if (listener != null) {
            this.fSelectionChangedListeners.remove(listener);
        }
    }

    public ISelection getSelection() {
        return () -> false;
    }

    public void setSelection(ISelection selection) {
    }

    public void menuDetected(MenuDetectEvent e) {
        e.doit = false;
    }

    public MenuManager getMenuManager() {
        return this.fMenuManager;
    }

    public void showMenu() {
        Composite plotArea = this.getChartViewer().getSwtChart().getPlotArea();
        plotArea.getMenu().setVisible(true);
    }

    public void fireSelectionChanged() {
        if (this.fSelectionChangedListeners != null) {
            for (ISelectionChangedListener listener : this.fSelectionChangedListeners) {
                listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this.getSelection()));
            }
        }
    }

    private void fillContextMenu(MenuManager menuManager) {
        menuManager.add(this.createClampAction());
    }

    private MenuManager createContextMenus() {
        MenuManager menuManager = new MenuManager();
        Composite plotArea = this.getChartViewer().getSwtChart().getPlotArea();
        Menu menu = menuManager.createContextMenu((Control)plotArea);
        plotArea.setMenu(menu);
        plotArea.addMenuDetectListener((MenuDetectListener)this);
        this.fViewSite.registerContextMenu(menuManager, (ISelectionProvider)this);
        return menuManager;
    }

    private IAction createClampAction() {
        Action action = new Action(Messages.TmfChartView_LockYAxis, 1){

            public void run() {
                LockRangeDialog rangeDialog = new LockRangeDialog(ActionsChartMultiViewer.this.fViewSite.getShell(), ActionsChartMultiViewer.this.getChartViewer());
                rangeDialog.open();
            }
        };
        action.setChecked(false);
        return action;
    }
}

