/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules.platform;

import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.ease.AbstractScriptEngine;
import org.eclipse.ease.IDebugEngine;
import org.eclipse.ease.IExecutionListener;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.Logger;
import org.eclipse.ease.Script;
import org.eclipse.ease.ScriptResult;
import org.eclipse.ease.modules.AbstractScriptModule;
import org.eclipse.ease.modules.ScriptParameter;
import org.eclipse.ease.modules.WrapToScript;
import org.eclipse.ease.service.EngineDescription;
import org.eclipse.ease.service.IScriptService;
import org.eclipse.ease.service.ScriptService;
import org.eclipse.ease.service.ScriptType;
import org.eclipse.ease.tools.ResourceTools;
import org.eclipse.ease.ui.launching.EaseLaunchDelegate;
import org.eclipse.ui.PlatformUI;

public class ScriptingModule
extends AbstractScriptModule {
    public static final String MODULE_ID = "/System/Scripting";

    @WrapToScript
    public static IScriptEngine createScriptEngine(String identifier) {
        ScriptService scriptService;
        try {
            scriptService = (IScriptService)PlatformUI.getWorkbench().getService(IScriptService.class);
        }
        catch (IllegalStateException e) {
            scriptService = ScriptService.getInstance();
        }
        EngineDescription engine = scriptService.getEngineByID(identifier);
        if (engine != null) {
            return engine.createEngine();
        }
        Collection engines = scriptService.getEngines();
        for (EngineDescription description : engines) {
            if (!description.getName().equals(identifier)) continue;
            return description.createEngine();
        }
        engine = scriptService.getEngine(identifier);
        if (engine != null) {
            return engine.createEngine();
        }
        return null;
    }

    @WrapToScript
    public static String[] listScriptEngines() {
        ScriptService scriptService;
        ArrayList<String> result = new ArrayList<String>();
        try {
            scriptService = (IScriptService)PlatformUI.getWorkbench().getService(IScriptService.class);
        }
        catch (IllegalStateException e) {
            scriptService = ScriptService.getInstance();
        }
        for (EngineDescription description : scriptService.getEngines()) {
            result.add(description.getID());
        }
        return result.toArray(new String[result.size()]);
    }

    @WrapToScript
    public ScriptResult fork(Object resource, @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") String arguments, @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") String engineIdOrExtension) {
        String location;
        ScriptType scriptType;
        ScriptService scriptService;
        ILaunch currentLaunch = this.getScriptEngine().getLaunch();
        boolean useDebugger = currentLaunch != null && currentLaunch.getDebugTarget() != null;
        try {
            scriptService = (IScriptService)PlatformUI.getWorkbench().getService(IScriptService.class);
        }
        catch (IllegalStateException e) {
            scriptService = ScriptService.getInstance();
        }
        EngineDescription description = null;
        if (engineIdOrExtension != null) {
            ScriptType scriptType2;
            description = scriptService.getEngineByID(engineIdOrExtension);
            if (description == null && (scriptType2 = scriptService.getScriptType("." + engineIdOrExtension)) != null) {
                if (useDebugger) {
                    description = scriptType2.getDebugEngine();
                }
                if (description == null) {
                    description = scriptType2.getEngine();
                }
            }
            if (description == null) {
                throw new RuntimeException("No script engine found for ID = \"" + engineIdOrExtension + "\"");
            }
        }
        if (description == null && (scriptType = scriptService.getScriptType(location = ResourceTools.toAbsoluteLocation((Object)resource, (Object)this.getScriptEngine().getExecutedFile()))) != null) {
            if (useDebugger) {
                description = scriptType.getDebugEngine();
            }
            if (description == null) {
                description = scriptType.getEngine();
            }
        }
        if (description != null) {
            ILaunchConfiguration launchConfiguration;
            IScriptEngine engine = description.createEngine();
            engine.setOutputStream((OutputStream)this.getScriptEngine().getOutputStream());
            engine.setErrorStream((OutputStream)this.getScriptEngine().getErrorStream());
            engine.setInputStream(this.getScriptEngine().getInputStream());
            engine.setCloseStreamsOnTerminate(false);
            if (useDebugger && engine instanceof IDebugEngine && (launchConfiguration = currentLaunch.getLaunchConfiguration()) != null) {
                ((IDebugEngine)engine).setupDebugger(currentLaunch, EaseLaunchDelegate.getSuspendOnStartupValue((ILaunchConfiguration)launchConfiguration), EaseLaunchDelegate.getSuspendOnScriptLoadValue((ILaunchConfiguration)launchConfiguration), EaseLaunchDelegate.getDisplayDynamicCodeValue((ILaunchConfiguration)launchConfiguration));
            }
            engine.setVariable("argv", (Object)AbstractScriptEngine.extractArguments((String)arguments));
            Object scriptObject = ResourceTools.resolve((Object)resource, (Object)this.getScriptEngine().getExecutedFile());
            if (scriptObject == null) {
                scriptObject = URI.create(resource.toString());
            }
            ScriptResult result = engine.executeAsync(scriptObject);
            engine.schedule();
            return result;
        }
        throw new RuntimeException("No script engine found for source \"" + resource + "\"");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WrapToScript
    public static boolean join(IScriptEngine engine, @ScriptParameter(defaultValue="0") long timeout) {
        if (!(engine instanceof Job)) throw new RuntimeException("Cannot evaluate engine state");
        long stopWaitingTime = System.currentTimeMillis() + timeout;
        try {
            while (true) {
                if (((Job)engine).getState() == 0) {
                    return true;
                }
                long now = System.currentTimeMillis();
                if (timeout == 0L) {
                    Thread.sleep(1000L);
                    continue;
                }
                if (stopWaitingTime <= now) return false;
                Thread.sleep(Math.min(stopWaitingTime - now, 1000L));
            }
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WrapToScript
    public Object executeSync(Object monitor, Object code) {
        Object object = monitor;
        synchronized (object) {
            return this.getScriptEngine().inject(code);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WrapToScript
    public static void wait(Object monitor, @ScriptParameter(defaultValue="0") long timeout) throws InterruptedException {
        Object object = monitor;
        synchronized (object) {
            monitor.wait(timeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WrapToScript
    public static void notify(Object monitor) {
        Object object = monitor;
        synchronized (object) {
            monitor.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WrapToScript
    public static void notifyAll(Object monitor) {
        Object object = monitor;
        synchronized (object) {
            monitor.notifyAll();
        }
    }

    @WrapToScript
    public void setSharedObject(String key, Object object, @ScriptParameter(defaultValue="false") boolean permanent, @ScriptParameter(defaultValue="false") boolean writable) throws IllegalAccessException {
        ScriptStorage.getInstance().put(key, object, this.getScriptEngine(), permanent, writable);
    }

    @WrapToScript
    public Object getSharedObject(String key) {
        return ScriptStorage.getInstance().get(key);
    }

    private static class ScriptStorage
    implements IExecutionListener {
        private static ScriptStorage fInstance = null;
        private final Map<String, StorageElement> fElements = new HashMap<String, StorageElement>();

        private ScriptStorage() {
        }

        public static synchronized ScriptStorage getInstance() {
            if (fInstance == null) {
                fInstance = new ScriptStorage();
            }
            return fInstance;
        }

        public synchronized Object get(String key) {
            StorageElement storedElement = this.fElements.get(key);
            return storedElement != null ? storedElement.fElement : null;
        }

        public synchronized void put(String key, Object object, IScriptEngine scriptEngine, boolean permanent, boolean writable) throws IllegalAccessException {
            if (this.fElements.containsKey(key)) {
                this.remove(key, scriptEngine);
            }
            this.fElements.put(key, new StorageElement(object, ScriptStorage.getOwner(scriptEngine), permanent, writable));
            if (!permanent) {
                scriptEngine.addExecutionListener((IExecutionListener)this);
            }
        }

        public synchronized void remove(String key, IScriptEngine scriptEngine) throws IllegalAccessException {
            if (this.fElements.containsKey(key)) {
                StorageElement element = this.fElements.get(key);
                if (element.fWritable || element.fOwner.equals(ScriptStorage.getOwner(scriptEngine))) {
                    this.fElements.remove(key);
                } else {
                    throw new IllegalAccessException("Engine is not the owner of shared object \"" + key + "\"");
                }
            }
        }

        private static Object getOwner(IScriptEngine engine) {
            return engine.hashCode();
        }

        public synchronized void notify(IScriptEngine engine, Script script, int status) {
            if (status == 2) {
                for (String key : new HashSet<String>(this.fElements.keySet())) {
                    StorageElement element = this.fElements.get(key);
                    if (!element.fOwner.equals(ScriptStorage.getOwner(engine)) || element.fPermanent) continue;
                    try {
                        this.remove(key, engine);
                    }
                    catch (IllegalAccessException e) {
                        Logger.error((String)"org.eclipse.ease.modules.platform", (String)"Error while cleaning up shared objects", (Throwable)e);
                    }
                }
                if (this.fElements.isEmpty()) {
                    fInstance = null;
                }
                engine.removeExecutionListener((IExecutionListener)this);
            }
        }
    }

    private static class StorageElement {
        public Object fElement;
        public Object fOwner;
        public boolean fPermanent;
        private final boolean fWritable;

        public StorageElement(Object element, Object owner, boolean permanent, boolean writable) {
            this.fElement = element;
            this.fOwner = owner;
            this.fPermanent = permanent;
            this.fWritable = writable;
        }
    }
}

