/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.scripts.repository.impl;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.ease.AbstractCodeParser;
import org.eclipse.ease.ICodeParser;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.Logger;
import org.eclipse.ease.service.EngineDescription;
import org.eclipse.ease.service.IScriptService;
import org.eclipse.ease.service.ScriptType;
import org.eclipse.ease.sign.ScriptSignatureException;
import org.eclipse.ease.sign.VerifySignature;
import org.eclipse.ease.tools.NullOutputStream;
import org.eclipse.ease.ui.console.ScriptConsole;
import org.eclipse.ease.ui.scripts.repository.IRepositoryPackage;
import org.eclipse.ease.ui.scripts.repository.IScript;
import org.eclipse.ease.ui.scripts.repository.IScriptLocation;
import org.eclipse.ease.ui.scripts.repository.impl.KeywordMapImpl;
import org.eclipse.ease.ui.scripts.repository.impl.RawLocationImpl;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EcoreEMap;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.prefs.Preferences;

public class ScriptImpl
extends RawLocationImpl
implements IScript {
    protected static final long TIMESTAMP_EDEFAULT = -1L;
    protected long timestamp = -1L;
    protected EMap<String, String> scriptKeywords;
    protected EMap<String, String> userKeywords;
    protected Boolean signatureState = null;

    protected ScriptImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return IRepositoryPackage.Literals.SCRIPT;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public void setTimestamp(long newTimestamp) {
        long oldTimestamp = this.timestamp;
        this.timestamp = newTimestamp;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, oldTimestamp, this.timestamp));
        }
    }

    @Override
    public IScriptLocation getEntry() {
        if (this.eContainerFeatureID() != 3) {
            return null;
        }
        return (IScriptLocation)this.eInternalContainer();
    }

    public NotificationChain basicSetEntry(IScriptLocation newEntry, NotificationChain msgs) {
        msgs = this.eBasicSetContainer((InternalEObject)newEntry, 3, msgs);
        return msgs;
    }

    @Override
    public void setEntry(IScriptLocation newEntry) {
        if (newEntry != this.eInternalContainer() || this.eContainerFeatureID() != 3 && newEntry != null) {
            if (EcoreUtil.isAncestor((EObject)this, (EObject)newEntry)) {
                throw new IllegalArgumentException("Recursive containment not allowed for " + this.toString());
            }
            NotificationChain msgs = null;
            if (this.eInternalContainer() != null) {
                msgs = this.eBasicRemoveFromContainer(msgs);
            }
            if (newEntry != null) {
                msgs = ((InternalEObject)newEntry).eInverseAdd((InternalEObject)this, 4, IScriptLocation.class, msgs);
            }
            if ((msgs = this.basicSetEntry(newEntry, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)newEntry, (Object)newEntry));
        }
    }

    @Override
    public EMap<String, String> getScriptKeywords() {
        if (this.scriptKeywords == null) {
            this.scriptKeywords = new EcoreEMap(IRepositoryPackage.Literals.KEYWORD_MAP, KeywordMapImpl.class, (InternalEObject)this, 4);
        }
        return this.scriptKeywords;
    }

    @Override
    public EMap<String, String> getUserKeywords() {
        if (this.userKeywords == null) {
            this.userKeywords = new EcoreEMap(IRepositoryPackage.Literals.KEYWORD_MAP, KeywordMapImpl.class, (InternalEObject)this, 5);
        }
        return this.userKeywords;
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 3: {
                if (this.eInternalContainer() != null) {
                    msgs = this.eBasicRemoveFromContainer(msgs);
                }
                return this.basicSetEntry((IScriptLocation)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 3: {
                return this.basicSetEntry(null, msgs);
            }
            case 4: {
                return ((InternalEList)this.getScriptKeywords()).basicRemove((Object)otherEnd, msgs);
            }
            case 5: {
                return ((InternalEList)this.getUserKeywords()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
        switch (this.eContainerFeatureID()) {
            case 3: {
                return this.eInternalContainer().eInverseRemove((InternalEObject)this, 4, IScriptLocation.class, msgs);
            }
        }
        return super.eBasicRemoveFromContainerFeature(msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 2: {
                return this.getTimestamp();
            }
            case 3: {
                return this.getEntry();
            }
            case 4: {
                if (coreType) {
                    return this.getScriptKeywords();
                }
                return this.getScriptKeywords().map();
            }
            case 5: {
                if (coreType) {
                    return this.getUserKeywords();
                }
                return this.getUserKeywords().map();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 2: {
                this.setTimestamp((Long)newValue);
                return;
            }
            case 3: {
                this.setEntry((IScriptLocation)newValue);
                return;
            }
            case 4: {
                ((EStructuralFeature.Setting)this.getScriptKeywords()).set(newValue);
                return;
            }
            case 5: {
                ((EStructuralFeature.Setting)this.getUserKeywords()).set(newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 2: {
                this.setTimestamp(-1L);
                return;
            }
            case 3: {
                this.setEntry(null);
                return;
            }
            case 4: {
                this.getScriptKeywords().clear();
                return;
            }
            case 5: {
                this.getUserKeywords().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 2: {
                return this.timestamp != -1L;
            }
            case 3: {
                return this.getEntry() != null;
            }
            case 4: {
                return this.scriptKeywords != null && !this.scriptKeywords.isEmpty();
            }
            case 5: {
                return this.userKeywords != null && !this.userKeywords.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 2: {
                this.run();
                return null;
            }
            case 3: {
                return this.getName();
            }
            case 4: {
                return this.getPath();
            }
        }
        return super.eInvoke(operationID, arguments);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (timestamp: ");
        result.append(this.timestamp);
        result.append(')');
        return result.toString();
    }

    @Override
    public Map<String, String> getKeywords() {
        HashMap<String, String> parameters = new HashMap<String, String>(this.getScriptKeywords().map());
        parameters.putAll(this.getUserKeywords().map());
        return parameters;
    }

    @Override
    public ScriptType getType() {
        IScriptService scriptService = (IScriptService)PlatformUI.getWorkbench().getService(IScriptService.class);
        ScriptType type = null;
        String identifier = this.getKeywords().get("script-type");
        if (identifier != null) {
            type = (ScriptType)scriptService.getAvailableScriptTypes().get(identifier);
        }
        if (type == null) {
            type = scriptService.getScriptType(this.getLocation());
        }
        return type;
    }

    @Override
    public String getName() {
        return this.getPath().lastSegment();
    }

    @Override
    public IPath getPath() {
        String name = this.getKeywords().get("name");
        if (name != null) {
            return new Path(name).makeAbsolute();
        }
        String relativePath = this.getLocation().substring(this.getEntry().getLocation().length());
        if (this.isRemote()) {
            try {
                relativePath = URLDecoder.decode(relativePath, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return new Path(relativePath).makeAbsolute();
    }

    @Override
    public IScriptEngine prepareEngine() {
        EngineDescription engineDescription = this.getEngineDescription();
        if (engineDescription != null) {
            Preferences prefs;
            boolean allowRemoteAccess;
            IScriptEngine engine = engineDescription.createEngine();
            String ioTarget = this.getKeywords().get("io");
            if ("system".equalsIgnoreCase(ioTarget)) {
                if (engine instanceof Job) {
                    ((Job)engine).setSystem(false);
                    ((Job)engine).setName("EASE script: " + this.getName());
                }
            } else if ("none".equalsIgnoreCase(ioTarget)) {
                engine.setOutputStream((OutputStream)new NullOutputStream());
                engine.setErrorStream((OutputStream)new NullOutputStream());
                engine.setInputStream((InputStream)new ByteArrayInputStream(new byte[0]));
                if (engine instanceof Job) {
                    ((Job)engine).setSystem(false);
                    ((Job)engine).setName("EASE script: " + this.getName());
                }
            } else {
                ScriptConsole console = ScriptConsole.create((String)(String.valueOf(engine.getName()) + ": " + this.getPath()), (IScriptEngine)engine);
                engine.setOutputStream((OutputStream)console.getOutputStream());
                engine.setErrorStream((OutputStream)console.getErrorStream());
                engine.setInputStream((InputStream)console.getInputStream());
            }
            if (this.isRemote() && !(allowRemoteAccess = (prefs = InstanceScope.INSTANCE.getNode("org.eclipse.ease").node("scripts")).getBoolean("scriptRemoteAccess", false))) {
                engine.getErrorStream().println("Remote script source detected. Access is disabled in preferences.");
                return null;
            }
            Object executionContent = this.getResource();
            if (executionContent == null) {
                executionContent = this.getInputStream();
            }
            engine.executeAsync(executionContent);
            return engine;
        }
        Logger.error((String)"org.eclipse.ease.ui.scripts", (String)("Could not detect script engine for " + this));
        return null;
    }

    @Override
    public IScriptEngine run() {
        return this.run(new String[0]);
    }

    @Override
    public IScriptEngine run(String ... parameters) {
        IScriptEngine engine = this.prepareEngine();
        if (engine != null) {
            engine.setVariable("argv", (Object)parameters);
            engine.schedule();
        }
        return engine;
    }

    @Override
    public IScriptEngine run(Map<String, Object> parameters) {
        IScriptEngine engine = this.prepareEngine();
        if (engine != null) {
            for (Map.Entry<String, Object> entry : parameters.entrySet()) {
                engine.setVariable(entry.getKey(), entry.getValue());
            }
            engine.schedule();
        }
        return engine;
    }

    private EngineDescription getEngineDescription() {
        IScriptService scriptService = (IScriptService)PlatformUI.getWorkbench().getService(IScriptService.class);
        String engineIDs = this.getKeywords().get("script-engine");
        if (engineIDs == null) {
            ScriptType type = this.getType();
            if (type != null) {
                return scriptService.getEngine(type.getName());
            }
            return null;
        }
        HashSet<String> blacklist = new HashSet<String>();
        String[] stringArray = engineIDs.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            EngineDescription engineDescription = scriptService.getEngineByID(id.trim());
            if (engineDescription != null) {
                return engineDescription;
            }
            if (id.trim().startsWith("!")) {
                blacklist.add(id.trim().substring(1));
            }
            ++n2;
        }
        for (EngineDescription description : scriptService.getEngines(this.getType().getName())) {
            if (blacklist.contains(description.getID())) continue;
            return description;
        }
        return null;
    }

    @Override
    public boolean isRemote() {
        Object resource = this.getResource();
        return !(resource instanceof IFile) && !(resource instanceof File) && !this.getLocation().toString().startsWith("platform:/");
    }

    @Override
    public void refreshScriptKeywords() {
        ICodeParser parser;
        ScriptType type = this.getType();
        if (type != null && (parser = type.getCodeParser()) != null) {
            String comment = parser.getHeaderComment(this.getInputStream());
            this.getScriptKeywords().clear();
            this.getScriptKeywords().putAll(AbstractCodeParser.extractKeywords((String)comment));
        }
    }

    @Override
    public void updateSignatureState() {
        ScriptType type = this.getType();
        if (type != null) {
            try {
                VerifySignature verifySignature = VerifySignature.getInstance((ScriptType)type, (InputStream)this.getInputStream());
                this.signatureState = verifySignature == null ? null : Boolean.valueOf(verifySignature.verify());
            }
            catch (ScriptSignatureException e) {
                Logger.error((String)"org.eclipse.ease.ui.scripts", (String)e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public Boolean getSignatureState() {
        return this.signatureState;
    }

    @Override
    public void setUserKeyword(String keyword, String value) {
        String oldContent = this.getKeywords().get(keyword);
        if (value == null) {
            this.getUserKeywords().remove((Object)keyword);
        } else {
            this.getUserKeywords().put((Object)keyword, (Object)value);
        }
        String newContent = this.getKeywords().get(keyword);
        if (newContent != oldContent) {
            this.fireKeywordEvent(keyword, newContent, oldContent);
        }
    }

    public void fireKeywordEvent(String key, String value, String oldValue) {
        Object service = PlatformUI.getWorkbench().getService(IEventBroker.class);
        if (service instanceof IEventBroker) {
            HashMap<String, Object> eventData = new HashMap<String, Object>();
            eventData.put("script", this);
            eventData.put("keyword", key);
            eventData.put("value", value);
            eventData.put("oldValue", oldValue);
            ((IEventBroker)service).post("org/eclipse/ease/scripts/keyword/" + key, eventData);
        }
    }
}

