/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.applications;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ease.Logger;
import org.eclipse.ease.ScriptResult;
import org.eclipse.ease.service.ScriptService;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.ui.IStartup;

public class RunHeadlessScript
implements IApplication {
    private static final Collection<String> EARLY_STARTUP_BLACKLIST = Arrays.asList("org.eclipse.team.svn.ui.startup.SVNCoreStartup", "org.eclipse.egit.ui.internal.clone.GitCloneDropAdapter", "org.eclipse.equinox.internal.p2.ui.sdk.scheduler.AutomaticUpdateScheduler");

    /*
     * Enabled aggressive block sorting
     */
    private static Map<String, Object> extractInputParameters(String[] arguments) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("args", new ArrayList());
        int index = 0;
        while (index < arguments.length) {
            if (parameters.containsKey("script")) {
                ((List)parameters.get("args")).add(arguments[index]);
            } else if ("-script".equals(arguments[index])) {
                if (index + 1 >= arguments.length) {
                    System.out.println("ERROR: script name is missing");
                    return null;
                }
                parameters.put("script", arguments[index + 1]);
                ((List)parameters.get("args")).add(arguments[index + 1]);
                ++index;
            } else if ("-workspace".equals(arguments[index])) {
                if (index + 1 >= arguments.length) {
                    System.out.println("ERROR: workspace location is missing");
                    return null;
                }
                parameters.put("workspace", arguments[index + 1]);
                ++index;
            } else if ("-engine".equals(arguments[index])) {
                if (index + 1 >= arguments.length) {
                    System.out.println("ERROR: workspace location is missing");
                    return null;
                }
                parameters.put("engine", arguments[index + 1]);
                ++index;
            } else {
                if ("-help".equals(arguments[index])) {
                    return null;
                }
                System.out.println("ERROR: invalid args (" + arguments[index] + ")");
                return null;
            }
            ++index;
        }
        return parameters;
    }

    private static void printUsage() {
        System.out.println("SYNTAX: [-workspace <workspace location> [-refreshWorkspace]] [-engine <engineID>]-script <script name> <script parameters>");
        System.out.println("");
        System.out.println("\t\t<script name> is a path like 'file://C/myfolder/myscript.js'");
        System.out.println("\t\t<engineID> provides a dedicated script engine ID. Use org.eclipse.ease.listEngines application.");
        System.out.println("\t\t<workspace location> is a file system path like 'C:\\somefolder\\myworkspace'");
        System.out.println("\t\t\tif you provide a workspace you can use workspace:// identifiers in your scripts");
        System.out.println("\t\t\tif you provide a workspace you may ask to refresh it first prior to script execution");
        System.out.println("\t\t<script parameters> will be passed to the script as String[] in the variable 'argv'");
    }

    public Object start(IApplicationContext context) throws Exception {
        Object object = context.getArguments().get("application.args");
        if (object instanceof String[]) {
            Map<String, Object> parameters = RunHeadlessScript.extractInputParameters((String[])object);
            if (parameters != null) {
                Location location = null;
                if (parameters.containsKey("workspace")) {
                    location = Platform.getInstanceLocation();
                    URL workspaceURL = new File(parameters.get("workspace").toString()).toURL();
                    if (!location.isSet()) {
                        if (!location.set(workspaceURL, true)) {
                            System.err.println("ERROR: Could not set the workspace to \"" + location.getURL() + "\"");
                            return -1;
                        }
                    } else if (!location.getURL().toString().equals(workspaceURL.toString())) {
                        System.err.println("ERROR: Could not set the workspace as it is already set to \"" + location.getURL() + "\"");
                        return -1;
                    }
                    if (parameters.containsKey("refreshWorkspace")) {
                        ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                    }
                }
                this.loadEarlyStartupExtensions();
                try {
                    if (parameters.containsKey("script")) {
                        block26: {
                            Object result;
                            block27: {
                                String scriptLocation = parameters.get("script").toString();
                                String engineID = parameters.containsKey("engine") ? parameters.get("engine").toString() : null;
                                String[] arguments = ((List)parameters.get("args")).toArray(new String[0]);
                                try {
                                    result = ScriptService.getInstance().executeScript(scriptLocation, engineID, arguments);
                                    if (result == null) break block26;
                                    if (!ScriptResult.VOID.equals(result)) break block27;
                                    Integer n = 0;
                                    return n;
                                }
                                catch (Throwable throwable) {
                                    Integer n = -1;
                                    return n;
                                }
                            }
                            Integer n = Integer.parseInt(result.toString());
                            return n;
                        }
                        Integer n = 0;
                        return n;
                    }
                    System.err.println("ERROR: Could not access file \"" + parameters.get("script") + "\"");
                }
                finally {
                    ResourcesPlugin.getWorkspace().save(true, null);
                    if (location != null) {
                        location.release();
                    }
                }
            }
            RunHeadlessScript.printUsage();
        }
        return -1;
    }

    private void loadEarlyStartupExtensions() {
        IConfigurationElement[] config;
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.ui.startup");
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            if (e.getName().equals("startup") && !EARLY_STARTUP_BLACKLIST.contains(e.getAttribute("class"))) {
                try {
                    Logger.info("org.eclipse.ease", "Loading early startup extension: " + e.getAttribute("class"));
                    Object earlyStartupParticipant = e.createExecutableExtension("class");
                    if (earlyStartupParticipant instanceof IStartup) {
                        try {
                            ((IStartup)earlyStartupParticipant).earlyStartup();
                        }
                        catch (Throwable e1) {
                            System.err.println("ERROR: Failed to execute " + earlyStartupParticipant.getClass().getName() + ".earlyStartup(): " + e1);
                        }
                    }
                }
                catch (CoreException e1) {
                    System.err.println("ERROR: Could not create instance for startup code: " + e.getAttribute("class"));
                }
            }
            ++n2;
        }
    }

    public void stop() {
    }
}

