/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.model;

import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.format.DataSizeWithUnitFormat;
import org.eclipse.tracecompass.common.core.format.DataSpeedWithUnitFormat;
import org.eclipse.tracecompass.common.core.format.DecimalWithUnitPrefixFormat;
import org.eclipse.tracecompass.common.core.format.SubSecondTimeWithUnitFormat;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataType;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestampFormat;

public final class DataTypeUtils {
    private static final Format DECIMAL_NO_UNIT_FORMAT = new DecimalWithUnitPrefixFormat("");
    private static final Format OTHER_FORMAT = new Format(){
        private static final long serialVersionUID = -2824035517014261121L;

        @Override
        public StringBuffer format(@Nullable Object obj, @Nullable StringBuffer toAppendTo, @Nullable FieldPosition pos) {
            if (toAppendTo == null) {
                return new StringBuffer(String.valueOf(obj));
            }
            return Objects.requireNonNull(toAppendTo.append(String.valueOf(obj)));
        }

        @Override
        public @Nullable Object parseObject(@Nullable String source, @Nullable ParsePosition pos) {
            return null;
        }
    };

    private DataTypeUtils() {
    }

    public static Format getFormat(DataType type, String units) {
        switch (type) {
            case NUMBER: {
                return units.isEmpty() ? DECIMAL_NO_UNIT_FORMAT : new DecimalWithUnitPrefixFormat(units);
            }
            case TIMESTAMP: {
                return (Format)Objects.requireNonNull(TmfTimestampFormat.getDefaulTimeFormat());
            }
            case BINARY_NUMBER: {
                if (units.endsWith("/s")) {
                    return DataSpeedWithUnitFormat.getInstance();
                }
                return DataSizeWithUnitFormat.getInstance();
            }
            case DURATION: {
                return SubSecondTimeWithUnitFormat.getInstance();
            }
            case STRING: {
                return OTHER_FORMAT;
            }
        }
        return OTHER_FORMAT;
    }
}

