/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.tmf.ui.multiview.ui.view.xychart;

import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tracecompass.incubator.internal.tmf.ui.multiview.ui.view.xychart.ActionsChartMultiViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.ITmfChartTimeProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.TmfBaseProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.TmfXYChartViewer;
import org.swtchart.IAxis;
import org.swtchart.ICustomPaintListener;
import org.swtchart.IPlotArea;

public class MouseDragZoomProvider
extends TmfBaseProvider
implements MouseListener,
MouseMoveListener,
ICustomPaintListener {
    private long fStartTime;
    private long fEndTime;
    private boolean fIsUpdate;
    private ActionsChartMultiViewer fChartViewer;

    public MouseDragZoomProvider(ActionsChartMultiViewer tmfChartViewer) {
        super((ITmfChartTimeProvider)tmfChartViewer.getChartViewer());
        this.fChartViewer = tmfChartViewer;
        this.register();
    }

    public void register() {
        this.getChart().getPlotArea().addMouseListener((MouseListener)this);
        this.getChart().getPlotArea().addMouseMoveListener((MouseMoveListener)this);
        ((IPlotArea)this.getChart().getPlotArea()).addCustomPaintListener((ICustomPaintListener)this);
    }

    public void deregister() {
        if (this.getChartViewer().getControl() != null && !this.getChartViewer().getControl().isDisposed()) {
            this.getChart().getPlotArea().removeMouseListener((MouseListener)this);
            this.getChart().getPlotArea().removeMouseMoveListener((MouseMoveListener)this);
            ((IPlotArea)this.getChart().getPlotArea()).removeCustomPaintListener((ICustomPaintListener)this);
        }
    }

    public void refresh() {
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
        if (this.getChartViewer().getWindowDuration() != 0L && e.button == 3) {
            IAxis xAxis = this.getChart().getAxisSet().getXAxis(0);
            this.fEndTime = this.fStartTime = this.limitXDataCoordinate(xAxis.getDataCoordinate(e.x));
            this.fIsUpdate = true;
        }
    }

    public void mouseUp(MouseEvent e) {
        if (this.fIsUpdate && this.fStartTime != this.fEndTime) {
            if (this.fStartTime > this.fEndTime) {
                long tmp = this.fStartTime;
                this.fStartTime = this.fEndTime;
                this.fEndTime = tmp;
            }
            ITmfChartTimeProvider viewer = this.getChartViewer();
            viewer.updateWindow(this.fStartTime + viewer.getTimeOffset(), this.fEndTime + viewer.getTimeOffset());
        } else if (e.button == 3) {
            this.fChartViewer.showMenu();
        }
        if (this.fIsUpdate) {
            this.getChart().redraw();
        }
        this.fIsUpdate = false;
    }

    public void mouseMove(MouseEvent e) {
        if (this.fIsUpdate) {
            IAxis xAxis = this.getChart().getAxisSet().getXAxis(0);
            this.fEndTime = this.limitXDataCoordinate(xAxis.getDataCoordinate(e.x));
            ITmfChartTimeProvider viewer = this.getChartViewer();
            if (viewer instanceof TmfXYChartViewer) {
                TmfXYChartViewer xyChartViewer = (TmfXYChartViewer)viewer;
                xyChartViewer.updateStatusLine(this.fStartTime, this.fEndTime, this.limitXDataCoordinate(xAxis.getDataCoordinate(e.x)));
            }
            this.getChart().redraw();
        }
    }

    public void paintControl(PaintEvent e) {
        if (this.fIsUpdate && this.fStartTime != this.fEndTime) {
            IAxis xAxis = this.getChart().getAxisSet().getXAxis(0);
            int startX = xAxis.getPixelCoordinate((double)this.fStartTime);
            int endX = xAxis.getPixelCoordinate((double)this.fEndTime);
            e.gc.setBackground(MouseDragZoomProvider.getDisplay().getSystemColor(34));
            if (this.fStartTime < this.fEndTime) {
                e.gc.fillRectangle(startX, 0, endX - startX, e.height);
            } else {
                e.gc.fillRectangle(endX, 0, startX - endX, e.height);
            }
            e.gc.drawLine(startX, 0, startX, e.height);
            e.gc.drawLine(endX, 0, endX, e.height);
        }
    }

    public boolean drawBehindSeries() {
        return true;
    }

    protected static Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }
}

