/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.javascript.nashorn;

import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.eclipse.ease.AbstractReplScriptEngine;
import org.eclipse.ease.Script;
import org.eclipse.ease.ScriptEngineException;
import org.eclipse.ease.ScriptObjectType;
import org.eclipse.ease.debugging.model.EaseDebugVariable;
import org.eclipse.ease.lang.javascript.JavaScriptHelper;

public class NashornScriptEngine
extends AbstractReplScriptEngine {
    public static final String ENGINE_ID = "org.eclipse.ease.javascript.nashorn";
    private ScriptEngine fEngine;

    public NashornScriptEngine() {
        super("Nashorn");
    }

    public void terminateCurrent() {
    }

    protected Object internalGetVariable(String name) {
        return this.fEngine.get(name);
    }

    protected Map<String, Object> internalGetVariables() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        Bindings bindings = this.fEngine.getBindings(100);
        for (Map.Entry entry : bindings.entrySet()) {
            variables.put((String)entry.getKey(), entry.getValue());
        }
        return variables;
    }

    protected boolean internalHasVariable(String name) {
        return this.fEngine.getBindings(100).containsKey(name);
    }

    protected void internalSetVariable(String name, Object content) {
        if (!JavaScriptHelper.isSaveName((String)name)) {
            throw new RuntimeException("\"" + name + "\" is not a valid JavaScript variable name");
        }
        this.fEngine.put(name, content);
    }

    public void registerJar(URL url) {
    }

    protected void setupEngine() throws ScriptEngineException {
        ScriptEngineManager engineManager = new ScriptEngineManager();
        this.fEngine = engineManager.getEngineByName("nashorn");
        if (this.fEngine == null) {
            throw new ScriptEngineException("Unable to load Nashorn Script Engine");
        }
    }

    protected void teardownEngine() {
        this.fEngine = null;
    }

    protected Object execute(Script script, Object reference, String fileName, boolean uiThread) throws Exception {
        return this.fEngine.eval(script.getCode());
    }

    protected boolean acceptVariable(Object value) {
        if (NashornScriptEngine.isFunction(value)) {
            return false;
        }
        return super.acceptVariable(value);
    }

    public ScriptObjectType getType(Object object) {
        if (object != null) {
            if (NashornScriptEngine.isArray(object)) {
                return ScriptObjectType.NATIVE_ARRAY;
            }
            if (NashornScriptEngine.isFunction(object)) {
                return ScriptObjectType.NATIVE_OBJECT;
            }
        }
        return super.getType(object);
    }

    protected String getTypeName(Object value) {
        ScriptObjectType type = this.getType(value);
        switch (type) {
            case NATIVE_ARRAY: {
                return "JavaScript Array";
            }
            case NATIVE_OBJECT: {
                return "JavaScript Object";
            }
        }
        return super.getTypeName(value);
    }

    protected Collection<EaseDebugVariable> getDefinedVariables(Object scope) {
        HashSet<EaseDebugVariable> result = new HashSet<EaseDebugVariable>();
        if (NashornScriptEngine.isScriptObject(scope)) {
            Map<String, Object> childElements = this.getChildElements(scope);
            if (NashornScriptEngine.isArray(scope)) {
                for (Map.Entry<String, Object> child : childElements.entrySet()) {
                    EaseDebugVariable variable = this.createVariable("[" + child.getKey() + "]", child.getValue());
                    result.add(variable);
                }
            } else {
                for (Map.Entry<String, Object> child : childElements.entrySet()) {
                    EaseDebugVariable variable = this.createVariable(child.getKey(), child.getValue());
                    result.add(variable);
                }
            }
            return result;
        }
        return super.getDefinedVariables(scope);
    }

    protected EaseDebugVariable createVariable(String name, Object value) {
        EaseDebugVariable variable = super.createVariable(name, value);
        if (NashornScriptEngine.isArray(value)) {
            variable.getValue().setValueString("array[" + this.getChildElements(value).size() + "]");
            variable.setType(EaseDebugVariable.Type.NATIVE_ARRAY);
        } else if (NashornScriptEngine.isScriptObject(value)) {
            variable.getValue().setValueString("object{" + this.getChildElements(value).size() + "}");
            variable.setType(EaseDebugVariable.Type.NATIVE_OBJECT);
        }
        return variable;
    }

    public String toString(Object object) {
        if (NashornScriptEngine.isArray(object)) {
            Map<String, Object> childElements = this.getChildElements(object);
            ArrayList<String> keys = new ArrayList<String>(childElements.keySet());
            Collections.sort(keys, (o1, o2) -> {
                try {
                    int index1 = Integer.parseInt(o1);
                    int index2 = Integer.parseInt(o2);
                    return index2 - index1;
                }
                catch (NumberFormatException e) {
                    return o1.compareTo((String)o2);
                }
            });
            ArrayList<Object> elements = new ArrayList<Object>();
            for (String index : keys) {
                elements.add(childElements.get(index));
            }
            return this.buildArrayString(elements);
        }
        if (NashornScriptEngine.isFunction(object)) {
            Map<String, Object> childElements = this.getChildElements(object);
            return this.buildObjectString(childElements);
        }
        return super.toString(object);
    }

    private static boolean isScriptObject(Object value) {
        return value != null && "jdk.nashorn.api.scripting.ScriptObjectMirror".equals(value.getClass().getName());
    }

    private Map<String, Object> getChildElements(Object parent) {
        HashMap<String, Object> children = new HashMap<String, Object>();
        if (NashornScriptEngine.isScriptObject(parent)) {
            try {
                Object keys;
                Method keySetMethod = parent.getClass().getMethod("keySet", new Class[0]);
                Method getMethod = parent.getClass().getMethod("get", Object.class);
                if (keySetMethod != null && getMethod != null && (keys = keySetMethod.invoke(parent, new Object[0])) instanceof Collection) {
                    for (Object key : (Collection)keys) {
                        Object childValue = getMethod.invoke(parent, key);
                        if (!this.acceptVariable(childValue)) continue;
                        children.put(key.toString(), childValue);
                    }
                }
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
            }
            catch (SecurityException securityException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return children;
    }

    private static boolean isFunction(Object value) {
        return NashornScriptEngine.invokeBooleanMethod(value, "isFunction");
    }

    private static boolean isArray(Object value) {
        return NashornScriptEngine.invokeBooleanMethod(value, "isArray");
    }

    private static boolean invokeBooleanMethod(Object value, String methodName) {
        if (NashornScriptEngine.isScriptObject(value)) {
            try {
                Method method = value.getClass().getMethod(methodName, new Class[0]);
                if (method != null) {
                    Object isFunction = method.invoke(value, new Object[0]);
                    return Boolean.parseBoolean(isFunction.toString());
                }
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
            }
            catch (SecurityException securityException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return false;
    }

    protected void notifyExecutionListeners(Script script, int status) {
        if (!this.getTerminateOnIdle() && 4 == status) {
            this.setVariable("_", script.getResult().getResult());
        }
        super.notifyExecutionListeners(script, status);
    }
}

