/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.callstack.ui.views.weightedtree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.linuxtools.dataviewers.piechart.PieChart;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGBA;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.tracecompass.incubator.analysis.core.weighted.tree.IDataPalette;
import org.eclipse.tracecompass.incubator.analysis.core.weighted.tree.IWeightedTreeProvider;
import org.eclipse.tracecompass.incubator.analysis.core.weighted.tree.WeightedTree;
import org.eclipse.tracecompass.incubator.internal.callstack.ui.views.weightedtree.Messages;
import org.eclipse.tracecompass.incubator.internal.callstack.ui.views.weightedtree.WeightedTreeView;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.model.OutputElementStyle;
import org.eclipse.tracecompass.tmf.core.presentation.RGBAColor;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ui.model.StyleManager;
import org.eclipse.tracecompass.tmf.ui.viewers.TmfTimeViewer;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.TimeGraphColorScheme;

public class WeightedTreePieChartViewer
extends TmfTimeViewer {
    private static final float MIN_PRECENTAGE_TO_SHOW_SLICE = 0.01f;
    private @Nullable PieChart fGlobalPC = null;
    private final Listener fMouseMoveListener;
    private final MouseListener fMouseClickListener;
    private ListenerList fSelectedListeners = new ListenerList(1);
    private IWeightedTreeProvider.MetricType fWeightType = new IWeightedTreeProvider.MetricType(String.valueOf(Messages.WeightedTreeViewer_Weight), IWeightedTreeProvider.DataType.NUMBER, null);
    private TimeGraphColorScheme fColorScheme = new TimeGraphColorScheme();
    private final WeightedTreeView fView;
    private @Nullable PieChartPalette fPiePalette = null;

    public WeightedTreePieChartViewer(@Nullable Composite parent, WeightedTreeView view) {
        super(parent);
        if (parent != null) {
            parent.addDisposeListener(e -> this.fColorScheme.dispose());
        }
        this.fView = view;
        this.fMouseMoveListener = new Listener(){

            public void handleEvent(@Nullable Event event) {
                if (event == null) {
                    return;
                }
                PieChart pc = (PieChart)event.widget;
                switch (event.type) {
                    case 5: {
                        int sliceIndex = pc.getSliceIndexFromPosition(0, event.x, event.y);
                        if (sliceIndex < 0) {
                            pc.setToolTipText(null);
                            break;
                        }
                        float percOfSlice = (float)pc.getSlicePercent(0, sliceIndex);
                        String percent = String.format("%.1f", Float.valueOf(percOfSlice));
                        Long value = (long)pc.getSeriesSet().getSeries()[sliceIndex].getXSeries()[0];
                        String text = String.valueOf(pc.getSeriesSet().getSeries()[sliceIndex].getId()) + "\n";
                        text = String.valueOf(text) + WeightedTreePieChartViewer.this.fWeightType.format((Object)value) + " (" + percent + "%)";
                        pc.setToolTipText(text);
                        return;
                    }
                }
            }
        };
        this.fMouseClickListener = new MouseListener(){

            public void mouseUp(@Nullable MouseEvent e) {
            }

            public void mouseDown(@Nullable MouseEvent e) {
                if (e == null) {
                    return;
                }
                PieChart pc = (PieChart)e.widget;
                int slicenb = pc.getSliceIndexFromPosition(0, e.x, e.y);
                if (slicenb < 0 || slicenb >= pc.getSeriesSet().getSeries().length) {
                    return;
                }
                Event selectionEvent = new Event();
                selectionEvent.text = pc.getSeriesSet().getSeries()[slicenb].getId();
                WeightedTreePieChartViewer.this.notifySelectionListener(selectionEvent);
            }

            public void mouseDoubleClick(@Nullable MouseEvent e) {
            }
        };
    }

    public void loadTrace(final @Nullable ITmfTrace trace) {
        super.loadTrace(trace);
        if (trace == null) {
            return;
        }
        Thread thread = new Thread(){

            @Override
            public void run() {
                WeightedTreePieChartViewer.this.initializeDataSource(trace);
            }
        };
        thread.start();
    }

    private synchronized void initializeDataSource(ITmfTrace trace) {
        Set<IWeightedTreeProvider<?, ?, WeightedTree<?>>> modules = this.fView.getWeightedTrees(trace);
        modules.forEach(m -> {
            if (m instanceof IAnalysisModule) {
                ((IAnalysisModule)m).schedule();
            }
        });
    }

    synchronized void updateGlobalPieChart(Set<WeightedTree<?>> trees, IWeightedTreeProvider<?, ?, WeightedTree<?>> treeProvider) {
        long totalWeight = WeightedTreePieChartViewer.getTotalWeight(trees);
        PieChart pie = this.getGlobalPC();
        if (pie == null || totalWeight == 0L) {
            pie = this.createPieChart(treeProvider);
            this.setGlobalPC(pie);
            this.fWeightType = treeProvider.getWeightType();
            this.setPalette(treeProvider.getPalette());
        }
        if (totalWeight > 0L) {
            this.updatePieChartWithData(pie, trees, treeProvider, totalWeight);
        }
        pie.redraw();
    }

    private synchronized void setPalette(IDataPalette palette) {
        PieChartPalette currentPalette = this.fPiePalette;
        if (currentPalette == null || !palette.equals(currentPalette.fPalette)) {
            this.fPiePalette = new PieChartPalette(palette);
        }
    }

    private PieChart createPieChart(IWeightedTreeProvider<?, ?, WeightedTree<?>> treeProvider) {
        PieChart pie = new PieChart(this.getParent(), 0);
        Color backgroundColor = this.fColorScheme.getColor(38);
        Color foregroundColor = this.fColorScheme.getColor(39);
        pie.getTitle().setText(treeProvider.getTitle());
        pie.getTitle().setForeground(foregroundColor);
        pie.setBackground(backgroundColor);
        pie.setForeground(foregroundColor);
        pie.getAxisSet().getXAxis(0).getTitle().setText("");
        pie.getAxisSet().getXAxis(0).getTitle().setForeground(foregroundColor);
        pie.getLegend().setVisible(true);
        pie.getLegend().setPosition(131072);
        pie.getLegend().setBackground(backgroundColor);
        pie.getLegend().setForeground(foregroundColor);
        pie.addListener(5, this.fMouseMoveListener);
        pie.addMouseListener(this.fMouseClickListener);
        return pie;
    }

    private static long getTotalWeight(Collection<WeightedTree<?>> trees) {
        if (trees.isEmpty()) {
            return 0L;
        }
        long totalWeight = 0L;
        for (WeightedTree<?> tree : trees) {
            totalWeight += tree.getWeight();
        }
        return totalWeight;
    }

    private void updatePieChartWithData(PieChart chart, Collection<WeightedTree<?>> trees, IWeightedTreeProvider<?, ?, WeightedTree<?>> treeProvider, long totalWeight) {
        long otherWeight = 0L;
        WeightedTree<?> otherTree = null;
        ArrayList list = new ArrayList();
        for (WeightedTree<?> tree : trees) {
            if ((float)tree.getWeight() / (float)totalWeight > 0.01f) {
                list.add(tree);
                continue;
            }
            otherWeight += tree.getWeight();
            otherTree = tree;
        }
        Collections.sort(list, Collections.reverseOrder());
        int listSize = otherWeight == 0L ? list.size() : list.size() + 1;
        double[][] sliceValues = new double[listSize][1];
        String[] sliceNames = new String[listSize];
        int i = 0;
        PieChartPalette palette = this.fPiePalette;
        Color[] colors = palette == null ? null : new Color[listSize];
        for (WeightedTree weightedTree : list) {
            sliceNames[i] = treeProvider.toDisplayString(weightedTree);
            sliceValues[i][0] = weightedTree.getWeight();
            if (colors != null && palette != null) {
                colors[i] = palette.getColor(weightedTree);
            }
            ++i;
        }
        if (otherWeight != 0L) {
            if (otherTree != null && otherTree.getWeight() == otherWeight) {
                sliceNames[list.size()] = treeProvider.toDisplayString(otherTree);
                if (colors != null && palette != null) {
                    colors[list.size()] = palette.getColor(otherTree);
                }
            } else {
                sliceNames[list.size()] = Messages.WeightedTreeViewer_Other;
            }
            sliceValues[list.size()][0] = otherWeight;
        }
        if (colors != null) {
            chart.setCustomColors(colors);
        }
        chart.addPieChartSeries(sliceNames, sliceValues);
    }

    public void addSelectionListener(Listener l) {
        this.fSelectedListeners.add((Object)l);
    }

    public void removeSelectionListener(Listener l) {
        this.fSelectedListeners.remove((Object)l);
    }

    private void notifySelectionListener(Event e) {
        Object[] objectArray = this.fSelectedListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            ((Listener)o).handleEvent(e);
            ++n2;
        }
    }

    synchronized @Nullable PieChart getGlobalPC() {
        return this.fGlobalPC;
    }

    private synchronized void setGlobalPC(PieChart pie) {
        PieChart pc = this.fGlobalPC;
        if (pc != null) {
            pc.dispose();
        }
        this.fGlobalPC = pie;
    }

    public void elementSelected(Set<WeightedTree<?>> trees, IWeightedTreeProvider<?, ?, WeightedTree<?>> treeProvider) {
        this.updateGlobalPieChart(trees, treeProvider);
    }

    public @Nullable Control getControl() {
        return this.getParent();
    }

    public void refresh() {
    }

    private class PieChartPalette {
        private final IDataPalette fPalette;
        private final StyleManager fStyleManager;
        private final Map<OutputElementStyle, Color> fColors = new HashMap<OutputElementStyle, Color>();

        private PieChartPalette(IDataPalette palette) {
            this.fPalette = palette;
            this.fStyleManager = new StyleManager(palette.getStyles());
        }

        public Color getColor(WeightedTree<?> tree) {
            @NonNull OutputElementStyle style = this.fPalette.getStyleFor(tree);
            return this.fColors.computeIfAbsent(style, st -> {
                @NonNull RGBAColor colorStyle = this.fStyleManager.getColorStyle(st, "background-color");
                if (colorStyle == null) {
                    colorStyle = this.fStyleManager.getColorStyle(st, "color");
                }
                if (colorStyle == null) {
                    return WeightedTreePieChartViewer.this.fColorScheme.getColor(2);
                }
                return WeightedTreePieChartViewer.this.fColorScheme.getColor(new RGBA((int)colorStyle.getRed(), (int)colorStyle.getGreen(), (int)colorStyle.getBlue(), (int)colorStyle.getAlpha()));
            });
        }
    }
}

