/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.struct;

import java.util.List;
import org.antlr.runtime.tree.CommonTree;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.tracecompass.ctf.core.event.metadata.DeclarationScope;
import org.eclipse.tracecompass.ctf.core.event.types.IDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.StructDeclaration;
import org.eclipse.tracecompass.ctf.core.trace.CTFTrace;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.AbstractScopedCommonTreeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ICommonTreeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ParseException;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.TypeDeclaratorParser;

public final class StructDeclarationParser
extends AbstractScopedCommonTreeParser {
    public static final StructDeclarationParser INSTANCE = new StructDeclarationParser();

    private StructDeclarationParser() {
    }

    @Override
    public StructDeclaration parse(CommonTree declaration, ICommonTreeParser.ICommonTreeParserParameter param) throws ParseException {
        if (!(param instanceof Param)) {
            throw new IllegalArgumentException("Param must be a " + Param.class.getCanonicalName());
        }
        DeclarationScope scope = ((Param)param).fDeclarationScope;
        StructDeclaration struct = ((Param)param).fStruct;
        CommonTree typeSpecifierListNode = (CommonTree)declaration.getFirstChildWithType(117);
        if (typeSpecifierListNode == null) {
            throw new ParseException("Cannot have an struct without a type specifier");
        }
        CommonTree typeDeclaratorListNode = (CommonTree)declaration.getFirstChildWithType(116);
        if (typeDeclaratorListNode == null) {
            throw new ParseException("Cannot have an struct without a declarator");
        }
        List typeDeclaratorList = typeDeclaratorListNode.getChildren();
        for (CommonTree typeDeclaratorNode : typeDeclaratorList) {
            StringBuilder identifierSB = new StringBuilder();
            CTFTrace trace = ((Param)param).fTrace;
            IDeclaration decl = TypeDeclaratorParser.INSTANCE.parse(typeDeclaratorNode, new TypeDeclaratorParser.Param(trace, typeSpecifierListNode, scope, identifierSB));
            String fieldName = identifierSB.toString();
            scope.registerIdentifier(fieldName, decl);
            if (struct.hasField(fieldName)) {
                throw new ParseException("struct: duplicate field " + fieldName);
            }
            struct.addField(fieldName, decl);
        }
        return struct;
    }

    @NonNullByDefault
    public static final class Param
    implements ICommonTreeParser.ICommonTreeParserParameter {
        private final StructDeclaration fStruct;
        private final DeclarationScope fDeclarationScope;
        private final CTFTrace fTrace;

        public Param(StructDeclaration struct, CTFTrace trace, DeclarationScope scope) {
            this.fStruct = struct;
            this.fTrace = trace;
            this.fDeclarationScope = scope;
        }
    }
}

